/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.interfacing;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.build.MinkowskiBuilder;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.interfacing.CalculationAbortedException;
import chemaxon.marvin.modelling.interfacing.CalculationFailedException;
import chemaxon.marvin.modelling.interfacing.CalculationInput;
import chemaxon.marvin.modelling.interfacing.CalculationResult;
import chemaxon.marvin.modelling.interfacing.CxnMoleculeInput;
import chemaxon.marvin.modelling.interfacing.InvokeCalculation;
import chemaxon.marvin.modelling.interfacing.MultipleConformersResultImpl;

public class InvokeMinkowskiCalculation
extends InvokeCalculation {
    private CleanSettings settings = null;

    public void setSettings(CleanSettings s) {
        this.settings = s;
    }

    @Override
    public CalculationResult invoke(CalculationInput input, boolean reportSingleConformer) throws CalculationAbortedException, CalculationFailedException {
        CxnMoleculeInput in = (CxnMoleculeInput)input;
        debugPrintout debug = CleanArgs.getDebug();
        MinkowskiBuilder mb = new MinkowskiBuilder(debug == null ? new debugPrintout() : debug, in.getSelMol(), 48, true);
        if (debug != null) {
            debug.printBC("Invoke startClean");
        }
        double[][] coords = mb.startClean(null, in.getSelMol(), this.settings);
        if (debug != null) {
            debug.printBC("startClean returned.");
        }
        return new MultipleConformersResultImpl(input, coords);
    }
}

