/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.interfacing;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.debug.VerbosePrinter;
import chemaxon.marvin.modelling.interfacing.CalculationAbortedException;
import chemaxon.marvin.modelling.interfacing.CalculationFailedException;
import chemaxon.marvin.modelling.interfacing.CalculationInput;
import chemaxon.marvin.modelling.interfacing.CalculationResult;
import chemaxon.marvin.modelling.interfacing.CxnMoleculeInput;
import chemaxon.marvin.modelling.interfacing.InvokeCalculation;
import chemaxon.marvin.modelling.interfacing.MultipleConformerResult;
import chemaxon.marvin.modelling.interfacing.MultipleConformersResultImpl;
import chemaxon.marvin.modelling.struc.Fragment;
import chemaxon.marvin.modelling.util.U;

public class OptimizerCalculation
extends InvokeCalculation {
    public static final int CALCULATE_ENERGY = 1;
    public static final int CALCULATE_OPTIMIZE = 2;
    private int type = 0;
    private CleanSettings settings = null;
    private double optLimit = CleanSettings.BUILDCOMMAND_DEFAULTOPTLIMITVALUE;

    public OptimizerCalculation(int t) {
        this.type = t;
    }

    public void setOptLimit(double l) {
        this.optLimit = l;
    }

    public void setCleanSettings(CleanSettings s) {
        this.settings = s;
    }

    @Override
    public CalculationResult invoke(CalculationInput input, boolean reportSingleConformer) throws CalculationAbortedException, CalculationFailedException {
        VerbosePrinter vps = CleanArgs.getVerbosePrinter("OptimizerCalculation.invoke()");
        if (vps != null) {
            vps.print("Aquire input");
        }
        CxnMoleculeInput in = (CxnMoleculeInput)input.getInputDescriptor();
        MultipleConformerResult res = null;
        double[][][] coord = input.getCoordinates();
        if (input instanceof CxnMoleculeInput) {
            if (vps != null) {
                vps.print("Input is CxnMoleculeInput");
            }
            switch (this.type) {
                case 1: {
                    if (vps != null) {
                        vps.print("Allocate res for energy");
                    }
                    res = new MultipleConformersResultImpl((CalculationInput)in, new double[coord.length]);
                    break;
                }
                case 2: {
                    if (vps != null) {
                        vps.print("Allocate res for optimization");
                    }
                    res = new MultipleConformersResultImpl((CalculationInput)in, coord, new double[coord.length]);
                }
            }
        } else {
            if (vps != null) {
                vps.print("Input is a MultipleConformerResult");
            }
            res = (MultipleConformerResult)input;
        }
        if (vps != null) {
            vps.print("Get fragment");
        }
        Fragment frag = in.getSelMolFrag(false, this.settings);
        switch (this.type) {
            case 1: {
                if (vps != null) {
                    vps.print("Invoke energy");
                }
                for (int i = 0; i < coord.length; ++i) {
                    double e = frag.calcDreiding(coord[i]);
                    res.overrideEnergy(i, e);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < coord.length; ++i) {
                    if (vps != null) {
                        vps.print("Invoke optimization on frag" + i, "coords: " + U.toString(coord[i]));
                    }
                    if (!frag.optimizeDreiding(coord[i], this.optLimit)) {
                        throw new CalculationFailedException();
                    }
                    if (vps != null) {
                        vps.print("Optimizer converged and returned.", "coords: " + U.toString(coord[i]));
                    }
                    double e = frag.calcDreiding(coord[i]);
                    if (vps != null) {
                        vps.print("E=" + e);
                    }
                    res.overrideEnergy(i, e);
                }
                res.overrideOptLimit(this.optLimit);
            }
        }
        return res;
    }
}

