/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.interfacing;

import chemaxon.marvin.modelling.interfacing.CalculationInput;
import chemaxon.marvin.modelling.interfacing.CalculationResult;
import chemaxon.marvin.modelling.interfacing.CxnMoleculeInput;
import chemaxon.marvin.modelling.interfacing.InvokeCalculation;
import chemaxon.marvin.modelling.interfacing.MultipleConformersResultImpl;

public class RandomCoordinatesCalculation
extends InvokeCalculation {
    @Override
    public CalculationResult invoke(CalculationInput input, boolean singleconf) {
        CxnMoleculeInput in = (CxnMoleculeInput)input;
        if (!in.isSingleFrag()) {
            throw new UnsupportedOperationException("Not single fragment.");
        }
        double[][] c = new double[in.getSelMol().getAtomCount()][3];
        double r = 1.0 + 10.0 * Math.random();
        double e = Math.random() * 200.0 - 400.0;
        for (int i = 0; i < c.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                c[i][j] = (-1.0 + 2.0 * Math.random()) * r;
            }
        }
        return new MultipleConformersResultImpl((CalculationInput)in, c, e);
    }
}

