/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.interfacing;

import chemaxon.marvin.modelling.interfacing.CalculationAbortedException;
import chemaxon.marvin.modelling.interfacing.CalculationFailedException;
import chemaxon.marvin.modelling.interfacing.CalculationInput;
import chemaxon.marvin.modelling.interfacing.CalculationResult;
import chemaxon.marvin.modelling.interfacing.CxnMoleculeInput;
import chemaxon.marvin.modelling.interfacing.InvokeCalculation;
import chemaxon.marvin.modelling.interfacing.MultipleConformerResult;
import chemaxon.marvin.modelling.interfacing.MultipleConformersResultImpl;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.DPoint3;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import java.util.BitSet;

public class RxnMoleculeAdapter
extends InvokeCalculation {
    InvokeCalculation base;

    public RxnMoleculeAdapter(InvokeCalculation basecalc) {
        this.setVerbosePrinter(basecalc.getVerbosePrinter());
        this.base = basecalc;
    }

    @Override
    public CalculationResult invoke(CalculationInput input, boolean reportSingleConformer) throws CalculationAbortedException, CalculationFailedException {
        MultipleConformersResultImpl ret;
        if (this.vp != null) {
            this.vp.print("Invoked with a structure");
        }
        CxnMoleculeInput in = (CxnMoleculeInput)input;
        CalculationInput[] frags = in.findFrags();
        MultipleConformerResult[] res = new MultipleConformerResult[frags.length];
        for (int i = 0; i < frags.length; ++i) {
            res[i] = (MultipleConformerResult)this.base.invoke(frags[i], true);
        }
        boolean allEnergiesAvailable = MultipleConformerResult.collectAllEnergyAvailable(res);
        boolean allCoordinatesAvailable = MultipleConformerResult.collectAllCoordAvailable(res);
        if (allCoordinatesAvailable) {
            double[][] c;
            int i;
            RxnMolecule rxn = (RxnMolecule)((RgMolecule)in.getMol()).getRoot();
            int[] atomToFrag = in.getAtomToFrag();
            BitSet fragAllocated = new BitSet(frags.length);
            boolean AGENT = false;
            boolean REACTANT = true;
            int PRODUCT = 2;
            int COMPONENTCOUNT = 3;
            int[][] componentFrags = new int[3][frags.length];
            int[] componentFragsCount = new int[3];
            int[] componentCxnType = new int[]{2, 0, 1};
            double[] componentMaxAbs = new double[3];
            if (this.vp != null) {
                this.vp.print("Identify components");
            }
            for (int component = 0; component < 3; ++component) {
                for (int i2 = 0; i2 < rxn.getComponentCount(componentCxnType[component]); ++i2) {
                    Molecule m = rxn.getComponent(componentCxnType[component], i2);
                    for (int j = 0; j < m.getAtomCount(); ++j) {
                        int mai = rxn.indexOf(m.getAtom(j));
                        int fragi = atomToFrag[mai];
                        if (fragAllocated.get(fragi)) continue;
                        fragAllocated.set(fragi);
                        int n = component;
                        int n2 = componentFragsCount[n];
                        componentFragsCount[n] = n2 + 1;
                        componentFrags[component][n2] = fragi;
                    }
                }
                if (this.vp != null) {
                    this.vp.print("Component#" + component);
                    this.vp.print("componentFragsCount: " + componentFragsCount[component]);
                    this.vp.print("compoentFrags: " + U.sel(componentFrags[component]));
                }
                double s = 0.0;
                for (int i3 = 0; i3 < componentFragsCount[component]; ++i3) {
                    MultipleConformerResult resi = res[componentFrags[component][i3]];
                    double[][] c2 = resi.getCoordinates(0);
                    s = Math.max(s, U.maxAbs(c2));
                }
                double[][] cr = V.genCubeRaster(2.0 * s + 1.0, componentFragsCount[component]);
                for (i = 0; i < componentFragsCount[component]; ++i) {
                    MultipleConformerResult resi = res[componentFrags[component][i]];
                    c = resi.getCoordinates(0);
                    V.plusWriteBackToAllA(c, cr[i]);
                    componentMaxAbs[component] = Math.max(componentMaxAbs[component], U.maxAbs(c));
                }
                if (this.vp == null) continue;
                this.vp.print("Cube size: " + s);
            }
            double arrowLen = 2.0;
            double s = 0.0;
            for (i = 0; i < componentFragsCount[0]; ++i) {
                MultipleConformerResult resi = res[componentFrags[0][i]];
                c = resi.getCoordinates(0);
                s = Math.max(s, U.maxAbs(c));
            }
            arrowLen = Math.max(arrowLen, 2.0 * s + 2.0);
            for (i = 0; i < componentFragsCount[0]; ++i) {
                MultipleConformerResult resi = res[componentFrags[0][i]];
                c = resi.getCoordinates(0);
                V.plusWriteBackToAllA(c, new double[]{0.0, s + 1.0, 0.0});
            }
            s = 0.0;
            for (i = 0; i < componentFragsCount[1]; ++i) {
                MultipleConformerResult resi = res[componentFrags[1][i]];
                c = resi.getCoordinates(0);
                s = Math.max(s, U.maxAbs(c));
            }
            for (i = 0; i < componentFragsCount[1]; ++i) {
                MultipleConformerResult resi = res[componentFrags[1][i]];
                c = resi.getCoordinates(0);
                V.plusWriteBackToAllA(c, new double[]{-s - 1.0 - arrowLen / 2.0, 0.0, 0.0});
            }
            s = 0.0;
            for (i = 0; i < componentFragsCount[2]; ++i) {
                MultipleConformerResult resi = res[componentFrags[2][i]];
                c = resi.getCoordinates(0);
                s = Math.max(s, U.maxAbs(c));
            }
            for (i = 0; i < componentFragsCount[2]; ++i) {
                MultipleConformerResult resi = res[componentFrags[2][i]];
                c = resi.getCoordinates(0);
                V.plusWriteBackToAllA(c, new double[]{s + 1.0 + arrowLen / 2.0, 0.0, 0.0});
            }
            DPoint3[] arrow = new DPoint3[]{new DPoint3(-arrowLen / 2.0, 0.0, 0.0), new DPoint3(arrowLen / 2.0, 0.0, 0.0)};
            rxn.setReactionArrow(arrow);
        }
        Object coord = allCoordinatesAvailable ? (Object)new double[in.getAtomCount()][] : (double[][])null;
        double e = 0.0;
        for (int i = 0; i < frags.length; ++i) {
            if (allEnergiesAvailable) {
                e += res[i].getEnergy(0);
            }
            if (!allCoordinatesAvailable) continue;
            int[] ai = frags[i].getFragIndex();
            double[][] resc = res[i].getCoordinates(0);
            for (int k = 0; k < ai.length; ++k) {
                coord[ai[k]] = resc[k];
            }
        }
        double optl = MultipleConformerResult.collectOptLimits(res);
        if (allCoordinatesAvailable && allEnergiesAvailable) {
            ret = new MultipleConformersResultImpl(input, (double[][])coord, e);
            ret.overrideOptLimit(optl);
        } else if (allCoordinatesAvailable) {
            ret = new MultipleConformersResultImpl(input, (double[][])coord);
            ret.overrideOptLimit(optl);
        } else if (allEnergiesAvailable) {
            ret = new MultipleConformersResultImpl(input, e);
        } else {
            throw new UnsupportedOperationException();
        }
        return ret;
    }

    public static boolean isRxnMolecule(CalculationInput input) {
        RgMolecule m;
        Molecule r;
        Molecule inmol = ((CxnMoleculeInput)input).getMol();
        return inmol instanceof RgMolecule && (r = (m = (RgMolecule)inmol).getRoot()) instanceof RxnMolecule;
    }
}

