/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg;

import chemaxon.marvin.modelling.util.StringConversionUtility;
import java.io.Serializable;
import java.security.AllPermission;
import java.security.GuardedObject;
import java.text.DecimalFormat;
import java.util.BitSet;

public class JLinAlg {
    static final double zeroLimit = 1.0E-8;

    public static double VLength(double[] v) {
        return Math.sqrt(JLinAlg.VDot(v, v));
    }

    public static double VLength(double[] v, BitSet selection) {
        return Math.sqrt(JLinAlg.VDot(v, v, selection));
    }

    public static double VDot(Matrix m1, int row1, Matrix m2, int row2) {
        double d = 0.0;
        int len = Math.min(m1.nCols, m2.nCols);
        if (m1.mType.get(2) || m1.mType.get(3) || m2.mType.get(2) || m2.mType.get(3)) {
            for (int i = 0; i < len; ++i) {
                d += m1.getElement(row1, i) * m2.getElement(row2, i);
            }
        } else {
            d = JLinAlg.VDot(len, m1.aVec, m1.pShft + row1 * m1.nCols, m2.aVec, m2.pShft + row2 * m2.nCols);
        }
        return d;
    }

    public static double VDot(double[] v1, double[] v2) {
        int len = Math.min(v1.length, v2.length);
        return JLinAlg.VDot(len, v1, 0, v2, 0);
    }

    public static double VDot(double[] v1, double[] v2, BitSet selection) {
        int len = Math.min(v1.length, v2.length);
        return JLinAlg.VDot(len, v1, 0, v2, 0, selection);
    }

    public static double VDot(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft) {
        double d = 0.0;
        for (int i = 0; i < len; ++i) {
            d += v1[pV1Shft + i] * v2[pV2Shft + i];
        }
        return d;
    }

    public static double VDot(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft, BitSet selection) {
        double d = 0.0;
        if (selection == null) {
            for (int i = 0; i < len; ++i) {
                d += v1[pV1Shft + i] * v2[pV2Shft + i];
            }
        } else {
            int i = selection.nextSetBit(0);
            while (i >= 0) {
                d += v1[pV1Shft + i] * v2[pV2Shft + i];
                i = selection.nextSetBit(i + 1);
            }
        }
        return d;
    }

    public static double VDot(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft, Matrix metric) {
        if (metric != null) {
            double[] w = JLinAlg.mVMultiply(metric, v2, pV2Shft);
            return JLinAlg.VDot(len, v1, pV1Shft, w, 0);
        }
        return JLinAlg.VDot(len, v1, pV1Shft, v2, pV2Shft);
    }

    public static Matrix MDot(VectorSet vSet1, VectorSet vSet2) {
        return JLinAlg.MDot(vSet1, vSet2, null);
    }

    public static void VCoeff(VectorSet vSet1, int Ind1, VectorSet vSet2, double[] w, int wShft) {
        if (!vSet1.sType.get(2) || !vSet2.sType.get(2) || vSet1.vMtr == vSet2.vMtr) {
            // empty if block
        }
        if (vSet1.vLen != vSet2.vLen) {
            System.err.println("Vector length mismatch in VCoeff");
            throw new UnsupportedOperationException("Vector length mismatch in VCoeff");
        }
    }

    public static void VSchmidtO(VectorSet vSet1, VectorSet vSet2, double zlimit) {
        if (vSet2 == null) {
            vSet2 = new VectorSet(vSet1.nVec, vSet1.vLen, null, 0, vSet1.sType, vSet1.vOvr, vSet1.vMtr);
        }
        int nVec2 = 0;
        double[] w = new double[vSet1.nVec + vSet1.vLen];
        int wShft = vSet1.nVec;
        for (int i = 0; i < vSet1.nVec; ++i) {
            boolean OK;
            JLinAlg.VectCopy(vSet1.vLen, vSet1.vSet[i], vSet1.vShft[i], vSet2.vSet[nVec2], vSet2.vShft[nVec2]);
            if (vSet2.sType.get(0)) {
                JLinAlg.VectNormalize(vSet2.vLen, vSet2.vSet[nVec2], vSet2.vShft[nVec2], vSet2.vSet[nVec2], vSet2.vShft[nVec2], vSet2.vMtr, zlimit);
            }
            JLinAlg.VCoeff(vSet2.vLen, vSet2.vSet[nVec2], vSet2.vShft[nVec2], nVec2, vSet2.vSet, vSet2.vShft, vSet2.vMtr, w, 0);
            JLinAlg.VLinComb(vSet2.vLen, w, 0, nVec2, vSet2.vSet, vSet2.vShft, w, wShft);
            JLinAlg.vectSubtract(vSet2.vLen, vSet2.vSet[nVec2], vSet2.vShft[nVec2], w, wShft, vSet2.vSet[nVec2], vSet2.vShft[nVec2]);
            if (vSet2.sType.get(0)) {
                OK = JLinAlg.VectNormalize(vSet2.vLen, vSet2.vSet[nVec2], vSet2.vShft[nVec2], vSet2.vSet[nVec2], vSet2.vShft[nVec2], vSet2.vMtr, zlimit);
            } else {
                boolean bl = OK = Math.sqrt(JLinAlg.VDot(vSet2.vLen, vSet2.vSet[nVec2], vSet2.vShft[nVec2], vSet2.vSet[nVec2], vSet2.vShft[nVec2], vSet2.vMtr)) > zlimit;
            }
            if (!OK) continue;
            ++nVec2;
        }
        vSet2.nVec = nVec2;
    }

    public static void VCoeff(int len, double[] v1, int pV1Shft, int nVec2, double[][] v2, int[] pV2Shft, Matrix metric, double[] w, int wShft) {
        if (w == null) {
            w = new double[nVec2];
        }
        for (int i = 0; i < nVec2; ++i) {
            w[wShft + i] = JLinAlg.VDot(len, v1, pV1Shft, v2[i], pV2Shft[i], metric);
        }
    }

    public static double[] VLinComb(double[] c, VectorSet v) {
        return JLinAlg.VLinComb(v.vLen, c, 0, v.nVec, v.vSet, v.vShft, null, 0);
    }

    public static double[] VLinComb(double[] c, VectorSet v, double[] w) {
        return JLinAlg.VLinComb(v.vLen, c, 0, v.nVec, v.vSet, v.vShft, w, 0);
    }

    public static double[] VLinComb(double[] c, int cShft, VectorSet v, double[] w, int wShft) {
        return JLinAlg.VLinComb(v.vLen, c, cShft, v.nVec, v.vSet, v.vShft, w, wShft);
    }

    public static double[] VLinComb(int len, double[] c, int cShft, int nVec2, double[][] v2, int[] pV2Shft, double[] w, int wShft) {
        if (w == null) {
            w = new double[len];
        } else {
            JLinAlg.VectClear(len, w, wShft);
        }
        for (int i = 0; i < nVec2; ++i) {
            JLinAlg.VectScaleAndAdd(len, w, wShft, c[cShft + i], v2[i], pV2Shft[i], w, wShft);
        }
        return w;
    }

    public static double[] VLinComb(double[] c, VectorSubSet v) {
        double[] w = new double[v.vSet.vLen];
        JLinAlg.VLinComb(c, 0, v, w, 0);
        return w;
    }

    public static double[] VLinComb(double[] c, VectorSubSet v, double[] w) {
        return JLinAlg.VLinComb(c, 0, v, w, 0);
    }

    public static double[] VLinComb(double[] c, int cShft, VectorSubSet v, double[] w, int wShft) {
        int len = v.vSet.vLen;
        int nVec = v.nVec;
        if (w == null) {
            w = new double[len];
        } else {
            JLinAlg.VectClear(len, w, wShft);
        }
        for (int i = 0; i < nVec; ++i) {
            JLinAlg.VectScaleAndAdd(len, w, wShft, c[cShft + i], v.vSet.vSet[v.vInd[i]], v.vSet.vShft[v.vInd[i]], w, wShft);
        }
        return w;
    }

    public static double[] VLinComb(int len, double[] c, int cShft, int nVec2, double[] v2, int pV2Shft, double[] w, int wShft) {
        if (w == null) {
            w = new double[len];
        } else {
            JLinAlg.VectClear(len, w, wShft);
        }
        for (int i = 0; i < nVec2; ++i) {
            JLinAlg.VectScaleAndAdd(len, w, wShft, c[cShft + i], v2, pV2Shft + i * len, w, wShft);
        }
        return w;
    }

    public static double[] VLinComb(double[] c, double[][] v2, double[] w) {
        int i;
        int maxLen = 0;
        int minLen = Math.min(c.length, v2.length);
        for (i = 0; i < minLen; ++i) {
            if (v2[i].length <= maxLen) continue;
            maxLen = v2[i].length;
        }
        if (w == null) {
            w = new double[maxLen];
        } else {
            JLinAlg.VectClear(maxLen, w, 0);
        }
        for (i = 0; i < minLen; ++i) {
            JLinAlg.VectScaleAndAdd(w, c[i], v2[i], w);
        }
        return w;
    }

    public static double[] VectCompress(int len, int[] index, double[] c, int cShft, double[] v, int vShft) {
        if (c == null) {
            c = new double[len];
        } else {
            JLinAlg.VectClear(len, c, cShft);
        }
        for (int i = 0; i < len; ++i) {
            c[cShft + i] = v[vShft + index[i]];
        }
        return c;
    }

    public static double[] VectExtract(int len, int[] index, double[] c, int cShft, int vLen, double[] v, int vShft) {
        if (v == null) {
            c = new double[vShft + vLen];
        } else {
            JLinAlg.VectClear(vLen, v, vShft);
        }
        for (int i = 0; i < len; ++i) {
            v[vShft + index[i]] = c[cShft + i];
        }
        return v;
    }

    public static Matrix MDot(VectorSet vSet1, VectorSet vSet2, Matrix v3) {
        Matrix metric = null;
        if (vSet1.sType.get(2) && vSet2.sType.get(2) && vSet1.vMtr == vSet2.vMtr) {
            metric = vSet1.vMtr;
        }
        int len = vSet1.vLen;
        if (vSet1.vLen != vSet2.vLen) {
            System.err.println("Vector length mismatch in MDot");
            throw new UnsupportedOperationException("Vector length mismatch in MDot");
        }
        return JLinAlg.MDot(len, vSet1.nVec, vSet1.vSet, vSet1.vShft, vSet2.nVec, vSet2.vSet, vSet2.vShft, metric, v3);
    }

    public static Matrix MDot(int len, int nVec1, double[][] v1, int[] pV1Shft, int nVec2, double[][] v2, int[] pV2Shft, Matrix metric) {
        return JLinAlg.MDot(len, nVec1, v1, pV1Shft, nVec2, v2, pV2Shft, metric, null);
    }

    public static Matrix MDot(int len, int nVec1, double[][] v1, int[] pV1Shft, int nVec2, double[][] v2, int[] pV2Shft, Matrix metric, Matrix v3) {
        if (v3 == null) {
            BitSet v3_sType = null;
            if (nVec1 == nVec2 && v1 == v2 && pV1Shft == pV2Shft) {
                v3_sType = new BitSet(8);
                v3_sType.set(2);
                v3_sType.set(1);
            }
            v3 = new Matrix(nVec1, nVec2, v3_sType);
        }
        boolean doSymm = nVec1 == nVec2 && v1 == v2 && pV1Shft == pV2Shft;
        int lim2 = nVec2;
        for (int i = 0; i < nVec1; ++i) {
            if (doSymm) {
                lim2 = i + 1;
            }
            for (int j = 0; j < nVec2; ++j) {
                v3.setElement(i, j, JLinAlg.VDot(len, v1[i], pV1Shft[i], v2[j], pV2Shft[j], metric));
            }
        }
        return v3;
    }

    public static boolean VectNormalize(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft, Matrix metric, double zLimit) {
        double Sc = JLinAlg.VDot(len, v1, pV1Shft, v1, pV1Shft, metric);
        Sc = Sc < 0.0 ? 0.0 : Math.sqrt(Sc);
        if (Sc <= zLimit) {
            JLinAlg.VectClear(len, v2, pV2Shft);
            return false;
        }
        Sc = 1.0 / Sc;
        JLinAlg.VectScale(len, v1, pV1Shft, Sc, v2, pV2Shft);
        return true;
    }

    public static boolean VectNormalize(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft, Matrix metric) {
        return JLinAlg.VectNormalize(len, v1, pV1Shft, v2, pV2Shft, metric, 1.0E-8);
    }

    public static boolean VectNormalize(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft) {
        return JLinAlg.VectNormalize(len, v1, pV1Shft, v2, pV2Shft, null, 1.0E-8);
    }

    public static double[] VectUnit(int len, double[] v1, int pV1Shft, Matrix metric) {
        double[] v2 = new double[len];
        JLinAlg.VectNormalize(len, v1, pV1Shft, v2, 0, metric, 1.0E-8);
        return v2;
    }

    public static double VSum(double[] v, boolean doAbs) {
        return JLinAlg.VSum(v.length, v, 0, doAbs);
    }

    public static double VSum(int len, double[] v1, int pV1Shft, boolean doAbs) {
        double d = 0.0;
        if (doAbs) {
            for (int i = 0; i < len; ++i) {
                d += Math.abs(v1[pV1Shft + i]);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                d += v1[pV1Shft + i];
            }
        }
        return d;
    }

    public static void VVMul(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft, double[] v3, int pV3Shft) {
        for (int i = 0; i < len; ++i) {
            v3[pV3Shft + i] = v1[pV1Shft + i] * v2[pV2Shft + i];
        }
    }

    public static double[] VVMul(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft) {
        double[] v3 = new double[len];
        JLinAlg.VVMul(len, v1, pV1Shft, v2, pV2Shft, v3, 0);
        return v3;
    }

    public static double[] VVMul(double[] v1, double[] v2) {
        int len = Math.min(v1.length, v2.length);
        return JLinAlg.VVMul(len, v1, 0, v2, 0);
    }

    public static double[] VVMul(double[] v1, double[] v2, double[] v3) {
        int len = Math.min(v1.length, v2.length);
        JLinAlg.VVMul(len, v1, 0, v2, 0, v3, 0);
        return v3;
    }

    public static void VectClear(double[] v) {
        JLinAlg.VectClear(v.length, v, 0);
    }

    public static void VectClear(int len, double[] v, int pVShft) {
        for (int i = 0; i < len; ++i) {
            v[pVShft + i] = 0.0;
        }
    }

    public static double[] VectCopy(double[] v1, double[] v2) {
        if (v2 == null) {
            v2 = new double[v1.length];
        }
        int len = Math.min(v1.length, v2.length);
        int pV1Shft = 0;
        int pV2Shft = 0;
        JLinAlg.VectCopy(len, v1, pV1Shft, v2, pV2Shft);
        return v2;
    }

    public static void VectCopy(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft) {
        if (v1 == v2) {
            JLinAlg.VectCopy(len, v1, pV1Shft, pV2Shft);
        } else {
            System.arraycopy(v1, pV1Shft, v2, pV2Shft, len);
        }
    }

    public static double[] VectCopy(double[] v1) {
        return JLinAlg.VectCopy(v1.length, v1, 0);
    }

    public static double[] VectCopy(int len, double[] v1, int pV1Shft) {
        double[] v2 = new double[len];
        int pV2Shft = 0;
        for (int i = 0; i < len; ++i) {
            v2[pV2Shft + i] = v1[pV1Shft + i];
        }
        return v2;
    }

    public static void VectCopy(int len, double[] v, int pV1Shft, int pV2Shft) {
        if (pV1Shft == pV2Shft) {
            return;
        }
        if (pV1Shft > pV2Shft) {
            for (int i = 0; i < len; ++i) {
                v[pV2Shft + i] = v[pV1Shft + i];
            }
        } else {
            for (int i = len - 1; i >= 0; --i) {
                v[pV2Shft + i] = v[pV1Shft + i];
            }
        }
    }

    public static double VectMaxComponent(double[] v1, boolean Absolute) {
        return JLinAlg.VectMaxComponent(v1.length, v1, 0, Absolute);
    }

    public static double VectMaxComponent(int len, double[] v1, int pV1Shft, boolean Absolute) {
        double maxValue = v1[pV1Shft];
        double value = 0.0;
        if (Absolute) {
            maxValue = Math.abs(v1[pV1Shft]);
        }
        for (int i = 1; i < len; ++i) {
            value = Absolute ? Math.abs(v1[pV1Shft + i]) : v1[pV1Shft + i];
            maxValue = Math.max(maxValue, value);
        }
        return maxValue;
    }

    public static double VectMinComponent(double[] v, boolean Absolute) {
        return JLinAlg.VectMinComponent(v.length, v, 0, Absolute);
    }

    public static double VectMinComponent(int len, double[] v1, int pV1Shft, boolean Absolute) {
        double minValue = v1[pV1Shft];
        double value = 0.0;
        if (Absolute) {
            minValue = Math.abs(v1[pV1Shft]);
        }
        for (int i = 1; i < len; ++i) {
            value = Absolute ? Math.abs(v1[pV1Shft + i]) : v1[pV1Shft + i];
            minValue = Math.min(minValue, value);
        }
        return minValue;
    }

    public static int VectMaxIndex(int len, double[] v1, int pV1Shft, boolean Absolute) {
        if (len < 1) {
            return 0;
        }
        double maxValue = v1[pV1Shft];
        double value = 0.0;
        int iMax = 0;
        if (Absolute) {
            maxValue = Math.abs(v1[pV1Shft]);
        }
        for (int i = 1; i < len; ++i) {
            value = Absolute ? Math.abs(v1[pV1Shft + i]) : v1[pV1Shft + i];
            if (!(maxValue < value)) continue;
            iMax = i;
            maxValue = value;
        }
        return iMax;
    }

    public static int VectMinIndex(int len, double[] v1, int pV1Shft, boolean Absolute) {
        if (len < 1) {
            return 0;
        }
        double minValue = v1[pV1Shft];
        double value = 0.0;
        int iMin = 0;
        if (Absolute) {
            minValue = Math.abs(v1[pV1Shft]);
        }
        for (int i = 1; i < len; ++i) {
            value = Absolute ? Math.abs(v1[pV1Shft + i]) : v1[pV1Shft + i];
            if (!(minValue > value)) continue;
            iMin = i;
            minValue = value;
        }
        return iMin;
    }

    public static void VectScale(Matrix m1, int i1, double Sc, Matrix m2, int i2) {
        m2.setRow(i2, JLinAlg.VectScale(m1.getRow(i1), Sc), 0);
    }

    public static double[] VectScale(double[] v1, double Sc) {
        return JLinAlg.VectScale(v1, Sc, null);
    }

    public static double[] VectScale(double[] v1, double Sc, double[] v2) {
        int len = v1.length;
        if (v2 == null) {
            v2 = new double[len];
        }
        JLinAlg.VectScale(len, v1, 0, Sc, v2, 0);
        return v2;
    }

    public static double[] VectScale(int len, double[] v1, int pV1Shft, double Sc) {
        double[] v2 = new double[len];
        JLinAlg.VectScale(len, v1, pV1Shft, Sc, v2, 0);
        return v2;
    }

    public static double[] VectScale(int len, double[] v1, int pV1Shft, double Sc, double[] v2, int pV2Shft) {
        for (int i = 0; i < len; ++i) {
            v2[pV2Shft + i] = Sc * v1[pV1Shft + i];
        }
        return v2;
    }

    public static double[] VectAdd(double[] v1, double[] v2) {
        return JLinAlg.VectAdd(v1, v2, null);
    }

    public static double[] VectAdd(double[] v1, double[] v2, double[] v3) {
        if (v3 == null) {
            v3 = new double[v1.length];
        }
        return JLinAlg.VectAdd(v1.length, v1, 0, v2, 0, v3, 0);
    }

    public static double[] VectAdd(double[] v1, double[] v2, double[] v3, BitSet selection) {
        if (v3 == null) {
            v3 = new double[v1.length];
        }
        return JLinAlg.VectAdd(v1.length, v1, 0, v2, 0, v3, 0, selection);
    }

    public static double[] VectAdd(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft, double[] v3, int pV3Shft) {
        for (int i = 0; i < len; ++i) {
            v3[pV3Shft + i] = v1[pV1Shft + i] + v2[pV2Shft + i];
        }
        return v3;
    }

    public static double[] VectAdd(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft, double[] v3, int pV3Shft, BitSet selection) {
        if (selection == null) {
            for (int i = 0; i < len; ++i) {
                v3[pV3Shft + i] = v1[pV1Shft + i] + v2[pV2Shft + i];
            }
        } else {
            boolean count = false;
            int i = selection.nextSetBit(0);
            while (i >= 0 && i < len) {
                v3[pV3Shft + i] = v1[pV1Shft + i] + v2[pV2Shft + i];
                i = selection.nextSetBit(i + 1);
            }
        }
        return v3;
    }

    public static double[] vectSubtract(double[] v1, double[] v2) {
        int len = Math.max(v1.length, v2.length);
        double[] v3 = new double[len];
        if (v1.length >= v2.length) {
            JLinAlg.vectSubtract(v2.length, v1, 0, v2, 0, v3, 0);
        } else {
            JLinAlg.vectSubtract(len, v3, 0, v2, 0, v3, 0);
            JLinAlg.VectAdd(v1.length, v1, 0, v3, 0, v3, 0);
        }
        return v3;
    }

    public static double[] vectSubtract(double[] v1, double[] v2, double[] v3) {
        int len = Math.min(v1.length, v2.length);
        JLinAlg.vectSubtract(len, v1, 0, v2, 0, v3, 0);
        return v3;
    }

    public static double[] vectSubtract(double[] v1, double[] v2, BitSet selection) {
        int len = Math.max(v1.length, v2.length);
        double[] v3 = new double[len];
        if (v1.length >= v2.length) {
            JLinAlg.vectSubtract(v2.length, v1, 0, v2, 0, v3, 0, selection);
        } else {
            JLinAlg.vectSubtract(len, v3, 0, v2, 0, v3, 0, selection);
            JLinAlg.VectAdd(v1.length, v1, 0, v3, 0, v3, 0, selection);
        }
        return v3;
    }

    public static double[] vectSubtract(double[] v1, double[] v2, double[] v3, BitSet selection) {
        int len = Math.min(v1.length, v2.length);
        JLinAlg.vectSubtract(len, v1, 0, v2, 0, v3, 0, selection);
        return v3;
    }

    public static double[] vectSubtract(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft) {
        return JLinAlg.vectSubtract(len, v1, pV1Shft, v2, pV2Shft, null, 0);
    }

    public static double[] vectSubtract(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft, double[] v3, int pV3Shft) {
        if (v3 == null) {
            v3 = new double[len];
            pV3Shft = 0;
        }
        for (int i = 0; i < len; ++i) {
            v3[pV3Shft + i] = v1[pV1Shft + i] - v2[pV2Shft + i];
        }
        return v3;
    }

    public static double[] vectSubtract(int len, double[] v1, int pV1Shft, double[] v2, int pV2Shft, double[] v3, int pV3Shft, BitSet selection) {
        if (v3 == null) {
            v3 = new double[len];
            pV3Shft = 0;
        } else if (selection != null) {
            JLinAlg.VectClear(v3);
        }
        if (selection == null) {
            for (int i = 0; i < len; ++i) {
                v3[pV3Shft + i] = v1[pV1Shft + i] - v2[pV2Shft + i];
            }
        } else {
            int i = selection.nextSetBit(0);
            while (i >= 0) {
                v3[pV3Shft + i] = v1[pV1Shft + i] - v2[pV2Shft + i];
                i = selection.nextSetBit(i + 1);
            }
        }
        return v3;
    }

    public static double VectRMS(double[] v) {
        return JLinAlg.VectRMS(v.length, v, 0);
    }

    public static double VectRMS(int len, double[] v, int pVShft) {
        return Math.sqrt(JLinAlg.VDot(len, v, pVShft, v, pVShft) / (double)len);
    }

    public static void VectPrint(String Message, int len, double[] w, int wShft) {
        System.err.println(Message);
        for (int i = 0; i < len; ++i) {
            System.err.print(JLinAlg.formatNumber(8, 4, w[wShft + i]));
        }
        System.err.println();
    }

    public static double[] VectScaleAndAdd(double[] v1, double Sc, double[] v2, double[] v3) {
        int len = Math.max(v1.length, v2.length);
        if (v3 == null) {
            v3 = new double[len];
        }
        int minLen = Math.min(v1.length, v2.length);
        v3 = JLinAlg.VectScaleAndAdd(minLen, v1, 0, Sc, v2, 0, v3, 0);
        if (minLen != len) {
            if (v1.length > v2.length) {
                JLinAlg.VectCopy(len - minLen, v1, minLen, v3, minLen);
            } else {
                v3 = JLinAlg.VectScale(len - minLen, v2, minLen, Sc, v3, minLen);
            }
        }
        return v3;
    }

    public static double[] VectScaleAndAdd(int len, double[] v1, int pV1Shft, double Sc, double[] v2, int pV2Shft, double[] v3, int pV3Shft) {
        if (v3 == null) {
            v3 = new double[len];
        }
        for (int i = 0; i < len; ++i) {
            v3[pV3Shft + i] = v1[pV1Shft + i] + Sc * v2[pV2Shft + i];
        }
        return v3;
    }

    public static void mMMultiply(Matrix a, Matrix b, Matrix c) {
        block6: {
            double[] w;
            int nCols;
            block7: {
                int nRows;
                block5: {
                    nRows = a.nRows;
                    nCols = b.nCols;
                    w = new double[a.nCols];
                    if (!a.mType.get(4) || !b.mType.get(0)) break block5;
                    for (int i = 0; i < a.nCols; ++i) {
                        int bRowIndex = b.pShft + b.rowIndex(i);
                        int cRowIndex = c.pShft + c.rowIndex(i);
                        JLinAlg.VectScale(b.nCols, b.aVec, bRowIndex, a.getElement(i, i), c.aVec, cRowIndex);
                    }
                    break block6;
                }
                if (c.mType.get(3) || c.mType.get(2)) break block7;
                for (int i = 0; i < nCols; ++i) {
                    b.getCol(i, w, 0);
                    for (int j = 0; j < nRows; ++j) {
                        double[] aRowj = a.getRow(j);
                        c.aVec[c.pShft + j * c.nCols + i] = JLinAlg.VDot(a.nCols, aRowj, 0, w, 0);
                    }
                }
                break block6;
            }
            if (!c.mType.get(3) && !c.mType.get(2)) break block6;
            double[] wa = new double[a.nCols];
            for (int i = 0; i < nCols; ++i) {
                b.getCol(i, w, 0);
                for (int j = 0; j <= i; ++j) {
                    a.getRow(j, wa, 0);
                    int aIndex = a.pShft + i * a.nCols;
                    c.setElement(j, i, JLinAlg.VDot(wa, w));
                }
            }
        }
    }

    public static Matrix mMMultiply(Matrix a, Matrix b, BitSet mType) {
        int nRows = a.nRows;
        int nCols = b.nCols;
        Matrix c = new Matrix(nRows, nCols, mType);
        JLinAlg.mMMultiply(a, b, c);
        return c;
    }

    public static Matrix mMMultiply(Matrix a, Matrix b) {
        BitSet mType = new BitSet(8);
        if (a.mType.get(0) || b.mType.get(0)) {
            mType.set(0);
        }
        return JLinAlg.mMMultiply(a, b, mType);
    }

    public static Matrix mtMMultiply(Matrix a_tr, Matrix b) {
        BitSet mType = new BitSet(8);
        return JLinAlg.mtMMultiply(a_tr, b, mType);
    }

    public static Matrix mtMMultiply(Matrix a_tr, Matrix b, BitSet mType) {
        int nRows = a_tr.nCols;
        int nCols = b.nCols;
        Matrix c = new Matrix(nRows, nCols, mType);
        if (a_tr.mType.get(0) || b.mType.get(0)) {
            c.mType.set(0);
        }
        JLinAlg.mtMMultiply(a_tr, b, c);
        return c;
    }

    public static void mtMMultiply(Matrix a_tr, Matrix b, Matrix c) {
        block5: {
            int nRows;
            block4: {
                nRows = a_tr.nCols;
                int nCols = b.nCols;
                if (c.mType.get(3) || c.mType.get(2)) break block4;
                double[] aCol = new double[a_tr.nRows];
                double[] bCol = new double[b.nRows];
                for (int i = 0; i < nRows; ++i) {
                    a_tr.getCol(i, aCol, 0);
                    for (int j = 0; j < nCols; ++j) {
                        b.getCol(j, bCol, 0);
                        c.aVec[c.pShft + i * c.nCols + j] = JLinAlg.VDot(aCol, bCol);
                    }
                }
                break block5;
            }
            if (!c.mType.get(3) && !c.mType.get(2)) break block5;
            double[] aCol = new double[a_tr.nRows];
            double[] bCol = new double[b.nRows];
            c.mType.set(1);
            for (int i = 0; i < nRows; ++i) {
                a_tr.getCol(i, aCol, 0);
                for (int j = 0; j <= i; ++j) {
                    b.getCol(j, bCol, 0);
                    c.setElement(i, j, JLinAlg.VDot(aCol, bCol));
                }
            }
        }
    }

    public static Matrix mMtMultiply(Matrix a, Matrix b_tr, BitSet mType) {
        int nRows = a.nRows;
        int nCols = b_tr.nRows;
        Matrix c = new Matrix(nRows, nCols, mType);
        if (a.mType.get(0) || b_tr.mType.get(0)) {
            c.mType.set(0);
        }
        JLinAlg.mMtMultiply(a, b_tr, c);
        return c;
    }

    public static Matrix mMtMultiply(Matrix a, Matrix b_tr) {
        BitSet mType = new BitSet(8);
        if (a.mType.get(0) || b_tr.mType.get(0)) {
            mType.set(0);
        }
        return JLinAlg.mMtMultiply(a, b_tr, mType);
    }

    public static void mMtMultiply(Matrix a, Matrix b_tr, Matrix c) {
        block5: {
            int nRows;
            block4: {
                nRows = a.nRows;
                int nCols = b_tr.nRows;
                if (c.mType.get(3) || c.mType.get(2)) break block4;
                for (int i = 0; i < nRows; ++i) {
                    for (int j = 0; j < nCols; ++j) {
                        c.aVec[c.pShft + i * c.nCols + j] = JLinAlg.VDot(a, i, b_tr, j);
                    }
                }
                break block5;
            }
            if (!c.mType.get(3) && !c.mType.get(2)) break block5;
            c.mType.set(1);
            for (int i = 0; i < nRows; ++i) {
                for (int j = 0; j <= i; ++j) {
                    c.setElement(i, j, JLinAlg.VDot(a, i, b_tr, j));
                }
            }
        }
    }

    public static void mtMtMultiply(Matrix a, Matrix b, Matrix c) {
        block5: {
            double[] wb;
            double[] w;
            int nRows;
            block4: {
                nRows = a.nCols;
                int nCols = b.nRows;
                w = new double[a.nRows];
                wb = new double[b.nCols];
                if (c.mType.get(3) || c.mType.get(2)) break block4;
                for (int i = 0; i < nRows; ++i) {
                    a.getCol(i, w, 0);
                    for (int j = 0; j < nCols; ++j) {
                        int bIndex = b.pShft + j * b.nCols;
                        c.aVec[c.pShft + i * c.nCols + j] = JLinAlg.VDot(a.nRows, b.aVec, bIndex, w, 0);
                    }
                }
                break block5;
            }
            if (!c.mType.get(3) && !c.mType.get(2)) break block5;
            c.mType.set(1);
            for (int i = 0; i < nRows; ++i) {
                a.getCol(i, w, 0);
                for (int j = 0; j <= i; ++j) {
                    b.getRow(j, wb, 0);
                    int bIndex = b.pShft + j * b.nCols;
                    c.setElement(i, j, JLinAlg.VDot(a.nRows, wb, 0, w, 0));
                }
            }
        }
    }

    public static Matrix mtMtMultiply(Matrix a, Matrix b, BitSet mType) {
        int nRows = a.nCols;
        int nCols = b.nRows;
        Matrix c = new Matrix(nRows, nCols, mType);
        JLinAlg.mtMtMultiply(a, b, c);
        return c;
    }

    public static Matrix mtMtMultiply(Matrix a, Matrix b) {
        BitSet mType = new BitSet(8);
        if (a.mType.get(0) || b.mType.get(0)) {
            mType.set(0);
        }
        return JLinAlg.mtMtMultiply(a, b, mType);
    }

    public static double[] mVMultiply(Matrix a, double[] v, int vLen, int vShft, double[] w, int wShft) {
        int wLen = a.nRows;
        int Len = Math.min(a.nCols, vLen);
        if (a.mType.get(4)) {
            JLinAlg.VVMul(Len, a.aVec, a.pShft, v, vShft, w, wShft);
        } else if (a.mType.get(2) && a.mType.get(1)) {
            int n = Math.min(a.nCols, wLen);
            JLinAlg.VectClear(wLen, w, wShft);
            int ij = 0;
            for (int ii = 0; ii < n; ++ii) {
                for (int jj = 0; jj < ii; ++jj) {
                    double a_ij = a.aVec[a.pShft + ij];
                    int n2 = wShft + ii;
                    w[n2] = w[n2] + v[jj] * a_ij;
                    int n3 = wShft + jj;
                    w[n3] = w[n3] + v[ii] * a_ij;
                    ++ij;
                }
                double a_ij = a.aVec[a.pShft + ij];
                int n4 = wShft + ii;
                w[n4] = w[n4] + v[ii] * a_ij;
                ++ij;
            }
        } else {
            double d = 0.0;
            for (int i = 0; i < wLen; ++i) {
                d = 0.0;
                if (a.mType.get(0)) {
                    if (a.mType.get(2) || a.mType.get(3)) {
                        int kStart = 0;
                        int kEnd = a.nCols;
                        if (!a.mType.get(1)) {
                            if (a.mType.get(3)) {
                                kStart = i;
                            } else {
                                kEnd = i + 1;
                            }
                        }
                        for (int k = kStart; k < kEnd; ++k) {
                            d += a.getElement(i, k) * v[vShft + k];
                        }
                    } else {
                        d = JLinAlg.VDot(Len, a.aVec, a.pShft + i * a.nCols, v, vShft);
                    }
                }
                w[i] = d;
            }
        }
        return w;
    }

    public static double[] mVMultiply(Matrix a, double[] v, int vShft) {
        int wLen = a.nRows;
        double[] w = new double[wLen];
        int vLen = a.nCols;
        return JLinAlg.mVMultiply(a, v, vLen, vShft, w, 0);
    }

    public static double[] mVMultiply(Matrix a, double[] v, int vShft, double[] w, int wShft) {
        int vLen = a.nCols;
        return JLinAlg.mVMultiply(a, v, vLen, vShft, w, wShft);
    }

    public static double[] vectVectDivide(int len, double[] v1, int v1Shft, double[] v2, int v2Shft, double[] v3, int v3Shft) {
        if (v3 == null) {
            v3 = new double[len];
            v3Shft = 0;
        }
        for (int i = 0; i < len; ++i) {
            if (!(Math.abs(v2[v1Shft + i]) > 1.0E-8)) continue;
            v3[v3Shft + i] = v1[v1Shft + i] / v2[v2Shft + i];
        }
        return v3;
    }

    public static double[] miVMultiply(Matrix a, double[] v, int vShft) {
        int wLen = a.nRows;
        double[] w = new double[wLen];
        return JLinAlg.miVMultiply(a, v, vShft, w, 0);
    }

    public static double[] miVMultiply(Matrix a, double[] v, int vShft, double[] w, int wShft) {
        if (!a.mType.get(7)) {
            a.diagonalize();
        }
        double[] w1 = JLinAlg.mVMultiply(a.aLEV, v, vShft);
        w1 = JLinAlg.vectVectDivide(a.nRank, w1, 0, a.aEVa.aVec, a.aEVa.pShft, w1, 0);
        return JLinAlg.mtVMultiply(a.aREV, w1, 0, w, wShft);
    }

    public static double[] mitVMultiply(Matrix a, double[] v, int vShft) {
        int wLen = a.nRows;
        double[] w = new double[wLen];
        return JLinAlg.mitVMultiply(a, v, vShft, w, 0);
    }

    public static double[] mitVMultiply(Matrix a, double[] v, int vShft, double[] w, int wShft) {
        if (!a.mType.get(7)) {
            a.diagonalize();
        }
        double[] w1 = JLinAlg.mVMultiply(a.aREV, v, vShft);
        w1 = JLinAlg.vectVectDivide(a.nRank, w1, 0, a.aEVa.aVec, a.aEVa.pShft, w1, 0);
        return JLinAlg.mtVMultiply(a.aLEV, w1, 0, w, wShft);
    }

    public static double[] mVMultiply(Matrix a, double[] v) {
        return JLinAlg.mVMultiply(a, v, 0);
    }

    public static double[] mVMultiply(Matrix a, double[] v, double[] w) {
        return JLinAlg.mVMultiply(a, v, 0, w, 0);
    }

    public static double[] mtVMultiply(Matrix a, double[] v) {
        double[] w = null;
        w = JLinAlg.mtVMultiply(a, v, 0, w, 0);
        return w;
    }

    public static double[] mtVMultiply(Matrix a, double[] v, double[] w) {
        w = JLinAlg.mtVMultiply(a, v, 0, w, 0);
        return w;
    }

    public static double[] mtVMultiply(Matrix a, double[] v, int vShft) {
        double[] w = null;
        w = JLinAlg.mtVMultiply(a, v, vShft, w, 0);
        return w;
    }

    public static double[] mtVMultiply(Matrix a, double[] v, int vShft, double[] w, int wShft) {
        int wLen = a.nCols;
        int nVec = a.nRows;
        return JLinAlg.VLinComb(wLen, v, vShft, nVec, a.aVec, a.pShft, w, wShft);
    }

    public static Matrix cpMatrix(Matrix a) {
        Matrix b = new Matrix(a.nRows, a.nCols, a.mType);
        JLinAlg.cpMatrix(a, b);
        return b;
    }

    public static void cpMatrix(Matrix a, Matrix b) {
        if (a.aLen == b.aLen) {
            int shft;
            JLinAlg.VectCopy(a.aLen, a.aVec, a.pShft, b.aVec, b.pShft);
            if (a.mType.get(7)) {
                shft = 0;
                if (b.aEVa != null) {
                    shft = b.aEVa.pShft;
                }
                JLinAlg.VectCopy(a.aEVa.aLen, a.aEVa.aVec, a.aEVa.pShft, b.aEVa.aVec, shft);
                if (b.aLEV != null) {
                    shft = b.aLEV.pShft;
                }
                JLinAlg.VectCopy(a.aLEV.aLen, a.aLEV.aVec, a.aLEV.pShft, b.aLEV.aVec, shft);
                if (b.aLEV != null) {
                    shft = b.aREV.pShft;
                }
                JLinAlg.VectCopy(a.aREV.aLen, a.aREV.aVec, a.aREV.pShft, b.aREV.aVec, shft);
            }
            if (a.aMtr != null) {
                shft = 0;
                if (b.aMtr != null) {
                    shft = b.aMtr.pShft;
                }
                JLinAlg.VectCopy(a.aMtr.aLen, a.aMtr.aVec, a.aMtr.pShft, b.aMtr.aVec, shft);
            }
        } else {
            System.err.println("Length mismatch in cpMatrix");
            throw new UnsupportedOperationException("Length mismatch in cpMatrix");
        }
    }

    public static double[][] cpMatrixDB(Matrix a) {
        double[][] b = new double[a.nRows][a.nCols];
        JLinAlg.cpMatrix(a, b);
        return b;
    }

    public static void cpMatrix(Matrix a, double[][] b) {
        if (a.nRows != b.length) {
            System.err.println("Row count mismatch in cpMatrix");
        }
        for (int i = 0; i < a.nRows; ++i) {
            if (a.nCols != b[i].length) {
                System.err.println("Row length mismatch in cpMatrix");
            }
            for (int j = 0; j < a.nCols; ++j) {
                b[i][j] = a.getElement(i, j);
            }
        }
    }

    public static void SetRank(Matrix m) {
        JLinAlg.SetRank(m, m.zeroLimit);
    }

    public static void SetRank(Matrix m, double zLimit) {
        int nnRows;
        if (m.aEVa == null) {
            return;
        }
        int From = 0;
        int To = m.aEVa.nRows;
        for (int i = 0; i < m.aEVa.nRows; ++i) {
            if (Math.abs(m.aEVa.getElement(i, i)) >= zLimit) {
                if (i >= To) break;
                ++From;
            }
            if (!(Math.abs(m.aEVa.getElement(i, i)) < zLimit)) continue;
            To = i + 1;
        }
        if ((nnRows = To - From) > 0) {
            m.aEVa.removeRows(From, nnRows);
            if (m.aLEV != null) {
                m.aLEV.removeRows(From, nnRows);
            }
            if (m.aREV != null && m.aREV != m.aLEV) {
                m.aREV.removeRows(From, nnRows);
            }
        }
        m.nRank = m.aEVa.nRows;
        m.zeroLimit = zLimit;
    }

    public static void SetRank(Matrix m, int nRank) {
        if (m.aEVa == null) {
            return;
        }
        int To = m.aEVa.nRows - nRank;
        int From = 0;
        int nnRows = To - From;
        if (nnRows > 0) {
            m.aEVa.removeRows(From, nnRows);
            if (m.aLEV != null) {
                m.aLEV.removeRows(From, nnRows);
            }
            if (m.aREV != null && m.aREV != m.aLEV) {
                m.aREV.removeRows(From, nnRows);
            }
        }
        m.nRank = m.aEVa.nRows;
    }

    public static void SetRank(Matrix m, double zLimit, boolean abs) {
        int nnRows;
        if (abs) {
            JLinAlg.SetRank(m, zLimit);
            return;
        }
        if (m.aEVa == null) {
            return;
        }
        int From = 0;
        int To = m.aEVa.nRows;
        for (int i = 0; i < m.aEVa.nRows; ++i) {
            if (m.aEVa.getElement(i, i) > zLimit) {
                if (i >= To) break;
                ++From;
            }
            if (!(m.aEVa.getElement(i, i) <= zLimit)) continue;
            To = i + 1;
        }
        if ((nnRows = To - From) > 0) {
            m.aEVa.removeRows(From, nnRows);
            if (m.aLEV != null) {
                m.aLEV.removeRows(From, nnRows);
            }
            if (m.aREV != null && m.aREV != m.aLEV) {
                m.aREV.removeRows(From, nnRows);
            }
        }
        m.nRank = m.aEVa.nRows;
        m.zeroLimit = zLimit;
    }

    public static void matrixDiagonalize(Matrix m, double small, double overlapLimit) {
        if (m.mType.get(7)) {
            return;
        }
        m.nRank = Math.min(m.nRows, m.nCols);
        boolean diagLoop = true;
        double ovl = 0.0;
        while (diagLoop) {
            if (m.mType.get(1)) {
                JLinAlg.matrixJacobiDiagonalize(m);
                JLinAlg.SortEigValVect(m);
                m.aREV = m.aLEV;
                JLinAlg.SetRank(m, small);
                diagLoop = false;
            } else {
                int i;
                BitSet symmMType = new BitSet(8);
                symmMType.set(2);
                Matrix mMt = JLinAlg.mMtMultiply(m, m, symmMType);
                JLinAlg.matrixJacobiDiagonalize(mMt);
                m.nRank = mMt.nRows;
                if (m.aLEV != null) {
                    JLinAlg.cpMatrix(mMt.aLEV, m.aLEV);
                } else {
                    m.aLEV = JLinAlg.cpMatrix(mMt.aLEV);
                }
                if (m.aEVa != null) {
                    JLinAlg.cpMatrix(mMt.aEVa, m.aEVa);
                } else {
                    m.aEVa = JLinAlg.cpMatrix(mMt.aEVa);
                }
                JLinAlg.SortEigValVect(m);
                JLinAlg.SetRank(m, small);
                if (m.aREV != null) {
                    JLinAlg.mMMultiply(m.aLEV, m, m.aREV);
                } else {
                    m.aREV = JLinAlg.mMMultiply(m.aLEV, m);
                }
                m.aREV.Unitary();
                diagLoop = false;
                if (m.nRows == m.nCols) {
                    for (i = 0; i < m.aLEV.nRows && !diagLoop; ++i) {
                        double eVal = Math.sqrt(Math.abs(m.aEVa.getElement(i, i)));
                        ovl = JLinAlg.VDot(m.aLEV, i, m.aREV, i);
                        boolean bl = diagLoop = diagLoop || Math.abs(ovl) < overlapLimit;
                        if (ovl < 0.0) {
                            JLinAlg.VectScale(m.aREV, i, -1.0, m.aREV, i);
                            eVal = -eVal;
                        }
                        m.aEVa.setElement(i, i, eVal);
                    }
                } else {
                    for (i = 0; i < m.aEVa.nRows; ++i) {
                        m.aEVa.setElement(i, i, Math.sqrt(Math.abs(m.aEVa.getElement(i, i))));
                    }
                }
                if (diagLoop) {
                    m.Symmetrize(0);
                } else {
                    JLinAlg.SortEigValVect(m);
                    JLinAlg.SetRank(m, small);
                }
            }
            if (!diagLoop) continue;
        }
        m.mType.set(7);
        if (m.nRank != m.aREV.nRows || m.nRank != m.aLEV.nRows) {
            int realRank;
            m.nRank = realRank = Math.min(Math.min(m.aLEV.nRows, m.aREV.nRows), m.nRank);
            m.aLEV.nRows = realRank;
            m.aREV.nRows = realRank;
        }
    }

    public static void SortEigValVect(Matrix m) {
        if (m.aEVa != null && m.aEVa.nRows > 0) {
            sortEigValVect funcInterface = new sortEigValVect(m);
            JLinAlg.quickSort(0, m.aEVa.nRows - 1, funcInterface);
            if (!JLinAlg.isSorted(0, m.aEVa.nRows - 1, funcInterface)) {
                System.err.println("ERROR: SORT FAILED");
            }
        }
    }

    public static void matrixJacobiDiagonalize(Matrix m) {
        Matrix d;
        int ip;
        Matrix v;
        double JACOBI_EPS = Double.MIN_VALUE;
        int nrot = 0;
        if (m.nCols != m.nRows) {
            return;
        }
        int n = m.nCols;
        double[][] a = JLinAlg.cpMatrixDB(m);
        double[] b = new double[n];
        double[] z = new double[n];
        if (m.aLEV == null) {
            v = new Matrix(n, n);
            v.mType.set(5);
            m.aLEV = v;
        } else {
            v = m.aLEV;
            JLinAlg.VectClear(m.aLEV.aLen, m.aLEV.aVec, m.aLEV.pShft);
        }
        for (ip = 0; ip < n; ++ip) {
            v.setElement(ip, ip, 1.0);
        }
        if (m.aEVa == null) {
            BitSet mType = new BitSet(8);
            mType.set(4);
            m.aEVa = d = new Matrix(n, n, mType);
        } else {
            d = m.aEVa;
        }
        for (ip = 0; ip < n; ++ip) {
            b[ip] = a[ip][ip];
            d.setElement(ip, ip, b[ip]);
        }
        for (int i = 1; i <= 50; ++i) {
            int iq;
            double sm = 0.0;
            for (ip = 0; ip < n - 1; ++ip) {
                for (iq = ip + 1; iq < n; ++iq) {
                    sm += Math.abs(a[ip][iq]);
                }
            }
            if (Math.abs(sm) < JACOBI_EPS) {
                return;
            }
            double tresh = i < 4 ? 0.2 * sm / (double)(n * n) : 0.0;
            for (ip = 0; ip < n - 1; ++ip) {
                for (iq = ip + 1; iq < n; ++iq) {
                    int k;
                    int j;
                    double t;
                    double g = 100.0 * Math.abs(a[ip][iq]);
                    double d_ip = d.getElement(ip, ip);
                    double d_iq = d.getElement(iq, iq);
                    if (i > 4 && Math.abs(d_ip) + g == Math.abs(d_ip) && Math.abs(d_iq) + g == Math.abs(d_iq)) {
                        a[ip][iq] = 0.0;
                        continue;
                    }
                    if (!(Math.abs(a[ip][iq]) > tresh)) continue;
                    double h = d_iq - d_ip;
                    if (Math.abs(h) + g == Math.abs(h)) {
                        t = a[ip][iq] / h;
                    } else {
                        double theta = 0.5 * h / a[ip][iq];
                        t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                        if (theta < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(1.0 + t * t);
                    double s = t * c;
                    double tau = s / (1.0 + c);
                    h = t * a[ip][iq];
                    int n2 = ip;
                    z[n2] = z[n2] - h;
                    int n3 = iq;
                    z[n3] = z[n3] + h;
                    d.setElement(ip, ip, d_ip - h);
                    d.setElement(iq, iq, d_iq + h);
                    a[ip][iq] = 0.0;
                    for (j = 0; j < ip; ++j) {
                        JLinAlg.rotate(a, j, ip, j, iq, tau, s);
                    }
                    for (k = 0; k < a.length; ++k) {
                    }
                    for (j = ip + 1; j < iq; ++j) {
                        JLinAlg.rotate(a, ip, j, j, iq, tau, s);
                    }
                    for (k = 0; k < a.length; ++k) {
                    }
                    for (j = iq + 1; j < n; ++j) {
                        JLinAlg.rotate(a, ip, j, iq, j, tau, s);
                    }
                    for (k = 0; k < a.length; ++k) {
                    }
                    for (j = 0; j < n; ++j) {
                        JLinAlg.rotate(v, ip, j, iq, j, tau, s);
                    }
                    for (k = 0; k < a.length; ++k) {
                    }
                    ++nrot;
                }
            }
            for (ip = 0; ip < n; ++ip) {
                int n4 = ip;
                b[n4] = b[n4] + z[ip];
                d.setElement(ip, ip, b[ip]);
                z[ip] = 0.0;
            }
        }
    }

    static void rotate(double[][] a, int i, int j, int k, int l, double tau, double s) {
        double g = a[i][j];
        double h = a[k][l];
        a[i][j] = g - s * (h + g * tau);
        a[k][l] = h + s * (g - h * tau);
    }

    static void rotate(Matrix a, int i, int j, int k, int l, double tau, double s) {
        double g = a.aVec[a.pShft + i * a.nCols + j];
        double h = a.aVec[a.pShft + k * a.nCols + l];
        a.aVec[a.pShft + i * a.nCols + j] = g - s * (h + g * tau);
        a.aVec[a.pShft + k * a.nCols + l] = h + s * (g - h * tau);
    }

    static double[] OuterProduct3D(double[] v1, int p1, double[] v2, int p2) {
        return JLinAlg.OuterProduct3D(v1, p1, v2, p2, null, 0);
    }

    static double[] OuterProduct3D(double[] v1, int p1, double[] v2, int p2, double[] v3, int p3) {
        double[] r = v3;
        int rp = p3;
        boolean doCopy = false;
        if (v3 == null || v3 == v1 && p3 == p1 || v3 == v2 && p3 == p2) {
            doCopy = v3 != null;
            v3 = new double[3];
            p3 = 0;
            if (!doCopy) {
                r = v3;
                rp = p3;
            }
        }
        v3[p3] = v1[p1 + 1] * v2[p2 + 2] - v1[p1 + 2] * v2[p2 + 1];
        v3[p3 + 1] = v1[p1 + 2] * v2[p2] - v1[p1] * v2[p2 + 2];
        v3[p3 + 2] = v1[p1] * v2[p2 + 1] - v1[p1 + 1] * v2[p2];
        if (doCopy) {
            JLinAlg.VectCopy(3, v3, p3, r, rp);
            v3 = r;
            p3 = rp;
        }
        return r;
    }

    public static boolean isSorted(int From, int To, Sortable data) {
        for (int i = From; i < To; ++i) {
            if (!data.isGreater(i, i + 1)) continue;
            return false;
        }
        return true;
    }

    public static void quickSort(int From, int To, Sortable data) {
        int left = From;
        int right = To;
        int base = (left + right) / 2;
        while (true) {
            if (data.isGreater(base, left)) {
                ++left;
                continue;
            }
            while (data.isGreater(right, base)) {
                --right;
            }
            if (left <= right) {
                if (left != right) {
                    data.swap(left, right);
                    if (base == left) {
                        base = right;
                    } else if (base == right) {
                        base = left;
                    }
                }
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (From < right) {
            JLinAlg.quickSort(From, right, data);
        }
        if (left < To) {
            JLinAlg.quickSort(left, To, data);
        }
    }

    public static String formatNumber(int l, int p, double x) {
        if (Double.isNaN(x)) {
            return " NaN ";
        }
        if (x == Double.POSITIVE_INFINITY) {
            return "+INF";
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        int sl = l - 1;
        if (l < 4) {
            sl = 3;
        }
        char[] fs = new char[sl];
        for (int i = 0; i < fs.length; ++i) {
            fs[i] = 48;
        }
        if (p < 0) {
            p = 0;
        }
        if (p > l - 3) {
            p = l - 3;
        }
        if (p != 0) {
            fs[fs.length - p - 1] = 46;
        }
        DecimalFormat myFormatter = new DecimalFormat(String.valueOf(fs));
        String out = (x < 0.0 ? "" : " ") + myFormatter.format(x);
        char[] outc = out.toCharArray();
        if (outc != null) {
            int i = 1;
            while (i < outc.length - 2 && outc[i] == '0' && outc[i + 1] != '.') {
                outc[i++] = 32;
            }
            i = 0;
            while (i < outc.length - 1 && outc[i] == '-' && outc[i + 1] == ' ') {
                outc[i] = 32;
                outc[++i] = 45;
            }
            out = String.valueOf(outc);
        }
        return out;
    }

    public static double press(double[] x, double[] y) {
        if (x.length != y.length) {
            System.err.println("x and y size mismatch in JLinAlg.press");
            throw new UnsupportedOperationException("x, y size mismatch in press.");
        }
        double s2 = 0.0;
        for (int i = 0; i < y.length; ++i) {
            s2 += (x[i] - y[i]) * (x[i] - y[i]);
        }
        if (s2 > 0.001) {
            System.err.println("Cartesian coordinates does not match in press.");
            throw new UnsupportedOperationException("Cartesian coordinates does not match in press.");
        }
        return s2;
    }

    public static interface Sortable {
        public boolean isGreater(int var1, int var2);

        public void swap(int var1, int var2);
    }

    public static class sortEigValVect
    implements Sortable {
        Matrix m = null;

        public sortEigValVect(Matrix pMatrix) {
            this.m = pMatrix;
        }

        @Override
        public boolean isGreater(int i, int j) {
            return this.m.aEVa.getElement(i, i) > this.m.aEVa.getElement(j, j);
        }

        @Override
        public void swap(int i, int j) {
            double[] tmpVec;
            int vLen;
            double xx = this.m.aEVa.getElement(i, i);
            this.m.aEVa.setElement(i, i, this.m.aEVa.getElement(j, j));
            this.m.aEVa.setElement(j, j, xx);
            if (this.m.aLEV != null) {
                vLen = this.m.aLEV.nCols;
                tmpVec = new double[vLen];
                JLinAlg.VectCopy(vLen, this.m.aLEV.aVec, this.m.aLEV.pShft + i * this.m.aLEV.nCols, tmpVec, 0);
                JLinAlg.VectCopy(vLen, this.m.aLEV.aVec, this.m.aLEV.pShft + j * this.m.aLEV.nCols, this.m.aLEV.aVec, this.m.aLEV.pShft + i * this.m.aLEV.nCols);
                JLinAlg.VectCopy(vLen, tmpVec, 0, this.m.aLEV.aVec, this.m.aLEV.pShft + j * this.m.aLEV.nCols);
            }
            if (this.m.aREV != null) {
                vLen = this.m.aREV.nCols;
                tmpVec = new double[vLen];
                JLinAlg.VectCopy(vLen, this.m.aREV.aVec, this.m.aREV.pShft + i * this.m.aREV.nCols, tmpVec, 0);
                JLinAlg.VectCopy(vLen, this.m.aREV.aVec, this.m.aREV.pShft + j * this.m.aREV.nCols, this.m.aREV.aVec, this.m.aREV.pShft + i * this.m.aREV.nCols);
                JLinAlg.VectCopy(vLen, tmpVec, 0, this.m.aREV.aVec, this.m.aREV.pShft + j * this.m.aREV.nCols);
            }
        }
    }

    public static class JacobiTransformation {
        public double[][] a;
        public Matrix d;
        public Matrix v;
        public int n;
        public int nrot;
        static final double JACOBI_EPS = 1.0E-5;

        public JacobiTransformation(Matrix m) {
            int ip;
            if (m.nCols != m.nRows) {
                return;
            }
            this.n = m.nCols;
            this.a = JLinAlg.cpMatrixDB(m);
            double[] b = new double[this.n];
            double[] z = new double[this.n];
            if (m.aLEV == null) {
                this.v = new Matrix(this.n, this.n);
                this.v.mType.set(5);
                m.aLEV = this.v;
            } else {
                this.v = m.aLEV;
            }
            for (ip = 0; ip < this.n; ++ip) {
                this.v.setElement(ip, ip, 1.0);
            }
            if (m.aEVa == null) {
                BitSet mType = new BitSet(8);
                mType.set(4);
                m.aEVa = this.d = new Matrix(this.n, this.n, mType);
            } else {
                this.d = m.aEVa;
            }
            for (ip = 0; ip < this.n; ++ip) {
                b[ip] = this.a[ip][ip];
                this.d.setElement(ip, ip, b[ip]);
            }
            for (int i = 1; i <= 50; ++i) {
                int iq;
                double sm = 0.0;
                for (ip = 0; ip < this.n - 1; ++ip) {
                    for (iq = ip + 1; iq < this.n; ++iq) {
                        sm += Math.abs(this.a[ip][iq]);
                    }
                }
                if (Math.abs(sm) < 1.0E-5) {
                    return;
                }
                double tresh = i < 4 ? 0.2 * sm / (double)(this.n * this.n) : 0.0;
                for (ip = 0; ip < this.n - 1; ++ip) {
                    for (iq = ip + 1; iq < this.n; ++iq) {
                        int j;
                        double t;
                        double g = 100.0 * Math.abs(this.a[ip][iq]);
                        double d_ip = this.d.getElement(ip, ip);
                        double d_iq = this.d.getElement(iq, iq);
                        if (i > 4 && Math.abs(d_ip) + g == Math.abs(d_ip) && Math.abs(d_iq) + g == Math.abs(d_iq)) {
                            this.a[ip][iq] = 0.0;
                            continue;
                        }
                        if (!(Math.abs(this.a[ip][iq]) > tresh)) continue;
                        double h = d_iq - d_ip;
                        if (Math.abs(h) + g == Math.abs(h)) {
                            t = this.a[ip][iq] / h;
                        } else {
                            double theta = 0.5 * h / this.a[ip][iq];
                            t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                            if (theta < 0.0) {
                                t = -t;
                            }
                        }
                        double c = 1.0 / Math.sqrt(1.0 + t * t);
                        double s = t * c;
                        double tau = s / (1.0 + c);
                        h = t * this.a[ip][iq];
                        int n = ip;
                        z[n] = z[n] - h;
                        int n2 = iq;
                        z[n2] = z[n2] + h;
                        this.d.setElement(ip, ip, d_ip - h);
                        this.d.setElement(iq, iq, d_iq + h);
                        this.a[ip][iq] = 0.0;
                        for (j = 0; j < ip; ++j) {
                            this.rotate(this.a, j, ip, j, iq, tau, s);
                        }
                        for (j = ip + 1; j < iq; ++j) {
                            this.rotate(this.a, ip, j, j, iq, tau, s);
                        }
                        for (j = iq + 1; j < this.n; ++j) {
                            this.rotate(this.a, ip, j, iq, j, tau, s);
                        }
                        for (j = 0; j < this.n; ++j) {
                            this.rotate(this.v, j, ip, j, iq, tau, s);
                        }
                        ++this.nrot;
                    }
                }
                for (ip = 0; ip < this.n; ++ip) {
                    int n = ip;
                    b[n] = b[n] + z[ip];
                    this.d.setElement(ip, ip, b[ip]);
                    z[ip] = 0.0;
                }
            }
        }

        void rotate(double[][] a, int i, int j, int k, int l, double tau, double s) {
            double g = a[i][j];
            double h = a[k][l];
            a[i][j] = g - s * (h + g * tau);
            a[k][l] = h + s * (g - h * tau);
        }

        void rotate(Matrix a, int i, int j, int k, int l, double tau, double s) {
            double g = a.aVec[a.pShft + i * a.nCols + j];
            double h = a.aVec[a.pShft + k * a.nCols + l];
            a.aVec[a.pShft + i * a.nCols + j] = g - s * (h + g * tau);
            a.aVec[a.pShft + k * a.nCols + l] = h + s * (g - h * tau);
        }
    }

    public static class OrthogonalBasis {
        private double small = 1.0E-8;
        private int maxNumberOfVectors = 0;
        private int numberOfVectors = 0;
        private double[][] basis = null;
        private double[][] basisCoefficients = null;
        double[] c = null;

        public OrthogonalBasis(int maxNumberOfVectors) {
            this.maxNumberOfVectors = maxNumberOfVectors;
            this.basis = new double[maxNumberOfVectors][];
            this.basisCoefficients = new double[maxNumberOfVectors][];
            this.c = new double[maxNumberOfVectors];
        }

        public OrthogonalBasis(int maxNumberOfVectors, double small) {
            this.maxNumberOfVectors = maxNumberOfVectors;
            this.small = small;
            this.basis = new double[maxNumberOfVectors][];
            this.basisCoefficients = new double[maxNumberOfVectors][];
            this.c = new double[maxNumberOfVectors];
        }

        public boolean addVector(double[] v) {
            int i;
            if (this.numberOfVectors > 0 && v.length != this.basis[0].length || this.numberOfVectors == this.maxNumberOfVectors) {
                return false;
            }
            this.basis[this.numberOfVectors] = new double[v.length];
            if (!JLinAlg.VectNormalize(v.length, v, 0, this.basis[this.numberOfVectors], 0, null, Double.MIN_VALUE)) {
                return false;
            }
            for (i = 0; i < this.numberOfVectors; ++i) {
                this.c[i] = JLinAlg.VDot(this.basis[i], this.basis[this.numberOfVectors]);
            }
            if (1.0 - Math.sqrt(JLinAlg.VDot(this.numberOfVectors, this.c, 0, this.c, 0)) < this.small) {
                return false;
            }
            for (i = 0; i < this.numberOfVectors; ++i) {
                JLinAlg.VectScaleAndAdd(this.basis[this.numberOfVectors], -this.c[i], this.basis[i], this.basis[this.numberOfVectors]);
            }
            double vLen = JLinAlg.VLength(v);
            if (vLen > 0.0) {
                this.c[this.numberOfVectors] = 1.0 / vLen;
            }
            if (JLinAlg.VectNormalize(v.length, this.basis[this.numberOfVectors], 0, this.basis[this.numberOfVectors], 0, null, this.small)) {
                this.basisCoefficients[this.numberOfVectors] = new double[this.numberOfVectors + 1];
                for (int i2 = 0; i2 < this.numberOfVectors; ++i2) {
                    JLinAlg.VectScaleAndAdd(this.basisCoefficients[this.numberOfVectors], -this.c[i2], this.basisCoefficients[i2], this.basisCoefficients[this.numberOfVectors]);
                }
                this.basisCoefficients[this.numberOfVectors][this.numberOfVectors] = this.c[this.numberOfVectors];
                ++this.numberOfVectors;
                return true;
            }
            return false;
        }

        public double[][] getBasis() {
            double[][] b = new double[this.numberOfVectors][];
            for (int i = 0; i < b.length; ++i) {
                b[i] = this.basis[i];
            }
            return b;
        }

        public double[] getComponents(double[] v, double[] c) {
            int i;
            if (this.basis[0] == null || v.length != this.basis[0].length) {
                return null;
            }
            if (c == null) {
                c = new double[this.numberOfVectors];
            }
            for (i = 0; i < this.numberOfVectors; ++i) {
                c[i] = JLinAlg.VDot(v, this.basis[i]);
            }
            for (i = this.numberOfVectors; i < c.length; ++i) {
                c[i] = 0.0;
            }
            return c;
        }

        public double[] getVectorProjection(double[] basisComponents, double[] c) {
            return JLinAlg.VLinComb(basisComponents, this.basis, c);
        }

        public double[] getComponentsOnOriginalVectors(double[] basisComponents, double[] c) {
            return JLinAlg.VLinComb(basisComponents, this.basisCoefficients, c);
        }

        public boolean setBasis(double[][] basis) {
            this.numberOfVectors = 0;
            int i = 0;
            for (i = 0; i < this.numberOfVectors && this.addVector(basis[i]); ++i) {
            }
            return i > basis.length;
        }

        public boolean removeLastBasisVector() {
            if (this.numberOfVectors > 0) {
                --this.numberOfVectors;
                return true;
            }
            return false;
        }
    }

    public static class SubSpace {
        VectorSubSet vSSet = null;
        VectorSet vSet = null;
        public BitSet sSType = null;
        public static final int lSSType = 4;
        public static final int UNIT_V = 0;
        public static final int ORTH_V = 1;
        public static final int SEQV_S = 2;
        public static final int DIAG_O = 3;

        public SubSpace(VectorSubSet wSSet) {
            this.sSType = new BitSet(4);
            this.sSType.set(0);
            this.sSType.set(1);
            this.SetupSubSpace(wSSet, null, this.sSType);
        }

        public SubSpace(VectorSubSet wSSet, VectorSet wSet) {
            this.SetupSubSpace(wSSet, wSet, null);
        }

        public void SetupSubSpace(VectorSubSet wSSet, VectorSet wSet, BitSet wSSType) {
            this.sSType = wSSType;
            if (this.sSType == null) {
                this.sSType = new BitSet(4);
            }
            this.vSSet = wSSet;
            if (wSet == null) {
                this.vSet = new VectorSet(this.vSSet.nVec - 1, this.vSSet.vSet.nVec, this.vSSet.vSet.vOvr);
                if (this.vSet.sType.get(2)) {
                    // empty if block
                }
                int i0 = 0;
                for (int i = 0; i < this.vSet.nVec; ++i) {
                    int j = i + 1;
                    if (this.sSType.get(2)) {
                        i0 = i;
                    }
                    this.vSet.vSet[i][this.vSet.vShft[i] + this.vSSet.vInd[j]] = -1.0;
                    this.vSet.vSet[i][this.vSet.vShft[i] + this.vSSet.vInd[i0]] = 1.0;
                }
            } else {
                this.vSet = wSet;
            }
            if (this.sSType.get(0)) {
                this.vSet.NormalizeSet();
                this.vSet.sType.set(0);
            }
            if (this.sSType.get(1)) {
                this.vSet.sType.set(1);
                this.SchmidtO();
            } else if (this.vSet.sType.get(0)) {
                for (int i = 0; i < this.vSet.nVec; ++i) {
                    this.vSet.Normalize(i);
                }
            }
        }

        public double[] LinComb(double[] c, int cShft, double[] w, int wShft) {
            int i;
            int wLen = this.vSSet.vSet.vLen;
            int nVec = this.vSet.nVec;
            if (w == null) {
                w = new double[wLen];
            } else {
                JLinAlg.VectClear(wLen, w, wShft);
            }
            double[] ww = new double[this.vSet.vLen];
            for (i = 0; i < nVec; ++i) {
                JLinAlg.VectScaleAndAdd(this.vSet.vLen, ww, 0, c[cShft + i], this.vSet.vSet[i], this.vSet.vShft[i], ww, 0);
            }
            for (i = 0; i < this.vSet.vLen; ++i) {
                JLinAlg.VectScaleAndAdd(wLen, w, wShft, ww[i], this.vSSet.vSet.vSet[i], this.vSSet.vSet.vShft[i], w, wShft);
            }
            return w;
        }

        public void SchmidtO() {
            JLinAlg.VSchmidtO(this.vSet, this.vSet, 1.0E-4);
        }

        public double[] Components(double[] v) {
            return this.Components(v, 0, null, 0);
        }

        public double[] Components(double[] v, int vShft) {
            return this.Components(v, vShft, null, 0);
        }

        public double[] Components(double[] v, int vShft, double[] c, int cShft) {
            int i;
            if (c == null) {
                c = new double[this.vSet.nVec];
                cShft = 0;
            }
            double[] w = new double[this.vSSet.vSet.nVec];
            int wShft = 0;
            for (i = 0; i < this.vSSet.vSet.nVec; ++i) {
                w[i] = JLinAlg.VDot(this.vSSet.vSet.vLen, this.vSSet.vSet.vSet[i], this.vSSet.vSet.vShft[i], v, vShft);
            }
            for (i = 0; i < this.vSet.nVec; ++i) {
                c[i] = JLinAlg.VDot(this.vSet.vLen, this.vSet.vSet[i], this.vSet.vShft[i], w, wShft);
            }
            return c;
        }
    }

    public static class VectorSubSet {
        VectorSet vSet = null;
        int nVec = 0;
        int[] vInd = null;

        public VectorSubSet(VectorSet wSet, int nWVec, int[] wInd) {
            this.SetupVectorSubSet(wSet, nWVec, wInd);
        }

        public VectorSubSet(VectorSet wSet, int nWVec) {
            this.SetupVectorSubSet(wSet, nWVec, this.vInd);
        }

        public void SetupVectorSubSet(VectorSet wSet, int nWVec, int[] wInd) {
            this.vSet = wSet;
            this.nVec = nWVec;
            if (wInd == null) {
                wInd = new int[this.vSet.nVec];
                for (int i = 0; i < this.nVec; ++i) {
                    wInd[i] = i;
                }
            }
            this.vInd = wInd;
        }

        public void AddVector(double[] w, int wShft) {
            int iVec = 0;
            if (this.nVec == this.vInd.length) {
                iVec = this.vInd[0];
                --this.nVec;
                for (int i = 0; i < this.nVec; ++i) {
                    this.vInd[i] = this.vInd[i + 1];
                }
            } else {
                iVec = this.vInd[this.nVec];
            }
            this.vInd[this.nVec] = iVec;
            this.ChangeVector(this.nVec, w, wShft);
            ++this.nVec;
        }

        public void InsertVector(double[] w, int wShft) {
            if (this.nVec == this.vInd.length) {
                --this.nVec;
            }
            int iVec = this.vInd[this.nVec];
            ++this.nVec;
            for (int i = this.nVec - 1; i > 0; --i) {
                this.vInd[i] = this.vInd[i - 1];
            }
            this.vInd[0] = iVec;
            this.ChangeVector(0, w, wShft);
        }

        public void ChangeVector(int iSVec, double[] w, int wShft) {
            this.vSet.ChangeVector(this.vInd[iSVec], w, wShft);
        }

        public double vSetDot(int i, int j) {
            return this.vSet.vSetDot(this.vInd[i], this.vInd[j]);
        }

        public void vSetVectAdd(int i, int wLen, double[] w, int wShft) {
            this.vSet.vSetVectAdd(this.vInd[i], wLen, w, wShft);
        }

        public void vSetVectAdd(int i, double[] w) {
            int wLen = w.length;
            int wShft = 0;
            this.vSet.vSetVectAdd(this.vInd[i], wLen, w, wShft);
        }

        public void Normalize(int i, int j) {
            this.Normalize(this.vInd[i], this.vInd[j], 1.0E-8);
        }

        public void Normalize(int i, double zLimit) {
            this.Normalize(this.vInd[i], this.vInd[i], zLimit);
        }

        public void Normalize(int i) {
            this.Normalize(this.vInd[i], this.vInd[i], 1.0E-8);
        }

        public void Normalize(int i, int j, double zLimit) {
            this.vSet.Normalize(i, i, zLimit);
        }

        public double[] Unit(int i) {
            return this.vSet.Unit(this.vInd[i], 1.0E-8);
        }

        public double[] Unit(int i, double zLimit) {
            return this.vSet.Unit(this.vInd[i], zLimit);
        }

        public void Print(String Message) {
            System.err.println(Message);
            for (int i = 0; i < this.nVec; ++i) {
                for (int j = 0; j < this.vSet.vLen; ++j) {
                    System.err.print(" " + this.vSet.vSet[this.vInd[i]][this.vSet.vShft[this.vInd[i]] + j]);
                }
                System.err.println();
            }
        }
    }

    public static class VectorSet {
        double[][] vSet = null;
        int[] vShft = null;
        int nVec = 0;
        int vLen = 0;
        Matrix vOvr = null;
        Matrix vMtr = null;
        public BitSet sType = null;
        public static final int lType = 4;
        public static final int UNIT_V = 0;
        public static final int ORTH_V = 1;
        public static final int METR_M = 2;
        public static final int VOVR_M = 3;

        public VectorSet(int nVectors, int vLength, double[] w, int wShft, BitSet wType, Matrix wOvr, Matrix wMtr) {
            this.CreateVectorSet(nVectors, vLength, w, wShft, wType, wOvr, wMtr);
        }

        public VectorSet(int nVectors, int vLength, double[] w, int wShft, BitSet wType) {
            this.CreateVectorSet(nVectors, vLength, w, wShft, wType, null, null);
        }

        public VectorSet(int nVectors, int vLength, double[] w, int wShft, Matrix wOvr) {
            this.sType = new BitSet(4);
            this.sType.set(3);
            this.CreateVectorSet(nVectors, vLength, w, wShft, this.sType, wOvr, null);
        }

        public VectorSet(int nVectors, int vLength, double[] w, int wShft) {
            this.CreateVectorSet(nVectors, vLength, w, wShft, null, null, null);
        }

        public VectorSet(int nVectors, int vLength, Matrix wMtr) {
            this.CreateVectorSet(nVectors, vLength, null, 0, null, null, wMtr);
        }

        public VectorSet(int nVectors, int vLength) {
            this.CreateVectorSet(nVectors, vLength, null, 0, null, null, null);
        }

        public VectorSet(int nVectors, int vLength, BitSet wType) {
            this.CreateVectorSet(nVectors, vLength, null, 0, wType, null, null);
        }

        public void CreateVectorSet(int nVectors, int vLength, double[] w, int wShft, BitSet wType, Matrix wOvr, Matrix wMtr) {
            this.nVec = nVectors;
            this.vLen = vLength;
            this.vSet = new double[nVectors][];
            this.vShft = new int[nVectors];
            if (w == null) {
                workingSpace wS = new workingSpace(this.nVec * vLength);
                w = wS.wVec;
                wShft = wS.wPtr;
            }
            if (w != null) {
                for (int i = 0; i < this.nVec; ++i) {
                    this.vSet[i] = w;
                    this.vShft[i] = wShft + i * this.vLen;
                }
            } else {
                throw new UnsupportedOperationException("No working area - impossible.");
            }
            this.sType = wType != null ? wType : new BitSet(4);
            if (wMtr != null) {
                this.AddMetric(wMtr);
            }
            if (this.sType.get(3) || wOvr != null) {
                this.AddOverlap(wOvr);
            }
        }

        public void AddMetric(Matrix wMtr) {
            this.sType.set(2);
            this.vMtr = wMtr;
            if (this.vMtr == null) {
                System.err.println("Required metric tensor is missing in VectorSet.");
                throw new UnsupportedOperationException("Required metric tensor is missing in VectorSet.");
            }
        }

        public void AddOverlap() {
            this.AddOverlap(null);
        }

        public void AddOverlap(Matrix wOvr) {
            this.sType.set(3);
            this.vOvr = wOvr;
            if (this.vOvr == null) {
                BitSet oType = new BitSet(8);
                oType.set(2);
                oType.set(1);
                int mVec = this.vSet.length;
                this.vOvr = new Matrix(mVec, mVec, oType);
                this.UpdateOverlap();
            }
        }

        public void UpdateOverlap() {
            this.UpdateOverlap(0, this.nVec);
        }

        public void UpdateOverlap(int iVec) {
            if (this.vOvr == null) {
                this.AddOverlap();
            } else if (iVec < 0) {
                for (int i = 0; i < this.nVec; ++i) {
                    for (int j = 0; j <= i; ++j) {
                        this.vOvr.setElement(i, j, this.vSetDot0(i, j));
                    }
                }
            } else {
                for (int j = 0; j < this.nVec; ++j) {
                    this.vOvr.setElement(iVec, j, this.vSetDot0(iVec, j));
                }
            }
        }

        public void UpdateOverlap(int iFrom, int iEnd) {
            if (this.vOvr == null) {
                this.AddOverlap();
                return;
            }
            for (int i = iFrom; i < iEnd; ++i) {
                for (int j = 0; j <= i; ++j) {
                    this.vOvr.setElement(i, j, this.vSetDot0(i, j));
                }
            }
        }

        public void ChangeVector(int iVec, double[] w) {
            this.ChangeVector(iVec, w, 0);
        }

        public void ChangeVector(int iVec, double[] w, int wShft) {
            if (this.vSet[iVec] == null) {
                this.vSet[iVec] = w;
                this.vShft[iVec] = wShft;
            } else {
                JLinAlg.VectCopy(this.vLen, w, wShft, this.vSet[iVec], this.vShft[iVec]);
            }
            if (this.sType.get(0)) {
                this.Normalize(iVec);
            }
            if (this.sType.get(3)) {
                this.UpdateOverlap(iVec);
            }
        }

        public double vSetDot(int i, int j) {
            if (this.sType.get(3) && this.vOvr != null) {
                return this.vOvr.getElement(i, j);
            }
            if (this.sType.get(2)) {
                return JLinAlg.VDot(this.vLen, this.vSet[i], this.vShft[i], this.vSet[j], this.vShft[j], this.vMtr);
            }
            return JLinAlg.VDot(this.vLen, this.vSet[i], this.vShft[i], this.vSet[j], this.vShft[j]);
        }

        public double vSetDot0(int i, int j) {
            if (this.sType.get(2)) {
                return JLinAlg.VDot(this.vLen, this.vSet[i], this.vShft[i], this.vSet[j], this.vShft[j], this.vMtr);
            }
            return JLinAlg.VDot(this.vLen, this.vSet[i], this.vShft[i], this.vSet[j], this.vShft[j]);
        }

        public void vSetVectAdd(int i, int wLen, double[] w, int wShft) {
            int len = Math.min(this.vLen, wLen);
            JLinAlg.VectAdd(len, this.vSet[i], this.vShft[i], w, wShft, this.vSet[i], this.vShft[i]);
            if (this.sType.get(3)) {
                this.UpdateOverlap(i);
            }
        }

        public void Normalize(int i, int j) {
            this.Normalize(i, j, 1.0E-8);
        }

        public void Normalize(int i, double zLimit) {
            this.Normalize(i, i, zLimit);
        }

        public void Normalize(int i) {
            this.Normalize(i, i, 1.0E-8);
        }

        public void Normalize(int i, int j, double zLimit) {
            if (this.sType.get(2)) {
                JLinAlg.VectNormalize(this.vLen, this.vSet[i], this.vShft[i], this.vSet[j], this.vShft[j], this.vMtr, zLimit);
            } else {
                JLinAlg.VectNormalize(this.vLen, this.vSet[i], this.vShft[i], this.vSet[j], this.vShft[j], null, zLimit);
            }
            if (this.sType.get(3)) {
                this.UpdateOverlap(j);
            }
        }

        public void NormalizeSet(double zLimit) {
            if (!this.sType.get(0)) {
                for (int i = 0; i < this.nVec; ++i) {
                    this.Normalize(i, i, zLimit);
                }
            }
            this.sType.set(0);
        }

        public void NormalizeSet() {
            this.NormalizeSet(1.0E-8);
        }

        public double[] Unit(int i) {
            return this.Unit(i, 1.0E-8);
        }

        public double[] Unit(int i, double zLimit) {
            double[] w = new double[this.vLen];
            this.Unit(i, w, 0, zLimit);
            return w;
        }

        public void Unit(int i, double[] w, int wShft, double zLimit) {
            if (this.sType.get(2)) {
                JLinAlg.VectNormalize(this.vLen, this.vSet[i], this.vShft[i], w, wShft, this.vMtr, zLimit);
            } else {
                JLinAlg.VectNormalize(this.vLen, this.vSet[i], this.vShft[i], w, wShft, null, zLimit);
            }
        }

        public void Print(String Message) {
            System.err.println(Message);
            for (int i = 0; i < this.nVec; ++i) {
                for (int j = 0; j < this.vLen; ++j) {
                    System.err.print(" " + this.vSet[i][this.vShft[i] + j]);
                }
                System.err.println();
            }
        }
    }

    public static class Matrix
    implements Serializable {
        private static final long serialVersionUID = 6081259919527615070L;
        double zeroLimit = 1.0E-10;
        public double[] aVec = null;
        public int[] aInd = null;
        public Matrix aMtr = null;
        public Matrix aLEV = null;
        public Matrix aREV = null;
        public Matrix aEVa = null;
        public Matrix oMat = null;
        public int nCols = 0;
        public int nRows = 0;
        public int aLen = 0;
        public int pShft = 0;
        public int nRank = 0;
        public BitSet mType = null;
        public static final int lType = 8;
        public static final int FULL_M = 0;
        public static final int SYMM_M = 1;
        public static final int L_TRIA = 2;
        public static final int U_TRIA = 3;
        public static final int DIAG_M = 4;
        public static final int UNIT_M = 5;
        public static final int METR_M = 6;
        public static final int HAVE_D = 7;

        public Matrix(double[] v, int n_rows) {
            BitSet matrixType = new BitSet(8);
            int n_cols = v.length / n_rows;
            this.setupFullMatrix(v, n_rows, n_cols, 0, null, matrixType);
        }

        public Matrix(double[] v, int n_rows, int n_cols, int pointerShift) {
            BitSet matrixType = new BitSet(8);
            this.setupFullMatrix(v, n_rows, n_cols, pointerShift, null, matrixType);
        }

        public Matrix(double[] v, int n_rows, Matrix metric) {
            BitSet matrixType = new BitSet(8);
            int n_cols = v.length / n_rows;
            this.setupFullMatrix(v, n_rows, n_cols, 0, metric, matrixType);
        }

        public Matrix(double[] v, int n_rows, int n_cols, int pointerShift, Matrix metric) {
            BitSet matrixType = new BitSet(8);
            this.setupFullMatrix(v, n_rows, n_cols, pointerShift, metric, matrixType);
        }

        public Matrix(double[] v) {
            BitSet matrixType = new BitSet(8);
            matrixType.set(4);
            this.setupFullMatrix(v, v.length, v.length, 0, null, matrixType);
        }

        public Matrix(int n_rows, int n_cols) {
            this.setupFullMatrix(null, n_rows, n_cols, 0, null, null);
        }

        public Matrix(int n_rows, int n_cols, BitSet matrixType) {
            this.setupFullMatrix(null, n_rows, n_cols, 0, null, matrixType);
        }

        public Matrix(double[][] m) {
            BitSet matrixType = new BitSet(8);
            this.storeDDMatrix(m, 0, matrixType);
        }

        public Matrix(String s) {
            StringConversionUtility.fromString(new GuardedObject(this, new AllPermission()), s);
        }

        public String toString() {
            return StringConversionUtility.toString(new GuardedObject(this, new AllPermission()));
        }

        void storeDDMatrix(double[][] m, int pointerShift, BitSet matrixType) {
            int nrows = m.length;
            int ncols = 0;
            for (int i = 0; i < m.length; ++i) {
                ncols = Math.max(m[i].length, ncols);
            }
            double[] aVec = new double[nrows * ncols];
            for (int i = 0; i < m.length; ++i) {
                for (int j = 0; j < m[i].length; ++j) {
                    aVec[this.pShft + i * ncols + j] = m[i][j];
                }
            }
            this.setupFullMatrix(aVec, nrows, ncols, 0, null, matrixType);
        }

        void setupFullMatrix(double[] v, int n_rows, int n_cols, int pointerShift, Matrix metric, BitSet matrixType) {
            if (n_cols == 0) {
                n_cols = n_rows;
            }
            if (n_rows == 0) {
                n_rows = n_cols;
            }
            this.mType = matrixType != null ? (BitSet)matrixType.clone() : new BitSet(8);
            this.mType.set(0);
            this.nRows = n_rows;
            this.nCols = n_cols;
            this.aVec = v;
            int vLen = 0;
            if (this.mType.get(2) || this.mType.get(3)) {
                this.nCols = this.nRows = Math.min(this.nRows, this.nCols);
                vLen = this.nCols * (this.nCols + 1) / 2;
            } else {
                vLen = this.mType.get(4) ? (this.nCols = (this.nRows = Math.min(this.nRows, this.nCols))) : this.nRows * this.nCols;
            }
            this.aLen = vLen;
            if (this.aVec == null) {
                this.aVec = new double[vLen];
            }
            if (metric != null) {
                this.mType.set(6);
                this.aMtr = metric;
            }
        }

        public double getElement(int i, int j) {
            double d = Double.NaN;
            if (this.mType.get(0)) {
                if (this.mType.get(4)) {
                    if (i == j) {
                        d = this.aVec[this.pShft + i];
                    }
                } else if (this.mType.get(2)) {
                    if (this.mType.get(1) || i >= j) {
                        d = this.aVec[this.pShft + Matrix.lIndex(i, j)];
                    }
                } else if (this.mType.get(3) && (this.mType.get(1) || i <= j)) {
                    if (this.mType.get(1) || j >= i) {
                        d = this.aVec[this.pShft + this.uIndex(i, j)];
                    }
                } else {
                    d = this.aVec[this.pShft + i * this.nCols + j];
                }
            }
            return d;
        }

        public double[] getRow(int i) {
            double[] w = new double[this.nCols];
            this.getRow(i, w, 0);
            return w;
        }

        public void getRow(int i, double[] w, int wShft) {
            if (this.mType.get(0)) {
                if (this.mType.get(3) || this.mType.get(2)) {
                    int kStart = 0;
                    int kEnd = this.nCols;
                    if (!this.mType.get(1)) {
                        if (this.mType.get(3)) {
                            kStart = i;
                            JLinAlg.VectClear(i + 1, w, wShft);
                        } else {
                            kEnd = i + 1;
                            JLinAlg.VectClear(this.nCols - kEnd, w, wShft + kEnd);
                        }
                    }
                    for (int k = kStart; k < kEnd; ++k) {
                        w[k] = this.getElement(i, k);
                    }
                } else if (this.mType.get(4)) {
                    JLinAlg.VectClear(this.nCols, w, wShft);
                    w[i] = this.aVec[this.pShft + i];
                } else {
                    JLinAlg.VectCopy(this.nCols, this.aVec, this.pShft + this.rowIndex(i), w, wShft);
                }
            }
        }

        public double[] getCol(int i) {
            double[] w = new double[this.nRows];
            this.getCol(i, w, 0);
            return w;
        }

        public void getCol(int i, double[] w, int wShft) {
            block9: {
                if (!this.mType.get(0)) break block9;
                if (this.mType.get(3) || this.mType.get(3)) {
                    int kStart = 0;
                    int kEnd = this.nCols;
                    if (!this.mType.get(1)) {
                        if (this.mType.get(3)) {
                            kStart = i;
                            JLinAlg.VectClear(i + 1, w, wShft);
                        } else {
                            kEnd = i + 1;
                            JLinAlg.VectClear(this.nCols - kEnd, w, wShft + kEnd);
                        }
                    }
                    for (int k = kStart; k < kEnd; ++k) {
                        w[k] = this.getElement(k, i);
                    }
                } else if (this.mType.get(4)) {
                    JLinAlg.VectClear(this.nCols, w, wShft);
                    w[i] = this.aVec[this.pShft + i];
                } else {
                    for (int k = 0; k < this.nRows; ++k) {
                        w[k] = this.getElement(k, i);
                    }
                }
            }
        }

        public void setElement(int i, int j, double d) {
            if (this.mType.get(0)) {
                if (this.mType.get(4)) {
                    if (i == j) {
                        this.aVec[this.pShft + i] = d;
                    }
                } else if (this.mType.get(2)) {
                    if (this.mType.get(1) || i >= j) {
                        this.aVec[this.pShft + Matrix.lIndex((int)i, (int)j)] = d;
                    }
                } else if (this.mType.get(3)) {
                    if (this.mType.get(1) || j >= i) {
                        this.aVec[this.pShft + this.uIndex((int)i, (int)j)] = d;
                    }
                } else {
                    this.aVec[this.pShft + i * this.nCols + j] = d;
                }
            }
            this.mType.clear(7);
        }

        public void setRow(int i, double[] vec, int vecInd) {
            if (this.mType.get(0)) {
                if (this.mType.get(4)) {
                    this.aVec[this.pShft + i] = vec[vecInd + i];
                } else if (this.mType.get(2)) {
                    for (int j = 0; j <= i; ++j) {
                        this.aVec[this.pShft + Matrix.lIndex((int)i, (int)j)] = vec[vecInd + j];
                    }
                } else if (this.mType.get(3)) {
                    for (int j = i; j < this.nCols; ++j) {
                        this.aVec[this.pShft + this.uIndex((int)i, (int)j)] = vec[vecInd + j];
                    }
                } else {
                    JLinAlg.VectCopy(this.nCols, vec, vecInd, this.aVec, this.pShft + this.rowIndex(i));
                }
            }
            this.mType.clear(7);
        }

        public int rowIndex(int i) {
            if (this.mType.get(2)) {
                return Matrix.lIndex(i, 0);
            }
            if (this.mType.get(3)) {
                return this.uIndex(i, 0);
            }
            if (this.mType.get(4)) {
                return i;
            }
            return i * this.nCols;
        }

        public int endIndex() {
            int lastIndex = 0;
            lastIndex = this.mType.get(2) ? Matrix.lIndex(this.nRows, this.nRows) : (this.mType.get(3) ? this.uIndex(this.nRows, this.nRows) : (this.mType.get(4) ? this.nRows - 1 : this.nRows * this.nCols - 1));
            return lastIndex + 1;
        }

        private static int lIndex(int i, int j) {
            int ii = Math.max(i, j);
            int jj = Math.min(i, j);
            return ii * (ii + 1) / 2 + jj;
        }

        private int uIndex(int i, int j) {
            int ii = Math.min(i, j);
            int jj = Math.max(i, j);
            return this.nCols * ii - ii * (ii - 1) / 2 + jj - ii;
        }

        public double rowDot(int i, int j) {
            double d = 0.0;
            if (this.mType.get(6)) {
                double[] v = this.getRow(j);
                double[] w = JLinAlg.mVMultiply(this, v, 0);
                this.getRow(i, v, 0);
                d = JLinAlg.VDot(this.nCols, v, 0, w, 0);
            } else if (this.mType.get(0)) {
                if (this.mType.get(3) || this.mType.get(3)) {
                    int kStart = 0;
                    int kEnd = this.nCols;
                    if (!this.mType.get(1)) {
                        if (this.mType.get(3)) {
                            kStart = Math.max(i, j);
                        } else {
                            kEnd = Math.min(i, j) + 1;
                        }
                    }
                    for (int k = kStart; k < kEnd; ++k) {
                        d += this.getElement(i, k) * this.getElement(j, k);
                    }
                } else if (this.mType.get(4)) {
                    if (i == j) {
                        d = this.aVec[this.pShft + i] * this.aVec[this.pShft + i];
                    }
                } else {
                    d = JLinAlg.VDot(this.nCols, this.aVec, this.pShft + i * this.nCols, this.aVec, this.pShft + j * this.nCols);
                }
            }
            return d;
        }

        public double colDot(int i, int j) {
            double d = 0.0;
            for (int k = 0; k < this.nRows; ++k) {
                d += this.aVec[this.pShft + k * this.nCols + i] * this.aVec[this.pShft + k * this.nCols + j];
            }
            return d;
        }

        public void removeRows(int iFrom, int nnnRows) throws RuntimeException {
            int From = Math.max(0, iFrom);
            int nnRows = Math.min(this.nRows - From, nnnRows);
            if (this.mType.get(2) || this.mType.get(2)) {
                throw new RuntimeException("Triangular matrix is not allowed in removeRows.");
            }
            int To = From + nnRows;
            if (To >= this.nRows) {
                this.nRows = From;
            } else {
                int vLen = this.endIndex() - this.rowIndex(To);
                JLinAlg.VectCopy(vLen, this.aVec, this.pShft + this.rowIndex(To), this.pShft + this.rowIndex(From));
                this.nRows -= nnRows;
            }
            if (this.mType.get(4)) {
                this.nCols = this.nRows;
            }
        }

        public void insertRows(int From, int nnRows) {
            this.insertRows(From, nnRows, null, 0);
        }

        public void insertRows(int From, int nnRows, double[] vect, int vPShift) {
            if (this.mType.get(2) || this.mType.get(2)) {
                return;
            }
            if (this.nRows * this.nCols > this.aLen) {
                return;
            }
            int vLen = 0;
            int To = From + nnRows;
            if (From != this.nRows) {
                vLen = this.endIndex() - this.rowIndex(From);
                JLinAlg.VectCopy(vLen, this.aVec, this.pShft + this.rowIndex(From), this.pShft + this.rowIndex(To));
            }
            vLen = nnRows * this.nCols;
            if (vect != null) {
                JLinAlg.VectCopy(vLen, this.aVec, this.pShft + this.rowIndex(From), vect, vPShift);
            }
            this.nRows += nnRows;
            if (this.mType.get(4)) {
                this.nCols = this.nRows;
            }
        }

        public void Unitary() {
            this.Unitary(this.zeroLimit);
        }

        public void Unitary(double zLimit) {
            if (this.mType.get(0) && !this.mType.get(2) && !this.mType.get(3) && !this.mType.get(4)) {
                for (int i = 0; i < this.nRows; ++i) {
                    JLinAlg.VectNormalize(this.nCols, this.aVec, this.pShft + i * this.nCols, this.aVec, this.pShft + i * this.nCols, null, zLimit);
                }
            }
        }

        public Matrix Transpose() {
            BitSet aTrType = new BitSet(8);
            int essentialBits = 5;
            for (int i = 0; i < essentialBits; ++i) {
                if (!this.mType.get(i)) continue;
                aTrType.set(i);
            }
            Matrix aTr = new Matrix(this.nCols, this.nRows, aTrType);
            if (this.mType.get(4)) {
                JLinAlg.VectCopy(this.nRows, this.aVec, this.pShft, aTr.aVec, aTr.pShft);
            } else {
                for (int i = 0; i < this.nCols; ++i) {
                    for (int j = 0; j < this.nRows; ++j) {
                        aTr.setElement(i, j, this.getElement(j, i));
                    }
                }
            }
            return aTr;
        }

        public void Symmetrize(int iType) {
            if (this.mType.get(1)) {
                return;
            }
            if (this.mType.get(2) || this.mType.get(3) || iType > 2 | iType < 0) {
                System.err.println("Error in matrix symmetrization.");
                throw new UnsupportedOperationException("Error in matrix symmetrization.");
            }
            for (int i = 0; i < this.nRows; ++i) {
                for (int j = 0; j < i; ++j) {
                    double lTVal = this.getElement(i, j);
                    double uTVal = this.getElement(j, i);
                    if (iType == 0) {
                        this.setElement(i, j, (lTVal + uTVal) / 2.0);
                        this.setElement(j, i, (lTVal + uTVal) / 2.0);
                        continue;
                    }
                    if (iType == 1) {
                        this.setElement(i, j, lTVal);
                        this.setElement(j, i, lTVal);
                        continue;
                    }
                    if (iType != 2) continue;
                    this.setElement(i, j, uTVal);
                    this.setElement(j, i, uTVal);
                }
            }
            this.mType.set(1);
        }

        public void diagonalize(double zLimit, double ovlLimit) {
            JLinAlg.matrixDiagonalize(this, zLimit, ovlLimit);
        }

        public void diagonalize(double zLimit) {
            JLinAlg.matrixDiagonalize(this, zLimit, 0.0);
        }

        public void diagonalize() {
            if (!this.mType.get(7)) {
                JLinAlg.matrixDiagonalize(this, this.zeroLimit, 0.0);
            }
        }

        public void reDiagonalize(double zLimit) {
            this.mType.clear(7);
            this.aLEV = null;
            this.aREV = null;
            this.aEVa = null;
            JLinAlg.matrixDiagonalize(this, zLimit, 0.0);
        }

        public void reDiagonalize(double zLimit, double ovlLimit) {
            this.mType.clear(7);
            this.aLEV = null;
            this.aREV = null;
            this.aEVa = null;
            JLinAlg.matrixDiagonalize(this, zLimit, ovlLimit);
        }

        public void checkRank() {
            JLinAlg.SetRank(this, this.zeroLimit);
        }

        public void checkRank(double zLimit) {
            JLinAlg.SetRank(this, zLimit);
        }

        public Matrix getInverse() {
            return this.getInverse(this.zeroLimit);
        }

        public Matrix getInverse(double zeroLimit) {
            if (!this.mType.get(7)) {
                this.reDiagonalize(zeroLimit);
            }
            double[] tmpV = new double[this.nRank];
            for (int i = 0; i < this.nRank; ++i) {
                tmpV[i] = 1.0 / this.aEVa.getElement(i, i);
            }
            Matrix invEVa = new Matrix(tmpV);
            Matrix scREV = JLinAlg.mtMMultiply(this.aREV, invEVa);
            Matrix invM = JLinAlg.mMMultiply(scREV, this.aLEV);
            return invM;
        }

        public void Print() {
            String Message = "Matrix printout";
            this.Print(Message);
        }

        public void Print(String Message) {
            System.err.println(Message);
            for (int i = 0; i < this.nRows; ++i) {
                for (int j = 0; j < this.nCols; ++j) {
                    System.err.print(JLinAlg.formatNumber(8, 4, this.getElement(i, j)));
                }
                System.err.println();
            }
        }

        public boolean insertRow(int rowIndex, double[] data) {
            this.insertRows(rowIndex, 1, data, 0);
            return true;
        }

        public double[] removeRow(int rowIndex) throws IndexOutOfBoundsException {
            this.removeRows(rowIndex, 1);
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public double getValueAt(int rowIndex, int colIndex) throws IndexOutOfBoundsException {
            return this.getElement(rowIndex, colIndex);
        }

        public void setValueAt(int rowIndex, int colIndex, double value) throws IndexOutOfBoundsException {
            this.setElement(rowIndex, colIndex, value);
        }

        public int getColumnCount() {
            return this.nCols;
        }

        public int getRowCount() {
            return this.nRows;
        }

        public void transpose() {
            Matrix trM = this.Transpose();
            this.aVec = trM.aVec;
            this.nCols = trM.nCols;
            this.mType = trM.mType;
            this.nRows = trM.nRows;
            this.pShft = trM.pShft;
        }
    }

    public static class workingSpace {
        public static double[] w = null;
        public static int wLen = 0;
        public static int wEnd = 0;
        public double[] wVec = null;
        public int wPtr = -1;

        public workingSpace(int length) {
            if (length < 0) {
                if (w == null) {
                    w = new double[-length];
                    wLen = -length;
                    wEnd = 0;
                } else {
                    System.err.println("Reallocation is not allowed in workingSpace yet, doing reset.");
                    w = new double[-length];
                    wLen = -length;
                    wEnd = 0;
                }
            } else if (w == null || wEnd + length > wLen) {
                this.wVec = new double[length];
                this.wPtr = 0;
            } else {
                this.wPtr = wEnd;
                this.wVec = w;
                wEnd += length;
                JLinAlg.VectClear(length, this.wVec, this.wPtr);
            }
        }
    }
}

