/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.debug.Drawer;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.geom.Tetrahedron;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.util.U;

public class PrincipalAxes {
    double[] mc = new double[3];
    Tetrahedron t;
    double[][] pp;
    double[][] allc;
    double[][] traxes = null;

    public boolean isPlanar() {
        return this.t.getType() == 3;
    }

    void rotate(double[][] c, int[] sel, int a1, int a2, int a3, double f, Drawer d) {
        this.calcTraxes();
        double sf = Math.sin(f);
        double cf = Math.cos(f);
        if (d != null) {
            for (int i = 0; i < c.length; ++i) {
                d.addPoint(c[i]);
            }
            d.addPointMedr(this.mc, "mc");
            double s = V.findMaxExtension(c) / 2.0;
            d.addVector(s, this.traxes[a1], this.mc, "sA1");
            d.addVector(s, this.traxes[a2], this.mc, "sA2");
            d.addVector(s, this.traxes[a3], this.mc, "sA3");
        }
        for (int i = 0; i < sel.length; ++i) {
            double[] tc = V.minus(c[sel[i]], this.mc);
            double[] tct = new double[3];
            for (int j = 0; j < 3; ++j) {
                tct[j] = V.dot(tc, this.traxes[j]);
            }
            double[] tctr = new double[3];
            tctr[a1] = tct[a1] * cf - tct[a2] * sf;
            tctr[a2] = tct[a1] * sf + tct[a2] * cf;
            tctr[a3] = tct[a3];
            double[] cbef = null;
            if (d != null) {
                cbef = U.clone(c[sel[i]]);
                d.addPointSmallr(c[sel[i]]);
            }
            c[sel[i]][0] = this.mc[0] + tctr[0] * this.traxes[0][0] + tctr[1] * this.traxes[1][0] + tctr[2] * this.traxes[2][0];
            c[sel[i]][1] = this.mc[1] + tctr[0] * this.traxes[0][1] + tctr[1] * this.traxes[1][1] + tctr[2] * this.traxes[2][1];
            c[sel[i]][2] = this.mc[2] + tctr[0] * this.traxes[0][2] + tctr[1] * this.traxes[1][2] + tctr[2] * this.traxes[2][2];
            if (d == null) continue;
            d.addLine(cbef, c[sel[i]]);
        }
    }

    public void bend(double[][] c, int[] sel, double f, Drawer d) {
        this.rotate(c, sel, 1, 2, 0, f, d);
    }

    public void twist(double[][] c, int[] sel, double f, Drawer d) {
        this.rotate(c, sel, 0, 2, 1, f, d);
    }

    public double[][] getAllC() {
        return this.allc;
    }

    void calcTraxes() {
        double[] a2;
        int i;
        if (this.traxes != null) {
            return;
        }
        this.traxes = new double[3][];
        double[] a1 = null;
        if (this.pp.length == 1) {
            if (this.allc.length > 1) {
                double[] maxv = null;
                double maxvl = -1.0;
                for (i = 0; i < this.allc.length; ++i) {
                    double[] v = V.minus(this.allc[i], this.mc);
                    double vl = V.dot(v);
                    if (!(maxvl < 0.0) && !(maxvl < vl)) continue;
                    maxv = v;
                    maxvl = vl;
                }
                if (maxvl > 1.0) {
                    double[] dArray;
                    V.normalize(maxv);
                    if (maxv[0] > 0.8) {
                        double[] dArray2 = new double[3];
                        dArray2[0] = 0.0;
                        dArray2[1] = 1.0;
                        dArray = dArray2;
                        dArray2[2] = 0.0;
                    } else {
                        double[] dArray3 = new double[3];
                        dArray3[0] = 1.0;
                        dArray3[1] = 0.0;
                        dArray = dArray3;
                        dArray3[2] = 0.0;
                    }
                    double[] v2 = dArray;
                    a1 = V.vectProd(maxv, v2);
                    V.normalize(a1);
                }
            }
            if (a1 == null) {
                System.err.println("WARNING! Traxes() on single point");
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("WARNING! Traxes() on single point");
                }
                a1 = new double[]{1.0, 0.0, 0.0};
            }
        } else {
            a1 = V.minus(this.pp[this.t.getA2()], this.pp[this.t.getA1()]);
        }
        V.normalize(a1);
        this.traxes[0] = a1;
        if (this.t.getType() == 2) {
            a2 = new double[3];
            double fibest = -1.0;
            for (i = 0; i < this.allc.length; ++i) {
                double[] a2c = V.minus(this.allc[i], this.mc);
                double fi = V.angle(a1, a2c);
                if (!(fibest < 0.0) && !(Math.abs(fibest - 1.5707963267948966) > Math.abs(fi - 1.5707963267948966))) continue;
                fibest = fi;
                a2 = a2c;
            }
            if (Math.abs(fibest - 1.5707963267948966) > 1.5) {
                if (a1[0] < 0.9) {
                    a2[0] = 1.0;
                } else {
                    a2[1] = 1.0;
                }
            }
        } else if (this.t.getType() == 4) {
            a2 = V.minus(this.pp[this.t.getA3()], this.pp[this.t.getA1()]);
        } else {
            double[] dArray;
            if (a1[0] > 0.8) {
                double[] dArray4 = new double[3];
                dArray4[0] = 0.0;
                dArray4[1] = 1.0;
                dArray = dArray4;
                dArray4[2] = 0.0;
            } else {
                double[] dArray5 = new double[3];
                dArray5[0] = 1.0;
                dArray5[1] = 0.0;
                dArray = dArray5;
                dArray5[2] = 0.0;
            }
            a2 = dArray;
        }
        double a2a1dim = V.dot(a1, a2);
        double[] a2a1 = V.dot(a2a1dim, a1);
        a2 = V.minus(a2, a2a1);
        V.normalize(a2);
        this.traxes[1] = a2;
        this.traxes[2] = V.vectProd(this.traxes[0], this.traxes[1]);
        V.normalize(this.traxes[2]);
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Traxes: " + U.toString(this.traxes));
        }
    }

    public void printout(debugPrintout d, String btnlab) {
        int i;
        Drawer dr = new Drawer();
        for (i = 0; i < this.allc.length; ++i) {
            dr.addSmallCross(this.allc[i]);
        }
        for (i = 0; i < this.pp.length; ++i) {
            dr.addPointSmallr(this.pp[i]);
        }
        dr.addPointMedr(this.mc, "mc");
        if (this.t.getA1() < this.pp.length && this.t.getA1() >= 0) {
            dr.addPointBigR(this.pp[this.t.getA1()], "A1");
        }
        if (this.t.getA2() < this.pp.length && this.t.getA2() >= 0) {
            dr.addPointBigR(this.pp[this.t.getA2()], "A2");
        }
        if (this.t.getA3() < this.pp.length && this.t.getA3() >= 0) {
            dr.addPointBigR(this.pp[this.t.getA3()], "A3");
        }
        if (this.t.getA4() < this.pp.length && this.t.getA4() >= 0) {
            dr.addPointBigR(this.pp[this.t.getA4()], "A4");
        }
        this.calcTraxes();
        double s = V.findMaxExtension(this.allc) / 2.0;
        for (int i2 = 0; i2 < 3; ++i2) {
            dr.addArrow(this.mc, V.plus(this.mc, V.dot(s, this.traxes[i2])), "traxe" + i2);
        }
        dr.placeApplet(d, btnlab);
    }

    public PrincipalAxes(double[][] points, int[] selecteds) {
        this.allc = points;
        int n = selecteds == null ? points.length : selecteds.length;
        this.pp = selecteds != null ? (Object)new double[n][] : points;
        for (int i = 0; i < n; ++i) {
            double[] p = points[selecteds == null ? i : selecteds[i]];
            V.plusWriteBackToa(this.mc, p);
            if (selecteds == null) continue;
            this.pp[i] = p;
        }
        V.dotWriteBackToA(1.0 / (double)n, this.mc);
        StringBuffer vb = null;
        if (CleanArgs.doVerbose()) {
            vb = new StringBuffer(50);
        }
        this.t = new Tetrahedron(this.pp, 0.3, vb);
        if (vb != null) {
            CleanArgs.verbose("Principal axes tetrahedron: " + vb.toString(), this.t.toString());
        }
    }
}

