/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg;

import java.io.Serializable;

public class QuatFit
implements Serializable {
    private double[][] xyz_f = null;
    private double[][] xyz_r = null;
    int max_sweeps = 30;
    public double[] q = null;

    public QuatFit(double[][] referenceCoordinates) {
        this.xyz_r = new double[4][referenceCoordinates[0].length + 1];
        this.xyz_r[0][0] = 0.0;
        this.xyz_r[0][1] = 0.0;
        this.xyz_r[0][2] = 0.0;
        this.xyz_r[0][3] = 0.0;
        for (int i = 0; i < referenceCoordinates[0].length; ++i) {
            this.xyz_r[0][i + 1] = 0.0;
            for (int j = 0; j < 3; ++j) {
                this.xyz_r[j + 1][i + 1] = referenceCoordinates[j][i];
            }
        }
    }

    public void quatfit(double[][] fitCoordinates, int[][] pairs) {
        double[] weightFrom0 = new double[pairs[0].length];
        for (int i = 0; i < pairs[0].length; ++i) {
            weightFrom0[i] = 1.0;
        }
        this.quatfit(fitCoordinates, weightFrom0, pairs);
    }

    public void quatfit(double[][] fitCoordinates, double[] weightFrom0, int[][] pairs) {
        double[] ref_center = new double[4];
        double[] fit_center = new double[4];
        double[][] u = new double[4][4];
        this.q = new double[4];
        int npairs = pairs[0].length;
        double[] weight = new double[npairs + 1];
        double[][] ref_xyz = new double[4][npairs + 1];
        double[][] fit_xyz = new double[4][npairs + 1];
        this.xyz_f = new double[4][fitCoordinates[0].length + 1];
        this.xyz_f[0][0] = 0.0;
        this.xyz_f[0][1] = 0.0;
        this.xyz_f[0][2] = 0.0;
        this.xyz_f[0][3] = 0.0;
        for (int i = 0; i < fitCoordinates[0].length; ++i) {
            this.xyz_f[0][i + 1] = 0.0;
            for (int j = 0; j < 3; ++j) {
                this.xyz_f[j + 1][i + 1] = fitCoordinates[j][i];
            }
        }
        int nat_r = this.xyz_r[0].length - 1;
        int nat_f = this.xyz_f[0].length - 1;
        for (int i = 1; i <= npairs; ++i) {
            for (int j = 1; j <= 3; ++j) {
                ref_xyz[j][i] = this.xyz_r[j][pairs[0][i - 1] + 1];
                fit_xyz[j][i] = this.xyz_f[j][pairs[1][i - 1] + 1];
            }
            weight[i] = weightFrom0[i - 1];
        }
        QuatFit.center(npairs, ref_xyz, weight, 1, ref_center);
        QuatFit.center(npairs, fit_xyz, weight, 1, fit_center);
        QuatFit.qtrfit(npairs, fit_xyz, ref_xyz, weight, this.q, u, this.max_sweeps);
        QuatFit.center(nat_f, this.xyz_f, weight, 2, fit_center);
        this.rotmol(nat_f, this.xyz_f, this.xyz_f, u);
        this.rotmol(npairs, fit_xyz, fit_xyz, u);
        QuatFit.center(nat_f, this.xyz_f, weight, 3, ref_center);
        QuatFit.center(npairs, fit_xyz, weight, 3, ref_center);
        QuatFit.center(npairs, ref_xyz, weight, 3, ref_center);
    }

    public void getFittedCrd(double[][] fitCoordinates) {
        for (int i = 1; i < this.xyz_f[0].length; ++i) {
            for (int j = 1; j <= 3; ++j) {
                fitCoordinates[j - 1][i - 1] = this.xyz_f[j][i];
            }
        }
    }

    private static void center(int n, double[][] x, double[] w, int io, double[] o) {
        int i;
        double modif;
        if (io == 2) {
            modif = -1.0;
        } else if (io == 3) {
            modif = 1.0;
        } else {
            modif = -1.0;
            o[1] = 0.0;
            o[2] = 0.0;
            o[3] = 0.0;
            double wnorm = 0.0;
            for (i = 1; i <= n; ++i) {
                o[1] = o[1] + x[1][i] * Math.sqrt(w[i]);
                o[2] = o[2] + x[2][i] * Math.sqrt(w[i]);
                o[3] = o[3] + x[3][i] * Math.sqrt(w[i]);
                wnorm += Math.sqrt(w[i]);
            }
            o[1] = o[1] / wnorm;
            o[2] = o[2] / wnorm;
            o[3] = o[3] / wnorm;
        }
        for (i = 1; i <= n; ++i) {
            x[1][i] = x[1][i] + modif * o[1];
            x[2][i] = x[2][i] + modif * o[2];
            x[3][i] = x[3][i] + modif * o[3];
        }
    }

    private void rotmol(int n, double[][] x, double[][] y, double[][] u) {
        for (int i = 1; i <= n; ++i) {
            double yx = u[1][1] * x[1][i] + u[1][2] * x[2][i] + u[1][3] * x[3][i];
            double yy = u[2][1] * x[1][i] + u[2][2] * x[2][i] + u[2][3] * x[3][i];
            double yz = u[3][1] * x[1][i] + u[3][2] * x[2][i] + u[3][3] * x[3][i];
            y[1][i] = yx;
            y[2][i] = yy;
            y[3][i] = yz;
        }
    }

    private static void jacobi(double[][] a, double[] d, double[][] v, int nrot) {
        int i;
        int j;
        for (j = 0; j <= 3; ++j) {
            for (i = 0; i <= 3; ++i) {
                v[i][j] = 0.0;
            }
            v[j][j] = 1.0;
            d[j] = a[j][j];
        }
        for (int l = 1; l <= nrot; ++l) {
            double dtemp;
            int k;
            double dnorm = 0.0;
            double onorm = 0.0;
            for (j = 0; j <= 3; ++j) {
                dnorm += Math.abs(d[j]);
                for (i = 0; i <= j - 1; ++i) {
                    onorm += Math.abs(a[i][j]);
                }
            }
            if (onorm / dnorm <= 1.0E-12) {
                nrot = l;
                for (j = 0; j <= 2; ++j) {
                    k = j;
                    dtemp = d[k];
                    for (i = j + 1; i <= 3; ++i) {
                        if (!(d[i] < dtemp)) continue;
                        k = i;
                        dtemp = d[k];
                    }
                    if (k <= j) continue;
                    d[k] = d[j];
                    d[j] = dtemp;
                    for (i = 0; i <= 3; ++i) {
                        dtemp = v[i][k];
                        v[i][k] = v[i][j];
                        v[i][j] = dtemp;
                    }
                }
                return;
            }
            for (j = 1; j <= 3; ++j) {
                for (i = 0; i <= j - 1; ++i) {
                    double atemp;
                    double t;
                    double b = a[i][j];
                    if (!(Math.abs(b) > 0.0)) continue;
                    double dma = d[j] - d[i];
                    if (Math.abs(dma) + Math.abs(b) <= Math.abs(dma)) {
                        t = b / dma;
                    } else {
                        double q = 0.5 * dma / b;
                        t = 1.0 / (Math.abs(q) + Math.sqrt(1.0 + q * q));
                        if (q < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(t * t + 1.0);
                    double s = t * c;
                    a[i][j] = 0.0;
                    for (k = 0; k <= i - 1; ++k) {
                        atemp = c * a[k][i] - s * a[k][j];
                        a[k][j] = s * a[k][i] + c * a[k][j];
                        a[k][i] = atemp;
                    }
                    for (k = i + 1; k <= j - 1; ++k) {
                        atemp = c * a[i][k] - s * a[k][j];
                        a[k][j] = s * a[i][k] + c * a[k][j];
                        a[i][k] = atemp;
                    }
                    for (k = j + 1; k <= 3; ++k) {
                        atemp = c * a[i][k] - s * a[j][k];
                        a[j][k] = s * a[i][k] + c * a[j][k];
                        a[i][k] = atemp;
                    }
                    for (k = 0; k <= 3; ++k) {
                        double vtemp = c * v[k][i] - s * v[k][j];
                        v[k][j] = s * v[k][i] + c * v[k][j];
                        v[k][i] = vtemp;
                    }
                    dtemp = c * c * d[i] + s * s * d[j] - 2.0 * c * s * b;
                    d[j] = s * s * d[i] + c * c * d[j] + 2.0 * c * s * b;
                    d[i] = dtemp;
                }
            }
        }
    }

    private static void q2mat(double[] q, double[][] u) {
        u[1][1] = q[0] * q[0] + q[1] * q[1] - q[2] * q[2] - q[3] * q[3];
        u[2][1] = 2.0 * (q[1] * q[2] - q[0] * q[3]);
        u[3][1] = 2.0 * (q[1] * q[3] + q[0] * q[2]);
        u[1][2] = 2.0 * (q[2] * q[1] + q[0] * q[3]);
        u[2][2] = q[0] * q[0] - q[1] * q[1] + q[2] * q[2] - q[3] * q[3];
        u[3][2] = 2.0 * (q[2] * q[3] - q[0] * q[1]);
        u[1][3] = 2.0 * (q[3] * q[1] - q[0] * q[2]);
        u[2][3] = 2.0 * (q[3] * q[2] + q[0] * q[1]);
        u[3][3] = q[0] * q[0] - q[1] * q[1] - q[2] * q[2] + q[3] * q[3];
    }

    private static void qtrfit(int n, double[][] x, double[][] y, double[] w, double[] q, double[][] u, int nr) {
        int i;
        double[][] c = new double[4][4];
        double[][] v = new double[4][4];
        double[] d = new double[4];
        double xxyx = 0.0;
        double xxyy = 0.0;
        double xxyz = 0.0;
        double xyyx = 0.0;
        double xyyy = 0.0;
        double xyyz = 0.0;
        double xzyx = 0.0;
        double xzyy = 0.0;
        double xzyz = 0.0;
        for (i = 1; i <= n; ++i) {
            xxyx += x[1][i] * y[1][i] * w[i];
            xxyy += x[1][i] * y[2][i] * w[i];
            xxyz += x[1][i] * y[3][i] * w[i];
            xyyx += x[2][i] * y[1][i] * w[i];
            xyyy += x[2][i] * y[2][i] * w[i];
            xyyz += x[2][i] * y[3][i] * w[i];
            xzyx += x[3][i] * y[1][i] * w[i];
            xzyy += x[3][i] * y[2][i] * w[i];
            xzyz += x[3][i] * y[3][i] * w[i];
        }
        for (i = 0; i <= 3; ++i) {
            for (int j = 0; j <= 3; ++j) {
                c[i][j] = 0.0;
            }
        }
        c[0][0] = xxyx + xyyy + xzyz;
        c[0][1] = xzyy - xyyz;
        c[1][1] = xxyx - xyyy - xzyz;
        c[0][2] = xxyz - xzyx;
        c[1][2] = xxyy + xyyx;
        c[2][2] = xyyy - xzyz - xxyx;
        c[0][3] = xyyx - xxyy;
        c[1][3] = xzyx + xxyz;
        c[2][3] = xyyz + xzyy;
        c[3][3] = xzyz - xxyx - xyyy;
        QuatFit.jacobi(c, d, v, nr);
        q[0] = v[0][3];
        q[1] = v[1][3];
        q[2] = v[2][3];
        q[3] = v[3][3];
        QuatFit.q2mat(q, u);
    }
}

