/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg;

import chemaxon.marvin.modelling.linalg.SparseMatrixRow;
import java.util.Vector;

public class SparseArray
implements SparseMatrixRow {
    private int[] indeces = null;
    private double[] values = null;

    public void setIndeces(int[] indeces) {
        this.indeces = indeces;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    @Override
    public int[] getIndeces() {
        return this.indeces;
    }

    @Override
    public double[] getValues() {
        return this.values;
    }

    public SparseArray(int[] indeces, double[] values) {
        this.indeces = indeces;
        this.values = values;
    }

    @Override
    public SparseMatrixRow add(SparseMatrixRow b) {
        SparseArray c = null;
        int[][] tmpind = SparseArray.mergeIndeces(this.getIndeces(), b.getIndeces());
        if (tmpind == null) {
            return null;
        }
        int[] indc = new int[tmpind.length];
        double[] valc = new double[tmpind.length];
        if (c == null) {
            c = new SparseArray(indc, valc);
        }
        for (int i = 0; i < tmpind.length; ++i) {
            int[] is = tmpind[i];
            if (is[0] == -1) {
                indc[i] = this.indeces[is[1]];
                int n = i;
                valc[n] = valc[n] + b.getValues()[is[1]];
                continue;
            }
            if (is[1] == -1) {
                indc[i] = this.indeces[is[0]];
                valc[i] = this.values[is[0]];
                continue;
            }
            indc[i] = this.indeces[is[0]];
            valc[i] = this.values[is[0]] + b.getValues()[is[1]];
        }
        return c;
    }

    public static int[][] mergeIndeces(int[] indeces1, int[] indeces2) {
        Vector<int[]> merger = new Vector<int[]>();
        int i = 0;
        int j = 0;
        while (j < indeces1.length && i < indeces2.length) {
        }
        while (j < indeces1.length && indeces1[j] < indeces2[i]) {
            ++j;
        }
        System.err.println("Merge: I:, J: " + i + ", " + j);
        System.err.println("Merge: Ind(I):, Ind(J): " + indeces2[i] + ", " + indeces1[j]);
        if (j < indeces1.length) {
            int[] ind;
            if (indeces2[i] == indeces1[j]) {
                ind = new int[]{j++, i};
                merger.addElement(ind);
            } else if (indeces2[i] < indeces1[j]) {
                ind = new int[]{-1, i++};
                merger.addElement(ind);
            } else {
                ind = new int[]{j, -1};
                merger.addElement(ind);
            }
        }
        if (merger.size() == 0) {
            return null;
        }
        int[][] retind = new int[merger.size()][];
        return (int[][])merger.toArray((T[])retind);
    }

    @Override
    public double dot(SparseMatrixRow b) {
        int[][] tmpind = SparseArray.mergeIndeces(this.getIndeces(), b.getIndeces());
        if (tmpind == null) {
            return 0.0;
        }
        double dot = 0.0;
        for (int i = 0; i < tmpind.length; ++i) {
            int[] is = tmpind[i];
            if (is[0] <= -1 || is[1] <= -1) continue;
            dot += this.values[is[0]] * b.getValues()[is[1]];
        }
        return dot;
    }

    @Override
    public SparseMatrixRow scaleAndAdd(double sc, SparseMatrixRow b) {
        SparseArray c = null;
        int[][] tmpind = SparseArray.mergeIndeces(this.getIndeces(), b.getIndeces());
        if (tmpind == null) {
            return null;
        }
        int[] indc = new int[tmpind.length];
        double[] valc = new double[tmpind.length];
        if (c == null) {
            c = new SparseArray(indc, valc);
        }
        for (int i = 0; i < tmpind.length; ++i) {
            int[] is = tmpind[i];
            if (is[0] == -1) {
                indc[i] = this.indeces[is[1]];
                int n = i;
                valc[n] = valc[n] + sc * b.getValues()[is[1]];
                continue;
            }
            if (is[1] == -1) {
                indc[i] = this.indeces[is[0]];
                valc[i] = this.values[is[0]];
                continue;
            }
            indc[i] = this.indeces[is[0]];
            valc[i] = this.values[is[0]] + b.getValues()[is[1]];
        }
        return c;
    }

    public static double[] spMVMul(SparseMatrixRow[] spM, double[] v, double[] res) {
        if (res == null) {
            res = new double[spM.length];
        }
        for (int i = 0; i < spM.length; ++i) {
            SparseMatrixRow row = spM[i];
            int[] ind = row.getIndeces();
            double[] val = row.getValues();
            for (int j = 0; j < ind.length; ++j) {
                int k = ind[j];
                int n = i;
                res[n] = res[n] + val[j] * v[k];
            }
        }
        return res;
    }
}

