/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg;

import chemaxon.marvin.modelling.debug.Drawer;
import chemaxon.marvin.modelling.linalg.M;
import chemaxon.marvin.modelling.util.U;
import java.util.Vector;

public class V {
    public static double dot(double[] a) {
        double dot = 0.0;
        for (int i = 0; i < a.length; ++i) {
            dot += a[i] * a[i];
        }
        return dot;
    }

    public static void linComb(double[] target, double[] a, double[] b, double aweight) {
        double bweight = 1.0 - aweight;
        for (int i = 0; i < target.length; ++i) {
            target[i] = a[i] * aweight + b[i] * bweight;
        }
    }

    public static double calcRadius(double[] o, double[][] c, int[] sel, boolean avg, boolean ringbondhalf) {
        int i;
        double r = 0.0;
        for (i = 0; i < sel.length; ++i) {
            if (c[i].length == o.length) continue;
            throw new UnsupportedOperationException();
        }
        for (i = 0; i < sel.length; ++i) {
            double[] p = ringbondhalf ? V.avg(c[sel[i]], c[sel[(i + 1) % sel.length]]) : c[sel[i]];
            double d = V.vectLen(p, o);
            if (avg) {
                r += d;
                continue;
            }
            if (i != 0 && !(r > d)) continue;
            r = d;
        }
        if (avg) {
            r /= (double)sel.length;
        }
        return r;
    }

    public static void moveMCToOrigo(double[][] c) {
        double[] mc = V.avg(c);
        mc = V.minus(mc);
        V.plusWriteBackToAllA(c, mc);
    }

    public static double[][] genCubeRaster(double sep, int n) {
        int rasz;
        int rasy;
        int rasx;
        int ras;
        if (n == 0) {
            return null;
        }
        double[][] ret = new double[n][3];
        if (n > 9) {
            rasx = ras = (int)Math.exp(0.3333333333333333 * Math.log(n));
            rasy = ras;
            rasz = ras;
        } else {
            rasx = ras = (int)Math.sqrt(n);
            rasy = ras;
            rasz = 1;
        }
        while (rasx * rasy * rasz < n) {
            if (rasx * rasy * rasz < n) {
                ++rasx;
            }
            if (rasx * rasy * rasz < n) {
                ++rasy;
            }
            if (rasx * rasy * rasz >= n) continue;
            ++rasz;
        }
        int s = 0;
        for (int z = 0; s < n && z < rasz; ++z) {
            for (int y = 0; s < n && y < rasy; ++y) {
                for (int x = 0; s < n && x < rasx; ++s, ++x) {
                    ret[s][0] = sep * (double)x;
                    ret[s][1] = sep * (double)y;
                    ret[s][2] = sep * (double)z;
                }
            }
        }
        V.moveMCToOrigo(ret);
        return ret;
    }

    public static double[] avg(double[][] c) {
        if (c == null || c.length == 0) {
            return null;
        }
        double[] ret = new double[c[0].length];
        for (int i = 0; i < c.length; ++i) {
            if (c[i].length != ret.length) {
                throw new UnsupportedOperationException();
            }
            for (int j = 0; j < ret.length; ++j) {
                int n = j;
                ret[n] = ret[n] + c[i][j];
            }
        }
        int j = 0;
        while (j < ret.length) {
            int n = j++;
            ret[n] = ret[n] / (double)c.length;
        }
        return ret;
    }

    public static double[] avg(double[][] c, int[] sel) {
        int i;
        if (sel == null || sel.length == 0) {
            return null;
        }
        double[] ret = new double[c[0].length];
        for (i = 1; i < c.length; ++i) {
            if (c[i].length == ret.length) continue;
            throw new UnsupportedOperationException();
        }
        for (i = 0; i < sel.length; ++i) {
            for (int j = 0; j < ret.length; ++j) {
                int n = j;
                ret[n] = ret[n] + c[sel[i]][j];
            }
        }
        i = 0;
        while (i < ret.length) {
            int n = i++;
            ret[n] = ret[n] / (double)sel.length;
        }
        return ret;
    }

    public static double[] avg(double[] a, double[] b, double[] c, double[] d) {
        if (a.length != b.length || a.length != c.length || a.length != d.length) {
            return null;
        }
        double[] ret = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = (a[i] + b[i] + c[i] + d[i]) / 4.0;
        }
        return ret;
    }

    public static double[] avg(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new UnsupportedOperationException();
        }
        double[] ret = new double[a.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (a[i] + b[i]) / 2.0;
        }
        return ret;
    }

    public static double[] avg(double[][] c, int sel1, int sel2) {
        return V.avg(c[sel1], c[sel2]);
    }

    public static double findMaxExtension(double[][] c) {
        if (c.length < 2) {
            return 0.0;
        }
        double vl = -1.0;
        for (int i = 1; i < c.length; ++i) {
            double[] d1 = c[i];
            for (int j = 0; j < i; ++j) {
                double[] d2 = c[j];
                double l = V.vectLenSquare(d1, d2);
                if (!(vl < 0.0) && !(vl < l)) continue;
                vl = l;
            }
        }
        return Math.sqrt(vl);
    }

    public static boolean isPlanar(double sep, double[][] c, int[] sel, StringBuffer v, Drawer d) {
        int n;
        if (v != null) {
            v.append("isPlanar check: ");
        }
        int n2 = n = sel == null ? c.length : sel.length;
        if (n < 2) {
            if (v != null) {
                v.append("n=" + n + ", no planar.");
            }
            return false;
        }
        if (d != null) {
            int i;
            for (i = 0; i < c.length; ++i) {
                d.addSmallCross(c[i]);
            }
            if (sel != null) {
                for (i = 0; i > sel.length; ++i) {
                    d.addPointSmallr(c[sel[i]]);
                }
            }
        }
        int a1 = -1;
        int a2 = -1;
        double[] d1best = null;
        double[] d2best = null;
        double vl = -1.0;
        for (int i = 1; i < n; ++i) {
            double[] d1 = sel == null ? c[i] : c[sel[i]];
            for (int j = 0; j < i; ++j) {
                double[] d2 = sel == null ? c[j] : c[sel[j]];
                double l = V.vectLenSquare(d1, d2);
                if (!(vl < 0.0) && !(vl < l)) continue;
                vl = l;
                a1 = i;
                a2 = j;
                d1best = d1;
                d2best = d2;
            }
        }
        if (v != null) {
            v.append(" a1=" + a1 + " a2=" + a2 + " vl=" + vl);
        }
        if (d != null) {
            d.addPointMedr(d1best, "d1best");
            d.addPointMedr(d2best, "d2best");
        }
        if (vl < sep) {
            if (v != null) {
                v.append(" vl=" + vl + "<sep=" + sep + " no linear, no planar");
            }
            return false;
        }
        double[] v1 = V.minus(d2best, d1best);
        V.normalize(v1);
        if (d != null) {
            d.addVector(1.0, v1, d1best, "v1");
        }
        int a3 = -1;
        double[] d3best = null;
        vl = -1.0;
        for (int i = 0; i < n; ++i) {
            double[] d3 = sel == null ? c[i] : c[sel[i]];
            double[] vv = V.minus(d3, d1best);
            double l = V.dot(vv) - V.dot(vv, v1);
            if (!(vl < 0.0) && !(vl < l)) continue;
            vl = l;
            a3 = i;
            d3best = d3;
        }
        if (v != null) {
            v.append(" a3=" + a3 + " vl=" + vl);
        }
        if (d != null) {
            d.addPointMedr(d3best, "d3best");
        }
        if (vl < sep) {
            if (v != null) {
                v.append(" vl=" + vl + "<sep=" + sep + " linear, no planar");
            }
            return false;
        }
        double[] v2 = V.minus(d3best, d1best);
        double[] v3 = V.vectProd(v1, v2);
        V.normalize(v3);
        if (d != null) {
            d.addVector(1.0, v3, d1best, "v3");
        }
        vl = -1.0;
        int a4 = -1;
        double[] d4best = null;
        for (int i = 0; i < n; ++i) {
            double[] d4 = sel == null ? c[i] : c[sel[i]];
            double[] vv = V.minus(d4, d1best);
            double l = V.dot(v3, vv);
            if (!(vl < 0.0) && !(vl < l)) continue;
            vl = l;
            a4 = i;
            d4best = d4;
        }
        if (v != null) {
            v.append(" a4= " + a4 + " vl=" + vl);
        }
        if (d != null) {
            d.addPointMedr(d3best, "d4best");
        }
        if (vl < sep) {
            if (v != null) {
                v.append(" vl=" + vl + "<sep=" + sep + " planar");
            }
            return true;
        }
        return false;
    }

    public static boolean isSP3Deformed(double[] center, double[] c1, double[] c2, double[] c3, double[] c4, double minLen, double maxAngle, double minOOPAngle) {
        return V.isSP3Deformed(center, new double[][]{c1, c2, c3, c4}, minLen, maxAngle, minOOPAngle);
    }

    public static boolean isSP3Deformed(double[] center, double[] c1, double[] c2, double[] c3, double[] c4) {
        return V.isSP3Deformed(center, new double[][]{c1, c2, c3, c4}, 0.5, 3.0543261909900763, 0.4363323129985824);
    }

    public static double signum(double d) {
        if (d > 0.0) {
            return 1.0;
        }
        if (d < 0.0) {
            return -1.0;
        }
        return 0.0;
    }

    public static boolean isSP3Deformed(double[] center, double[][] n, double minLen, double maxAngle, double minOOPAngle) {
        if (n.length != 4) {
            throw new IndexOutOfBoundsException();
        }
        double[][] nn = V.minus(n, center);
        for (int i = 0; i < nn.length; ++i) {
            if (!(V.vectLen(nn[i]) < minLen)) continue;
            return true;
        }
        boolean foundDSep = false;
        boolean allSSep = true;
        for (int i = 0; i < 3; ++i) {
            double[] v1 = nn[i];
            for (int j = i + 1; j < 4; ++j) {
                boolean a2ok;
                double[] v2 = nn[j];
                if (V.angle(v1, v2) > maxAngle) {
                    return true;
                }
                int ni1 = -1;
                int ni2 = -1;
                for (int k = 0; k < 4; ++k) {
                    if (k == i || k == j) continue;
                    if (ni1 == -1) {
                        ni1 = k;
                        continue;
                    }
                    if (ni2 != -1) break;
                    ni2 = k;
                    break;
                }
                double[] norm = V.vectProd(v1, v2);
                double sc1 = V.dot(norm, nn[ni1]);
                double sc2 = V.dot(norm, nn[ni2]);
                if (!(V.signum(sc1) * V.signum(sc2) > -0.5)) continue;
                double a1 = V.angle(norm, nn[ni1]);
                double a2 = V.angle(norm, nn[ni2]);
                boolean a1ok = Math.abs(a1 - 1.5707963267948966) < minOOPAngle;
                boolean bl = a2ok = Math.abs(a2 - 1.5707963267948966) < minOOPAngle;
                if (a1ok && a2ok) {
                    foundDSep = true;
                    continue;
                }
                if (a1ok || a2ok) continue;
                allSSep = false;
            }
        }
        return !foundDSep && !allSSep;
    }

    public static boolean hasMinSep(Vector v, double l) {
        for (int i = 0; i < v.size(); ++i) {
            double[][] c = (double[][])v.get(i);
            if (!V.hasMinSep(c, l)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMinSep(double[][] c, double l) {
        l *= l;
        for (int i = 1; i < c.length; ++i) {
            for (int j = 0; j < i; ++j) {
                double sep = 0.0;
                for (int k = 0; k < 3; ++k) {
                    sep += M.sqr(c[i][k] - c[j][k]);
                }
                if (!(sep < l)) continue;
                return false;
            }
        }
        return true;
    }

    public static double vectLen(double[] a, double[] b) {
        return Math.sqrt(V.vectLenSquare(a, b));
    }

    public static double vectLenSquare(double[] a, double[] b) {
        return V.dot(V.minus(a, b));
    }

    public static double vectLen(double[] v) {
        return Math.sqrt(V.dot(v));
    }

    public static double normDistSq(double[] a2, double[] a1, double[] b2, double[] b1) {
        double[] va = V.minus(a2, a1);
        double[] vb = V.minus(b2, b1);
        V.normalize(va);
        V.normalize(vb);
        double[] d = V.minus(va, vb);
        return V.dot(d);
    }

    public static double dot(double[] a, double[] b) {
        int l1 = a.length;
        int l2 = b.length;
        double dot = 0.0;
        l1 = l1 < l2 ? l1 : l2;
        for (int i = 0; i < l1; ++i) {
            dot += a[i] * b[i];
        }
        return dot;
    }

    public static double[] dot(double s, double[] v) {
        int l = v.length;
        double[] result = new double[l];
        for (int i = 0; i < l; ++i) {
            result[i] = s * v[i];
        }
        return result;
    }

    public static void dotWriteBackToA(double s, double[] a) {
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] * s;
        }
    }

    public static double[] vectProd(double[] a, double[] b) {
        double[] bb;
        int i;
        double[] aa;
        double[] c = new double[3];
        if (a == null) {
            aa = new double[3];
        } else if (a.length < 3) {
            aa = new double[3];
            for (i = 0; i < a.length; ++i) {
                aa[i] = a[i];
            }
        } else {
            aa = a;
        }
        if (b == null) {
            bb = new double[3];
        } else if (b.length < 3) {
            bb = new double[3];
            for (i = 0; i < b.length; ++i) {
                bb[i] = b[i];
            }
        } else {
            bb = b;
        }
        c[0] = aa[1] * bb[2] - aa[2] * bb[1];
        c[1] = aa[2] * bb[0] - aa[0] * bb[2];
        c[2] = aa[0] * bb[1] - aa[1] * bb[0];
        return c;
    }

    public static double[] plus(double[] a, double[] b) {
        return V.plus(a, b, null);
    }

    public static double[] plus(double[] a, double[] b, double[] result) {
        int i;
        double[] vmax;
        int l1 = a.length;
        int l2 = b.length;
        double[] vmin = l1 < l2 ? a : b;
        double[] dArray = vmax = vmin == a ? b : a;
        if (result == null || result.length < vmax.length) {
            result = new double[vmax.length];
        }
        for (i = 0; i < vmin.length; ++i) {
            result[i] = a[i] + b[i];
        }
        for (i = vmin.length; i < vmax.length; ++i) {
            result[i] = vmax[i];
        }
        return result;
    }

    public static void plusWriteBackToa(double[] a, double[] b) {
        int l1 = a.length;
        int l2 = b.length;
        double[] vmin = l1 < l2 ? a : b;
        for (int i = 0; i < vmin.length; ++i) {
            a[i] = a[i] + b[i];
        }
    }

    public static void plusWriteBackToAllA(double[][] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            V.plusWriteBackToa(a[i], b);
        }
    }

    public static double angle(double[] aTo, double[] aFrom, double[] bTo, double[] bFrom) {
        return V.angle(V.minus(aTo, aFrom), V.minus(bTo, bFrom));
    }

    public static double angle(double[] a, double[] b) {
        double[] anorm = U.clone(a);
        double[] bnorm = U.clone(b);
        V.normalize(anorm);
        V.normalize(bnorm);
        double adp = V.dot(anorm, bnorm);
        if (adp < -1.0) {
            return Math.PI;
        }
        if (adp > 1.0) {
            return 0.0;
        }
        return Math.acos(adp);
    }

    public static double[][] minus(double[][] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i].length == b.length) continue;
            return null;
        }
        double[][] ret = new double[a.length][];
        for (int i = 0; i < a.length; ++i) {
            ret[i] = V.minus(a[i], b);
        }
        return ret;
    }

    public static double[] minus(double[] a, double[] b) {
        int i;
        int l1 = a.length;
        int l2 = b.length;
        double[] vmin = l1 < l2 ? a : b;
        double[] vmax = vmin == a ? b : a;
        double[] result = new double[vmax.length];
        for (i = 0; i < vmin.length; ++i) {
            result[i] = a[i] - b[i];
        }
        if (vmax == a) {
            for (i = vmin.length; i < vmax.length; ++i) {
                result[i] = vmax[i];
            }
        } else {
            for (i = vmin.length; i < vmax.length; ++i) {
                result[i] = -vmax[i];
            }
        }
        return result;
    }

    public static double[] minus(double[] a) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = -a[i];
        }
        return result;
    }

    public static boolean equals(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new UnsupportedOperationException("Array size mismatch");
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i] || Double.isNaN(a[i]) && Double.isNaN(b[i])) continue;
            return false;
        }
        return true;
    }

    public static void minusWriteBackToa(double[] a, double[] b) {
        int l1 = a.length;
        int l2 = b.length;
        double[] vmin = l1 < l2 ? a : b;
        for (int i = 0; i < vmin.length; ++i) {
            a[i] = a[i] - b[i];
        }
    }

    public static double dotUsingMetric(double[] x, double[] y, double[] m) {
        double sum = 0.0;
        for (int i = 0; i < Math.min(Math.min(x.length, y.length), m.length); ++i) {
            sum += x[i] * y[i] * m[i];
        }
        return sum;
    }

    public static double dotUsingMetric(double[] x, double[] m) {
        return V.dotUsingMetric(x, x, m);
    }

    public static double dot(double[] a, double[] b, double[] m) {
        double sum = 0.0;
        for (int i = 0; i < m.length; ++i) {
            sum += a[i] * b[i] * m[i];
        }
        return sum;
    }

    public static void nullVector(double[] v) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = 0.0;
        }
    }

    public static void normalizeSafe(double[] v) {
        V.normalizeSafe(v, true);
    }

    public static void normalizeSafe(double[] v, boolean expectExtreme) {
        if (!U.isDoubleOK(v)) {
            throw new UnsupportedOperationException("Error with given vector: " + U.sel(v) + " ee: " + expectExtreme);
        }
        double l = V.vectLen(v);
        if (l == 0.0) {
            if (!expectExtreme) {
                throw new UnsupportedOperationException("Error with given vector");
            }
            V.nullVector(v);
            return;
        }
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i] / l;
        }
        if (!U.isDoubleOK(v)) {
            if (!expectExtreme) {
                throw new UnsupportedOperationException("Error during vector normalization");
            }
            if (l < 1.0E-6) {
                V.nullVector(v);
                return;
            }
            throw new UnsupportedOperationException("Error during vector normalization");
        }
        double l2 = V.vectLen(v);
        if (Math.abs(1.0 - l2) > 0.001) {
            if (!expectExtreme) {
                throw new UnsupportedOperationException("Error during vector normalization");
            }
            if (l < 0.001) {
                if (l2 < 0.001) {
                    V.nullVector(v);
                    return;
                }
                V.normalizeSafe(v, false);
                return;
            }
            throw new UnsupportedOperationException("Error during vector normalization");
        }
    }

    public static void normalize(double[] v, double l) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i] / (l == 0.0 ? 1.0 : l);
        }
    }

    public static void normalize(double[] v) {
        V.normalize(v, Math.sqrt(V.dot(v)));
    }

    public static void normalize(double[][] v) {
        for (int i = 0; i < v.length; ++i) {
            V.normalize(v[i]);
        }
    }

    public static void setZero(double[] v) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = 0.0;
        }
    }

    public static void copyV(double[] dest, double[] src) {
        int i;
        for (i = 0; i < dest.length && i < src.length; ++i) {
            dest[i] = src[i];
        }
        for (i = src.length; i < dest.length; ++i) {
            dest[i] = 0.0;
        }
    }

    public static double[] scale(double[] a, double sc, double[] b) {
        if (b == null) {
            b = new double[a.length];
        }
        int len = Math.min(a.length, b.length);
        for (int i = 0; i < len; ++i) {
            b[i] = sc * a[i];
        }
        return b;
    }

    public static double[] scale(double[] a, double sc) {
        return V.scale(a, sc, null);
    }

    public static void avgWriteBackToA(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = (a[i] + b[i]) / 2.0;
        }
    }
}

