/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg.internals;

import chemaxon.common.util.DoubleVector;
import chemaxon.common.util.IntVector;
import chemaxon.marvin.modelling.linalg.SparseArray;
import chemaxon.marvin.modelling.linalg.internals.Internals;
import java.util.Vector;

public abstract class InternalCoordinate {
    private double[] cartesianCoordinates = null;
    private int[] indeces = null;
    private int type = -1;
    protected BMatrixLine bMatLine = null;

    protected InternalCoordinate(double[] cartesianCoordinates, int[] indeces) {
        this.cartesianCoordinates = cartesianCoordinates;
        this.indeces = indeces;
    }

    private InternalCoordinate() {
    }

    public int getType() {
        return this.type;
    }

    protected void setType(int type) {
        this.type = type;
    }

    public int[] getAtomIndeces() {
        return this.indeces;
    }

    public abstract double getValue();

    public double checkValueChange(double valueChange) {
        return valueChange;
    }

    public abstract BMatrixLine getBMatrixLine();

    public abstract double[] fillBMatrixLine(double[] var1);

    public String toString() {
        String out = Internals.internalCoordinateTypes[this.getType()];
        int[] ind = this.getAtomIndeces();
        for (int i = 0; i < ind.length; ++i) {
            out = out + " " + ind[i];
        }
        return out;
    }

    public double[] getCartesianCoordinates() {
        return this.cartesianCoordinates;
    }

    public void setCartesianCoordinates(double[] cartesianCoordinates) {
        this.cartesianCoordinates = cartesianCoordinates;
    }

    public static int[][] mergeIndeces(int[] indeces1, int[] indeces2) {
        Vector<int[]> merger = new Vector<int[]>();
        int i = 0;
        int j = 0;
        while (j < indeces1.length && i < indeces2.length) {
        }
        while (j < indeces1.length && indeces1[j] < indeces2[i]) {
            ++j;
        }
        System.err.println("Merge: I:, J: " + i + ", " + j);
        System.err.println("Merge: Ind(I):, Ind(J): " + indeces2[i] + ", " + indeces1[j]);
        if (j < indeces1.length) {
            int[] ind;
            if (indeces2[i] == indeces1[j]) {
                ind = new int[]{j++, i};
                merger.addElement(ind);
            } else if (indeces2[i] < indeces1[j]) {
                ind = new int[]{-1, i++};
                merger.addElement(ind);
            } else {
                ind = new int[]{j, -1};
                merger.addElement(ind);
            }
        }
        if (merger.size() == 0) {
            return null;
        }
        int[][] retind = new int[merger.size()][];
        return (int[][])merger.toArray((T[])retind);
    }

    protected void setIndeces(int[] indeces) {
        this.indeces = indeces;
        if (this.bMatLine != null && indeces.length * 3 != this.bMatLine.lineElements.length) {
            throw new UnsupportedOperationException("Array mismatch.");
        }
    }

    SparseArray[] BBtMul(BMatrixLine[] bMat) {
        IntVector gMatLineInd = new IntVector();
        DoubleVector gMatLineArray = new DoubleVector();
        SparseArray[] gMat = new SparseArray[bMat.length];
        for (int i = 0; i < bMat.length; ++i) {
            for (int j = 0; j < bMat.length; ++j) {
                double dot = bMat[i].dot(bMat[j]);
                if (dot == 0.0) continue;
                gMatLineInd.addElement(j);
                gMatLineArray.addElement(dot);
            }
            gMat[i] = new SparseArray(gMatLineInd.toArray(), gMatLineArray.toArray());
        }
        return gMat;
    }

    public class BMatrixLine {
        protected int[] atomIndeces = null;
        protected double[] lineElements = null;

        public BMatrixLine(int[] atomIndeces, double[] lineElements) {
            this.atomIndeces = atomIndeces;
            if (lineElements.length != atomIndeces.length * 3) {
                throw new UnsupportedOperationException("Array mismatch in BMatrixLine.");
            }
            this.lineElements = lineElements;
        }

        public double[] getLineArray() {
            return this.lineElements;
        }

        public int[] getAtomIndeces() {
            return this.atomIndeces;
        }

        public BMatrixLine add(BMatrixLine b) {
            BMatrixLine c = null;
            int[][] tmpind = InternalCoordinate.mergeIndeces(this.getAtomIndeces(), b.getAtomIndeces());
            if (tmpind == null) {
                return null;
            }
            int[] indc = new int[tmpind.length];
            double[] valc = new double[tmpind.length];
            if (c == null) {
                c = new BMatrixLine(indc, valc);
            }
            for (int i = 0; i < tmpind.length; ++i) {
                int[] is = tmpind[i];
                if (is[0] == -1) {
                    indc[i] = InternalCoordinate.this.indeces[is[1]];
                    valc[i * 3] = b.getLineArray()[is[1] * 3];
                    valc[i * 3 + 1] = b.getLineArray()[is[1] * 3 + 1];
                    valc[i * 3 + 2] = b.getLineArray()[is[1] * 3 + 2];
                } else if (is[1] == -1) {
                    indc[i] = InternalCoordinate.this.indeces[is[0]];
                    valc[i * 3] = this.lineElements[is[0] * 3];
                    valc[i * 3 + 1] = this.lineElements[is[0] * 3 + 1];
                    valc[i * 3 + 2] = this.lineElements[is[0] * 3 + 2];
                }
                indc[i] = InternalCoordinate.this.indeces[is[0]];
                valc[i * 3] = this.lineElements[is[0] * 3] + b.getLineArray()[is[1] * 3];
                valc[i * 3 + 1] = this.lineElements[is[0] * 3 + 1] + b.getLineArray()[is[1] * 3 + 1];
                valc[i * 3 + 2] = this.lineElements[is[0] * 3 + 2] + b.getLineArray()[is[1] * 3 + 2];
            }
            return c;
        }

        public double dot(BMatrixLine b) {
            int[][] tmpind = InternalCoordinate.mergeIndeces(this.getAtomIndeces(), b.getAtomIndeces());
            if (tmpind == null) {
                return 0.0;
            }
            double dot = 0.0;
            for (int i = 0; i < tmpind.length; ++i) {
                int[] is = tmpind[i];
                if (is[0] <= -1 || is[1] <= -1) continue;
                dot += this.lineElements[is[0] * 3] * b.getLineArray()[is[1] * 3];
                dot += this.lineElements[is[0] * 3 + 1] * b.getLineArray()[is[1] * 3 + 1];
                dot += this.lineElements[is[0] * 3 + 2] * b.getLineArray()[is[1] * 3 + 2];
            }
            return dot;
        }

        public BMatrixLine scaleAndAdd(double sc, BMatrixLine b) {
            BMatrixLine c = null;
            int[][] tmpind = InternalCoordinate.mergeIndeces(this.getAtomIndeces(), b.getAtomIndeces());
            if (tmpind == null) {
                return null;
            }
            int[] indc = new int[tmpind.length];
            double[] valc = new double[tmpind.length];
            if (c == null) {
                c = new BMatrixLine(indc, valc);
            }
            for (int i = 0; i < tmpind.length; ++i) {
                int[] is = tmpind[i];
                if (is[0] == -1) {
                    indc[i] = InternalCoordinate.this.indeces[is[1]];
                    int n = i * 3;
                    valc[n] = valc[n] + sc * b.getLineArray()[is[1] * 3];
                    int n2 = i * 3 + 1;
                    valc[n2] = valc[n2] + sc * b.getLineArray()[is[1] * 3 + 1];
                    int n3 = i * 3 + 2;
                    valc[n3] = valc[n3] + sc * b.getLineArray()[is[1] * 3 + 2];
                } else if (is[1] == -1) {
                    indc[i] = InternalCoordinate.this.indeces[is[0]];
                    valc[i * 3] = this.lineElements[is[0] * 3];
                    valc[i * 3 + 1] = this.lineElements[is[0] * 3 + 1];
                    valc[i * 3 + 2] = this.lineElements[is[0] * 3 + 2];
                }
                indc[i] = InternalCoordinate.this.indeces[is[0]];
                valc[i * 3] = this.lineElements[is[0] * 3] + sc * b.getLineArray()[is[1] * 3];
                valc[i * 3 + 1] = this.lineElements[is[0] * 3 + 1] + sc * b.getLineArray()[is[1] * 3 + 1];
                valc[i * 3 + 2] = this.lineElements[is[0] * 3 + 2] + sc * b.getLineArray()[is[1] * 3 + 2];
            }
            return c;
        }
    }
}

