/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg.internals;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.linalg.internals.CombinedInternalCoordinate;
import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.linalg.internals.Internals;
import chemaxon.marvin.modelling.struc.ConformationMatch;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Vector;

public class InternalCoordinateSystem
implements Runnable {
    private static final long serialVersionUID = 4527128927692628679L;
    private double[] cartesianCoordinates = null;
    private double[] masses = null;
    private boolean validBMatrix = false;
    private boolean validDefinition = false;
    private boolean massWeighted = false;
    private InternalCoordinate.BMatrixLine[] bMatrix = null;
    private boolean cosAngleEnabled = false;
    private boolean dihedralEnabled = true;
    private boolean outOfPlaneEnabled = true;
    private boolean bondAngleEnabled = true;
    private boolean bondStretchEnabled = true;
    private double linearBondAngleLimit = 3.12413936106985;
    private BitSet[] closeAtoms = null;
    private BitSet[] close14Atoms = null;
    private Molecule m = null;
    private HashMap internalCoordHashMap = null;
    private Vector internalCoordVector = null;
    private Projector projector = null;
    private JLinAlg.Matrix gInverse = null;

    public JLinAlg.Matrix getGInverse() {
        return this.gInverse;
    }

    public void setGInverse(JLinAlg.Matrix gInverse) {
        this.gInverse = gInverse;
    }

    public InternalCoordinateSystem() {
        this.internalCoordVector = new Vector();
    }

    public InternalCoordinateSystem(Molecule m) {
        this.internalCoordVector = new Vector();
        this.setCartesianCoordinates(ConformationMatch.getMolCoordinates(m));
        this.setM(m);
    }

    public InternalCoordinateSystem(Molecule m, int initialCapacity) {
        this.internalCoordVector = new Vector(initialCapacity);
        this.setM(m);
    }

    public String toString() {
        String out = "";
        InternalCoordinate[] ics = this.getInternalCoordinates();
        for (int i = 0; i < ics.length; ++i) {
            out = out + "\n" + i + "\t" + ics[i].toString();
        }
        return out;
    }

    public static InternalCoordinate[] getCoolInternals(Molecule mol) {
        boolean terminator = true;
        boolean coolAromatic = true;
        InternalCoordinateSystem ics = new InternalCoordinateSystem(mol);
        InternalCoordinateSystem cq = new InternalCoordinateSystem(mol);
        double[] cartesians = ics.getCartesianCoordinates();
        BitSet ringAtoms = new BitSet();
        int[][] sSSR = mol.getSSSR();
        for (int i = 0; i < sSSR.length; ++i) {
            for (int j = 0; j < sSSR[i].length; ++j) {
                ringAtoms.set(sSSR[i][j]);
            }
        }
        InternalCoordinate[] bb = ics.getInternalsForType(1);
        for (int i = 0; i < bb.length; ++i) {
            cq.addInternalCoordinate(bb[i]);
        }
        int[][] cTab = mol.getCtab();
        BitSet ringatoms = new BitSet();
        int[][] lsSSR = mol.getSSSR();
        for (int i = 0; i < lsSSR.length; ++i) {
            for (int j = 0; j < lsSSR[i].length; ++j) {
                ringAtoms.set(lsSSR[i][j]);
            }
        }
        BitSet terminalA = new BitSet();
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            if (ringatoms.get(i) || cTab[i].length <= 1) continue;
            int nnSingle = 0;
            for (int j = 0; j < cTab[i].length; ++j) {
                if (cTab[cTab[i][j]].length <= 1) continue;
                ++nnSingle;
            }
            if (nnSingle > true) continue;
            terminalA.set(i);
        }
        InternalCoordinate[] a = ics.getInternalsForType(2);
        Internals.GeneralCombinedInternal qTmp = new Internals.GeneralCombinedInternal(cq.getCartesianCoordinates());
        mol.calcHybridization();
        int iCenter = -1;
        for (int i = 0; i < a.length; ++i) {
            int k;
            int j;
            int ic = a[i].getAtomIndeces()[1];
            if (iCenter == -1) {
                iCenter = ic;
            }
            if (ic == iCenter) {
                qTmp.add(a[i], 0.0);
            }
            if (ic == iCenter && i != a.length - 1) continue;
            InternalCoordinate[] localAng = qTmp.getComponentInternals();
            int nAng = localAng.length;
            if (nAng == 1) {
                cq.addInternalCoordinate(localAng[0]);
            }
            BitSet ringAng = new BitSet();
            BitSet chainAng = new BitSet();
            IntVector r = new IntVector();
            IntVector chain = new IntVector();
            for (j = 0; j < localAng.length; ++j) {
                int iic = localAng[j].getAtomIndeces()[1];
                int a1 = localAng[j].getAtomIndeces()[0];
                int a3 = localAng[j].getAtomIndeces()[2];
                if (ringAtoms.get(iic) || terminalA.get(iic)) continue;
                chain.add(iic);
            }
            for (j = 0; j < localAng.length; ++j) {
                int a1 = localAng[j].getAtomIndeces()[0];
                int a3 = localAng[j].getAtomIndeces()[2];
                if (ringAtoms.get(iCenter) && ringAtoms.get(a1) && ringAtoms.get(a3)) {
                    ringAng.set(j);
                }
                if (!chain.contains(iCenter) || !chain.contains(a1) && !terminalA.get(a1) || !chain.contains(a3) && !terminalA.get(a3)) continue;
                chainAng.set(j);
            }
            if (nAng == 6 && cTab[iCenter].length == 4) {
                int[] atoms = qTmp.getAtomIndeces();
                for (int j2 = 0; j2 < atoms.length; ++j2) {
                    if (ringAtoms.get(atoms[j2])) {
                        r.addElement(atoms[j2]);
                    }
                    if (ringAtoms.get(atoms[j2]) || cTab[atoms[j2]].length <= 1) continue;
                    chain.add(atoms[j2]);
                }
                int rc = ringAng.cardinality() + chainAng.cardinality();
                if (rc == 0) {
                    int j3;
                    int joint = atoms[0];
                    for (j3 = 0; j3 < atoms.length; ++j3) {
                        if (cTab[atoms[j3]].length <= 1) continue;
                        joint = atoms[j3];
                        break;
                    }
                    joint = atoms[0];
                    for (j3 = 0; j3 < localAng.length; ++j3) {
                        int a1 = localAng[j3].getAtomIndeces()[0];
                        int a3 = localAng[j3].getAtomIndeces()[2];
                        if (cTab[a1].length > 1) {
                            joint = a1;
                            break;
                        }
                        if (cTab[a3].length <= 1) continue;
                        joint = a3;
                        break;
                    }
                    BitSet ambrella = new BitSet(localAng.length);
                    for (int j4 = 0; j4 < localAng.length; ++j4) {
                        int a1 = localAng[j4].getAtomIndeces()[0];
                        int a3 = localAng[j4].getAtomIndeces()[2];
                        if (a1 != joint && a3 != joint) continue;
                        ambrella.set(j4);
                    }
                    int[] ch3Ang = new int[localAng.length];
                    int j5 = -1;
                    int ij = 0;
                    ++j5;
                    j5 = ambrella.nextSetBit(j5);
                    while (j5 != -1) {
                        ch3Ang[ij] = j5++;
                        ++ij;
                        j5 = ambrella.nextSetBit(j5);
                    }
                    j5 = -1;
                    int ia = 0;
                    while (ij < localAng.length) {
                        while (ambrella.get(ia)) {
                            ++ia;
                        }
                        ch3Ang[ij] = ia++;
                        ++ij;
                    }
                    InternalCoordinate[] ch3 = new InternalCoordinate[localAng.length];
                    for (k = 0; k < ch3.length; ++k) {
                        ch3[k] = localAng[ch3Ang[k]];
                    }
                    for (k = 0; k < 5; ++k) {
                        double[] coeff = new double[ch3.length];
                        switch (k) {
                            case 0: {
                                coeff[0] = -1.0;
                                coeff[1] = -1.0;
                                coeff[2] = -1.0;
                                coeff[3] = 1.0;
                                coeff[4] = 1.0;
                                coeff[5] = 1.0;
                                break;
                            }
                            case 1: {
                                coeff[3] = 2.0;
                                coeff[4] = -1.0;
                                coeff[5] = -1.0;
                                break;
                            }
                            case 2: {
                                coeff[4] = 1.0;
                                coeff[5] = -1.0;
                                break;
                            }
                            case 3: {
                                coeff[0] = 2.0;
                                coeff[1] = -1.0;
                                coeff[2] = -1.0;
                                break;
                            }
                            case 4: {
                                coeff[1] = 1.0;
                                coeff[2] = -1.0;
                                break;
                            }
                            default: {
                                System.err.println("Internal error in getCool.");
                            }
                        }
                        Internals.GeneralCombinedInternal qch3i = new Internals.GeneralCombinedInternal(ch3[0].getCartesianCoordinates(), ch3, coeff);
                        cq.addInternalCoordinate(qch3i);
                    }
                }
                if (ringAng.cardinality() == 1 || chainAng.cardinality() == 1 && ringAng.cardinality() * chainAng.cardinality() == 0) {
                    int k2;
                    InternalCoordinate[] ch2 = new InternalCoordinate[localAng.length - 1];
                    int j6 = 0;
                    for (k2 = 0; k2 < ch2.length; ++k2) {
                        if (chainAng.get(j6) || ringAng.get(j6)) {
                            ++j6;
                            --k2;
                            continue;
                        }
                        ch2[k2] = localAng[j6];
                        ++j6;
                    }
                    for (k2 = 0; k2 < ch2.length; ++k2) {
                        if (cTab[ch2[k2].getAtomIndeces()[0]].length != 1 || cTab[ch2[k2].getAtomIndeces()[2]].length != 1 || k2 <= 0) continue;
                        InternalCoordinate tq = ch2[0];
                        ch2[0] = ch2[k2];
                        ch2[k2] = tq;
                    }
                    for (k2 = 0; k2 < 4; ++k2) {
                        double[] coeff = new double[ch2.length];
                        switch (k2) {
                            case 0: {
                                coeff[0] = 4.0;
                                coeff[1] = -1.0;
                                coeff[2] = -1.0;
                                coeff[3] = -1.0;
                                coeff[4] = -1.0;
                                break;
                            }
                            case 1: {
                                coeff[1] = 1.0;
                                coeff[2] = 1.0;
                                coeff[3] = -1.0;
                                coeff[4] = -1.0;
                                break;
                            }
                            case 2: {
                                coeff[1] = 1.0;
                                coeff[2] = -1.0;
                                coeff[3] = -1.0;
                                coeff[4] = 1.0;
                                break;
                            }
                            case 3: {
                                break;
                            }
                            default: {
                                System.err.println("Internal error in getCool/CH2.");
                            }
                        }
                        if (JLinAlg.VLength(coeff) == 0.0) continue;
                        Internals.GeneralCombinedInternal qch2i = new Internals.GeneralCombinedInternal(ch2[0].getCartesianCoordinates(), ch2, coeff);
                        cq.addInternalCoordinate(qch2i);
                    }
                    if (chainAng.cardinality() == 1) {
                        cq.addInternalCoordinate(localAng[chainAng.nextSetBit(0)]);
                    }
                }
            }
            if (nAng == 3 && cTab[iCenter].length == 3) {
                BitSet specAng = (BitSet)ringAng.clone();
                specAng.or(chainAng);
                InternalCoordinate[] nh2 = new InternalCoordinate[localAng.length];
                int ni = 0;
                if (specAng.cardinality() == 2) {
                    specAng.flip(0, 3);
                }
                if (specAng.cardinality() == 3) {
                    specAng.flip(0, 3);
                    specAng.set(0);
                }
                if (specAng.cardinality() == 0) {
                    specAng.set(0);
                }
                if (specAng.cardinality() == 1) {
                    int j7;
                    for (j7 = 0; j7 < localAng.length; ++j7) {
                        if (!specAng.get(j7)) continue;
                        nh2[ni] = localAng[j7];
                        ++ni;
                    }
                    for (j7 = 0; j7 < localAng.length; ++j7) {
                        if (specAng.get(j7)) continue;
                        nh2[ni] = localAng[j7];
                        ++ni;
                    }
                } else {
                    throw new UnsupportedOperationException("Consistency error in getCoolInternals.NH2");
                }
                if (ringAng.cardinality() == 0 || mol.getAtom(iCenter).getHybridizationState() == 3) {
                    int kSt = 0;
                    if (ringAng.cardinality() > 0) {
                        kSt = 1;
                    }
                    if (ringAng.cardinality() >= 2) {
                        kSt = 2;
                    }
                    for (int k3 = kSt; k3 < 2; ++k3) {
                        double[] coeff = new double[nh2.length];
                        switch (k3) {
                            case 0: {
                                coeff[0] = 2.0;
                                coeff[1] = -1.0;
                                coeff[2] = -1.0;
                                break;
                            }
                            case 1: {
                                coeff[1] = 1.0;
                                coeff[2] = -1.0;
                                break;
                            }
                            default: {
                                System.err.println("Internal error in getCool/NH2.");
                            }
                        }
                        Internals.GeneralCombinedInternal qnh2i = new Internals.GeneralCombinedInternal(nh2[0].getCartesianCoordinates(), nh2, coeff);
                        cq.addInternalCoordinate(qnh2i);
                    }
                    if (mol.getAtom(iCenter).getHybridizationState() == 3) {
                        int at = -1;
                        IntVector iv = new IntVector();
                        block42: for (int j8 = 1; j8 < nh2.length; ++j8) {
                            int[] atoms = nh2[j8].getAtomIndeces();
                            for (k = 0; k < atoms.length; ++k) {
                                at = atoms[k];
                                if (at == iCenter) continue;
                                if (iv.contains(at)) continue block42;
                                iv.addElement(at);
                            }
                        }
                        int[] ind = new int[]{nh2[0].getAtomIndeces()[0], nh2[0].getAtomIndeces()[1], nh2[0].getAtomIndeces()[2], at};
                        if (ringAng.cardinality() < 2) {
                            Internals.InternalOutOfPlaneAngle outq = new Internals.InternalOutOfPlaneAngle(nh2[0].getCartesianCoordinates(), ind);
                            cq.addInternalCoordinate(outq);
                        }
                    }
                } else {
                    double[] coeff = new double[]{0.0, 1.0, -1.0};
                    Internals.GeneralCombinedInternal qnh2i = new Internals.GeneralCombinedInternal(nh2[0].getCartesianCoordinates(), nh2, coeff);
                    cq.addInternalCoordinate(qnh2i);
                }
                qTmp = new Internals.GeneralCombinedInternal(cq.getCartesianCoordinates());
                iCenter = ic;
                qTmp.add(a[i], 0.0);
            }
            qTmp = new Internals.GeneralCombinedInternal(cq.getCartesianCoordinates());
            qTmp.add(a[i], 0.0);
            iCenter = a[i].getAtomIndeces()[1];
        }
        if (coolAromatic) {
            int maxAromatic = 7;
            int aromatization = 1;
            int[][] arr = mol.getAromaticAndAliphaticRings(aromatization, true, true, maxAromatic, Integer.MAX_VALUE)[0];
            IntVector iv = new IntVector();
            int lDih = 4;
            block44: for (int j = 0; j < arr.length; ++j) {
                int l = arr[j].length;
                InternalCoordinate[] rdql = new InternalCoordinate[l];
                InternalCoordinate[] rdqal = new InternalCoordinate[l];
                for (int j2 = 0; j2 < arr[j].length; ++j2) {
                    iv.clear();
                    iv.add(arr[j][j2]);
                    int j3 = j2 + 1;
                    iv.add(arr[j][j3 % l]);
                    iv.add(arr[j][++j3 % l]);
                    iv.add(arr[j][++j3 % l]);
                    int[] idx = iv.toArray();
                    int[] idxa = new int[]{idx[0], idx[1], idx[2]};
                    Internals.InternalDihedralAngle rdq = new Internals.InternalDihedralAngle(cartesians, idx);
                    Internals.InternalBondAngle rdqa = new Internals.InternalBondAngle(cartesians, idxa);
                    rdql[j2] = rdq;
                    rdqal[j2] = rdqa;
                }
                int m = l / 2;
                int count = 0;
                double[][] c = new double[m][l];
                double[][] si = new double[m][l];
                for (int s = 1; s < m; ++s) {
                    for (int k = 0; k < l; ++k) {
                        c[count][k] = Math.cos((double)(k * (s + 1) * 2) * Math.PI / (double)l);
                    }
                    Internals.GeneralCombinedInternal rq = new Internals.GeneralCombinedInternal(cartesians, rdql, c[count]);
                    cq.addInternalCoordinate(rq);
                    rq = new Internals.GeneralCombinedInternal(cartesians, rdqal, c[count]);
                    cq.addInternalCoordinate(rq);
                    if (++count == m) continue block44;
                    for (int k = 0; k < l; ++k) {
                        c[count][k] = Math.sin((double)(k * (s + 1) * 2) * Math.PI / (double)l);
                    }
                    rq = new Internals.GeneralCombinedInternal(cartesians, rdql, c[count]);
                    cq.addInternalCoordinate(rq);
                    rq = new Internals.GeneralCombinedInternal(cartesians, rdqal, c[count]);
                    cq.addInternalCoordinate(rq);
                    if (++count == m) continue block44;
                }
            }
        }
        if (terminator) {
            IntVector terminalCenters = new IntVector();
            for (int i = 0; i < mol.getAtomCount(); ++i) {
                int c;
                if (cTab[i].length >= 2 || terminalCenters.contains(c = cTab[i][0])) continue;
                terminalCenters.addElement(cTab[i][0]);
            }
            int[] pTerminals = terminalCenters.toArray();
            terminalCenters.clear();
            for (int i = 0; i < pTerminals.length; ++i) {
                int j;
                int iC1 = pTerminals[i];
                int[] iC1List = cTab[iC1];
                IntVector terminals1 = new IntVector();
                IntVector terminals2 = new IntVector();
                int iC2 = -1;
                int tType = -1;
                for (j = 0; j < iC1List.length; ++j) {
                    if (cTab[iC1List[j]].length < 2 && (tType == -1 || mol.getAtom(iC1List[j]).getAtno() == tType)) {
                        if (terminals1.size() == 0) {
                            tType = mol.getAtom(iC1List[j]).getAtno();
                        }
                        terminals1.addElement(iC1List[j]);
                        continue;
                    }
                    if (iC2 == -1) {
                        iC2 = iC1List[j];
                        continue;
                    }
                    iC2 = -1;
                    break;
                }
                if (iC2 == -1 || terminals1.size() <= 1) continue;
                for (j = 0; j < cTab[iC2].length; ++j) {
                    if (cTab[iC2][j] == iC1) continue;
                    terminals2.addElement(cTab[iC2][j]);
                }
                int nDih = terminals1.size() * terminals2.size();
                InternalCoordinate[] rot = new Internals.InternalDihedralAngle[nDih];
                double[] coeff = new double[rot.length];
                int[] ind = new int[4];
                int r = 0;
                for (int j9 = 0; j9 < terminals1.size(); ++j9) {
                    for (int j2 = 0; j2 < terminals2.size(); ++j2) {
                        ind = new int[]{terminals1.elementAt(j9), iC1, iC2, terminals2.elementAt(j2)};
                        rot[r] = new Internals.InternalDihedralAngle(cartesians, ind);
                        coeff[r] = 1.0 / (double)nDih;
                        ++r;
                    }
                }
                Internals.GeneralCombinedInternal q = new Internals.GeneralCombinedInternal(rot[0].getCartesianCoordinates());
                q.setComponentInternals(rot);
                q.setComponentCoefficients(coeff);
                cq.addInternalCoordinate(q);
            }
        }
        InternalCoordinate[] q = cq.getInternalCoordinates();
        for (int i = 0; i < q.length; ++i) {
            if (q[i].getType() != 8) continue;
            Internals.GeneralCombinedInternal ciq = (Internals.GeneralCombinedInternal)q[i];
            ciq.normalizeCoefficients();
        }
        return cq.getInternalCoordinates();
    }

    @Override
    public void run() {
        int i2;
        if (this.m == null) {
            throw new UnsupportedOperationException("Cannot define internal coordinates for null molecule.");
        }
        this.setValidDefinition(false);
        MolBond[] bonds = this.m.getBondArray();
        if (this.isBondStretchEnabled()) {
            for (int i = 0; i < bonds.length; ++i) {
                int[] indeces = new int[]{this.m.indexOf(bonds[i].getAtom1()), this.m.indexOf(bonds[i].getAtom2())};
                Internals.InternalBondLength qbl = new Internals.InternalBondLength(this.getCartesianCoordinates(), indeces);
                this.internalCoordVector.addElement(qbl);
            }
        }
        int[][] cTab = this.m.getCtab();
        if (this.isBondAngleEnabled()) {
            for (int i = 0; i < cTab.length; ++i) {
                for (int j = 0; j < cTab[i].length; ++j) {
                    int i1 = cTab[i][j];
                    for (int k = j + 1; k < cTab[i].length; ++k) {
                        int i3 = cTab[i][k];
                        int[] indeces = new int[]{i1, i, i3};
                        InternalCoordinate qba = new Internals.InternalBondAngle(this.getCartesianCoordinates(), indeces);
                        if (((InternalCoordinate)qba).getValue() > this.getLinearBendLimit()) {
                            if (this.isCosAngleEnabled()) {
                                qba = new Internals.InternalCosAngle(this.getCartesianCoordinates(), indeces);
                            } else {
                                throw new UnsupportedOperationException("Linear bend I and II has not been implemented yet, enable cosAngle instead.");
                            }
                        }
                        this.internalCoordVector.addElement(qba);
                    }
                }
            }
        }
        if (this.isOutOfPlaneEnabled()) {
            for (int i = 0; i < cTab.length; ++i) {
                if (cTab[i].length != 3) continue;
                int i1 = cTab[i][0];
                i2 = cTab[i][1];
                int i3 = cTab[i][2];
                int[] indeces = new int[]{i1, i, i2, i3};
                Internals.InternalOutOfPlaneAngle oopb = new Internals.InternalOutOfPlaneAngle(this.getCartesianCoordinates(), indeces);
                this.internalCoordVector.addElement(oopb);
                indeces = new int[]{i1, i, i3, i2};
                oopb = new Internals.InternalOutOfPlaneAngle(this.getCartesianCoordinates(), indeces);
                this.internalCoordVector.addElement(oopb);
                indeces = new int[]{i2, i, i3, i1};
                oopb = new Internals.InternalOutOfPlaneAngle(this.getCartesianCoordinates(), indeces);
                this.internalCoordVector.addElement(oopb);
            }
        }
        if (this.isDihedralEnabled()) {
            for (int i = 0; i < bonds.length; ++i) {
                int i1 = this.m.indexOf(bonds[i].getAtom1());
                i2 = this.m.indexOf(bonds[i].getAtom2());
                for (int j = 0; j < cTab[i1].length; ++j) {
                    int ja = cTab[i1][j];
                    for (int k = 0; k < cTab[i2].length; ++k) {
                        int ka = cTab[i2][k];
                        if (ja == ka || ja == i2 || ka == i1) continue;
                        int[] indeces = new int[]{ja, i1, i2, ka};
                        int[] ind1 = new int[]{ja, i1, i2};
                        int[] ind2 = new int[]{i1, i2, ka};
                        if (new Internals.InternalBondAngle(this.getCartesianCoordinates(), ind1).getValue() >= this.linearBondAngleLimit) continue;
                        if (new Internals.InternalBondAngle(this.getCartesianCoordinates(), ind2).getValue() >= this.linearBondAngleLimit) continue;
                        Internals.InternalDihedralAngle qd = new Internals.InternalDihedralAngle(this.getCartesianCoordinates(), indeces);
                        this.internalCoordVector.addElement(qd);
                    }
                }
            }
        }
        this.setValidDefinition(true);
    }

    public static String getKeyForInternalCoordinate(InternalCoordinate q) {
        int i;
        String key = Integer.toString(q.getType());
        int[] indx = new int[q.getAtomIndeces().length];
        for (i = 0; i < indx.length; ++i) {
            indx[i] = q.getAtomIndeces()[i];
        }
        switch (q.getType()) {
            case 1: {
                if (indx[0] <= indx[1]) break;
                int ii = indx[0];
                indx[0] = indx[1];
                indx[1] = ii;
                break;
            }
            case 2: {
                if (indx[0] <= indx[2]) break;
                int ii = indx[0];
                indx[0] = indx[2];
                indx[2] = ii;
                break;
            }
            case 6: {
                if (indx[0] <= indx[2]) break;
                int ii = indx[0];
                indx[0] = indx[2];
                indx[2] = ii;
                break;
            }
            case 3: {
                if (indx[1] <= indx[2]) break;
                int ii = indx[0];
                indx[0] = indx[3];
                indx[3] = ii;
                ii = indx[1];
                indx[1] = indx[2];
                indx[2] = ii;
                break;
            }
        }
        for (i = 0; i < indx.length; ++i) {
            key = key + " " + indx[i];
        }
        return key;
    }

    public InternalCoordinate[] findInternals(String searchKey) {
        Vector qv = new Vector();
        HashMap ichm = this.getInternalCoordinateHashMap();
        if (this.internalCoordHashMap == null) {
            // empty if block
        }
        InternalCoordinate[] qa = new InternalCoordinate[qv.size()];
        return qv.toArray(qa);
    }

    public InternalCoordinate[] findInternals(int coordType, int[] idx) {
        Vector qv = new Vector();
        InternalCoordinate[] qa = new InternalCoordinate[qv.size()];
        return qv.toArray(qa);
    }

    public double[] getCartesianCoordinates() {
        return this.cartesianCoordinates;
    }

    public void setCartesianCoordinates(double[] cartesianCoordinates) {
        this.setValidBMatrix(false);
        JLinAlg.VectCopy(cartesianCoordinates, this.cartesianCoordinates);
        if (this.isValidDefinition()) {
            InternalCoordinate[] q = this.getInternalCoordinates();
            for (int i = 0; i < q.length; ++i) {
                q[i].setCartesianCoordinates(cartesianCoordinates);
            }
        }
    }

    public double[] getMasses() {
        return this.masses;
    }

    public void setMasses(double[] masses) {
        if (this.massWeighted) {
            this.setValidBMatrix(false);
        }
        this.masses = masses;
    }

    private boolean isValidBMatrix() {
        return this.validBMatrix;
    }

    protected void setValidBMatrix(boolean validBMatrix) {
        this.validBMatrix = validBMatrix;
    }

    public InternalCoordinate[] getInternalCoordinates() {
        if (!this.isValidDefinition()) {
            this.run();
        }
        InternalCoordinate[] internals = new InternalCoordinate[this.internalCoordVector.size()];
        this.internalCoordVector.toArray(internals);
        return internals;
    }

    public InternalCoordinate[] getInternalsForType(int type) {
        if (!this.isValidDefinition()) {
            this.run();
        }
        int counter = 0;
        for (InternalCoordinate q : this.internalCoordVector) {
            if (q.getType() != type) continue;
            ++counter;
        }
        InternalCoordinate[] internals = new InternalCoordinate[counter];
        counter = 0;
        for (InternalCoordinate q : this.internalCoordVector) {
            if (q.getType() != type) continue;
            internals[counter] = q;
            ++counter;
        }
        return internals;
    }

    public HashMap getInternalCoordinateHashMap() {
        if (!this.isValidDefinition()) {
            this.run();
        }
        if (this.internalCoordHashMap == null) {
            this.internalCoordHashMap = new HashMap(this.internalCoordVector.size());
            for (int i = 0; i < this.internalCoordVector.size(); ++i) {
                InternalCoordinate q = (InternalCoordinate)this.internalCoordVector.elementAt(i);
                this.internalCoordHashMap.put(InternalCoordinateSystem.getKeyForInternalCoordinate(q), q);
            }
        }
        return this.internalCoordHashMap;
    }

    public void setInternalCoordinates(InternalCoordinate[] internalCoordinates) {
        this.internalCoordVector.clear();
        this.internalCoordVector.addAll(Arrays.asList(internalCoordinates));
        this.setValidBMatrix(false);
        this.setValidDefinition(true);
        this.closeAtoms = null;
    }

    public void addInternalCoordinate(InternalCoordinate q) {
        this.internalCoordVector.addElement(q);
        if (this.internalCoordHashMap != null) {
            this.internalCoordHashMap.put(InternalCoordinateSystem.getKeyForInternalCoordinate(q), q);
        }
        this.setValidBMatrix(false);
        this.setValidDefinition(true);
    }

    public boolean removeInternalCoordinate(InternalCoordinate q) {
        HashMap iCSHM;
        if (!this.isValidDefinition()) {
            return false;
        }
        int idx = this.internalCoordVector.indexOf(q);
        if (idx < 0 && (q = (InternalCoordinate)(iCSHM = this.getInternalCoordinateHashMap()).remove(InternalCoordinateSystem.getKeyForInternalCoordinate(q))) == null) {
            return false;
        }
        idx = this.internalCoordVector.indexOf(q);
        if (idx < 0) {
            throw new RuntimeException("Internal consistency error in InternalCoordinateSystem.removeInternalCoordinate");
        }
        this.internalCoordVector.removeElementAt(idx);
        this.setValidBMatrix(false);
        this.closeAtoms = null;
        if (this.internalCoordHashMap != null) {
            this.internalCoordHashMap.remove(InternalCoordinateSystem.getKeyForInternalCoordinate(q));
        }
        return true;
    }

    public boolean replaceInternalCoordinate(InternalCoordinate originalCoordinate, InternalCoordinate newCoordinate) {
        HashMap iCSHM;
        if (!this.isValidDefinition()) {
            return false;
        }
        int idx = this.internalCoordVector.indexOf(originalCoordinate);
        if (idx < 0 && (originalCoordinate = (InternalCoordinate)(iCSHM = this.getInternalCoordinateHashMap()).get(InternalCoordinateSystem.getKeyForInternalCoordinate(originalCoordinate))) == null) {
            return false;
        }
        idx = this.internalCoordVector.indexOf(originalCoordinate);
        this.internalCoordVector.setElementAt(newCoordinate, idx);
        if (this.internalCoordHashMap != null) {
            String key = InternalCoordinateSystem.getKeyForInternalCoordinate(originalCoordinate);
            this.internalCoordHashMap.remove(key);
            this.internalCoordHashMap.put(InternalCoordinateSystem.getKeyForInternalCoordinate(newCoordinate), newCoordinate);
        }
        if (idx < 0) {
            throw new RuntimeException("Internal consistency error in InternalCoordinateSystem.replaceInternalCoordinate");
        }
        this.setValidBMatrix(false);
        return true;
    }

    public boolean isMassWeighted() {
        return this.massWeighted;
    }

    public void setMassWeighted(boolean massWeighted) {
        if (this.masses != null && this.massWeighted != massWeighted) {
            this.setValidBMatrix(false);
            this.massWeighted = massWeighted;
        }
    }

    public boolean isValidDefinition() {
        return this.validDefinition;
    }

    public InternalCoordinate.BMatrixLine[] getBMatrix() {
        if (!this.isValidDefinition()) {
            this.run();
        }
        if (!this.isValidBMatrix()) {
            int i;
            if (this.massWeighted && this.masses == null) {
                if (this.m == null) {
                    throw new UnsupportedOperationException("Cannot do mass weighting with no masses.");
                }
                this.masses = new double[this.m.getAtomCount()];
                for (i = 0; i < this.masses.length; ++i) {
                    this.masses[i] = this.m.getAtom(i).getMass();
                }
            }
            if (this.bMatrix == null || this.bMatrix.length != this.internalCoordVector.size()) {
                this.bMatrix = new InternalCoordinate.BMatrixLine[this.internalCoordVector.size()];
            }
            for (i = 0; i < this.internalCoordVector.size(); ++i) {
                InternalCoordinate q = (InternalCoordinate)this.internalCoordVector.elementAt(i);
                this.bMatrix[i] = q.getBMatrixLine();
            }
            if (this.isMassWeighted()) {
                for (i = 0; i < this.bMatrix.length; ++i) {
                    for (int j = 0; j < this.bMatrix[i].atomIndeces.length; ++j) {
                        int ia = this.bMatrix[i].atomIndeces[j];
                        double mass = this.getMasses()[ia];
                        int n = j * 3;
                        this.bMatrix[i].lineElements[n] = this.bMatrix[i].lineElements[n] / mass;
                        int n2 = j * 3 + 1;
                        this.bMatrix[i].lineElements[n2] = this.bMatrix[i].lineElements[n2] / mass;
                        int n3 = j * 3 + 2;
                        this.bMatrix[i].lineElements[n3] = this.bMatrix[i].lineElements[n3] / mass;
                    }
                }
            }
        }
        return this.bMatrix;
    }

    public boolean isCosAngleEnabled() {
        return this.cosAngleEnabled;
    }

    public void setCosAngleEnabled(boolean cosAngleEnabled) {
        if (this.cosAngleEnabled != cosAngleEnabled) {
            this.setValidDefinition(false);
        }
        this.cosAngleEnabled = cosAngleEnabled;
    }

    public Molecule getM() {
        return this.m;
    }

    public void setM(Molecule m) {
        this.m = m;
        this.cartesianCoordinates = new double[3 * m.getAtomCount()];
        for (int i = 0; i < m.getAtomCount(); ++i) {
            DPoint3 xyz = m.getAtom(i).getLocation();
            this.cartesianCoordinates[i * 3] = xyz.x;
            this.cartesianCoordinates[i * 3 + 1] = xyz.y;
            this.cartesianCoordinates[i * 3 + 2] = xyz.z;
        }
        this.setValidDefinition(false);
    }

    protected void setValidDefinition(boolean validDefinition) {
        if (!validDefinition) {
            this.internalCoordVector.clear();
            this.closeAtoms = null;
            this.close14Atoms = null;
            this.bMatrix = null;
        }
        this.validDefinition = validDefinition;
    }

    public double getLinearBendLimit() {
        return this.linearBondAngleLimit;
    }

    public BitSet[] getCloseAtoms() {
        if (this.closeAtoms == null) {
            if (!this.validDefinition) {
                this.run();
            }
            this.closeAtoms = new BitSet[this.m.getAtomCount()];
            for (int i = 0; i < this.closeAtoms.length; ++i) {
                this.closeAtoms[i] = new BitSet(this.m.getAtomCount());
            }
            for (InternalCoordinate q : this.internalCoordVector) {
                if (q.getType() != 8) {
                    this.setCloseBits(this.closeAtoms, q);
                    continue;
                }
                CombinedInternalCoordinate c = (CombinedInternalCoordinate)((Object)q);
                for (int i = 0; i < c.getComponentInternals().length; ++i) {
                    q = c.getComponentInternals()[i];
                    this.setCloseBits(this.closeAtoms, q);
                }
            }
        }
        return this.closeAtoms;
    }

    private void setCloseBits(BitSet[] closeAtoms, InternalCoordinate q) {
        switch (q.getType()) {
            case 1: {
                int[] idx = q.getAtomIndeces();
                closeAtoms[idx[0]].set(idx[1]);
                closeAtoms[idx[1]].set(idx[0]);
                break;
            }
            case 2: {
                int[] idx = q.getAtomIndeces();
                closeAtoms[idx[0]].set(idx[2]);
                closeAtoms[idx[2]].set(idx[0]);
                break;
            }
            case 6: {
                int[] idx = q.getAtomIndeces();
                closeAtoms[idx[0]].set(idx[2]);
                closeAtoms[idx[2]].set(idx[0]);
                break;
            }
            case 9: {
                int[] idx = q.getAtomIndeces();
                closeAtoms[idx[0]].set(idx[2]);
                closeAtoms[idx[2]].set(idx[0]);
                break;
            }
        }
    }

    public BitSet[] getClose14Atoms() {
        if (this.close14Atoms == null) {
            this.close14Atoms = new BitSet[this.m.getAtomCount()];
            for (int i = 0; i < this.close14Atoms.length; ++i) {
                this.close14Atoms[i] = new BitSet(this.m.getAtomCount());
            }
            for (InternalCoordinate q : this.internalCoordVector) {
                if (q.getType() != 8) {
                    this.setClose14Bits(this.close14Atoms, q);
                    continue;
                }
                CombinedInternalCoordinate c = (CombinedInternalCoordinate)((Object)q);
                for (int i = 0; i < c.getComponentInternals().length; ++i) {
                    q = c.getComponentInternals()[i];
                    this.setClose14Bits(this.close14Atoms, q);
                }
            }
        }
        return this.close14Atoms;
    }

    private void setClose14Bits(BitSet[] closeAtoms, InternalCoordinate q) {
        int[] idx = q.getAtomIndeces();
        switch (q.getType()) {
            case 3: {
                closeAtoms[idx[0]].set(idx[3]);
                closeAtoms[idx[3]].set(idx[0]);
                break;
            }
            case 6: {
                int idxj;
                int i;
                for (i = 0; i < this.m.getCtab()[idx[2]].length; ++i) {
                    idxj = this.m.getCtab()[idx[2]][i];
                    if (idxj == idx[1]) continue;
                    closeAtoms[idx[0]].set(idxj);
                    closeAtoms[idxj].set(idx[0]);
                }
                for (i = 0; i < this.m.getCtab()[idx[0]].length; ++i) {
                    idxj = this.m.getCtab()[idx[0]][i];
                    if (idxj == idx[1]) continue;
                    closeAtoms[idx[2]].set(idxj);
                    closeAtoms[idxj].set(idx[2]);
                }
                break;
            }
            case 9: {
                int idxj;
                int i;
                for (i = 0; i < this.m.getCtab()[idx[2]].length; ++i) {
                    idxj = this.m.getCtab()[idx[2]][i];
                    if (idxj == idx[1]) continue;
                    closeAtoms[idx[0]].set(idxj);
                    closeAtoms[idxj].set(idx[0]);
                }
                for (i = 0; i < this.m.getCtab()[idx[0]].length; ++i) {
                    idxj = this.m.getCtab()[idx[0]][i];
                    if (idxj == idx[1]) continue;
                    closeAtoms[idx[2]].set(idxj);
                    closeAtoms[idxj].set(idx[2]);
                }
                break;
            }
        }
    }

    public static String monitor(int verboseLevel, InternalCoordinate q) {
        String monOut = q.toString();
        monOut = monOut + " " + q.getValue();
        return monOut;
    }

    public static String monitor(int verboseLevel, InternalCoordinate q, double val) {
        String monOut = q.toString();
        monOut = monOut + " " + q.getValue() + " " + val;
        return monOut;
    }

    public static String monitor(String message, int verboseLevel, InternalCoordinateSystem iqs, double[] val) {
        String monOut = message + "\n";
        InternalCoordinate[] q = iqs.getInternalCoordinates();
        if (val != null && val.length != q.length) {
            throw new UnsupportedOperationException("Value array length mismatch in IntrnalCoordinateSystem monitor");
        }
        for (int i = 0; i < q.length; ++i) {
            monOut = monOut + q[i].toString() + " " + q[i].getValue();
            monOut = val != null ? monOut + " " + val[i] + "\n" : monOut + "\n";
        }
        return monOut;
    }

    public InternalCoordinate getInternalCoordinate(String key) {
        return (InternalCoordinate)this.getInternalCoordinateHashMap().get(key);
    }

    public boolean isDihedralEnabled() {
        return this.dihedralEnabled;
    }

    public void setDihedralEnabled(boolean dihedralEnabled) {
        if (this.dihedralEnabled != dihedralEnabled) {
            this.setValidDefinition(false);
        }
        this.dihedralEnabled = dihedralEnabled;
    }

    public boolean isOutOfPlaneEnabled() {
        return this.outOfPlaneEnabled;
    }

    public void setOutOfPlaneEnabled(boolean outOfPlaneEnabled) {
        if (this.outOfPlaneEnabled != outOfPlaneEnabled) {
            this.setValidDefinition(false);
        }
        this.outOfPlaneEnabled = outOfPlaneEnabled;
    }

    public boolean isBondAngleEnabled() {
        return this.bondAngleEnabled;
    }

    public void setBondAngleEnabled(boolean bondAngleEnabled) {
        if (this.bondAngleEnabled != bondAngleEnabled) {
            this.setValidDefinition(false);
        }
        this.bondAngleEnabled = bondAngleEnabled;
    }

    public boolean isBondStretchEnabled() {
        return this.bondStretchEnabled;
    }

    public void setBondStretchEnabled(boolean bondStretchEnabled) {
        if (this.bondStretchEnabled != bondStretchEnabled) {
            this.setValidDefinition(false);
        }
        this.bondStretchEnabled = bondStretchEnabled;
    }

    public double getLinearBondAngleLimit() {
        return this.linearBondAngleLimit;
    }

    public void setLinearBondAngleLimit(double linearBondAngleLimit) {
        if (this.linearBondAngleLimit != linearBondAngleLimit) {
            this.setValidDefinition(false);
        }
        this.linearBondAngleLimit = linearBondAngleLimit;
    }

    public Projector getProjector() {
        if (this.projector == null) {
            this.projector = new Projector();
        }
        return this.projector;
    }

    public static double[] bMultiply(InternalCoordinate.BMatrixLine[] bMatrix, double[] v, double[] w) {
        if (w == null) {
            w = new double[bMatrix.length];
        }
        for (int i = 0; i < bMatrix.length; ++i) {
            w[i] = 0.0;
            for (int j = 0; j < bMatrix[i].atomIndeces.length; ++j) {
                int jk0 = bMatrix[i].atomIndeces[j] * 3;
                int jj0 = j * 3;
                int n = i;
                w[n] = w[n] + bMatrix[i].lineElements[jj0] * v[jk0];
                int n2 = i;
                w[n2] = w[n2] + bMatrix[i].lineElements[jj0 + 1] * v[jk0 + 1];
                int n3 = i;
                w[n3] = w[n3] + bMatrix[i].lineElements[jj0 + 2] * v[jk0 + 2];
            }
        }
        return w;
    }

    public static double[] addBtQiLine(InternalCoordinate.BMatrixLine bMatrixLine, double val, double[] w) {
        for (int j = 0; j < bMatrixLine.atomIndeces.length; ++j) {
            int jk0 = bMatrixLine.atomIndeces[j] * 3;
            int jj0 = j * 3;
            int n = jk0;
            w[n] = w[n] + bMatrixLine.lineElements[jj0] * val;
            int n2 = jk0 + 1;
            w[n2] = w[n2] + bMatrixLine.lineElements[jj0 + 1] * val;
            int n3 = jk0 + 2;
            w[n3] = w[n3] + bMatrixLine.lineElements[jj0 + 2] * val;
        }
        return w;
    }

    public static double[] bBtMultiply(InternalCoordinate.BMatrixLine[] bMatrix, double[] v, double[] w) {
        if (w == null) {
            w = new double[bMatrix.length];
        }
        return w;
    }

    private class Projector
    implements Runnable {
        JLinAlg.Matrix gInverse = null;

        private Projector() {
        }

        @Override
        public void run() {
        }
    }
}

