/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg.internals;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.EquationSequenceSolver;
import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.linalg.SparseArray;
import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.linalg.internals.InternalCoordinateSystem;
import chemaxon.struc.Molecule;
import java.io.IOException;

public class InternalCoordinateTools {
    private static int verboseLevel = 1;
    private InternalCoordinate.BMatrixLine[] bMat = null;
    private InternalCoordinateSystem ics = null;
    private double[] cartesianForces = null;
    private double[] internalForces = null;
    private EquationSequenceSolver geqs = null;

    public InternalCoordinate.BMatrixLine[] getBMat() {
        return this.bMat;
    }

    public void setBMat(InternalCoordinate.BMatrixLine[] bMat) {
        this.bMat = bMat;
    }

    public double[] getCartesianForces() {
        return this.cartesianForces;
    }

    public void setCartesianForces(double[] cartesianForces) {
        this.cartesianForces = cartesianForces;
    }

    public InternalCoordinateSystem getIcs() {
        return this.ics;
    }

    public void setIcs(InternalCoordinateSystem ics) {
        this.ics = ics;
    }

    public double[] getInternalForces() {
        return this.internalForces;
    }

    public void setInternalForces(double[] internalForces) {
        this.internalForces = internalForces;
    }

    public static InternalCoordinate.BMatrixLine getNumericBMatrixRow(InternalCoordinate q) {
        double small = 1.0E-6;
        int[] indx = q.getAtomIndeces();
        double[] bLN = new double[3 * indx.length];
        double[] c = q.getCartesianCoordinates();
        for (int i = 0; i < indx.length; ++i) {
            int ij = indx[i] * 3;
            for (int j = 0; j < 3; ++j) {
                double dv;
                int n = ij;
                c[n] = c[n] + 1.0E-6;
                double v1 = q.getValue();
                int n2 = ij;
                c[n2] = c[n2] - 2.0E-6;
                double v2 = q.getValue();
                int n3 = ij++;
                c[n3] = c[n3] + 1.0E-6;
                bLN[i * 3 + j] = dv = q.checkValueChange(v1 - v2) / 2.0E-6;
            }
        }
        InternalCoordinate internalCoordinate = q;
        internalCoordinate.getClass();
        InternalCoordinate.BMatrixLine bLine = internalCoordinate.new InternalCoordinate.BMatrixLine(indx, bLN);
        return bLine;
    }

    public static InternalCoordinate.BMatrixLine[] getNumericBMatrix(InternalCoordinateSystem qSystem) {
        InternalCoordinate[] q = qSystem.getInternalCoordinates();
        InternalCoordinate.BMatrixLine[] bMat = new InternalCoordinate.BMatrixLine[q.length];
        for (int i = 0; i < bMat.length; ++i) {
            bMat[i] = InternalCoordinateTools.getNumericBMatrixRow(q[i]);
        }
        return bMat;
    }

    public static boolean debugAnalitycBMatrix(InternalCoordinateSystem qSystem) {
        boolean ok = true;
        InternalCoordinate.BMatrixLine[] aBMat = qSystem.getBMatrix();
        InternalCoordinate.BMatrixLine[] nBMat = InternalCoordinateTools.getNumericBMatrix(qSystem);
        InternalCoordinate[] q = qSystem.getInternalCoordinates();
        for (int i = 0; i < q.length; ++i) {
            double d2Sum = 0.0;
            for (int j = 0; j < nBMat[i].lineElements.length; ++j) {
                double dd = nBMat[i].lineElements[j] - aBMat[i].lineElements[j];
                d2Sum += dd * dd;
            }
            if (d2Sum > 0.001) {
                System.err.println(InternalCoordinateTools.internalCoordinateToString(q[i]));
                int[] indeces = q[i].getAtomIndeces();
                for (int j = 0; j < indeces.length; ++j) {
                    System.err.print("\t" + indeces[j] + "\t");
                }
                System.err.println();
                for (int l = 0; l < 3; ++l) {
                    for (int j = 0; j < indeces.length; ++j) {
                        System.err.print(debugPrintout.formatNumber(8, 3, aBMat[i].lineElements[j * 3 + l]) + debugPrintout.formatNumber(8, 3, nBMat[i].lineElements[j * 3 + l]));
                    }
                    System.err.println();
                }
                System.err.println();
                ok = false;
                continue;
            }
            if (InternalCoordinateTools.getVerboseLevel() <= 0) continue;
            System.err.println(InternalCoordinateTools.internalCoordinateToString(q[i]));
        }
        return ok;
    }

    public static String internalCoordinateToString(InternalCoordinate q) {
        String dump = "--------------------------------\n";
        double value = q.getValue();
        switch (q.getType()) {
            case 1: {
                dump = dump + " Bond strech for";
                break;
            }
            case 2: {
                dump = dump + " Bond angle for";
                value *= 57.29577951308232;
                break;
            }
            case 4: {
                dump = dump + " Out-of-plane bending for";
                value *= 57.29577951308232;
                break;
            }
            case 3: {
                dump = dump + " Dihedral angle for";
                value *= 57.29577951308232;
                break;
            }
            default: {
                dump = dump + " Type #" + q.getType() + " internal coordinate for";
            }
        }
        int[] indeces = q.getAtomIndeces();
        dump = dump + " " + indeces[0];
        for (int i = 1; i < indeces.length; ++i) {
            dump = dump + "-" + indeces[i];
        }
        dump = dump + "\tValue: " + debugPrintout.formatNumber(8, 3, value);
        return dump;
    }

    public static void main(String[] args) {
        MolImporter mi = null;
        InternalCoordinateTools.setVerboseLevel(1);
        try {
            if (args.length == 0 || args[0].equals("-")) {
                mi = new MolImporter(System.in);
            } else {
                String fileName = args[0];
                mi = new MolImporter(fileName);
            }
            Molecule m = mi.read();
            int counter = 1;
            while (m != null) {
                System.err.println("Processing molecule #" + counter);
                if (m.getDim() < 3) {
                    m.clean(3, null);
                }
                InternalCoordinateSystem qs = new InternalCoordinateSystem(m);
                qs.setCosAngleEnabled(true);
                if (!InternalCoordinateTools.debugAnalitycBMatrix(qs)) {
                    System.out.println(m.toFormat("sdf"));
                    System.err.println(m.toFormat("sdf"));
                } else {
                    System.err.println("Internal coordinates are ready to use.");
                }
                m = mi.read();
                ++counter;
            }
        }
        catch (MolFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getVerboseLevel() {
        return verboseLevel;
    }

    public static void setVerboseLevel(int verboseLevel) {
        InternalCoordinateTools.verboseLevel = verboseLevel;
    }

    public static double[] bMul(InternalCoordinate.BMatrixLine[] bMat, double[] xVec, double[] qVec) {
        if (qVec == null) {
            qVec = new double[bMat.length];
        }
        for (int i = 0; i < bMat.length; ++i) {
            InternalCoordinate.BMatrixLine bMatrixLine = bMat[i];
            qVec[i] = 0.0;
            for (int j = 0; j < bMatrixLine.atomIndeces.length; ++j) {
                int jAIndx = bMatrixLine.atomIndeces[j];
                int n = i;
                qVec[n] = qVec[n] + bMatrixLine.lineElements[j * 3] * xVec[jAIndx * 3];
                int n2 = i;
                qVec[n2] = qVec[n2] + bMatrixLine.lineElements[j * 3 + 1] * xVec[jAIndx * 3 + 1];
                int n3 = i;
                qVec[n3] = qVec[n3] + bMatrixLine.lineElements[j * 3 + 2] * xVec[jAIndx * 3 + 2];
            }
        }
        return qVec;
    }

    public static double[] bTMul(InternalCoordinate.BMatrixLine[] bMat, double[] qVec, double[] xVec) {
        if (xVec == null) {
            return null;
        }
        JLinAlg.VectClear(xVec);
        for (int i = 0; i < bMat.length; ++i) {
            InternalCoordinate.BMatrixLine bMatrixLine = bMat[i];
            double[] tmp = JLinAlg.VectScale(bMatrixLine.lineElements, qVec[i]);
            for (int j = 0; j < bMatrixLine.atomIndeces.length; ++j) {
                int k = bMatrixLine.atomIndeces[j];
                int n = k * 3;
                xVec[n] = xVec[n] + tmp[j * 3];
                int n2 = k * 3 + 1;
                xVec[n2] = xVec[n2] + tmp[j * 3 + 1];
                int n3 = k * 3 + 2;
                xVec[n3] = xVec[n3] + tmp[j * 3 + 2];
            }
        }
        return xVec;
    }

    public static SparseArray[] bTranspose(InternalCoordinate.BMatrixLine[] bMat) {
        int i;
        int nDim = 0;
        for (int i2 = 0; i2 < bMat.length; ++i2) {
            InternalCoordinate.BMatrixLine bMatrixLine = bMat[i2];
            int[] ind = bMatrixLine.getAtomIndeces();
            for (int j = 0; j < ind.length; ++j) {
                int k = ind[j];
                if (k < nDim) continue;
                nDim = k + 1;
            }
        }
        int[] trL = new int[nDim];
        SparseArray[] bTr = new SparseArray[nDim];
        for (int i3 = 0; i3 < bMat.length; ++i3) {
            InternalCoordinate.BMatrixLine bMatrixLine = bMat[i3];
            int[] indx = bMatrixLine.getAtomIndeces();
            for (int j = 0; j < indx.length; ++j) {
                int k = indx[j];
                int n = k * 3;
                trL[n] = trL[n] + 1;
                int n2 = k * 3 + 1;
                trL[n2] = trL[n2] + 1;
                int n3 = k * 3 + 2;
                trL[n3] = trL[n3] + 1;
            }
        }
        int[][] bTrIndx = new int[nDim][];
        double[][] bTrVal = new double[nDim][];
        for (i = 0; i < bTrIndx.length; ++i) {
            bTrIndx[i] = new int[trL[i]];
            bTrVal[i] = new double[trL[i]];
            trL[i] = 0;
        }
        for (i = 0; i < bMat.length; ++i) {
            InternalCoordinate.BMatrixLine bMatrixLine = bMat[i];
            int[] ind = bMatrixLine.getAtomIndeces();
            double[] val = bMatrixLine.getLineArray();
            for (int j = 0; j < ind.length; ++j) {
                int k = ind[j];
                bTrIndx[k][trL[k]] = i;
                bTrVal[k][trL[k]] = val[j];
                int n = k;
                trL[n] = trL[n] + 1;
            }
        }
        for (i = 0; i < bTr.length; ++i) {
            bTr[i] = new SparseArray(bTrIndx[i], bTrVal[i]);
        }
        return bTr;
    }

    public static double bijMul(InternalCoordinate.BMatrixLine[] bMat, int i, int j) {
        InternalCoordinate.BMatrixLine iLine = bMat[i];
        InternalCoordinate.BMatrixLine jLine = bMat[j];
        double res = 0.0;
        int i1 = 0;
        int j1 = 0;
        while (i1 < iLine.atomIndeces.length && j1 < jLine.atomIndeces.length) {
            if (iLine.atomIndeces[i1] == jLine.atomIndeces[j1]) {
                res += iLine.lineElements[i1 * 3] * jLine.lineElements[j1 * 3];
                res += iLine.lineElements[i1 * 3 + 1] * jLine.lineElements[j1 * 3 + 1];
                res += iLine.lineElements[i1 * 3 + 1] * jLine.lineElements[j1 * 3 + 1];
            }
            if (iLine.atomIndeces[i1] < jLine.atomIndeces[j1]) {
                i1 = Math.min(i1 + 1, iLine.atomIndeces.length);
                continue;
            }
            j1 = Math.min(j1 + 1, jLine.atomIndeces.length);
        }
        return res;
    }
}

