/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg;

import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.linalg.JacobiTransformation;
import chemaxon.marvin.modelling.linalg.Matrix;
import chemaxon.marvin.modelling.linalg.V;

public class multiDim {
    int maxDim = 0;
    int maxV = 0;
    int mOffs = 0;
    double[] s = null;
    public int n = 0;
    public int d = 0;
    boolean expRealloc = false;

    public void setExpRealloc(boolean b) {
        this.expRealloc = b;
    }

    void realloc(int newDim, int newV) {
        if (newDim < this.d) {
            newDim = this.d;
        }
        if (newV < this.n) {
            newV = this.n;
        }
        if (newDim > this.maxDim || newV > this.maxV) {
            double[] newS = new double[(newV + 1) * newDim];
            int newMOffs = newDim * newV;
            for (int dd = 0; dd < this.d; ++dd) {
                newS[newMOffs + dd] = this.s[this.mOffs + dd];
                for (int nn = 0; nn < this.n; ++nn) {
                    newS[dd + nn * newDim] = this.s[dd + nn * this.maxDim];
                }
            }
            this.maxDim = newDim;
            this.maxV = newV;
            this.s = newS;
            this.mOffs = newMOffs;
        }
    }

    void checkSize(int dim, int vn) {
        if (dim >= this.maxDim || vn >= this.maxV) {
            this.realloc(dim >= this.maxDim ? (dim + 1) * (this.expRealloc ? 2 : 1) : this.maxDim, vn >= this.maxV ? (vn + 1) * (this.expRealloc ? 2 : 1) : this.maxV);
        }
        if (dim >= this.d) {
            for (int i = this.d; i <= dim; ++i) {
                this.s[this.mOffs + i] = 1.0;
            }
            this.d = dim + 1;
        }
        if (vn >= this.n) {
            this.n = vn + 1;
        }
    }

    public int getVcount() {
        return this.n;
    }

    public int size() {
        return this.n;
    }

    public int getD() {
        return this.d;
    }

    public double getM(int coord) {
        this.checkSize(coord, -1);
        return this.s[this.mOffs + coord];
    }

    public double[] getM() {
        double[] ret = new double[this.d];
        for (int i = 0; i < this.d; ++i) {
            ret[i] = this.s[this.mOffs + i];
        }
        return ret;
    }

    public void putM(double[] m) {
        int i;
        this.checkSize(m.length - 1, -1);
        for (i = 0; i < m.length; ++i) {
            this.s[this.mOffs + i] = m[i];
        }
        for (i = m.length; i < this.d; ++i) {
            this.s[this.mOffs + i] = 1.0;
        }
    }

    public void putM(int coord, double val) {
        this.checkSize(coord, -1);
        this.s[this.mOffs + coord] = val;
    }

    public void putV(int no, int coord, double val) {
        this.checkSize(coord, no);
        this.s[no * this.maxDim + coord] = val;
    }

    public void putV(int vn, double[] v) {
        int i;
        this.checkSize(v.length - 1, vn);
        for (i = 0; i < v.length; ++i) {
            this.s[this.maxDim * vn + i] = v[i];
        }
        for (i = v.length; i < this.d; ++i) {
            this.s[this.maxDim * vn + i] = 0.0;
        }
    }

    public void setZero(int vn) {
        this.checkSize(0, vn);
        for (int i = 0; i < this.d; ++i) {
            this.s[this.maxDim * vn + i] = 0.0;
        }
    }

    public double[][] getV() {
        double[][] ret = new double[this.n][this.d];
        for (int j = 0; j < this.n; ++j) {
            for (int i = 0; i < this.d; ++i) {
                ret[j][i] = this.s[j * this.maxDim + i];
            }
        }
        return ret;
    }

    public double[] getV(int n) {
        double[] ret = new double[this.d];
        if (n < this.n && n >= 0) {
            for (int i = 0; i < this.d; ++i) {
                ret[i] = this.s[n * this.maxDim + i];
            }
        }
        return ret;
    }

    public double getV(int vn, int dd) {
        if (vn < this.n && vn >= 0 && dd < this.d && dd >= 0) {
            return this.s[vn * this.maxDim + dd];
        }
        return 0.0;
    }

    public int getMaxV() {
        return this.maxV;
    }

    public int getMaxDim() {
        return this.maxDim;
    }

    public void printDebug(debugPrintout debug) {
        debug.printCoord(this.getV(), this.getM());
    }

    public multiDim(int n, int d) {
        this.n = 0;
        this.d = 0;
        this.realloc(d, n);
    }

    public multiDim() {
        this.n = 0;
        this.d = 0;
    }

    public multiDim(double[][] vInit, double[] mInit) {
        int i;
        int vn = vInit.length;
        int dim = mInit.length;
        for (i = 0; i < vn; ++i) {
            if (vInit[i].length <= dim) continue;
            dim = vInit[i].length;
        }
        if (dim != 0) {
            if (vn > this.maxV || dim > this.maxDim) {
                this.n = 0;
                this.d = 0;
                this.realloc(dim, vn);
            }
            this.n = vn;
            this.d = dim;
            for (i = 0; i < mInit.length; ++i) {
                this.s[this.mOffs + i] = mInit[i];
            }
            for (int j = 0; j < vInit.length; ++j) {
                for (int i2 = 0; i2 < vInit[j].length; ++i2) {
                    this.s[j * this.maxDim + i2] = vInit[j][i2];
                }
            }
        }
    }

    public int addDim() {
        this.checkSize(this.d, -1);
        return this.d - 1;
    }

    public void schmidtOrthogonalize() {
    }

    public double[] doSchmidtOrthogonalisation(double[] v) {
        double[] ret = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            double dXi = V.dotUsingMetric(v, this.getV(i), this.getM());
            if (V.dotUsingMetric(this.getV(i), this.getV(i), this.getM()) < 0.0) {
                dXi *= -1.0;
            }
            ret[i] = dXi;
            V.minusWriteBackToa(v, V.dot(dXi, this.getV(i)));
        }
        return ret;
    }

    public double metrid(double[] v) {
        if (v != null && v.length > 0) {
            return V.dotUsingMetric(v, this.getM());
        }
        return 0.0;
    }

    public void norm(double[] v) {
        if (v != null && v.length > 0) {
            double dXi = Math.sqrt(Math.abs(this.metrid(v)));
            dXi = Math.abs(dXi) > 1.0E-4 ? 1.0 / dXi : 0.0;
            int i = 0;
            while (i < v.length) {
                int n = i++;
                v[n] = v[n] * dXi;
            }
        }
    }

    public multiDim doJacobi() {
        multiDim ret = new multiDim();
        return ret;
    }

    public void empty() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.d; ++j) {
                this.s[this.maxDim * i + j] = 0.0;
            }
        }
        this.d = 0;
        this.n = 0;
    }

    public double[] linearCombine(double[] v) {
        double[] ret = new double[this.d];
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < ret.length; ++j) {
                int n = j;
                ret[n] = ret[n] + v[i] * this.getV(i, j);
            }
        }
        return ret;
    }

    public void findBaseJacobi(multiDim result, int[] cnodes, int pN) {
        result.empty();
        int dim = this.d;
        double[] origo = this.getV(cnodes[0]);
        double[] metric = this.getM();
        result.putM(metric);
        int nodes = pN;
        if (nodes < 2) {
            return;
        }
        double[][] vSet = new double[nodes - 1][dim];
        for (int i = 1; i < nodes; ++i) {
            vSet[i - 1] = V.minus(this.getV(cnodes[i]), origo);
        }
        double vectors = nodes - 1;
        double[][] oInit = new double[nodes - 1][nodes - 1];
        int i = 0;
        while ((double)i < vectors) {
            double[] Xi = vSet[i];
            int j = 0;
            while ((double)j < vectors) {
                double[] Xj = vSet[j];
                oInit[i][j] = V.dotUsingMetric(Xi, Xj, metric);
                ++j;
            }
            ++i;
        }
        Matrix O = new Matrix(oInit);
        JacobiTransformation Odiag = new JacobiTransformation(O);
        double[] OdiagV = Odiag.d;
        double[][] OdiagM = Odiag.v;
        int bn = 0;
        int i2 = 0;
        while ((double)i2 < vectors) {
            if (Math.abs(OdiagV[i2]) > 1.0E-4) {
                ++bn;
            }
            ++i2;
        }
        bn = 0;
        i2 = 0;
        while ((double)i2 < vectors) {
            if (Math.abs(OdiagV[i2]) > 1.0E-4) {
                double[] combined = new double[dim];
                int j = 0;
                while ((double)j < vectors) {
                    combined = V.plus(combined, V.dot(OdiagM[j][i2], vSet[j]));
                    ++j;
                }
                result.putV(bn, V.dot(1.0 / Math.sqrt(Math.abs(OdiagV[i2])), combined));
                ++bn;
            }
            ++i2;
        }
    }

    public double[][] findBaseJacobi(int[] cnodes) {
        multiDim result = new multiDim(cnodes.length + 2, this.maxDim + 2);
        this.findBaseJacobi(result, cnodes, cnodes.length);
        return result.getV();
    }

    public static boolean isZero(double[] v) {
        if (v != null) {
            for (int i = 0; i < v.length; ++i) {
                if (!(Math.abs(v[i]) > 1.0E-4)) continue;
                return false;
            }
        }
        return true;
    }
}

