/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.linalg;

import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.linalg.multiDim;

public class subSpace {
    public multiDim nodes = null;
    public multiDim base = null;
    public multiDim ortho = null;
    public int[] nindex = null;
    public int n = 0;

    void init() {
        this.nodes = new multiDim();
        this.base = new multiDim();
        this.nindex = new int[100];
    }

    public subSpace() {
        this.init();
    }

    public subSpace(multiDim pNodes) {
        if (pNodes != null) {
            this.nodes = pNodes;
            this.base = new multiDim(pNodes.maxV, pNodes.maxDim);
            this.nindex = new int[pNodes.maxV];
        }
    }

    public void setBase(multiDim b) {
        this.base = b;
    }

    public void empty() {
        if (this.base == null) {
            this.init();
        }
        this.n = 0;
        this.base.empty();
    }

    public void sync(multiDim pNodes) {
        this.empty();
        this.n = 0;
        this.nodes = pNodes;
    }

    public void adminInsert(int pN) {
        if (this.nindex == null) {
            this.init();
        }
        if (this.n == this.nindex.length) {
            int[] nIndexTmp = new int[10 + this.nindex.length * 2];
            for (int i = 0; i < this.n; ++i) {
                nIndexTmp[i] = this.nindex[i];
            }
            this.nindex = nIndexTmp;
        }
        this.nindex[this.n++] = pN;
    }

    public void doJacobi() {
        if (this.nodes == null) {
            this.init();
        }
        this.nodes.findBaseJacobi(this.base, this.nindex, this.n);
    }

    public void addJacobi(int pN) {
        this.adminInsert(pN);
        this.doJacobi();
    }

    public void generateOrthogonalSubspace() {
        if (this.base != null) {
            if (this.ortho == null) {
                int d;
                int n;
                if (this.nodes != null) {
                    n = this.nodes.maxV;
                    d = this.nodes.maxDim;
                } else {
                    n = this.base.maxV;
                    d = this.base.maxDim;
                }
                this.ortho = new multiDim(n, d);
            } else {
                this.ortho.empty();
            }
            this.ortho.putM(this.base.getM());
            int orthoNo = 0;
            double[] candidate = new double[this.base.d];
            for (int dimNo = 0; dimNo < this.base.d; ++dimNo) {
                V.setZero(candidate);
                candidate[dimNo] = 1.0;
                this.base.doSchmidtOrthogonalisation(candidate);
                if (!(Math.abs(this.base.metrid(candidate)) > 1.0E-4)) continue;
                this.base.norm(candidate);
                boolean found = false;
                for (int i = 0; i < orthoNo && !found; ++i) {
                    if (multiDim.isZero(V.minus(candidate, this.ortho.getV(i)))) {
                        found = true;
                        continue;
                    }
                    if (!multiDim.isZero(V.plus(candidate, this.ortho.getV(i)))) continue;
                    found = true;
                }
                if (found) continue;
                this.ortho.putV(orthoNo, candidate);
                ++orthoNo;
            }
        }
    }
}

