/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.md;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.marvin.modelling.md.Debug;
import chemaxon.marvin.modelling.md.DreidingFF;
import chemaxon.marvin.modelling.md.ForceField;
import chemaxon.marvin.modelling.md.Integrator;
import chemaxon.marvin.modelling.md.LeapFrog;
import chemaxon.marvin.modelling.md.MDException;
import chemaxon.marvin.modelling.md.NewDreidingFF;
import chemaxon.marvin.modelling.md.PositionVerlet;
import chemaxon.marvin.modelling.md.ProjectedVelocityVerlet;
import chemaxon.marvin.modelling.md.StabilizedVelocityVerlet;
import chemaxon.marvin.modelling.md.VelocityVerlet;
import chemaxon.marvin.modelling.md.XtcExport;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class MolecularDynamics {
    private Molecule mol;
    private boolean centerMolecule = false;
    private double steptime = 0.1;
    private int stepno = 1000;
    private int forcefieldtype = 1;
    private int integratortype = 1;
    private double temperature = 300.0;
    private int elapsedstep = 0;
    private double elapsedtime = 0.0;
    static final int FF_NOTKNOWN = 0;
    static final int FF_DREIDING = 1;
    static final int FF_MMFF = 2;
    static final int FF_NEWDREIDING = 3;
    static final int INT_NOTKNOWN = 0;
    static final int INT_VELOCITYVERLET = 1;
    static final int INT_POSITIONVERLET = 2;
    static final int INT_LEAPFROG = 3;
    static final int INT_STABILIZEDVELOCITYVERLET = 4;
    static final int INT_PROJECTEDVELOCITYVERLET = 5;
    private ForceField ff = null;
    private Integrator integrator = null;
    private double lastenergy = 0.0;
    private double lastpotenergy = 0.0;
    private double lastkinenergy = 0.0;
    public static final int TRAJ_NONE = 0;
    public static final int TRAJ_XTC = 1;
    public static final int TRAJ_MOL = 2;
    public static final int TRAJ_SDF = 2;
    private int trajectorytype = 0;
    private String trajectoryfile = "-";
    OutputStream trajectorystream = null;
    MolExporter trajectorymolexporter;
    XtcExport trajectoryxtcexport;

    public MolecularDynamics() {
    }

    public MolecularDynamics(Molecule inputmol) throws MDException {
        this.setInputMolecule(inputmol);
    }

    public MolecularDynamics(Molecule inputmol, int steps) throws MDException {
        this.setInputMolecule(inputmol);
        this.setStepNo(steps);
    }

    public void setForceField(String ffstr) {
        if (ffstr != null) {
            if (ffstr.equalsIgnoreCase("newdreiding")) {
                this.forcefieldtype = 3;
            }
            if (ffstr.equalsIgnoreCase("dreiding")) {
                this.forcefieldtype = 1;
            }
        } else {
            this.forcefieldtype = 1;
        }
    }

    public void setIntegrator(String intstr) {
        if (intstr != null) {
            if (intstr.equalsIgnoreCase("positionverlet")) {
                this.integratortype = 2;
            }
            if (intstr.equalsIgnoreCase("leapfrog")) {
                this.integratortype = 3;
            }
            if (intstr.equalsIgnoreCase("stabilizedvelocityverlet")) {
                this.integratortype = 4;
            }
            if (intstr.equalsIgnoreCase("projectedvelocityverlet")) {
                this.integratortype = 5;
            }
        } else {
            this.integratortype = 1;
        }
    }

    public void setStepNo(int stepnumber) {
        this.stepno = stepnumber > 0 ? stepnumber : 1;
    }

    public void setTimeStep(String steptimestr) {
        this.steptime = steptimestr != null && steptimestr.length() > 0 ? Double.valueOf(steptimestr) : 0.1;
    }

    public void setTemperature(double temperatureK) {
        this.temperature = temperatureK >= 0.0 ? temperatureK : 300.0;
    }

    public void setTrajectory(String trajtype, String trajfile) {
        this.trajectoryfile = trajfile;
        if (this.trajectoryfile != null && this.trajectoryfile.length() > 0 && !this.trajectoryfile.equals("-")) {
            try {
                this.trajectorystream = new FileOutputStream(this.trajectoryfile);
            }
            catch (IOException e) {
                this.trajectoryfile = "-";
                this.trajectorystream = System.out;
            }
        } else {
            this.trajectoryfile = "-";
            this.trajectorystream = System.out;
        }
        this.trajectorytype = 0;
        if (trajtype != null && trajtype.length() > 0) {
            if (trajtype.equalsIgnoreCase("mol")) {
                this.trajectorytype = 2;
                try {
                    this.trajectorymolexporter = new MolExporter(this.trajectorystream, "mol");
                }
                catch (MolFormatException e) {
                    this.trajectorytype = 0;
                }
                catch (IllegalArgumentException e) {
                    this.trajectorytype = 0;
                }
                catch (IOException e) {
                    this.trajectorytype = 0;
                }
            }
            if (trajtype.equalsIgnoreCase("sdf")) {
                this.trajectorytype = 2;
                try {
                    this.trajectorymolexporter = new MolExporter(this.trajectorystream, "sdf");
                }
                catch (MolFormatException e) {
                    this.trajectorytype = 0;
                }
                catch (IllegalArgumentException e) {
                    this.trajectorytype = 0;
                }
                catch (IOException e) {
                    this.trajectorytype = 0;
                }
            }
        }
    }

    public void setDebugLevel(int level, String debugoutputstr) {
        Debug.debuglevel = level;
        if (Debug.debuglevel > 0) {
            if (debugoutputstr != null && debugoutputstr.length() > 0 && !debugoutputstr.equals("-")) {
                try {
                    FileOutputStream debugfile = new FileOutputStream(debugoutputstr);
                    Debug.debugstream = new PrintStream(debugfile);
                }
                catch (IOException e) {
                    Debug.debugstream = System.err;
                }
            } else {
                Debug.debugstream = System.err;
            }
            if ((Debug.debuglevel & 8) > 0) {
                Debug.debugstream.println("Calculation parameters:");
                Debug.debugstream.println("Center molecule: " + this.centerMolecule);
                Debug.debugstream.println("Forcefield code: " + this.forcefieldtype);
                Debug.debugstream.println("Integrator code: " + this.integratortype);
                Debug.debugstream.println("Steptime: " + this.steptime + " fs");
                Debug.debugstream.println("Stepno: " + this.stepno);
                Debug.debugstream.println("Debuglevel: " + Debug.debuglevel);
                Debug.debugstream.println("Debugoutput: " + debugoutputstr + "\n\n");
            }
        } else {
            Debug.debuglevel = 0;
            Debug.debugstream = System.err;
        }
    }

    public void setInputMolecule(Molecule inputmol) throws MDException {
        this.mol = inputmol;
        if (this.mol == null || this.mol.isEmpty()) {
            throw new MDException("Molecule is empty");
        }
        if ((Debug.debuglevel & 8) > 0) {
            int atoms = this.mol.getAtomCount();
            Debug.debugstream.println("Atom number: " + this.mol.getName());
            Debug.debugstream.println("No.\tRendszam\tTomeg\tX\tY\tZ\n");
            for (int i = 0; i < atoms; ++i) {
                MolAtom a = this.mol.getAtom(i);
                Debug.debugstream.println(i + "\t" + a.getAtno() + "\t" + a.getMass() + "\t" + a.getX() + "\t" + a.getY() + "\t" + a.getZ());
            }
            Debug.debugstream.println();
        }
        this.InitMD();
    }

    public void setCenterMolecule(boolean centerMolecule) {
        this.centerMolecule = centerMolecule;
    }

    public int getStepNo() {
        return this.stepno;
    }

    public double getTimeStep() {
        return this.steptime;
    }

    public double getCurrentStepNo() {
        return this.elapsedstep;
    }

    public double getElapsedTime() {
        return this.elapsedtime;
    }

    public double getLastTotalEnergy() {
        return this.lastenergy;
    }

    public double getLastPotentialEnergy() {
        return this.lastpotenergy;
    }

    public double getLastKineticEnergy() {
        return this.lastkinenergy;
    }

    public double[] getVelocities() {
        return this.integrator.getVelocities();
    }

    public void setVelocities(double[] newvelocities) throws MDException {
        this.integrator.setVelocities(newvelocities);
    }

    public void InitMD() throws MDException {
        switch (this.forcefieldtype) {
            case 3: {
                this.ff = new NewDreidingFF(this.mol);
                if ((Debug.debuglevel & 1) <= 0) break;
                Debug.debugstream.println("MMFF Force field selected");
                break;
            }
            default: {
                this.ff = new DreidingFF(this.mol);
                if ((Debug.debuglevel & 1) <= 0) break;
                Debug.debugstream.println("Dreiding Force field selected");
            }
        }
        switch (this.integratortype) {
            case 2: {
                this.integrator = new PositionVerlet(this.mol, this.ff);
                break;
            }
            case 3: {
                this.integrator = new LeapFrog(this.mol, this.ff);
                break;
            }
            case 4: {
                this.integrator = new StabilizedVelocityVerlet(this.mol, this.ff);
                break;
            }
            case 5: {
                this.integrator = new ProjectedVelocityVerlet(this.mol, this.ff);
                break;
            }
            default: {
                this.integrator = new VelocityVerlet(this.mol, this.ff);
            }
        }
        this.integrator.setStepTime(this.steptime);
        this.integrator.setTemperature(this.temperature);
        if (this.centerMolecule) {
            this.integrator.centerCoordinates();
        }
        this.elapsedstep = 0;
        this.elapsedtime = 0.0;
    }

    public Molecule RunMD() throws MDException {
        double sum;
        double kin;
        double pot;
        double[] c = new double[this.mol.getAtomCount() * 3];
        this.InitMD();
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Step time: " + this.steptime + " fs");
            Debug.debugstream.println("Step number: " + this.stepno);
        }
        for (int s = 0; s < this.stepno; ++s) {
            MDException e = (MDException)this.integrator.Update().next();
            if (e != null) {
                throw e;
            }
            ++this.elapsedstep;
            this.elapsedtime += this.steptime;
            if ((Debug.debuglevel & 4) <= 0 && this.trajectorytype != 2 && this.trajectorytype != 1) continue;
            c = this.integrator.getCoordinates();
            if ((Debug.debuglevel & 4) > 0) {
                pot = this.integrator.getPotentialEnergy();
                kin = this.integrator.getKineticEnergy();
                sum = kin + pot;
                Debug.debugstream.println("Stepno: " + this.elapsedstep);
                Debug.debugstream.println("Steptime: " + this.steptime);
                Debug.debugstream.println("Time: " + this.elapsedtime);
                Debug.debugstream.println("Pot. energy: " + pot + " kcal/mol");
                Debug.debugstream.println("Kin. energy: " + kin + " kcal/mol");
                Debug.debugstream.println("Sum. energy: " + sum + " kcal/mol");
                Debug.debugstream.println("Temperature: " + this.integrator.getTemperature() + " K");
                Debug.debugstream.println("\t\tx\ty\tz");
                for (int i = 0; i < this.mol.getAtomCount(); ++i) {
                    Debug.debugstream.println(i + ".\t" + c[i * 3] + "\t" + c[i * 3 + 1] + "\t" + c[i * 3 + 2]);
                }
                Debug.debugstream.println();
            }
            this.integrator.storeCoordinates(this.mol, c);
            this.saveTrajectory(this.mol);
        }
        pot = this.integrator.getPotentialEnergy();
        kin = this.integrator.getKineticEnergy();
        this.lastenergy = sum = kin + pot;
        this.lastkinenergy = kin;
        this.lastpotenergy = pot;
        this.integrator.storeCoordinates(this.mol, this.integrator.getCoordinates());
        this.mol.setComment("Time " + Double.toString(this.elapsedtime) + " fs");
        this.mol.setProperty("Energy", Double.toString(sum));
        return this.mol;
    }

    public Molecule NextStep() throws MDException {
        double sum;
        ++this.stepno;
        ++this.elapsedstep;
        this.elapsedtime += this.steptime;
        double[] c = new double[this.mol.getAtomCount() * 3];
        MDException e = (MDException)this.integrator.Update().next();
        if (e != null) {
            throw e;
        }
        double pot = this.integrator.getPotentialEnergy();
        double kin = this.integrator.getKineticEnergy();
        this.lastenergy = sum = kin + pot;
        this.lastkinenergy = kin;
        this.lastpotenergy = pot;
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Stepno: " + this.elapsedstep);
            Debug.debugstream.println("Steptime: " + this.steptime);
            Debug.debugstream.println("Time: " + this.elapsedtime);
            Debug.debugstream.println("Pot. energy: " + pot + " kcal/mol");
            Debug.debugstream.println("Kin. energy: " + kin + " kcal/mol");
            Debug.debugstream.println("Sum. energy: " + sum + " kcal/mol");
            Debug.debugstream.println("Temperature: " + this.integrator.getTemperature() + " K");
            c = this.integrator.getCoordinates();
            for (int i = 0; i < c.length; i += 3) {
                Debug.debugstream.println("\t\tx\ty\tz");
                Debug.debugstream.println(i + ".\t" + c[i] + "\t" + c[i + 1] + "\t" + c[i + 2]);
            }
        }
        c = this.integrator.getCoordinates();
        this.integrator.storeCoordinates(this.mol, c);
        this.saveTrajectory(this.mol);
        this.mol.setComment("MD Step " + Double.toString(this.elapsedstep));
        this.mol.setProperty("Energy", Double.toString(sum));
        return this.mol;
    }

    private void saveTrajectory(Molecule mol) {
        if (this.trajectorytype == 2 || this.trajectorytype == 2) {
            try {
                this.trajectorymolexporter.write(mol);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setActiveTermostat(boolean activeTermostat, double strength) {
        this.integrator.setActiveTermostat(activeTermostat, strength);
    }

    public void setInternalProjection(boolean internalProjection) {
        this.integrator.setInternalProjection(internalProjection);
    }

    public void setTranslationRotationProjection(boolean translationRotationProjection) {
        this.integrator.setTranslationRotationProjection(translationRotationProjection);
    }

    public void setVirtualResistance(boolean virtualResistance, double resistanceCoeff) {
        this.integrator.setVirtualResistance(virtualResistance, resistanceCoeff);
    }

    public long getProjectionTime() {
        long projectionTime = 0L;
        if (this.integrator != null) {
            projectionTime = this.integrator.getProjectionTime();
        }
        return projectionTime;
    }

    public long getBMatrixTime() {
        long bMatrixTime = 0L;
        if (this.integrator != null) {
            bMatrixTime = this.integrator.getBMatrixTime();
        }
        return bMatrixTime;
    }

    public long getMdTime() {
        long mdTime = 0L;
        if (this.integrator != null) {
            mdTime = this.integrator.getMdTime();
        }
        return mdTime;
    }

    public void setTimeStep(double stepSize) {
        this.steptime = Math.min(stepSize, 0.01);
    }
}

