/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.md;

import chemaxon.marvin.modelling.md.Debug;
import chemaxon.marvin.modelling.md.ForceField;
import chemaxon.marvin.modelling.md.MDException;
import chemaxon.marvin.modelling.mm.Dreiding;
import chemaxon.struc.Molecule;

public class NewDreidingFF
extends ForceField {
    chemaxon.marvin.modelling.mm.ForceField ff = null;
    static final double scale = 627.51;

    public NewDreidingFF(Molecule mol) throws MDException {
        if (mol == null || mol.isEmpty()) {
            throw new MDException("Molecule is empty.");
        }
        if ((Debug.debuglevel & 8) > 0) {
            Debug.debugstream.println("New Dreiding called");
        }
        if (mol.getFragCount() > 1) {
            if ((Debug.debuglevel & 8) > 0) {
                Debug.debugstream.println("FATAL: Multiple fragments!!!");
            }
            throw new MDException("Can't handle multiple fragment molecule.");
        }
        try {
            Dreiding dd = new Dreiding();
            dd.init(mol);
            this.ff = dd;
        }
        catch (Exception e) {
            throw new MDException("Dreiding initialization failed.");
        }
    }

    @Override
    protected double CalcEnergy(double[] coords) throws MDException {
        try {
            this.ff.setCrd(coords);
            double energy = this.ff.getFunctionValue();
            if ((Debug.debuglevel & 4) > 0) {
                Debug.debugstream.println("Dreiding.Energy:" + energy);
            }
            this.lastEnergy = energy;
            return energy;
        }
        catch (Exception e) {
            throw new MDException("Error in Dreiding energy calculation.");
        }
    }

    @Override
    protected double[] CalcForce(double[] coords) throws MDException {
        try {
            this.ff.setCrd(coords);
            double[] grad = this.ff.getFunctionGradient();
            this.lastEnergy = this.ff.getFunctionValue();
            if ((Debug.debuglevel & 4) > 0) {
                int j = 1;
                Debug.debugstream.println("Dreiding.Gradients:");
                for (int i = 0; i < grad.length; i += 3) {
                    Debug.debugstream.println(j + ". " + grad[i] + "\t" + grad[i + 1] + "\t" + grad[i + 2]);
                    ++j;
                }
                Debug.debugstream.println();
            }
            return grad;
        }
        catch (Exception e) {
            throw new MDException("Error in Dreiding force calculation.");
        }
    }
}

