/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.md;

import chemaxon.marvin.modelling.md.Debug;
import chemaxon.marvin.modelling.md.ForceField;
import chemaxon.marvin.modelling.md.Integrator;
import chemaxon.marvin.modelling.md.MDException;
import chemaxon.marvin.modelling.md.MDTools;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.Iterator;

public class StabilizedVelocityVerlet
extends MDTools
implements Integrator {
    double[] a;
    double[] grad;
    double potenergy = 0.0;
    double dt = 1.0;
    ForceField ff = null;

    public StabilizedVelocityVerlet(Molecule mol, ForceField forcefield) throws MDException {
        super(mol);
        if (forcefield == null) {
            throw new MDException("Force field must be initialized before intergrator called.");
        }
        this.a = new double[this.atomcount * 3];
        this.grad = new double[this.atomcount * 3];
        this.ff = forcefield;
        for (int i = 0; i < this.atomcount * 3; ++i) {
            this.grad[i] = 0.0;
            this.a[i] = 0.0;
        }
    }

    @Override
    public void setStepTime(double femtosectimestep) {
        this.dt = femtosectimestep;
    }

    @Override
    public double getPotentialEnergy() {
        return this.potenergy;
    }

    @Override
    public Iterator Update() {
        return new UpdateData();
    }

    class UpdateData
    implements Iterator {
        UpdateData() {
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        public Object next() {
            int i;
            double scale;
            int i2;
            double tLimit = StabilizedVelocityVerlet.this.tt.getTargetTemperature();
            double tMaxLimit = 100.0 * StabilizedVelocityVerlet.this.tt.getTargetTemperature();
            if ((Debug.debuglevel & 1) > 0) {
                Debug.debugstream.println("NEXT MD step...");
                Debug.debugstream.println("Next atomcount:" + StabilizedVelocityVerlet.this.atomcount);
                Debug.debugstream.println("Next length:" + StabilizedVelocityVerlet.this.coords.length);
                Debug.debugstream.println("Step time: " + StabilizedVelocityVerlet.this.dt + " fs");
                Debug.debugstream.println();
                Debug.debugstream.println("Coordinates (x y z) Angstrom");
                for (i2 = 0; i2 < StabilizedVelocityVerlet.this.atomcount; ++i2) {
                    MolAtom matom = StabilizedVelocityVerlet.this.mdmol.getAtom(i2);
                    double matommass = matom.getMass();
                    Debug.debugstream.println(i2 + ".\t" + matommass + "\t" + StabilizedVelocityVerlet.this.coords[i2 * 3] + "\t" + StabilizedVelocityVerlet.this.coords[i2 * 3 + 1] + "\t" + StabilizedVelocityVerlet.this.coords[i2 * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Velocities (x y z) Angstrom/femtosecond");
                for (i2 = 0; i2 < StabilizedVelocityVerlet.this.atomcount; ++i2) {
                    Debug.debugstream.println(i2 + ".\t" + StabilizedVelocityVerlet.this.velocities[i2 * 3] + "\t" + StabilizedVelocityVerlet.this.velocities[i2 * 3 + 1] + "\t" + StabilizedVelocityVerlet.this.velocities[i2 * 3 + 2]);
                }
                Debug.debugstream.println();
            }
            for (i2 = 0; i2 < StabilizedVelocityVerlet.this.atomcount * 3; ++i2) {
                StabilizedVelocityVerlet.this.velocities[i2] = StabilizedVelocityVerlet.this.velocities[i2] + StabilizedVelocityVerlet.this.a[i2] * StabilizedVelocityVerlet.this.dt / 2.0;
                StabilizedVelocityVerlet.this.coords[i2] = StabilizedVelocityVerlet.this.coords[i2] + StabilizedVelocityVerlet.this.velocities[i2] * StabilizedVelocityVerlet.this.dt;
            }
            try {
                StabilizedVelocityVerlet.this.grad = StabilizedVelocityVerlet.this.ff.Force(StabilizedVelocityVerlet.this.coords);
                StabilizedVelocityVerlet.this.potenergy = StabilizedVelocityVerlet.this.ff.Energy(StabilizedVelocityVerlet.this.coords);
            }
            catch (MDException e) {
                return e;
            }
            double maxMV2 = 0.0;
            for (int i3 = 0; i3 < StabilizedVelocityVerlet.this.atomcount; ++i3) {
                MolAtom matom = StabilizedVelocityVerlet.this.mdmol.getAtom(i3);
                double matommass = matom.getMass();
                double atMV2 = 0.0;
                for (int j = 0; j < 3; ++j) {
                    int idx = i3 * 3 + j;
                    StabilizedVelocityVerlet.this.a[idx] = -4.1868E-4 * StabilizedVelocityVerlet.this.grad[idx] / matommass;
                    StabilizedVelocityVerlet.this.velocities[idx] = StabilizedVelocityVerlet.this.velocities[idx] + StabilizedVelocityVerlet.this.a[idx] * StabilizedVelocityVerlet.this.dt / 2.0;
                    atMV2 += StabilizedVelocityVerlet.this.velocities[idx] * StabilizedVelocityVerlet.this.velocities[idx];
                }
                if (!((atMV2 *= matommass) > maxMV2)) continue;
                maxMV2 = atMV2;
            }
            double maxtemp = maxMV2 * 4186.8 / 6.02214199E23 / 1.3806505E-23 / 3.0 / 4.1868E-4;
            double temp = StabilizedVelocityVerlet.this.tt.getTemperature();
            if (maxtemp > tMaxLimit) {
                scale = Math.sqrt(tMaxLimit / maxtemp);
                if ((Debug.debuglevel & 4) > 0) {
                    Debug.debugstream.println("Max temperature getting too high: " + maxtemp + "(" + StabilizedVelocityVerlet.this.tt.getTemperature() + ")");
                    Debug.debugstream.println("Scaling velocities by: " + scale);
                }
                i = 0;
                while (i < StabilizedVelocityVerlet.this.atomcount * 3) {
                    int n = i;
                    StabilizedVelocityVerlet.this.velocities[n] = StabilizedVelocityVerlet.this.velocities[n] * scale;
                    int n2 = i++;
                    StabilizedVelocityVerlet.this.a[n2] = StabilizedVelocityVerlet.this.a[n2] * scale;
                }
                if ((Debug.debuglevel & 4) > 0) {
                    Debug.debugstream.println("New temperature is: " + StabilizedVelocityVerlet.this.getTemperature());
                }
                temp = StabilizedVelocityVerlet.this.tt.getTemperature();
            }
            if (temp > tLimit) {
                scale = Math.sqrt(tLimit / temp);
                if ((Debug.debuglevel & 4) > 0) {
                    Debug.debugstream.println("Temperature getting too high: " + temp + "(" + StabilizedVelocityVerlet.this.tt.getTemperature() + ")");
                    Debug.debugstream.println("Scaling velocities by: " + scale);
                }
                i = 0;
                while (i < StabilizedVelocityVerlet.this.atomcount * 3) {
                    int n = i;
                    StabilizedVelocityVerlet.this.velocities[n] = StabilizedVelocityVerlet.this.velocities[n] * scale;
                    int n3 = i++;
                    StabilizedVelocityVerlet.this.a[n3] = StabilizedVelocityVerlet.this.a[n3] * scale;
                }
                if ((Debug.debuglevel & 4) > 0) {
                    Debug.debugstream.println("New temperature is: " + StabilizedVelocityVerlet.this.getTemperature());
                }
            }
            if ((Debug.debuglevel & 2) > 0) {
                int i4;
                Debug.debugstream.println("After MD step...");
                Debug.debugstream.println("Accelerations (x y z) Angstrom/femtosecond^2");
                for (i4 = 0; i4 < StabilizedVelocityVerlet.this.atomcount; ++i4) {
                    Debug.debugstream.println(i4 + ".\t" + StabilizedVelocityVerlet.this.a[i4 * 3] + "\t" + StabilizedVelocityVerlet.this.a[i4 * 3 + 1] + "\t" + StabilizedVelocityVerlet.this.a[i4 * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Coordinates (x y z) Angstrom");
                for (i4 = 0; i4 < StabilizedVelocityVerlet.this.atomcount; ++i4) {
                    Debug.debugstream.println(i4 + ".\t" + StabilizedVelocityVerlet.this.coords[i4 * 3] + "\t" + StabilizedVelocityVerlet.this.coords[i4 * 3 + 1] + "\t" + StabilizedVelocityVerlet.this.coords[i4 * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Velocities (x y z) Angstrom/femtosecond");
                for (i4 = 0; i4 < StabilizedVelocityVerlet.this.atomcount; ++i4) {
                    Debug.debugstream.println(i4 + ".\t" + StabilizedVelocityVerlet.this.velocities[i4 * 3] + "\t" + StabilizedVelocityVerlet.this.velocities[i4 * 3 + 1] + "\t" + StabilizedVelocityVerlet.this.velocities[i4 * 3 + 2]);
                }
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

