/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.md;

import chemaxon.marvin.modelling.md.XtcTools;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class XtcImport
extends XtcTools {
    protected FileInputStream istream;
    protected DataInputStream distream;
    protected boolean DirectFileRead;
    protected boolean valid;
    long natoms;
    long step;
    double time;
    double[] x;
    double[] y;
    double[] z;
    long size;
    double[] atomcoords;
    int csize;
    long[] minint;
    long[] maxint;
    int frame;
    int[] ibuffer;
    byte[] cbuffer;
    int[] cbuf;
    double A;
    double B;
    double C;
    double alpha;
    double beta;
    double gamma;
    double precision;

    public XtcImport(int[] inputarray) {
        this.size = 0L;
        this.frame = 0;
        this.istream = null;
        this.distream = null;
        this.DirectFileRead = false;
        if (inputarray.length <= 13) {
            this.valid = false;
        } else {
            int i;
            this.ibuffer = new int[inputarray.length];
            for (i = 0; i <= 13; ++i) {
                this.ibuffer[i] = inputarray[i];
            }
            if (this.XtcCheckHeader()) {
                for (i = 13; i < inputarray.length; ++i) {
                    this.ibuffer[i] = inputarray[i];
                }
                this.valid = true;
            } else {
                this.valid = false;
            }
        }
    }

    public XtcImport(FileInputStream is) throws IOException {
        this.XtcImportFile(is, false);
    }

    public XtcImport(FileInputStream is, boolean DirectMode) throws IOException {
        this.XtcImportFile(is, DirectMode);
    }

    public int XtcGetAtomNum() {
        return (int)this.natoms;
    }

    public int XtcGetStep() {
        return (int)this.step;
    }

    public float XtcGetTime() {
        return (float)this.time;
    }

    public boolean XtcNextStep() throws IOException {
        if (this.DirectFileRead) {
            this.ibuffer = new int[24];
            for (int i = 0; i <= 13; ++i) {
                this.ibuffer[i] = this.distream.readInt();
            }
        }
        if (this.XtcCheckHeader()) {
            this.atomcoords = new double[(int)(this.natoms * 3L)];
            boolean ret = this.XtcRead3DCoords(this.atomcoords);
            if (!this.DirectFileRead) {
                this.frame = this.size <= 9L ? this.frame + 14 + (int)this.size : this.frame + 23 + this.csize / 4;
            }
            return ret;
        }
        return false;
    }

    public boolean XtcGetCoordinates(double[] coords) throws IOException {
        if (this.valid && (long)coords.length >= this.natoms * 3L) {
            int idx = 0;
            int i = 0;
            while ((long)i < this.natoms) {
                for (int j = 0; j < 3; ++j) {
                    coords[idx] = this.atomcoords[idx];
                    ++idx;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void XtcImportFile(FileInputStream is, boolean DirectMode) throws IOException {
        this.size = 0L;
        this.frame = 0;
        this.istream = is;
        this.distream = new DataInputStream(this.istream);
        this.DirectFileRead = DirectMode;
        if (!this.DirectFileRead) {
            this.ibuffer = new int[14];
            int[] saveheader = new int[14];
            for (int i = 0; i <= 13; ++i) {
                this.ibuffer[i] = this.distream.readInt();
                saveheader[i] = this.ibuffer[i];
            }
            if (this.XtcCheckHeader()) {
                int i;
                this.cbuffer = new byte[this.istream.available()];
                long cread = this.istream.read(this.cbuffer);
                int iread = (int)(cread / 4L);
                if (cread % 4L != 0L) {
                    ++iread;
                }
                this.ibuffer = new int[iread + 13 + 1];
                for (i = 0; i <= 13; ++i) {
                    this.ibuffer[i] = saveheader[i];
                }
                for (i = 0; i < this.cbuffer.length; i += 4) {
                    long tmp = this.cbuffer[i] >= 0 ? (long)this.cbuffer[i] : (long)(this.cbuffer[i] + 256);
                    tmp = tmp * 256L + (long)(this.cbuffer[i + 1] >= 0 ? this.cbuffer[i + 1] : this.cbuffer[i + 1] + 256);
                    tmp = tmp * 256L + (long)(this.cbuffer[i + 2] >= 0 ? this.cbuffer[i + 2] : this.cbuffer[i + 2] + 256);
                    tmp = tmp * 256L + (long)(this.cbuffer[i + 3] >= 0 ? this.cbuffer[i + 3] : this.cbuffer[i + 3] + 256);
                    this.ibuffer[i / 4 + 13 + 1] = (int)tmp;
                }
                this.valid = true;
            } else {
                this.valid = false;
            }
        }
    }

    private long XtcInt2Long(int i) {
        long tmp = i;
        if (tmp < 0L) {
            tmp += 0x100000000L;
        }
        return tmp;
    }

    private float XtcInt2Float(int i) {
        float tmp = Float.intBitsToFloat(i);
        return tmp;
    }

    private long XtcReadCompressed(long[] buf, long len) {
        int maxidx = (int)(len / 4L);
        if (len % 4L != 0L) {
            ++maxidx;
        }
        for (int i = 0; i < maxidx; ++i) {
            if (this.frame + 23 + i > this.ibuffer.length) {
                return (i - 1) * 4;
            }
            long nxt = this.ibuffer[this.frame + 23 + i];
            if (nxt < 0L) {
                nxt += 0x100000000L;
            }
            long mask = 0xFF000000L;
            this.cbuf[i * 4] = (int)(nxt & mask) >> 24;
            if (this.cbuf[i * 4] < 0) {
                int n = i * 4;
                this.cbuf[n] = this.cbuf[n] + 256;
            }
            this.cbuf[i * 4 + 1] = (int)(nxt & (mask >>= 8)) >> 16;
            this.cbuf[i * 4 + 2] = (int)(nxt & (mask >>= 8)) >> 8;
            this.cbuf[i * 4 + 3] = (int)(nxt & (mask >>= 8));
            buf[i + 3] = nxt;
        }
        return maxidx * 4;
    }

    private boolean XtcCheckHeader() {
        block10: {
            block9: {
                double d;
                double d2;
                if (this.ibuffer[this.frame + 0] != 1995) {
                    this.valid = false;
                    return false;
                }
                if (this.frame + 13 > this.ibuffer.length) {
                    this.valid = false;
                    return false;
                }
                this.natoms = this.XtcInt2Long(this.ibuffer[this.frame + 1]);
                if (this.natoms < 0L) {
                    this.valid = false;
                    return false;
                }
                this.step = this.XtcInt2Long(this.ibuffer[this.frame + 2]);
                if (this.step < 0L) {
                    this.valid = false;
                    return false;
                }
                this.time = this.XtcInt2Long(this.ibuffer[this.frame + 3]);
                if (d2 < 0.0) {
                    this.valid = false;
                    return false;
                }
                this.x = new double[3];
                this.y = new double[3];
                this.z = new double[3];
                this.x[0] = this.XtcInt2Float(this.ibuffer[this.frame + 4]);
                if (this.x[0] < 0.0 || (this.x[1] = (double)this.XtcInt2Float(this.ibuffer[this.frame + 5])) < 0.0 || (this.x[2] = (double)this.XtcInt2Float(this.ibuffer[this.frame + 6])) < 0.0 || (this.y[0] = (double)this.XtcInt2Float(this.ibuffer[this.frame + 4])) < 0.0 || (this.y[1] = (double)this.XtcInt2Float(this.ibuffer[this.frame + 8])) < 0.0 || (this.y[2] = (double)this.XtcInt2Float(this.ibuffer[this.frame + 9])) < 0.0 || (this.z[0] = (double)this.XtcInt2Float(this.ibuffer[this.frame + 10])) < 0.0 || (this.z[1] = (double)this.XtcInt2Float(this.ibuffer[this.frame + 11])) < 0.0) break block9;
                this.z[2] = this.XtcInt2Float(this.ibuffer[this.frame + 12]);
                if (!(d < 0.0)) break block10;
            }
            this.valid = false;
            return false;
        }
        long lsize = this.XtcInt2Long(this.ibuffer[this.frame + 13]);
        if (this.size != 0L && this.size != lsize) {
            this.valid = false;
            return false;
        }
        this.size = lsize;
        this.valid = true;
        return true;
    }

    private int xtc_receivebits(long[] buf, int nbits) {
        long mask = (1 << nbits) - 1;
        int cnt = (int)buf[0];
        long lastbits = buf[1];
        long lastbyte = buf[2];
        int num = 0;
        while (nbits >= 8) {
            if (cnt >= this.cbuf.length) {
                this.valid = false;
                return 0;
            }
            lastbyte = lastbyte << 8 | (long)this.cbuf[cnt++];
            num = (int)((long)num | lastbyte >> (int)lastbits << nbits - 8);
            nbits -= 8;
        }
        if (nbits > 0) {
            if (lastbits < (long)nbits) {
                lastbits += 8L;
                if (cnt >= this.cbuf.length) {
                    this.valid = false;
                    return 0;
                }
                lastbyte = lastbyte << 8 | (long)this.cbuf[cnt++];
            }
            num = (int)((long)num | lastbyte >> (int)(lastbits -= (long)nbits) & (long)((1 << nbits) - 1));
        }
        num = (int)((long)num & mask);
        buf[0] = cnt;
        buf[1] = lastbits;
        buf[2] = lastbyte;
        return num;
    }

    private void xtc_receiveints(long[] buf, int nints, int nbits, long[] sizes, long[] nums) {
        long[] bytes = new long[32];
        bytes[3] = 0L;
        bytes[2] = 0L;
        bytes[1] = 0L;
        int nbytes = 0;
        while (nbits > 8) {
            bytes[nbytes++] = this.xtc_receivebits(buf, 8);
            nbits -= 8;
        }
        if (nbits > 0) {
            bytes[nbytes++] = this.xtc_receivebits(buf, nbits);
        }
        for (int i = nints - 1; i > 0; --i) {
            long num = 0L;
            for (int j = nbytes - 1; j >= 0; --j) {
                long p;
                num = num << 8 | bytes[j];
                bytes[j] = p = num / sizes[i];
                num -= p * sizes[i];
            }
            nums[i] = num;
        }
        nums[0] = bytes[0] | bytes[1] << 8 | bytes[2] << 16 | bytes[3] << 24;
    }

    private boolean XtcRead3DCoords(double[] fp) throws IOException {
        int bitsize;
        int i;
        long[] sizeint = new long[3];
        long[] sizesmall = new long[3];
        long[] thiscoordarray = new long[3];
        int[] bitsizeint = new int[3];
        long[] prevcoord = new long[3];
        if (this.size <= 9L) {
            int idx = 14;
            this.csize = (int)this.size * 3 * 4;
            int i2 = 0;
            while ((long)i2 < this.size) {
                if (this.DirectFileRead) {
                    fp[3 * i2] = this.distream.readFloat();
                    fp[3 * i2 + 1] = this.distream.readFloat();
                    fp[3 * i2 + 2] = this.distream.readFloat();
                } else {
                    if ((long)this.frame + this.size * 3L * 4L > (long)this.ibuffer.length) {
                        this.valid = false;
                        return false;
                    }
                    fp[3 * i2] = Float.intBitsToFloat(this.ibuffer[this.frame + idx + i2]);
                    fp[3 * i2 + 1] = Float.intBitsToFloat(this.ibuffer[this.frame + idx + i2 + 1]);
                    fp[3 * i2 + 1] = Float.intBitsToFloat(this.ibuffer[this.frame + idx + i2 + 2]);
                }
                ++i2;
            }
            return true;
        }
        if (this.DirectFileRead) {
            for (i = 14; i < 23; ++i) {
                this.ibuffer[i] = this.distream.readInt();
            }
        }
        if (this.frame + 23 > this.ibuffer.length) {
            this.valid = false;
            return false;
        }
        this.precision = Float.intBitsToFloat(this.ibuffer[this.frame + 14]);
        double inv_precision = 1.0 / this.precision;
        this.minint = new long[3];
        this.maxint = new long[3];
        this.minint[0] = this.ibuffer[this.frame + 15];
        this.minint[1] = this.ibuffer[this.frame + 16];
        this.minint[2] = this.ibuffer[this.frame + 17];
        this.maxint[0] = this.ibuffer[this.frame + 18];
        this.maxint[1] = this.ibuffer[this.frame + 19];
        this.maxint[2] = this.ibuffer[this.frame + 20];
        sizeint[0] = this.maxint[0] - this.minint[0] + 1L;
        sizeint[1] = this.maxint[1] - this.minint[1] + 1L;
        sizeint[2] = this.maxint[2] - this.minint[2] + 1L;
        if ((sizeint[0] | sizeint[1] | sizeint[2]) > 0xFFFFFFL) {
            bitsizeint[0] = this.xtc_sizeofint(sizeint[0]);
            bitsizeint[1] = this.xtc_sizeofint(sizeint[1]);
            bitsizeint[2] = this.xtc_sizeofint(sizeint[2]);
            bitsize = 0;
        } else {
            bitsize = this.xtc_sizeofints(3, sizeint);
        }
        int smallidx = this.ibuffer[this.frame + 21];
        int smaller = xtc_magicints[9 > smallidx - 1 ? 9 : smallidx - 1] / 2;
        int small = xtc_magicints[smallidx] / 2;
        sizesmall[1] = sizesmall[2] = (long)xtc_magicints[smallidx];
        sizesmall[0] = sizesmall[2];
        long[] ip = new long[(int)((double)(this.size * 3L) * 1.3)];
        long[] buf = new long[(int)((double)(this.size * 3L) * 1.3)];
        buf[2] = 0L;
        buf[1] = 0L;
        buf[0] = 0L;
        this.csize = this.ibuffer[this.frame + 22];
        buf[0] = this.csize;
        if (this.csize % 4 != 0) {
            this.csize += 4 - this.csize % 4;
        }
        this.cbuf = new int[(int)(buf[0] * 4L) + 8];
        if (this.DirectFileRead) {
            this.ibuffer = new int[23 + this.csize / 4 + 1];
            for (i = 23; i < 23 + this.csize / 4; ++i) {
                this.ibuffer[i] = this.distream.readInt();
            }
        }
        if (this.XtcReadCompressed(buf, buf[0]) < (long)this.csize) {
            this.valid = false;
            return false;
        }
        buf[2] = 0L;
        buf[1] = 0L;
        buf[0] = 0L;
        int lfp = 0;
        int run = 0;
        i = 0;
        while ((long)i < this.size) {
            int thiscoord = i * 3;
            if (bitsize == 0) {
                ip[thiscoord] = this.xtc_receivebits(buf, bitsizeint[0]);
                ip[thiscoord + 1] = this.xtc_receivebits(buf, bitsizeint[1]);
                ip[thiscoord + 2] = this.xtc_receivebits(buf, bitsizeint[2]);
            } else {
                this.xtc_receiveints(buf, 3, bitsize, sizeint, thiscoordarray);
                ip[thiscoord] = thiscoordarray[0];
                ip[thiscoord + 1] = thiscoordarray[1];
                ip[thiscoord + 2] = thiscoordarray[2];
            }
            ++i;
            int n = thiscoord;
            ip[n] = ip[n] + this.minint[0];
            int n2 = thiscoord + 1;
            ip[n2] = ip[n2] + this.minint[1];
            int n3 = thiscoord + 2;
            ip[n3] = ip[n3] + this.minint[2];
            prevcoord[0] = ip[thiscoord];
            prevcoord[1] = ip[thiscoord + 1];
            prevcoord[2] = ip[thiscoord + 2];
            int flag = this.xtc_receivebits(buf, 1);
            int is_smaller = 0;
            if (flag == 1) {
                run = this.xtc_receivebits(buf, 5);
                is_smaller = run % 3;
                run -= is_smaller;
                --is_smaller;
            }
            if (run > 0) {
                thiscoord += 3;
                for (int k = 0; k < run; k += 3) {
                    this.xtc_receiveints(buf, 3, smallidx, sizesmall, thiscoordarray);
                    ip[thiscoord] = thiscoordarray[0];
                    ip[thiscoord + 1] = thiscoordarray[1];
                    ip[thiscoord + 2] = thiscoordarray[2];
                    ++i;
                    int n4 = thiscoord;
                    ip[n4] = ip[n4] + (prevcoord[0] - (long)small);
                    int n5 = thiscoord + 1;
                    ip[n5] = ip[n5] + (prevcoord[1] - (long)small);
                    int n6 = thiscoord + 2;
                    ip[n6] = ip[n6] + (prevcoord[2] - (long)small);
                    if (k == 0) {
                        long tmp = ip[thiscoord];
                        ip[thiscoord] = prevcoord[0];
                        prevcoord[0] = tmp;
                        tmp = ip[thiscoord + 1];
                        ip[thiscoord + 1] = prevcoord[1];
                        prevcoord[1] = tmp;
                        tmp = ip[thiscoord + 2];
                        ip[thiscoord + 2] = prevcoord[2];
                        prevcoord[2] = tmp;
                        fp[lfp++] = (double)prevcoord[0] * inv_precision;
                        fp[lfp++] = (double)prevcoord[1] * inv_precision;
                        fp[lfp++] = (double)prevcoord[2] * inv_precision;
                    } else {
                        prevcoord[0] = ip[thiscoord];
                        prevcoord[1] = ip[thiscoord + 1];
                        prevcoord[2] = ip[thiscoord + 2];
                    }
                    fp[lfp++] = (double)ip[thiscoord] * inv_precision;
                    fp[lfp++] = (double)ip[thiscoord + 1] * inv_precision;
                    fp[lfp++] = (double)ip[thiscoord + 2] * inv_precision;
                }
            } else {
                fp[lfp++] = (double)ip[thiscoord] * inv_precision;
                fp[lfp++] = (double)ip[thiscoord + 1] * inv_precision;
                fp[lfp++] = (double)ip[thiscoord + 2] * inv_precision;
            }
            smallidx += is_smaller;
            if (is_smaller < 0) {
                small = smaller;
                smaller = smallidx > 9 ? xtc_magicints[smallidx - 1] / 2 : 0;
            } else if (is_smaller > 0) {
                smaller = small;
                small = xtc_magicints[smallidx] / 2;
            }
            sizesmall[1] = sizesmall[2] = (long)xtc_magicints[smallidx];
            sizesmall[0] = sizesmall[2];
        }
        return true;
    }
}

