/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm;

import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.mm.CXNForceField;
import chemaxon.marvin.modelling.mm.MMDiagnosticObserver;
import chemaxon.marvin.modelling.mm.ProxScaledVdw;
import chemaxon.marvin.modelling.struc.MolGeom;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.util.ShortestPath;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Dreiding
extends CXNForceField {
    protected static final boolean COMPARE_WITH_OLD = true;
    public static final int H_ = 0;
    public static final int H_HB = 1;
    public static final int H__b = 2;
    public static final int B_3 = 3;
    public static final int B_2 = 4;
    public static final int C_3 = 5;
    public static final int C_R = 6;
    public static final int C_2 = 7;
    public static final int C_1 = 8;
    public static final int N_3 = 9;
    public static final int N_R = 10;
    public static final int N_2 = 11;
    public static final int N_1 = 12;
    public static final int O_3 = 13;
    public static final int O_R = 14;
    public static final int O_2 = 15;
    public static final int O_1 = 16;
    public static final int F_ = 17;
    public static final int Al3 = 18;
    public static final int Si3 = 19;
    public static final int P_3 = 20;
    public static final int S_3 = 21;
    public static final int Cl_ = 22;
    public static final int Ga3 = 23;
    public static final int Ge3 = 24;
    public static final int As3 = 25;
    public static final int Se3 = 26;
    public static final int Br_ = 27;
    public static final int In3 = 28;
    public static final int Sn3 = 29;
    public static final int Sb3 = 30;
    public static final int Te3 = 31;
    public static final int I_ = 32;
    public static final int Na_ = 33;
    public static final int Ca_ = 34;
    public static final int Fe_ = 35;
    public static final int Zn_ = 36;
    public static final int C_R1 = 37;
    public static final int C_34 = 38;
    public static final int C_33 = 39;
    public static final int C_32 = 40;
    public static final int C_31 = 41;
    public static final int Li_ = 42;
    public static final int S_non = 43;
    public static final int Al_non = 44;
    public static final int Si_non = 45;
    public static final int Ga_non = 46;
    public static final int Ge_non = 47;
    public static final int As_non = 48;
    public static final int Se_non = 49;
    public static final int In_non = 50;
    public static final int Sn_non = 51;
    public static final int Sb_non = 52;
    public static final int Te_non = 53;
    public static final int Fe_non = 54;
    public static final int Zn_non = 55;
    public static final int P_non = 56;
    public static final int C_2CP = 57;
    public static final int LP = 58;
    public static final int O_ester = 59;
    public static final int C_carbonyl = 60;
    public static final int DEFAULT = 61;
    private static final double tors33V = 2.0;
    private static final int tors33N = 3;
    private static final double tors33Psi = 180.0;
    private static final double tors33Psi_rad = Math.PI;
    private static final double tors23V = 1.0;
    private static final int tors23N = 6;
    private static final double tors23Psi = 0.0;
    private static final double tors23Psi_rad = 0.0;
    private static final double tors22V = 45.0;
    private static final int tors22N = 2;
    private static final double tors22Psi = 180.0;
    private static final double tors22Psi_rad = Math.PI;
    private static final double tors22resV = 25.0;
    private static final int tors22resN = 2;
    private static final double tors22resPsi = 180.0;
    private static final double tors22resPsi_rad = Math.PI;
    private static final double tors22sinV = 5.0;
    private static final int tors22sinN = 2;
    private static final double tors22sinPsi = 180.0;
    private static final double tors22sinPsi_rad = Math.PI;
    private static final double tors22sinArV = 10.0;
    private static final int tors22sinArN = 2;
    private static final double tors22sinArPsi = 180.0;
    private static final double tors22sinArPsi_rad = Math.PI;
    private static final double tors11V = 0.0;
    private static final int tors11N = 0;
    private static final double tors11Psi = 0.0;
    private static final double tors11Psi_rad = 0.0;
    private static final double tors3O3OV = 2.0;
    private static final int tors3O3ON = 2;
    private static final double tors3O3OPsi = 90.0;
    private static final double tors3O3OPsi_rad = 1.5707963267948966;
    private static final double tors3O2V = 2.0;
    private static final int tors3O2N = 2;
    private static final double tors3O2Psi = 180.0;
    private static final double tors3O2Psi_rad = Math.PI;
    private static final double tors332V = 1.0;
    private static final int tors332N = 3;
    private static final double tors332Psi = 180.0;
    private static final double tors332Psi_rad = Math.PI;
    private static final double defaultscale = 0.3;
    private static final double defaultAngleScale = 0.1;
    private static final double bond_delta = 0.01;
    private static final double bond_K = 700.0;
    private static final double bond_D = 70.0;
    private static final double angle_K = 100.0;
    private static final double invK = 40.0;
    private static final double invPsi0 = 0.0;
    private static final double invC = 59.9935;
    private static final double invCPsi0 = 54.74;
    private static final double invCcosPsi0 = 0.5772877;
    private static final double hydDhb = 9.5;
    private static final double hydRhb = 2.75;
    private static final double torsHPsi_rad = 1.5707963267948966;
    private static final double torsHV = 9.0;
    private static final int torsHN = 2;
    private double torsH_hydrogenScale = 1.0;
    private static final double angleHscale = 0.9;
    private double VDW_RADIUS_SCALE = 1.0;
    private double VDW_WELLDEPTH_SCALE = 1.0;
    private int vdwType = 2;
    private boolean useCorrectedInversionForm = true;
    private double angleScaleUpperInterval = 2.6179938779914944;
    private double angleScaleLowerInterval = 0.5235987755982988;
    private int angleTreatment = 4;
    public static final int ANGLECOS = 1;
    public static final int ANGLEQUADRATIC = 2;
    public static final int ANGLEMODQUADRATIC = 4;
    public static final int ANGLEFORCEDCOSONLINEAR = 8;
    private static final double RANGE_FOR_VDW_CUTOFF = 0.5;
    public static final int VDW_LENNARD = 1;
    public static final int VDW_LENNARD_CAPPED = 2;
    public static final int VDW_EXP = 3;
    private static final DreidingAtomType[] types = new DreidingAtomType[]{new DreidingAtomType(0, "H_", 1, 1, 0.33, -1.0, 3.14159265, 180.0, 3.195, 12.382, 0.0152, 1.0), new DreidingAtomType(1, "H_HB", 1, 1, 0.33, -1.0, 3.14159265, 180.0, 3.195, 12.0, 1.0E-4, 1.0), new DreidingAtomType(2, "H__b", 1, 1, 0.51, 0.0, 1.57079633, 90.0, 3.195, 12.382, 0.0152, 1.0), new DreidingAtomType(3, "B_3", 3, 5, 0.88, -0.333329702763402, 1.91062939, 109.471, 4.02, 14.23, 0.095, 1.0), new DreidingAtomType(4, "B_2", 2, 5, 0.79, -0.5, 2.0943951, 120.0, 4.02, 14.23, 0.095, 1.0), new DreidingAtomType(5, "C_3", 3, 6, 0.77, -0.333329702763402, 1.91062939, 109.471, 3.8983, 14.034, 0.0951, 1.0), new DreidingAtomType(6, "C_R", 4, 6, 0.7, -0.5, 2.0943951, 120.0, 3.8983, 14.034, 0.0951, 1.0), new DreidingAtomType(7, "C_2", 2, 6, 0.67, -0.5, 2.0943951, 120.0, 3.8983, 14.034, 0.0951, 1.0), new DreidingAtomType(8, "C_1", 1, 6, 0.602, -1.0, 3.14159265, 180.0, 3.8983, 14.034, 0.0951, 1.0), new DreidingAtomType(9, "N_3", 3, 7, 0.702, -0.287360519849712, 1.86226631, 106.7, 3.6621, 13.843, 0.0774, 1.0), new DreidingAtomType(10, "N_R", 4, 7, 0.65, -0.5, 2.0943951, 120.0, 3.6621, 13.843, 0.0774, 1.0), new DreidingAtomType(11, "N_2", 2, 7, 0.615, -0.5, 2.0943951, 120.0, 3.6621, 13.843, 0.0774, 1.0), new DreidingAtomType(12, "N_1", 1, 7, 0.556, -1.0, 3.14159265, 180.0, 3.6621, 13.843, 0.0774, 1.0), new DreidingAtomType(13, "O_3", 3, 8, 0.66, -0.250548973879778, 1.8240436, 104.51, 3.4046, 13.483, 0.0957, 1.0), new DreidingAtomType(14, "O_R", 4, 8, 0.66, -0.5, 2.0943951, 120.0, 3.4046, 13.483, 0.0957, 1.0), new DreidingAtomType(15, "O_2", 2, 8, 0.56, -0.5, 2.0943951, 120.0, 3.4046, 13.483, 0.0957, 1.0), new DreidingAtomType(16, "O_1", 1, 8, 0.528, -1.0, 3.14159265, 180.0, 3.4046, 13.483, 0.0957, 1.0), new DreidingAtomType(17, "F_", 1, 9, 0.611, -1.0, 3.14159265, 180.0, 3.472, 14.444, 0.0725, 1.0), new DreidingAtomType(18, "Al3", 3, 13, 1.047, -0.333329702763402, 1.91062939, 109.471, 4.39, 12.0, 0.31, 1.0), new DreidingAtomType(19, "Si3", 3, 14, 0.937, -0.333329702763402, 1.91062939, 109.471, 4.27, 12.0, 0.31, 1.0), new DreidingAtomType(20, "P_3", 3, 15, 0.89, -0.0575640269595672, 1.62839219, 93.3, 4.15, 12.0, 0.32, 1.0), new DreidingAtomType(21, "S_3", 3, 16, 1.04, -0.0366437087065559, 1.60744824, 92.1, 4.03, 12.0, 0.344, 1.0), new DreidingAtomType(22, "Cl_", 1, 17, 0.997, -1.0, 3.14159265, 180.0, 3.9503, 13.861, 0.2833, 1.0), new DreidingAtomType(23, "Ga3", 3, 31, 1.21, -0.333329702763402, 1.91062939, 109.471, 4.39, 12.0, 0.4, 1.0), new DreidingAtomType(24, "Ge3", 3, 32, 1.21, -0.333329702763402, 1.91062939, 109.471, 4.27, 12.0, 0.4, 1.0), new DreidingAtomType(25, "As3", 3, 33, 1.21, -0.0366437087065559, 1.60744824, 92.1, 4.15, 12.0, 0.41, 1.0), new DreidingAtomType(26, "Se3", 3, 34, 1.21, -0.0104717841162455, 1.5812683, 90.6, 4.03, 12.0, 0.43, 1.0), new DreidingAtomType(27, "Br_", 1, 35, 1.167, -1.0, 3.14159265, 180.0, 3.95, 12.0, 0.37, 1.0), new DreidingAtomType(28, "In3", 3, 49, 1.39, -0.333329702763402, 1.91062939, 109.471, 4.59, 12.0, 0.55, 1.0), new DreidingAtomType(29, "Sn3", 3, 50, 1.373, -0.333329702763402, 1.91062939, 109.471, 4.47, 12.0, 0.55, 1.0), new DreidingAtomType(30, "Sb3", 3, 51, 1.432, -0.0279216387235686, 1.59872159, 91.6, 4.35, 12.0, 0.55, 1.0), new DreidingAtomType(31, "Te3", 3, 52, 1.28, -0.00523596383141964, 1.57603231, 90.3, 4.23, 12.0, 0.57, 1.0), new DreidingAtomType(32, "I_", 1, 53, 1.36, -1.0, 3.14159265, 180.0, 4.15, 12.0, 0.51, 1.0), new DreidingAtomType(33, "Na_", 1, 11, 1.86, 0.0, 1.57079633, 90.0, 3.144, 12.0, 0.5, 1.0), new DreidingAtomType(34, "Ca_", 1, 20, 1.94, 0.0, 1.57079633, 90.0, 3.472, 12.0, 0.05, 1.0), new DreidingAtomType(35, "Fe_", 1, 26, 1.285, 0.0, 1.57079633, 90.0, 4.54, 12.0, 0.055, 1.0), new DreidingAtomType(36, "Zn_", 1, 30, 1.33, -0.333329702763402, 1.91062939, 109.471, 4.54, 12.0, 0.055, 1.0), new DreidingAtomType(37, "C_R1", 4, 6, 0.7, -0.5, 2.0943951, 120.0, 4.23, 14.034, 0.1356, 1.0), new DreidingAtomType(38, "C_34", 3, 6, 0.77, -0.333329702763402, 1.91062939, 109.471, 4.237, 12.0, 0.3016, 1.0), new DreidingAtomType(39, "C_33", 3, 6, 0.77, -0.333329702763402, 1.91062939, 109.471, 4.1524, 12.0, 0.25, 1.0), new DreidingAtomType(40, "C_32", 3, 6, 0.77, -0.333329702763402, 1.91062939, 109.471, 4.0677, 12.0, 0.1984, 1.0), new DreidingAtomType(41, "C_31", 3, 6, 0.77, -0.333329702763402, 1.91062939, 109.471, 3.983, 12.0, 0.1984, 1.0), new DreidingAtomType(42, "Li_", 1, 3, 1.1, -1.0, 3.14159265, 180.0, 3.195, 12.0, 0.0152, 1.0), new DreidingAtomType(43, "S_non", 3, 16, 1.04, -1.0, 3.14159265, 180.0, 4.03, 12.0, 0.344, 0.1), new DreidingAtomType(44, "Al_non", 3, 13, 1.047, -1.0, 3.14159265, 180.0, 4.39, 12.0, 0.31, 0.1), new DreidingAtomType(45, "Si_non", 3, 14, 0.937, -1.0, 3.14159265, 180.0, 4.27, 12.0, 0.31, 0.1), new DreidingAtomType(46, "Ga_non", 3, 31, 1.21, -1.0, 3.14159265, 180.0, 4.39, 12.0, 0.4, 0.1), new DreidingAtomType(47, "Ge_non", 3, 32, 1.21, -1.0, 3.14159265, 180.0, 4.27, 12.0, 0.4, 0.1), new DreidingAtomType(48, "As_non", 3, 33, 1.21, -1.0, 3.14159265, 180.0, 4.15, 12.0, 0.41, 0.1), new DreidingAtomType(49, "Se_non", 3, 34, 1.21, -1.0, 3.14159265, 180.0, 4.03, 12.0, 0.43, 0.1), new DreidingAtomType(50, "In_non", 3, 49, 1.39, -1.0, 3.14159265, 180.0, 4.59, 12.0, 0.55, 0.1), new DreidingAtomType(51, "Sn_non", 3, 50, 1.373, -1.0, 3.14159265, 180.0, 4.47, 12.0, 0.55, 0.1), new DreidingAtomType(52, "Sb_non", 3, 51, 1.432, -1.0, 3.14159265, 180.0, 4.35, 12.0, 0.55, 0.1), new DreidingAtomType(53, "Te_non", 3, 52, 1.28, -1.0, 3.14159265, 180.0, 4.23, 12.0, 0.57, 0.1), new DreidingAtomType(54, "Fe_non", 3, 26, 1.285, -1.0, 3.14159265, 180.0, 4.54, 12.0, 0.055, 0.1), new DreidingAtomType(55, "Zn_non", 3, 30, 1.33, -1.0, 3.14159265, 180.0, 4.54, 12.0, 0.055, 0.1), new DreidingAtomType(56, "P_non", 3, 15, 0.89, -1.0, 3.14159265, 180.0, 4.15, 12.0, 0.32, 0.1), new DreidingAtomType(57, "C_2CP", 2, 6, 0.67, -1.0, 3.14159265, 180.0, 3.8983, 14.034, 0.0951, 1.0), new DreidingAtomType(58, "LP", 1, 0, 1.25, -1.0, 3.14159265, 180.0, 3.195, 12.382, 0.0152, 1.0), new DreidingAtomType(59, "O_ester", 4, 8, 0.66, -0.5, 2.0943951, 120.0, 3.4046, 13.483, 0.0957, 1.0), new DreidingAtomType(60, "C_carbonyl", 4, 6, 0.7, -0.5, 2.0943951, 120.0, 3.8983, 14.034, 0.0951, 1.0)};

    public static double eqBond(DreidingAtomType t1, DreidingAtomType t2) {
        return t1.getBondRadius() + t2.getBondRadius() - 0.01;
    }

    private int neighbourCountWithoutLonePairs(int atomseq) {
        int c = 0;
        for (int i = 0; i < this.ctab[atomseq].length; ++i) {
            if (this.mol.getAtom(this.ctab[atomseq][i]).getAtno() == 130) continue;
            ++c;
        }
        return c;
    }

    private static boolean isTransitionMetal(int atomicNumber) {
        boolean t = false;
        t = atomicNumber >= 21 && atomicNumber <= 30 ? true : (atomicNumber >= 39 && atomicNumber <= 48 ? true : (atomicNumber >= 71 && atomicNumber <= 80 ? true : (atomicNumber >= 103 && atomicNumber <= 112 ? true : (atomicNumber >= 57 && atomicNumber <= 70 ? true : atomicNumber >= 89 && atomicNumber <= 102))));
        return t;
    }

    private static boolean isOxigenColumn(int atomicNumber) {
        boolean oxigenColumn = atomicNumber == 8 || atomicNumber == 16 || atomicNumber == 34 || atomicNumber == 52 || atomicNumber == 84;
        return oxigenColumn;
    }

    private static DreidingAtomType getDreidingAtomType(int type) {
        if (types[type].id == type) {
            return types[type];
        }
        throw new UnsupportedOperationException("Dreiding atom type mismatch");
    }

    public int getDreidingAtomTypeID(int atomSeq) {
        return ((DreidingAtom)this.atoms[atomSeq]).getType().getId();
    }

    public static String getDreidingAtomTypeLabel(int atomTypeID) {
        if (atomTypeID == 61) {
            return "DEFAULT";
        }
        return types[atomTypeID].getLabel();
    }

    public Dreiding(MMDiagnosticObserver obs) {
        super(obs);
    }

    public Dreiding() {
        super(null);
    }

    public CXNForceField.FFVector getVdw() {
        return this.vdw;
    }

    public void setVdwType(int vdwType) {
        this.vdwType = vdwType;
    }

    public boolean isUseCorrectedInversionForm() {
        return this.useCorrectedInversionForm;
    }

    public int getAngleTreatment() {
        return this.angleTreatment;
    }

    public void setAngleTreatment(int angleTreatment) {
        this.angleTreatment = angleTreatment;
    }

    public double getAngleScaleUpperInterval() {
        return this.angleScaleUpperInterval;
    }

    public void setAngleScaleUpperInterval(double angleUpperInterval) {
        this.angleScaleUpperInterval = angleUpperInterval;
    }

    public double getAngleScaleLowerInterval() {
        return this.angleScaleLowerInterval;
    }

    public void setAngleScaleLowerInterval(double angleLowerInterval) {
        this.angleScaleLowerInterval = angleLowerInterval;
    }

    public void setUseCorrectedInversionForm(boolean useCorrectedInversionForm) {
        this.useCorrectedInversionForm = useCorrectedInversionForm;
    }

    protected boolean isInCycloPropeneLikeRing(int atomSeqInMol) {
        boolean cycloPropenLike = false;
        if (this.neighbourCountWithoutLonePairs(atomSeqInMol) == 3) {
            int i;
            int otherAtom = -1;
            for (i = 0; i < this.bondsOfAtom[atomSeqInMol].length && otherAtom == -1; ++i) {
                MolBond b = this.mol.getBond(this.bondsOfAtom[atomSeqInMol][i]);
                if (b.getType() != 2 || (otherAtom = this.mol.indexOf(b.getAtom1())) != atomSeqInMol) continue;
                otherAtom = this.mol.indexOf(b.getAtom2());
            }
            if (otherAtom == -1) {
                return false;
            }
            for (i = 0; i < this.ctab[atomSeqInMol].length && !cycloPropenLike; ++i) {
                for (int j = 0; j < this.ctab[otherAtom].length && !cycloPropenLike; ++j) {
                    if (this.ctab[atomSeqInMol][i] != this.ctab[otherAtom][j]) continue;
                    cycloPropenLike = true;
                }
            }
        }
        return cycloPropenLike;
    }

    protected boolean isCarbonylCarbon(int atomSeqInMol) {
        if (this.mol.getAtom(atomSeqInMol).getAtno() != 6) {
            return false;
        }
        if (this.neighbourCountWithoutLonePairs(atomSeqInMol) == 3) {
            int otherAtom = -1;
            for (int i = 0; i < this.bondsOfAtom[atomSeqInMol].length && otherAtom == -1; ++i) {
                MolBond b = this.mol.getBond(this.bondsOfAtom[atomSeqInMol][i]);
                if (b.getType() != 2) continue;
                otherAtom = this.mol.indexOf(b.getAtom1());
                if (otherAtom == atomSeqInMol) {
                    otherAtom = this.mol.indexOf(b.getAtom2());
                }
                if (this.mol.getAtom(otherAtom).getAtno() != 8) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCarboxilOxigen(int atomSeqInMol) {
        if (this.mol.getAtom(atomSeqInMol).getAtno() != 8) {
            return false;
        }
        if (this.neighbourCountWithoutLonePairs(atomSeqInMol) == 1) {
            for (int i = 0; i < this.ctab[atomSeqInMol].length; ++i) {
                if (this.mol.getAtom(this.ctab[atomSeqInMol][i]).getAtno() != 6 || this.mol.getBond(this.bondsOfAtom[atomSeqInMol][i]).getType() != 2) continue;
                return true;
            }
        }
        return false;
    }

    private DreidingAtomType getDreidingType(int atomSeqInMol) {
        return ((DreidingAtom)this.atoms[atomSeqInMol]).getType();
    }

    public boolean isAmideNitrogen(int atomSeqInMol) {
        if (this.mol.getAtom(atomSeqInMol).getAtno() != 7) {
            return false;
        }
        if (this.ctab[atomSeqInMol].length < 4) {
            for (int jj = 0; jj < this.ctab[atomSeqInMol].length; ++jj) {
                int n = this.ctab[atomSeqInMol][jj];
                if (!this.isCarbonylCarbon(n)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAmideBond(int bondSeq) {
        int a1 = this.mol.indexOf(this.mol.getBond(bondSeq).getAtom1());
        int a2 = this.mol.indexOf(this.mol.getBond(bondSeq).getAtom2());
        return this.isAmideNitrogen(a1) && this.isCarbonylCarbon(a2) || this.isAmideNitrogen(a2) && this.isCarbonylCarbon(a1);
    }

    public int addableLonePairCountOnOxNi(int atomSeqInMol) {
        int z = ((DreidingAtom)this.atoms[atomSeqInMol]).getType().getAtomicNumber();
        int add = 0;
        if (z == 7 || z == 8) {
            int id = this.getDreidingAtomTypeID(atomSeqInMol);
            int neighLP = this.neighbourCountWithoutLonePairs(atomSeqInMol);
            int neigh = this.ctab[atomSeqInMol].length;
            int max = 0;
            if (id == 9 && neighLP == 3 || (id == 10 || id == 11) && neighLP == 2 || id == 12 && neighLP == 1) {
                max = 1;
            } else if (id == 13 && neighLP == 2) {
                max = 2;
            } else if (id == 13 && neighLP == 2 || id == 15 && neighLP == 1) {
                max = 2;
            } else if (id == 14 && neighLP == 2) {
                max = 1;
            }
            add = max - (neigh - neighLP);
            add = Math.max(0, add);
        }
        return add;
    }

    @Override
    protected CXNForceField.FFAtom createFFAtom(int atomSeqInMol) {
        return new DreidingAtom(atomSeqInMol);
    }

    @Override
    protected void calcFactorForDihedral(CXNForceField.FFDihedral d) {
        ((DreidingDihedral)d).calcFactors();
    }

    @Override
    protected CXNForceField.FFBond createFFBond(CXNForceField.FFAtom a1, CXNForceField.FFAtom a2, int type, int bondSeqInMol) {
        return new DreidingBond((DreidingAtom)a1, (DreidingAtom)a2, type, bondSeqInMol);
    }

    @Override
    protected boolean isAcceptableVdw(int a1, int a2) {
        if (!super.isAcceptableVdw(a1, a2)) {
            return false;
        }
        int commonCount = 0;
        int useCount = 0;
        int[] c1 = this.ctab[a1];
        int[] c2 = this.ctab[a2];
        for (int i = 0; i < c1.length; ++i) {
            for (int j = 0; j < c2.length; ++j) {
                if (c1[i] != c2[j]) continue;
                ++commonCount;
                DreidingAtom a = (DreidingAtom)this.atoms[c1[i]];
                if (!a.getType().isUseVdwInAngleTerm()) continue;
                ++useCount;
            }
        }
        if (useCount >= 1 && useCount == commonCount) {
            return true;
        }
        if (commonCount > 0 && (this.atoms[a1].getID() == 58 || this.atoms[a1].getID() == 58)) {
            return true;
        }
        return commonCount <= 0;
    }

    @Override
    protected CXNForceField.FFVector createFFLongRange() {
        if (this.vdwType == 1) {
            return new DreidingVdWLenard();
        }
        if (this.vdwType == 3) {
            return new DreidingVdWExp();
        }
        if (this.vdwType == 2) {
            return new DreidingVdWLenardCapped();
        }
        throw new UnsupportedOperationException("No valid van der Waals option was selected.");
    }

    private boolean acceptDihedralBetween(CXNForceField.FFAngle an1, CXNForceField.FFAngle an2) {
        if (((DreidingAtom)an1.getA2()).getType().cosAngle == -1.0) {
            return false;
        }
        if (((DreidingAtom)an2.getA2()).getType().cosAngle == -1.0) {
            return false;
        }
        if (((DreidingAtom)an1.getA1()).getType().isTransitionMetal()) {
            return false;
        }
        if (((DreidingAtom)an1.getA2()).getType().isTransitionMetal()) {
            return false;
        }
        if (((DreidingAtom)an1.getA3()).getType().isTransitionMetal()) {
            return false;
        }
        if (((DreidingAtom)an2.getA1()).getType().isTransitionMetal()) {
            return false;
        }
        if (((DreidingAtom)an2.getA2()).getType().isTransitionMetal()) {
            return false;
        }
        return !((DreidingAtom)an2.getA3()).getType().isTransitionMetal();
    }

    @Override
    protected CXNForceField.FFAngle createFFAngle(CXNForceField.FFBond b1, CXNForceField.FFBond b2) throws CXNForceField.FFComponentException {
        if (this.angleTreatment == 0 || this.angleTreatment == 3 || this.angleTreatment == 5 || this.angleTreatment == 6 || this.angleTreatment == 8) {
            throw new CXNForceField.FFComponentException("Angle energy treatment was badly defined by user.");
        }
        DreidingAngle fa = null;
        if ((this.angleTreatment & 1) == 1) {
            fa = new DreidingAngleCos((DreidingBond)b1, (DreidingBond)b2);
        } else if ((this.angleTreatment & 2) == 2) {
            fa = new DreidingAngle((DreidingBond)b1, (DreidingBond)b2);
        } else if ((this.angleTreatment & 4) == 4) {
            fa = new DreidingCorrectedAngle((DreidingBond)b1, (DreidingBond)b2);
        } else {
            throw new CXNForceField.FFComponentException("Angle energy treatment was badly defined by user.");
        }
        DreidingAtomType at = ((DreidingAtom)fa.getA2()).getType();
        if (at.getAngleDeg() == 180.0 && (this.angleTreatment & 8) == 8) {
            fa = new DreidingAngleCos((DreidingBond)b1, (DreidingBond)b2);
        }
        return fa;
    }

    @Override
    protected CXNForceField.FFDihedral createFFDihedral(CXNForceField.FFAngle an1, CXNForceField.FFAngle an2) throws CXNForceField.FFComponentException {
        DreidingDihedral d = null;
        if (this.acceptDihedralBetween(an1, an2)) {
            d = new DreidingDihedral((DreidingAngle)an1, (DreidingAngle)an2);
            if (d.getA1().getID() == d.getA4().getID()) {
                return null;
            }
            DreidingAtom a1 = (DreidingAtom)d.a1;
            DreidingAtom a2 = (DreidingAtom)d.a2;
            DreidingAtom a3 = (DreidingAtom)d.a3;
            DreidingAtom a4 = (DreidingAtom)d.a4;
            DreidingAtomType da1 = a1.getType();
            DreidingAtomType da2 = a2.getType();
            DreidingAtomType da3 = a3.getType();
            DreidingAtomType da4 = a4.getType();
            int centralBondType = d.b2.getType();
            boolean isAmide2 = this.isAmideNitrogen(a2.getID());
            boolean isAmide3 = this.isAmideNitrogen(a3.getID());
            int at2 = this.mol.getAtom(a2.getID()).getAtno();
            int at3 = this.mol.getAtom(a3.getID()).getAtno();
            if (isAmide2 && (at3 == 7 || at3 == 8) || isAmide3 && (at2 == 7 || at2 == 8)) {
                if (this.diagnosticObserver != null) {
                    this.diagnosticObserver.isTuneEnabled(5, a2.getID(), a3.getID());
                }
                d.v = 9.0;
                d.n = 2;
                d.psi0 = 1.5707963267948966;
                d.label = "hydrazine";
                int at1 = this.mol.getAtom(a1.getID()).getAtno();
                int at4 = this.mol.getAtom(a4.getID()).getAtno();
                if (at4 == 1 && !isAmide3 || at1 == 1 && !isAmide2) {
                    DreidingBond db = (DreidingBond)d.b2;
                    d.v *= this.torsH_hydrogenScale;
                }
                return d;
            }
            if (da2.getHybridization() == 3 && da3.getHybridization() == 3) {
                if (da2.isOxigenColumn() && da3.isOxigenColumn()) {
                    d.v = 2.0;
                    d.n = 2;
                    d.psi0 = 1.5707963267948966;
                    d.label = "paragraph h";
                } else {
                    d.v = 2.0;
                    d.n = 3;
                    d.psi0 = Math.PI;
                    d.label = "paragraph a";
                }
                return d;
            }
            if (da2.isSp2() && da3.getHybridization() == 3 || da2.getHybridization() == 3 && da3.isSp2()) {
                if (da1.isSp2() && da2.isSp2() || da4.isSp2() && da3.isSp2()) {
                    d.v = 1.0;
                    d.n = 6;
                    d.psi0 = 0.0;
                    d.label = "paragraph b";
                    if (da2.isOxigenColumn() && da2.getHybridization() == 3 && !da3.isOxigenColumn() || da3.isOxigenColumn() && da3.getHybridization() == 3 && !da2.isOxigenColumn()) {
                        d.v = 2.0;
                        d.n = 2;
                        d.psi0 = Math.PI;
                        d.label = "paragraph i";
                    }
                } else {
                    d.v = 1.0;
                    d.n = 3;
                    d.psi0 = Math.PI;
                    d.label = "paragraph j";
                }
                return d;
            }
            if (da2.getHybridization() == 2 && da3.getHybridization() == 2) {
                if (centralBondType == 2) {
                    d.v = 45.0;
                    d.n = 2;
                    d.psi0 = Math.PI;
                    d.label = "paragraph c";
                    return d;
                }
                if (centralBondType == 1) {
                    d.v = 5.0;
                    d.n = 2;
                    d.psi0 = Math.PI;
                    d.label = "paragraph e";
                    return d;
                }
            }
            if (da2.getHybridization() == 4 && da3.getHybridization() == 4) {
                boolean amide;
                boolean bl = amide = isAmide2 && this.isCarbonylCarbon(a3.getID()) || isAmide3 && this.isCarbonylCarbon(a2.getID());
                if (centralBondType == 4 || amide) {
                    if (isAmide2 && da1.getAtomicNumber() == 1 && !isAmide3 && da4.getId() == 15) {
                        d = new AmideDihedral((DreidingAngle)an1, (DreidingAngle)an2);
                    } else if (isAmide3 && da4.getAtomicNumber() == 1 && !isAmide2 && da1.getId() == 15) {
                        d = new AmideDihedral((DreidingAngle)an2, (DreidingAngle)an1);
                    }
                    d.v = 25.0;
                    d.n = 2;
                    d.psi0 = Math.PI;
                    d.label = "paragraph d";
                } else if (centralBondType == 1) {
                    if (da2.getLabel().equals("O_ester") && this.isCarbonylCarbon(a3.getID()) && !this.isCarboxilOxigen(a4.getID())) {
                        d = da4.getLabel().equals("H_") ? new EsterHDihedral((DreidingAngle)an1, (DreidingAngle)an2) : new EsterCDihedral((DreidingAngle)an1, (DreidingAngle)an2);
                        d.v = 5.0;
                        d.v *= 2.0;
                        d.n = 2;
                        d.psi0 = Math.PI;
                        d.label = "ester";
                    } else if (da3.getLabel().equals("O_ester") && this.isCarbonylCarbon(a2.getID()) && !this.isCarboxilOxigen(a1.getID())) {
                        d = da1.getLabel().equals("H_") ? new EsterHDihedral((DreidingAngle)an1, (DreidingAngle)an2) : new EsterCDihedral((DreidingAngle)an1, (DreidingAngle)an2);
                        d.v = 5.0;
                        d.v *= 2.0;
                        d.n = 2;
                        d.psi0 = Math.PI;
                        d.label = "ester";
                    } else if (!amide) {
                        d.v = 10.0;
                        d.n = 2;
                        d.psi0 = Math.PI;
                        d.label = "paragraph f";
                    }
                }
                return d;
            }
            if (da2.isSp2() && da3.isSp2() && centralBondType == 1) {
                d.v = 5.0;
                d.v *= 2.0;
                d.n = 2;
                d.psi0 = Math.PI;
                d.label = "paragraph e";
                return d;
            }
        }
        return d;
    }

    @Override
    protected CXNForceField.FFInversion createFFInversion(CXNForceField.FFAngle an1, CXNForceField.FFAngle an2, CXNForceField.FFAngle an3) throws CXNForceField.FFComponentException {
        DreidingAngle d1 = (DreidingAngle)an1;
        DreidingAngle d2 = (DreidingAngle)an2;
        DreidingAngle d3 = (DreidingAngle)an3;
        boolean tetrahedralSulfur = false;
        DreidingAtomType t = ((DreidingAtom)an1.getA2()).getType();
        if (t.getLabel().equals("S_3")) {
            int t1 = this.mol.getBond(d1.getB1().getBondSeqInMol()).getType();
            int t2 = this.mol.getBond(d1.getB2().getBondSeqInMol()).getType();
            int t3 = this.mol.getBond(d2.getB1().getBondSeqInMol()).getType();
            int t4 = this.mol.getBond(d2.getB2().getBondSeqInMol()).getType();
            if (t1 != 2 || t2 != 2 || t3 != 2 || t4 != 2) {
                tetrahedralSulfur = true;
            }
        }
        if (t.getLabel().equals("C_31") || tetrahedralSulfur) {
            if (this.useCorrectedInversionForm) {
                return new DreidingNonPlanarMappedInversion(d1, d2, d3);
            }
            return new DreidingNonPlanarInversion(d1, d2, d3);
        }
        DreidingAtomType d = ((DreidingAtom)an1.getA2()).getType();
        if (d.getId() != 9 && d.getId() != 20) {
            if (this.useCorrectedInversionForm) {
                return new DreidingPlanarMappedInversion(d1, d2, d3);
            }
            return new DreidingPlanarInversion(d1, d2, d3);
        }
        return null;
    }

    @Override
    public boolean init(Molecule molecule) {
        this.init(molecule, null);
        return true;
    }

    @Override
    public void init(Molecule molecule, int[] atomIndex) {
        super.init(molecule, atomIndex);
        try {
            this.checkForCumulenes();
        }
        catch (CXNForceField.FFComponentException ex) {
            Logger.getLogger(Dreiding.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void checkForCumulenes() throws CXNForceField.FFComponentException {
        int count = 0;
        for (int i = 0; i < this.atoms.length; ++i) {
            DreidingAtom da = (DreidingAtom)this.atoms[i];
            if (da.type.id != 7) continue;
            for (int j = 0; j < this.ctab[i].length; ++j) {
                if (((DreidingAtom)this.atoms[this.ctab[i][j]]).type.id != 8) continue;
                ++count;
            }
        }
        if (count > 1) {
            int j;
            int[] cumuleneEnds = new int[count];
            count = 0;
            for (int i = 0; i < this.atoms.length; ++i) {
                DreidingAtom da = (DreidingAtom)this.atoms[i];
                if (da.type.id != 7) continue;
                for (j = 0; j < this.ctab[i].length; ++j) {
                    if (((DreidingAtom)this.atoms[this.ctab[i][j]]).type.id != 8) continue;
                    cumuleneEnds[count++] = i;
                }
            }
            if (this.sp == null) {
                this.sp = new ShortestPath();
                this.sp.calculate(this.mol);
                this.path = new int[this.atoms.length];
            }
            int pathLen = 0;
            for (int i = 0; i < cumuleneEnds.length - 1; ++i) {
                for (j = i + 1; j < cumuleneEnds.length; ++j) {
                    int k;
                    pathLen = this.sp.getPath(cumuleneEnds[i], cumuleneEnds[j], this.path);
                    boolean cumuleneRod = false;
                    if (pathLen > 2) {
                        cumuleneRod = true;
                        for (int k2 = 0; k2 < pathLen && cumuleneRod; ++k2) {
                            DreidingAtom da = (DreidingAtom)this.atoms[this.path[k2]];
                            if ((k2 == 0 || k2 == pathLen - 1) && da.type.id != 7) {
                                cumuleneRod = false;
                            }
                            if (k2 <= 0 || k2 >= pathLen - 1 || da.type.id == 8) continue;
                            cumuleneRod = false;
                        }
                    }
                    if (!cumuleneRod) continue;
                    DreidingAtom da2 = (DreidingAtom)this.atoms[cumuleneEnds[i]];
                    DreidingAtom da3 = (DreidingAtom)this.atoms[cumuleneEnds[j]];
                    int dihedralCount = 0;
                    int ffCompCount = this.ffComp.size();
                    for (k = 0; k < this.ctab[cumuleneEnds[i]].length; ++k) {
                        DreidingAtom da1 = (DreidingAtom)this.atoms[this.ctab[cumuleneEnds[i]][k]];
                        if (da1.type.id == 8) continue;
                        for (int l = 0; l < this.ctab[cumuleneEnds[j]].length; ++l) {
                            DreidingAtom da4 = (DreidingAtom)this.atoms[this.ctab[cumuleneEnds[j]][l]];
                            if (da4.type.id == 8) continue;
                            ++dihedralCount;
                            DreidingDihedralOnAtoms d = new DreidingDihedralOnAtoms(da1, da2, da3, da4, -1);
                            d.v = 45.0;
                            d.n = 2;
                            if (pathLen % 2 == 0) {
                                d.psi = 0.0;
                            } else {
                                d.psi0 = 1.5707963267948966;
                            }
                            d.label = "cumulene";
                            d.calcFactors();
                            this.ffComp.add(d);
                        }
                    }
                    for (k = ffCompCount; k < this.ffComp.size(); ++k) {
                        DreidingDihedral d = (DreidingDihedral)this.ffComp.get(k);
                        d.b2.dihedralCount = dihedralCount;
                    }
                }
            }
        }
    }

    @Override
    public double getEqulibriumBondLength(int atom1, int atom2) {
        return Dreiding.eqBond(((DreidingAtom)this.atoms[atom1]).getType(), ((DreidingAtom)this.atoms[atom2]).getType());
    }

    private abstract class DreidingVdW
    extends CXNForceField.FFVector {
        protected double d0;
        protected double r0;
        protected double x1;
        protected double x2;
        protected double r010;
        protected double r06;
        protected double r04;

        private DreidingVdW() {
        }

        @Override
        public String toString() {
            DecimalFormat f = new DecimalFormat("0.0000");
            return super.toString() + " r0: " + f.format(this.r0) + " d0: " + f.format(this.d0);
        }
    }

    private class DreidingVdWExp
    extends DreidingVdW {
        private double khi0;
        private double x3;
        private double x4;

        private DreidingVdWExp() {
        }

        @Override
        public String toString() {
            return "vdW Exp " + super.toString();
        }

        protected boolean calcGeom() {
            if (this.valuesFilled) {
                return true;
            }
            this.vec[0] = this.a2.getCoordinate(0) - this.a1.getCoordinate(0);
            this.vec[1] = this.a2.getCoordinate(1) - this.a1.getCoordinate(1);
            this.vec[2] = this.a2.getCoordinate(2) - this.a1.getCoordinate(2);
            double lengthSq = this.vec[0] * this.vec[0] + this.vec[1] * this.vec[1] + this.vec[2] * this.vec[2];
            this.length = Math.sqrt(lengthSq);
            V.copyV(this.normalizedVec, this.vec);
            V.normalizeSafe(this.normalizedVec);
            this.valuesFilled = true;
            return true;
        }

        private void init() {
            DreidingAtom atom1 = (DreidingAtom)this.a1;
            DreidingAtom atom2 = (DreidingAtom)this.a2;
            if (atom1.getType().getLabel().equals(atom2.getType().getLabel())) {
                this.d0 = atom1.getType().getVdWD0();
                this.r0 = atom1.getType().getVdWR0();
            }
            if (atom1.getType().getLabel().equals(atom2.getType().getLabel())) {
                this.khi0 = atom1.getType().getVdWKhi0();
            } else {
                this.d0 = Math.sqrt(atom1.getType().getVdWD0() * atom2.getType().getVdWD0());
                this.r0 = Math.sqrt(atom1.getType().getVdWR0() * atom2.getType().getVdWR0());
                this.khi0 = (atom1.getType().getVdWKhi0() + atom2.getType().getVdWKhi0()) / 2.0;
            }
            this.r06 = this.r0 * this.r0 * this.r0 * this.r0 * this.r0 * this.r0;
            this.x1 = 6.0 / (this.khi0 - 6.0);
            this.x2 = this.khi0 / (this.khi0 - 6.0);
            this.x3 = this.d0 * 6.0 * this.x2 / this.r0;
            this.x4 = this.d0 * this.khi0 * this.x1 / this.r0;
        }

        @Override
        protected void calc_E_dE() {
            this.init();
            this.e = 0.0;
            this.dE = 0.0;
            double r = this.length;
            double rho = this.length / this.r0;
            double r6 = r * r * r * r * r * r;
            double rho6 = r6 / this.r06;
            double exp = Math.exp(this.khi0 * (1.0 - rho));
            this.e = this.d0 * (this.x1 * exp - this.x2 * 1.0 / rho6);
            if (Dreiding.this.wishDerivates) {
                double rho7 = rho6 * rho;
                this.dE = this.x3 * 1.0 / rho7 - this.x4 * exp;
            }
        }
    }

    private class DreidingVdWLenard
    extends DreidingVdW {
        private DreidingVdWLenard() {
        }

        @Override
        public String toString() {
            return "vdW L-J " + super.toString();
        }

        @Override
        public void calcFF() {
            DreidingAtom atom1 = (DreidingAtom)this.a1;
            DreidingAtom atom2 = (DreidingAtom)this.a2;
            if (atom1.getType().getId() == atom2.getType().getId()) {
                this.d0 = atom1.getType().getVdWD0() * Dreiding.this.VDW_WELLDEPTH_SCALE;
                this.r0 = atom1.getType().getVdWR0() * Dreiding.this.VDW_RADIUS_SCALE;
            } else {
                this.r0 = (atom1.getType().getVdWR0() + atom2.getType().getVdWR0()) / 2.0 * Dreiding.this.VDW_RADIUS_SCALE;
                this.d0 = Math.sqrt(atom1.getType().getVdWD0() * atom2.getType().getVdWD0()) * Dreiding.this.VDW_WELLDEPTH_SCALE;
            }
            this.valuesFilled = false;
            this.vec[0] = this.a2.getCoordinate(0) - this.a1.getCoordinate(0);
            this.vec[1] = this.a2.getCoordinate(1) - this.a1.getCoordinate(1);
            this.vec[2] = this.a2.getCoordinate(2) - this.a1.getCoordinate(2);
            double lengthSq = this.vec[0] * this.vec[0] + this.vec[1] * this.vec[1] + this.vec[2] * this.vec[2];
            this.e = 0.0;
            this.dE = 0.0;
            if (lengthSq < 1.0E-8) {
                lengthSq = 1.0E-8;
            }
            double scale = 1.0;
            double rr = 0.0;
            if (Dreiding.this.cutOffForVDW > 0.0) {
                double w = this.r0 * Dreiding.this.cutOffForVDW + 0.5;
                if (w * w < lengthSq) {
                    return;
                }
                this.length = Math.sqrt(lengthSq);
                rr = this.length - this.r0 * Dreiding.this.cutOffForVDW;
                scale = Dreiding.this.scale(rr, 0.5);
            } else {
                this.length = Math.sqrt(lengthSq);
            }
            this.valuesFilled = true;
            double r = this.length;
            this.r04 = this.r0 * this.r0 * this.r0 * this.r0;
            this.r06 = this.r04 * this.r0 * this.r0;
            this.r010 = this.r04 * this.r06;
            double r4 = r * r * r * r;
            double r6 = r4 * r * r;
            double r10 = r6 * r4;
            double rho6 = r6 / this.r06;
            double rho12 = rho6 * rho6;
            this.e = (this.d0 / rho12 - 2.0 * this.d0 / rho6) * this.weight;
            if (Dreiding.this.wishDerivates) {
                this.x1 = this.d0 * 12.0 * this.r06;
                this.x2 = this.x1 * this.r06;
                double r7 = r6 * r;
                double r13 = r6 * r7;
                this.dE = (this.x1 / r7 - this.x2 / r13) * this.weight;
                if (scale < 1.0) {
                    double dScale = CXNForceField.scaleGrad(rr, 0.5);
                    this.dE = this.dE * scale + this.e * dScale;
                }
                V.copyV(this.normalizedVec, this.vec);
                MolGeom.mul(this.normalizedVec, 1.0 / this.length);
                this.a2.addD(0, this.normalizedVec[0] * this.dE);
                this.a2.addD(1, this.normalizedVec[1] * this.dE);
                this.a2.addD(2, this.normalizedVec[2] * this.dE);
                this.a1.addD(0, this.normalizedVec[0] * this.dE * -1.0);
                this.a1.addD(1, this.normalizedVec[1] * this.dE * -1.0);
                this.a1.addD(2, this.normalizedVec[2] * this.dE * -1.0);
            }
            this.e *= scale;
            Dreiding.this.totalEnergy += this.e;
        }

        @Override
        protected void calc_E_dE() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class DreidingVdWLenardCapped
    extends CXNForceField.FFVector {
        ProxScaledVdw funct = new ProxScaledVdw();

        @Override
        public String toString() {
            return "vdW L-J capped" + super.toString();
        }

        @Override
        public void calcFF() {
            double r0;
            double d0;
            DreidingAtom atom1 = (DreidingAtom)this.a1;
            DreidingAtom atom2 = (DreidingAtom)this.a2;
            if (atom1.getType().getId() == atom2.getType().getId()) {
                d0 = atom1.getType().getVdWD0() * Dreiding.this.VDW_WELLDEPTH_SCALE;
                r0 = atom1.getType().getVdWR0() * Dreiding.this.VDW_RADIUS_SCALE;
            } else {
                r0 = (atom1.getType().getVdWR0() + atom2.getType().getVdWR0()) / 2.0 * Dreiding.this.VDW_RADIUS_SCALE;
                d0 = Math.sqrt(atom1.getType().getVdWD0() * atom2.getType().getVdWD0()) * Dreiding.this.VDW_WELLDEPTH_SCALE;
            }
            this.valuesFilled = false;
            this.vec[0] = this.a2.getCoordinate(0) - this.a1.getCoordinate(0);
            this.vec[1] = this.a2.getCoordinate(1) - this.a1.getCoordinate(1);
            this.vec[2] = this.a2.getCoordinate(2) - this.a1.getCoordinate(2);
            double lengthSq = this.vec[0] * this.vec[0] + this.vec[1] * this.vec[1] + this.vec[2] * this.vec[2];
            this.e = 0.0;
            this.dE = 0.0;
            double scale = 1.0;
            double rr = 0.0;
            if (Dreiding.this.cutOffForVDW > 0.0) {
                double w = r0 * Dreiding.this.cutOffForVDW + 0.5;
                if (w * w < lengthSq) {
                    return;
                }
                this.length = Math.sqrt(lengthSq);
                rr = this.length - r0 * Dreiding.this.cutOffForVDW;
                scale = Dreiding.this.scale(rr, 0.5);
            } else {
                this.length = Math.sqrt(lengthSq);
            }
            this.valuesFilled = true;
            this.funct.init(r0, d0);
            this.funct.setR(this.length);
            this.e = this.funct.getValue();
            if (Dreiding.this.wishDerivates) {
                V.copyV(this.normalizedVec, this.vec);
                MolGeom.mul(this.normalizedVec, 1.0 / this.length);
                this.dE = this.funct.getDer();
                if (scale < 1.0) {
                    double dScale = CXNForceField.scaleGrad(rr, 0.5);
                    this.dE = this.dE * scale + this.e * dScale;
                }
                this.a2.addD(0, this.normalizedVec[0] * this.dE);
                this.a2.addD(1, this.normalizedVec[1] * this.dE);
                this.a2.addD(2, this.normalizedVec[2] * this.dE);
                this.a1.addD(0, this.normalizedVec[0] * this.dE * -1.0);
                this.a1.addD(1, this.normalizedVec[1] * this.dE * -1.0);
                this.a1.addD(2, this.normalizedVec[2] * this.dE * -1.0);
            }
            this.e *= scale;
            Dreiding.this.totalEnergy += this.e;
        }

        @Override
        protected void calc_E_dE() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class DreidingNonPlanarMappedInversion
    extends CXNForceField.FFInversion {
        @Override
        public String toString() {
            return "Corrected Non planar " + super.toString();
        }

        public DreidingNonPlanarMappedInversion(DreidingAngle angle1, DreidingAngle angle2, DreidingAngle angle3) throws CXNForceField.FFComponentException {
            super(angle1, angle2, angle3);
        }

        @Override
        protected void calc_E_dE() {
            this.e = 0.0;
            this.dE = 0.0;
            if (Dreiding.this.whatToCalc != null && Dreiding.this.whatToCalc.get(3)) {
                return;
            }
            double psi = Math.asin(this.invSin);
            double psi0rad = 0.955393232541696;
            double myInvCos = this.invCos;
            double myInvSin = this.invSin;
            double derivateOfInner = 1.0;
            if (psi0rad <= psi || psi <= -1.0 * psi0rad) {
                double c = 0.0;
                double b = 1.5707963267948966 - psi0rad;
                double d = 1.5707963267948966 / b / b / b;
                if (psi0rad <= psi) {
                    c = psi - psi0rad;
                    double a = psi + d * c * c * c;
                    myInvCos = CXNForceField.cleanTrig(Math.cos(a));
                    myInvSin = CXNForceField.cleanTrig(Math.sin(a));
                } else if (psi <= -1.0 * psi0rad) {
                    c = -psi - psi0rad;
                    double a = psi - d * c * c * c;
                    myInvCos = CXNForceField.cleanTrig(Math.cos(a));
                    myInvSin = CXNForceField.cleanTrig(Math.sin(a));
                }
                derivateOfInner = 1.0 + d * 3.0 * c * c;
            }
            double x = myInvCos - 0.5772877;
            this.e = 29.99675 * x * x / 3.0;
            if (Dreiding.this.wishDerivates) {
                this.dE = -59.9935 * x * myInvSin * derivateOfInner / 3.0;
            }
        }
    }

    private class DreidingNonPlanarInversion
    extends CXNForceField.FFInversion {
        @Override
        public String toString() {
            return "Non planar " + super.toString();
        }

        public DreidingNonPlanarInversion(DreidingAngle angle1, DreidingAngle angle2, DreidingAngle angle3) throws CXNForceField.FFComponentException {
            super(angle1, angle2, angle3);
        }

        @Override
        protected void calc_E_dE() {
            this.e = 0.0;
            this.dE = 0.0;
            if (Dreiding.this.whatToCalc != null && Dreiding.this.whatToCalc.get(3)) {
                return;
            }
            double x = this.invCos - 0.5772877;
            this.e = 29.99675 * x * x / 3.0;
            if (Dreiding.this.wishDerivates) {
                this.dE = -59.9935 * x * this.invSin / 3.0;
            }
        }
    }

    private class DreidingPlanarInversion
    extends CXNForceField.FFInversion {
        public DreidingPlanarInversion(DreidingAngle angle1, DreidingAngle angle2, DreidingAngle angle3) throws CXNForceField.FFComponentException {
            super(angle1, angle2, angle3);
        }

        @Override
        protected void calc_E_dE() {
            this.e = 0.0;
            this.dE = 0.0;
            if (Dreiding.this.whatToCalc != null && Dreiding.this.whatToCalc.get(3)) {
                return;
            }
            this.e = 40.0 * (1.0 - this.invCos) / 3.0;
            if (Dreiding.this.wishDerivates) {
                this.dE = 40.0 * this.invSin / 3.0;
            }
        }
    }

    private class DreidingPlanarMappedInversion
    extends CXNForceField.FFInversion {
        @Override
        public String toString() {
            return "Corrected Planar " + super.toString();
        }

        public DreidingPlanarMappedInversion(DreidingAngle angle1, DreidingAngle angle2, DreidingAngle angle3) throws CXNForceField.FFComponentException {
            super(angle1, angle2, angle3);
        }

        @Override
        protected void calc_E_dE() {
            this.e = 0.0;
            this.dE = 0.0;
            if (Dreiding.this.whatToCalc != null && Dreiding.this.whatToCalc.get(3)) {
                return;
            }
            double psi = Math.asin(this.invSin);
            double psi0rad = 0.0;
            double myInvCos = this.invCos;
            double myInvSin = this.invSin;
            double derivateOfInner = 1.0;
            if (psi0rad <= psi || psi <= -1.0 * psi0rad) {
                double c = 0.0;
                double b = 1.5707963267948966 - psi0rad;
                double d = 1.5707963267948966 / b / b / b;
                if (psi0rad <= psi) {
                    c = psi - psi0rad;
                    double a = psi + d * c * c * c;
                    myInvCos = CXNForceField.cleanTrig(Math.cos(a));
                    myInvSin = CXNForceField.cleanTrig(Math.sin(a));
                } else if (psi <= -1.0 * psi0rad) {
                    c = -psi - psi0rad;
                    double a = psi - d * c * c * c;
                    myInvCos = CXNForceField.cleanTrig(Math.cos(a));
                    myInvSin = CXNForceField.cleanTrig(Math.sin(a));
                }
                derivateOfInner = 1.0 + d * 3.0 * c * c;
            }
            this.e = 40.0 * (1.0 - myInvCos) / 3.0;
            if (Dreiding.this.wishDerivates) {
                this.dE = 40.0 * myInvSin * derivateOfInner / 3.0;
            }
        }
    }

    private class EsterHDihedral
    extends DreidingDihedral {
        @Override
        public String toString() {
            return "EsterH " + super.toString();
        }

        public EsterHDihedral(DreidingAngle an1, DreidingAngle an2) throws CXNForceField.FFComponentException {
            super(an1, an2);
            --this.b2.dihedralCount;
        }

        @Override
        protected void calc_E_dE() {
            double f1;
            this.e = 0.0;
            this.dE = 0.0;
            if (Dreiding.this.whatToCalc != null && Dreiding.this.whatToCalc.get(2)) {
                return;
            }
            double d = MolGeom.dihedralDifference(this.psi, this.psi0);
            this.e = this.prefix * (1.0 - CXNForceField.cleanTrig(Math.cos((double)this.n * d)));
            double w = 2.7;
            double max = Math.PI;
            double min = 2.827433388230814;
            double scale1 = 1.0;
            double scale2 = 1.0;
            double f = 0.0;
            f = f1 = this.prefix * w * CXNForceField.cleanTrig(Math.cos(this.psi / 2.0));
            scale1 = Dreiding.this.scale(this.psi - min, max - min);
            scale2 = Dreiding.this.scale(-this.psi - min, max - min);
            this.e += f * scale1 * scale2;
            if (Dreiding.this.wishDerivates) {
                this.dE = this.prefix * (double)this.n * CXNForceField.cleanTrig(Math.sin((double)this.n * d));
                double dF = -0.5 * this.prefix * w * CXNForceField.cleanTrig(Math.sin(this.psi / 2.0));
                double scaleG1 = CXNForceField.scaleGrad(this.psi - min, max - min);
                double scaleG2 = -CXNForceField.scaleGrad(-this.psi - min, max - min);
                this.dE += f * scaleG1 * scale2 + f * scaleG2 * scale1 + dF * scale1 * scale2;
            }
        }
    }

    private class EsterCDihedral
    extends DreidingDihedral {
        @Override
        public String toString() {
            return "EsterC " + super.toString();
        }

        public EsterCDihedral(DreidingAngle an1, DreidingAngle an2) throws CXNForceField.FFComponentException {
            super(an1, an2);
            --this.b2.dihedralCount;
        }

        @Override
        protected void calc_E_dE() {
            this.e = 0.0;
            this.dE = 0.0;
            if (Dreiding.this.whatToCalc != null && Dreiding.this.whatToCalc.get(2)) {
                return;
            }
            double d = MolGeom.dihedralDifference(this.psi, this.psi0);
            double d0 = MolGeom.dihedralDifference(this.psi, 0.0);
            this.e = this.prefix * (1.0 - CXNForceField.cleanTrig(Math.cos((double)this.n * d)));
            double w = 2.7;
            double max = Math.PI;
            double min = 2.827433388230814;
            double sz = 1.1;
            double m = 3.0;
            double f1 = this.prefix * w * CXNForceField.cleanTrig(Math.cos(this.psi / 2.0));
            double f2 = Math.exp(-(d0 / sz) * (d0 / sz)) * m;
            double scale1 = Dreiding.this.scale(this.psi - min, max - min);
            double scale2 = Dreiding.this.scale(-this.psi - min, max - min);
            this.e += (f1 + f2) * scale1 * scale2;
            if (Dreiding.this.wishDerivates) {
                this.dE = this.prefix * (double)this.n * CXNForceField.cleanTrig(Math.sin((double)this.n * d));
                double dF = -0.5 * this.prefix * w * CXNForceField.cleanTrig(Math.sin(this.psi / 2.0));
                double scaleG1 = CXNForceField.scaleGrad(this.psi - min, max - min);
                double scaleG2 = -CXNForceField.scaleGrad(-this.psi - min, max - min);
                this.dE += (f1 + f2) * scaleG1 * scale2 + (f1 + f2) * scaleG2 * scale1 + (dF += -2.0 * d0 / sz / sz * f2) * scale1 * scale2;
            }
        }
    }

    private class DreidingDihedralOnAtoms
    extends DreidingDihedral {
        public DreidingDihedralOnAtoms(DreidingAtom a1, DreidingAtom a2, DreidingAtom a3, DreidingAtom a4, int type) throws CXNForceField.FFComponentException {
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
            this.b1 = new DreidingBondAutoFlush((DreidingAtom)this.a2, (DreidingAtom)this.a1, type, 1);
            this.b2 = new DreidingBondAutoFlush((DreidingAtom)this.a3, (DreidingAtom)this.a2, type, 1);
            this.b3 = new DreidingBondAutoFlush((DreidingAtom)this.a4, (DreidingAtom)this.a3, type, 1);
            this.angle1 = new DreidingAngleAutoFlush((DreidingBond)this.b2, (DreidingBond)this.b3);
            this.angle2 = new DreidingAngleAutoFlush((DreidingBond)this.b1, (DreidingBond)this.b2);
            this.v1 = this.b1.inormalizedVec;
        }

        @Override
        public void calcFF() {
            this.b1.calcGeom();
            this.b2.calcGeom();
            this.b3.calcGeom();
            super.calcFF();
        }
    }

    private class AmideDihedral
    extends DreidingDihedral {
        public AmideDihedral(DreidingAngle an1, DreidingAngle an2) throws CXNForceField.FFComponentException {
            super(an1, an2);
            --this.b2.dihedralCount;
        }

        @Override
        public String toString() {
            return "Amide " + super.toString();
        }

        @Override
        protected void calc_E_dE() {
            this.e = 0.0;
            this.dE = 0.0;
            if (Dreiding.this.whatToCalc != null && Dreiding.this.whatToCalc.get(2)) {
                return;
            }
            double d = MolGeom.dihedralDifference(this.psi, this.psi0);
            double amideWellExtraHight = 1.45;
            this.e = this.prefix * (1.0 - CXNForceField.cleanTrig(Math.cos((double)this.n * d))) + amideWellExtraHight * (1.0 - CXNForceField.cleanTrig(Math.cos(d)));
            if (Dreiding.this.wishDerivates) {
                this.dE = this.prefix * (double)this.n * CXNForceField.cleanTrig(Math.sin((double)this.n * d)) + amideWellExtraHight * CXNForceField.cleanTrig(Math.sin(d));
            }
        }
    }

    private class DreidingDihedral
    extends CXNForceField.FFDihedral {
        double v;
        double psi0;
        int n;
        double prefix;
        String label;

        @Override
        public String toString() {
            String s = super.toString() + " v: " + this.v + " n: " + this.n + " psi0: " + MolGeom.forHumans(this.psi0);
            String t1 = ((DreidingAtom)this.a1).getType().getLabel() + " h: " + ((DreidingAtom)this.a1).getType().getHybridization();
            String t2 = ((DreidingAtom)this.a2).getType().getLabel() + " h: " + ((DreidingAtom)this.a2).getType().getHybridization();
            String t3 = ((DreidingAtom)this.a3).getType().getLabel() + " h: " + ((DreidingAtom)this.a3).getType().getHybridization();
            String t4 = ((DreidingAtom)this.a4).getType().getLabel() + " h: " + ((DreidingAtom)this.a4).getType().getHybridization();
            s = s + "\t" + t1 + "\t" + t2 + "\t" + t3 + "\t" + t4;
            s = s + "Lab: " + this.label;
            return s;
        }

        public DreidingDihedral(DreidingAngle an1, DreidingAngle an2) throws CXNForceField.FFComponentException {
            super(an1, an2);
            this.label = "";
        }

        private DreidingDihedral() {
            this.label = "";
        }

        protected void calcFactors() {
            DreidingAtomType da2 = ((DreidingAtom)this.a2).getType();
            DreidingAtomType da3 = ((DreidingAtom)this.a3).getType();
            double unknownFactor = 1.0;
            if (da2.getId() == 61 || da3.getId() == 61) {
                unknownFactor = 0.3;
                this.v = 2.0;
                this.n = 2;
                this.psi0 = 90.0;
            }
            this.v *= unknownFactor;
            int ntors = this.b2.getDihedralCount();
            ntors = (Dreiding.this.ctab[this.a2.getID()].length - 1) * (Dreiding.this.ctab[this.a3.getID()].length - 1);
            this.prefix = 0.5 * this.v / (double)ntors;
        }

        @Override
        protected void calc_E_dE() {
            this.e = 0.0;
            this.dE = 0.0;
            if (Dreiding.this.whatToCalc != null && Dreiding.this.whatToCalc.get(2)) {
                return;
            }
            double d = MolGeom.dihedralDifference(this.psi, this.psi0);
            this.e = this.prefix * (1.0 - CXNForceField.cleanTrig(Math.cos((double)this.n * d)));
            if (Dreiding.this.wishDerivates) {
                this.dE = this.prefix * (double)this.n * CXNForceField.cleanTrig(Math.sin((double)this.n * d));
            }
        }
    }

    private class DreidingAngleCos
    extends DreidingAngle {
        @Override
        public String toString() {
            return "cos-type " + super.toString();
        }

        public DreidingAngleCos(DreidingBond b1, DreidingBond b2) throws CXNForceField.FFComponentException {
            super(b1, b2);
        }

        @Override
        protected void calc_E_dE() {
            this.e = 0.0;
            this.dE = 0.0;
            if (Dreiding.this.whatToCalc != null && Dreiding.this.whatToCalc.get(1)) {
                return;
            }
            double x = this.getAngleCos() - this.x0;
            if (this.x0 == -1.0) {
                this.e = this.k * (1.0 + this.getAngleCos());
                if (Dreiding.this.wishDerivates) {
                    this.dE = -1.0 * this.k * this.getAngleSin();
                }
            } else {
                double c = this.k / (1.0 - this.x0 * this.x0);
                this.e = 0.5 * c * x * x;
                if (Dreiding.this.wishDerivates) {
                    this.dE = -1.0 * c * x * this.getAngleSin();
                }
            }
        }

        @Override
        public double getEqulibriumAngle() {
            return ((DreidingAtom)this.getA2()).getType().getCosAngle();
        }
    }

    private class DreidingAngle
    extends CXNForceField.FFAngle {
        double k;
        double x0;

        @Override
        public String toString() {
            return super.toString() + " Angle0: " + MolGeom.forHumans(this.x0) + " K: " + this.k;
        }

        public DreidingAngle(DreidingBond b1, DreidingBond b2) throws CXNForceField.FFComponentException {
            super(b1, b2);
            this.k = 0.0;
            this.x0 = 0.0;
            DreidingAtomType t1 = ((DreidingAtom)this.getA1()).getType();
            DreidingAtomType t2 = ((DreidingAtom)this.getA2()).getType();
            DreidingAtomType t3 = ((DreidingAtom)this.getA3()).getType();
            DreidingAtomType t = t2;
            double s = t.getAngleScale();
            if (t2.isSp2() && (t1.isTransitionMetal() || t3.isTransitionMetal())) {
                t = types[57];
                s = 0.0;
                if (Dreiding.this.ctab[this.getA2().getID()].length == 3) {
                    s = 0.1;
                }
            }
            if (t2.getId() == 9 && (Dreiding.this.isAmideNitrogen(this.getA1().getID()) || Dreiding.this.isAmideNitrogen(this.getA1().getID()))) {
                s = 0.9;
            }
            this.k = 100.0 * s;
            this.x0 = t.getAngleRad();
        }

        private boolean hasAtomToDenyInversion() {
            if (((DreidingAtom)this.getA1()).getType().isTransitionMetal()) {
                return true;
            }
            return ((DreidingAtom)this.getA3()).getType().isTransitionMetal();
        }

        @Override
        protected void calc_E_dE() {
            this.e = 0.0;
            this.dE = 0.0;
            if (Dreiding.this.whatToCalc != null && Dreiding.this.whatToCalc.get(1) || this.k == 0.0) {
                return;
            }
            double x = this.getAngle() - this.x0;
            this.e = 0.5 * this.k * x * x;
            if (Dreiding.this.wishDerivates) {
                this.dE = this.k * x;
            }
        }

        @Override
        public double getEqulibriumAngle() {
            return ((DreidingAtom)this.getA2()).getType().getAngleRad();
        }
    }

    private class DreidingAngleAutoFlush
    extends DreidingAngle {
        public DreidingAngleAutoFlush(DreidingBond b1, DreidingBond b2) throws CXNForceField.FFComponentException {
            super(b1, b2);
        }

        @Override
        public double getAngle() {
            this.angle = Math.acos(this.getAngleCos());
            if (this.angle > Math.PI) {
                this.angle = Math.PI;
            }
            if (this.angle < 0.0) {
                this.angle = 0.0;
            }
            return this.angle;
        }

        @Override
        public double getAngleCos() {
            this.angleCos = CXNForceField.myCos(this.getNormalizedV1(), this.getNormalizedV2());
            this.angleCosCalculated = true;
            return this.angleCos;
        }

        @Override
        public double getAngleCosSq() {
            this.angleCosSq = this.getAngleCos() * this.getAngleCos();
            this.angleCosSqCalculated = true;
            return this.angleCosSq;
        }

        @Override
        public double getAngleSin() {
            this.angleSin = Math.sqrt(this.getAngleSinSq());
            this.angleSinCalculated = true;
            return this.angleSin;
        }

        @Override
        public double getAngleSinSq() {
            this.angleSinSq = 1.0 - this.getAngleCosSq();
            this.angleSinSqCalculated = true;
            return this.angleSinSq;
        }

        @Override
        public double[] getV1Xv2() {
            MolGeom.getVector3D(this.v1, this.v2, this.v1Xv2);
            this.v1Xv2Calculated = true;
            return this.v1Xv2;
        }
    }

    private class DreidingCorrectedAngle
    extends DreidingAngle {
        public DreidingCorrectedAngle(DreidingBond b1, DreidingBond b2) throws CXNForceField.FFComponentException {
            super(b1, b2);
        }

        @Override
        public String toString() {
            return "CORRECTED " + super.toString();
        }

        @Override
        protected void calc_E_dE() {
            this.e = 0.0;
            this.dE = 0.0;
            if (Dreiding.this.whatToCalc != null && Dreiding.this.whatToCalc.get(1) || this.k == 0.0) {
                return;
            }
            double x = this.getAngle();
            if (Dreiding.this.diagnosticObserver != null) {
                Dreiding.this.diagnosticObserver.notifyAngleEvaluation(-1, -1, -1, x, this.getEqulibriumAngle());
            }
            int section = 0;
            if (x > Dreiding.this.angleScaleUpperInterval) {
                section = 1;
            } else if (x < Dreiding.this.angleScaleLowerInterval) {
                section = 2;
                if (Dreiding.this.diagnosticObserver != null && !Dreiding.this.diagnosticObserver.isTuneEnabled(4)) {
                    section = 0;
                }
            } else {
                section = 0;
            }
            switch (section) {
                case 0: {
                    double diff = x - this.x0;
                    this.e = 0.5 * this.k * diff * diff;
                    if (!Dreiding.this.wishDerivates) break;
                    this.dE = this.k * diff;
                    break;
                }
                case 1: {
                    double phi = Dreiding.this.angleScaleUpperInterval;
                    double p = Math.PI;
                    double pp = p - phi;
                    double xp = x - phi;
                    this.e = 0.5 * this.k * this.x0 * this.x0 - this.k * x * this.x0 + 0.5 * this.k * x * x - 0.3333333333333333 * (this.k * p - this.k * this.x0) / pp / pp * xp * xp * xp;
                    if (!Dreiding.this.wishDerivates) break;
                    this.dE = -(this.k * this.x0) + this.k * x - this.k * (p - this.x0) / pp / pp * xp * xp;
                    break;
                }
                case 2: {
                    double xl = Dreiding.this.angleScaleLowerInterval;
                    this.e = 0.5 * this.k * this.x0 * this.x0 - this.k * this.x0 * xl / 3.0 - 0.5 * (2.0 * this.k * this.x0 / xl - this.k) * x * x + this.k * this.x0 * x * x * x / (3.0 * xl * xl);
                    if (!Dreiding.this.wishDerivates) break;
                    this.dE = -(2.0 * this.k * this.x0 / xl - this.k) * x + this.k * this.x0 * x * x / (xl * xl);
                    break;
                }
            }
        }
    }

    private class DreidingBondAutoFlush
    extends DreidingBond {
        DreidingBondAutoFlush(DreidingAtom datom1, DreidingAtom datom2, int type, int bondSeq) {
            super(datom1, datom2, type, bondSeq);
        }

        @Override
        void calcGeom() {
            this.vec[0] = this.a2.getCoordinate(0) - this.a1.getCoordinate(0);
            this.vec[1] = this.a2.getCoordinate(1) - this.a1.getCoordinate(1);
            this.vec[2] = this.a2.getCoordinate(2) - this.a1.getCoordinate(2);
            this.length = MolGeom.getLength(this.vec);
            V.copyV(this.normalizedVec, this.vec);
            V.normalizeSafe(this.normalizedVec);
            MolGeom.cpVec(this.vec, this.ivec);
            MolGeom.cpVec(this.normalizedVec, this.inormalizedVec);
            MolGeom.mul(this.inormalizedVec, -1.0);
            MolGeom.mul(this.ivec, -1.0);
        }
    }

    private class DreidingBond
    extends CXNForceField.FFBond {
        double k;
        double rEq;

        public DreidingBond(DreidingAtom datom1, DreidingAtom datom2, int type, int bondSeq) {
            super(datom1, datom2, type, bondSeq);
            this.k = 0.0;
            this.rEq = 0.0;
            DreidingAtomType t1 = ((DreidingAtom)this.getA1()).getType();
            DreidingAtomType t2 = ((DreidingAtom)this.getA2()).getType();
            double scale = 1.0;
            if (this.getType() == 2) {
                scale = 2.0;
            } else if (this.getType() == 3) {
                scale = 3.0;
            } else if (this.getType() == 4) {
                scale = 1.5;
            }
            if (t1.getId() == 61 || t2.getId() == 61) {
                scale *= 0.3;
            }
            this.k = 700.0 * scale;
            this.rEq = Dreiding.eqBond(t1, t2);
        }

        @Override
        public String toString() {
            DecimalFormat f = new DecimalFormat("0.00");
            return super.toString() + " k:" + this.k + " r0" + f.format(this.rEq);
        }

        @Override
        protected void calc_E_dE() {
            this.e = 0.0;
            this.dE = 0.0;
            if (Dreiding.this.whatToCalc != null && Dreiding.this.whatToCalc.get(0)) {
                return;
            }
            double x = super.getLength() - this.rEq;
            this.e = 0.5 * this.k * x * x;
            if (Dreiding.this.wishDerivates) {
                this.dE = this.k * x;
            }
        }
    }

    private class DreidingAtom
    extends CXNForceField.FFAtom {
        private final DreidingAtomType type;

        public DreidingAtom(int atomSeqInMol) {
            super(atomSeqInMol);
            DreidingAtomType d = null;
            MolAtom a = Dreiding.this.mol.getAtom(atomSeqInMol);
            int hyb = Dreiding.this.getHybr(atomSeqInMol);
            int neigh = Dreiding.this.ctab[atomSeqInMol].length;
            int neighLP = Dreiding.this.neighbourCountWithoutLonePairs(atomSeqInMol);
            switch (a.getAtno()) {
                case 130: {
                    d = types[58];
                    break;
                }
                case 1: {
                    if (Dreiding.this.neighAt(atomSeqInMol, 5) == 2) {
                        d = types[2];
                        break;
                    }
                    if (Dreiding.this.neighAt(atomSeqInMol, 7) == 1) {
                        d = types[1];
                        break;
                    }
                    if (Dreiding.this.neighAt(atomSeqInMol, 8) == 1) {
                        d = types[1];
                        break;
                    }
                    if (Dreiding.this.neighAt(atomSeqInMol, 9) == 1) {
                        d = types[1];
                        break;
                    }
                    if (Dreiding.this.neighAt(atomSeqInMol, 16) == 1) {
                        d = types[1];
                        break;
                    }
                    if (Dreiding.this.neighAt(atomSeqInMol, 17) == 1) {
                        d = types[1];
                        break;
                    }
                    d = types[0];
                    break;
                }
                case 3: {
                    d = types[42];
                    break;
                }
                case 5: {
                    if (hyb == 3) {
                        d = types[3];
                    }
                    if (hyb == 2) {
                        d = types[4];
                    }
                    if (hyb != 4) break;
                    d = types[4];
                    break;
                }
                case 6: {
                    d = types[5];
                    if (hyb == 3) {
                        if (neigh == 4) {
                            d = types[5];
                            break;
                        }
                        if (neigh == 3) {
                            d = types[41];
                            break;
                        }
                        if (neigh == 2) {
                            d = types[40];
                            break;
                        }
                        if (neigh == 1) {
                            d = types[39];
                            break;
                        }
                        if (neigh != 0) break;
                        d = types[38];
                        break;
                    }
                    if (hyb == 2) {
                        d = types[7];
                        if (Dreiding.this.isInCycloPropeneLikeRing(atomSeqInMol)) {
                            d = types[57];
                        }
                        if (!Dreiding.this.isCarbonylCarbon(atomSeqInMol)) break;
                        d = types[60];
                        break;
                    }
                    if (hyb == 4) {
                        d = types[6];
                        if (neigh != 2) break;
                        d = types[37];
                        break;
                    }
                    if (hyb != 1) break;
                    d = types[8];
                    break;
                }
                case 7: {
                    if (hyb == 3) {
                        int i;
                        int n;
                        int jj;
                        d = types[9];
                        if (Dreiding.this.isAmideNitrogen(atomSeqInMol)) {
                            d = types[10];
                            break;
                        }
                        if (neighLP < 4) {
                            for (jj = 0; jj < neigh; ++jj) {
                                n = Dreiding.this.ctab[atomSeqInMol][jj];
                                if (Dreiding.this.getHybr(n) != 2 || Dreiding.this.mol.getAtom(n).getAtno() != 7) continue;
                                for (i = 0; i < Dreiding.this.ctab[n].length; ++i) {
                                    int nn = Dreiding.this.ctab[n][i];
                                    int atn = Dreiding.this.mol.getAtom(nn).getAtno();
                                    int bt = Dreiding.this.mol.getBond(Dreiding.this.btab.getBondIndex(n, nn)).getType();
                                    if (bt != 2 || atn != 6) continue;
                                    d = types[10];
                                }
                            }
                        }
                        if (neighLP >= 4) break;
                        for (jj = 0; jj < neigh; ++jj) {
                            n = Dreiding.this.ctab[atomSeqInMol][jj];
                            if ((Dreiding.this.getHybr(n) == 2 || Dreiding.this.getHybr(n) == 4) && Dreiding.this.mol.getAtom(n).getAtno() == 6) {
                                d = types[10];
                            }
                            block32: for (i = 0; i < neigh - 1; ++i) {
                                if (Dreiding.this.isAmideNitrogen(Dreiding.this.ctab[atomSeqInMol][i])) {
                                    d = types[9];
                                    break;
                                }
                                for (int j = 1; j < neigh; ++j) {
                                    if (Dreiding.this.btab.getBondIndex(Dreiding.this.ctab[atomSeqInMol][i], Dreiding.this.ctab[atomSeqInMol][j]) == -1) continue;
                                    d = types[9];
                                    continue block32;
                                }
                            }
                            if (!Dreiding.this.isAmideNitrogen(Dreiding.this.ctab[atomSeqInMol][neigh - 1])) continue;
                            d = types[9];
                        }
                        break;
                    }
                    if (hyb == 2) {
                        d = types[11];
                        break;
                    }
                    if (hyb == 4) {
                        d = types[10];
                        break;
                    }
                    if (hyb != 1) break;
                    d = types[12];
                    break;
                }
                case 8: {
                    if (hyb == 3) {
                        d = types[13];
                        if (neighLP >= 3) break;
                        for (int jj = 0; jj < neigh; ++jj) {
                            int j = Dreiding.this.ctab[atomSeqInMol][jj];
                            boolean neighbourHasOxo = false;
                            for (int i = 0; i < Dreiding.this.ctab[j].length && !neighbourHasOxo; ++i) {
                                neighbourHasOxo = Dreiding.this.isCarboxilOxigen(Dreiding.this.ctab[j][i]);
                            }
                            int neighZ = Dreiding.this.mol.getAtom(j).getAtno();
                            if (!neighbourHasOxo || neighZ >= 10) continue;
                            d = types[59];
                        }
                        break;
                    }
                    if (hyb == 2) {
                        d = types[15];
                        break;
                    }
                    if (hyb == 4) {
                        d = types[14];
                        break;
                    }
                    if (hyb != 1) break;
                    d = types[16];
                    break;
                }
                case 9: {
                    d = types[17];
                    break;
                }
                case 13: {
                    if (neigh < 5) {
                        d = types[18];
                        break;
                    }
                    d = types[44];
                    break;
                }
                case 14: {
                    if (neigh < 5 && !Dreiding.this.isInCycloPropeneLikeRing(atomSeqInMol)) {
                        d = types[19];
                        break;
                    }
                    d = types[45];
                    break;
                }
                case 15: {
                    if (neigh < 5) {
                        d = types[20];
                        break;
                    }
                    d = types[56];
                    break;
                }
                case 16: {
                    if (neigh < 5) {
                        d = types[21];
                        break;
                    }
                    d = types[43];
                    break;
                }
                case 17: {
                    d = types[22];
                    break;
                }
                case 31: {
                    if (neigh < 5) {
                        d = types[23];
                        break;
                    }
                    d = types[46];
                    break;
                }
                case 32: {
                    if (neigh < 5) {
                        d = types[24];
                        break;
                    }
                    d = types[47];
                    break;
                }
                case 33: {
                    if (neigh < 5) {
                        d = types[25];
                        break;
                    }
                    d = types[48];
                    break;
                }
                case 34: {
                    if (neigh < 5) {
                        d = types[26];
                        break;
                    }
                    d = types[49];
                    break;
                }
                case 35: {
                    d = types[27];
                    break;
                }
                case 49: {
                    if (neigh < 5) {
                        d = types[28];
                        break;
                    }
                    d = types[50];
                    break;
                }
                case 50: {
                    if (neigh < 4) {
                        d = types[29];
                        break;
                    }
                    d = types[51];
                    break;
                }
                case 51: {
                    if (neigh < 4) {
                        d = types[30];
                        break;
                    }
                    d = types[52];
                    break;
                }
                case 52: {
                    if (neigh < 4) {
                        d = types[31];
                        break;
                    }
                    d = types[53];
                    break;
                }
                case 53: {
                    d = types[32];
                    break;
                }
                case 11: {
                    d = types[33];
                    break;
                }
                case 20: {
                    d = types[34];
                    break;
                }
                case 26: {
                    if (neigh < 4) {
                        d = types[35];
                        break;
                    }
                    d = types[54];
                    break;
                }
                case 30: {
                    d = neigh < 4 ? types[36] : types[55];
                }
            }
            if (d == null) {
                d = new DreidingAtomType(61, "DEFAULT", 3, a.getAtno(), 1.5, -1.0, 3.14159265, 180.0, 4.0, 12.0, 0.055, 0.1);
            }
            this.type = d;
        }

        public DreidingAtomType getType() {
            return this.type;
        }

        @Override
        public String toString() {
            MolAtom a = Dreiding.this.mol.getAtom(super.getID());
            return super.toString() + " HYB: " + this.type.getHybridization() + "\tATNO: " + a.getAtno() + " LABEL: " + this.type.getLabel() + "\n";
        }
    }

    public static class DreidingAtomType {
        private final int hybridization;
        private final double bondRadius;
        private final double cosAngle;
        private final double angleRad;
        private final double angleDeg;
        private double vdWR0;
        private final double vdWKhi0;
        private final double vdWD0;
        private final int atomicNumber;
        private final String label;
        private int id;
        private boolean transitionMetal;
        private boolean oxigenColumn;
        private boolean useVdwInAngleTerm;
        private double angleScale = 1.0;

        public DreidingAtomType(int id, String label, int hybridization, int atomicNumber, double bondRadius, double cosAngle, double angleRad, double angleDeg, double vdWR0, double vdWKhi0, double vdWD0, double angleScale) {
            this.id = id;
            this.angleScale = angleScale;
            this.label = label;
            this.hybridization = hybridization;
            this.atomicNumber = atomicNumber;
            this.bondRadius = bondRadius;
            this.cosAngle = cosAngle;
            this.angleRad = angleRad;
            this.angleDeg = angleDeg;
            this.vdWR0 = vdWR0;
            this.vdWKhi0 = vdWKhi0;
            this.vdWD0 = vdWD0;
            this.transitionMetal = Dreiding.isTransitionMetal(atomicNumber);
            this.oxigenColumn = Dreiding.isOxigenColumn(atomicNumber);
            this.useVdwInAngleTerm = this.transitionMetal;
            if (atomicNumber >= 13 && atomicNumber <= 16) {
                this.useVdwInAngleTerm = true;
            }
            if (atomicNumber >= 31 && atomicNumber < 34) {
                this.useVdwInAngleTerm = true;
            }
            if (atomicNumber >= 49 && atomicNumber <= 53) {
                this.useVdwInAngleTerm = true;
            }
            if (atomicNumber == 11 && atomicNumber == 20) {
                this.useVdwInAngleTerm = true;
            }
        }

        public double getAngleScale() {
            return this.angleScale;
        }

        public String getLabel() {
            return this.label;
        }

        public double getAngleDeg() {
            return this.angleDeg;
        }

        public double getAngleRad() {
            return this.angleRad;
        }

        public double getBondRadius() {
            return this.bondRadius;
        }

        public double getCosAngle() {
            return this.cosAngle;
        }

        public int getHybridization() {
            return this.hybridization;
        }

        public double getVdWD0() {
            return this.vdWD0;
        }

        public double getVdWKhi0() {
            return this.vdWKhi0;
        }

        public double getVdWR0() {
            return this.vdWR0;
        }

        public int getAtomicNumber() {
            return this.atomicNumber;
        }

        public int getId() {
            return this.id;
        }

        public boolean isOxigenColumn() {
            return this.oxigenColumn;
        }

        public boolean isTransitionMetal() {
            return this.transitionMetal;
        }

        public boolean isUseVdwInAngleTerm() {
            return this.useVdwInAngleTerm;
        }

        public boolean isSp2() {
            return this.getHybridization() % 2 == 0;
        }
    }
}

