/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm;

public class ProxScaledVdw {
    private double r0;
    private double d0;
    private double w1;
    private double w2;
    private double r06;
    private double r;
    private double r6;
    private double w22;
    private double w24;
    private double w26;
    private double w214_w1_w2;
    private double w12;

    public void init(double r0, double d0) {
        this.init(r0, d0, 0.2, 0.5);
    }

    public void init(double r0, double d0, double w1, double w2) {
        this.r0 = r0;
        this.d0 = d0;
        this.w1 = w1;
        this.w2 = w2;
        this.r06 = r0 * r0 * r0;
        this.r06 *= this.r06;
        this.w22 = w2 * w2;
        this.w24 = this.w22 * this.w22;
        this.w26 = this.w24 * this.w22;
        double w214 = this.w26 * this.w24 * this.w24;
        this.w214_w1_w2 = w214 * (w1 + w2);
        this.w12 = w1 * w1;
    }

    public void setR(double r) {
        this.r = r;
        this.r6 = r * r * r;
        this.r6 *= this.r6;
    }

    private double ddF() {
        return 12.0 * this.d0 * this.r06 * (-7.0 * this.r6 + 13.0 * this.r06) / (this.r6 * this.r6 * this.r * this.r);
    }

    private double dF() {
        return 12.0 * this.d0 * this.r06 * (this.r6 - this.r06) / (this.r6 * this.r6 * this.r);
    }

    private double F() {
        double f = 0.0;
        double rho6 = this.r6 / this.r06;
        double rho12 = rho6 * rho6;
        f = this.d0 / rho12 - 2.0 * this.d0 / rho6;
        return f;
    }

    private double ddG() {
        double d = (this.w1 - this.w2) * this.w214_w1_w2;
        return 12.0 * this.d0 * this.r06 * (this.w26 * (-7.0 * this.w12 + (16.0 * this.r - 9.0 * this.w2) * this.w2) + this.r06 * (13.0 * this.w12 + this.w2 * (-28.0 * this.r + 15.0 * this.w2))) / d;
    }

    private double dG() {
        return 12.0 * this.d0 * this.r06 * (2.0 * this.w12 * this.w2 * (-7.0 * this.r06 + 4.0 * this.w26) + this.r * this.r * (-14.0 * this.r06 * this.w2 + 8.0 * this.w26 * this.w2) + this.r * (-7.0 * this.w12 * this.w26 - 9.0 * this.w22 * this.w26 + this.r06 * (13.0 * this.w12 + 15.0 * this.w22))) / ((this.w1 - this.w2) * this.w214_w1_w2);
    }

    private double G() {
        return this.d0 * this.r06 * (8.0 * this.w24 * this.w24 * (7.0 * this.w12 - 3.0 * this.w22) + this.r06 * (-91.0 * this.w12 * this.w22 + 35.0 * this.w24) + 24.0 * this.r * this.w12 * this.w2 * (7.0 * this.r06 - 4.0 * this.w26) + 8.0 * this.r * this.r * this.r * (7.0 * this.r06 * this.w2 - 4.0 * this.w26 * this.w2) + 6.0 * this.r * this.r * (7.0 * this.w12 * this.w26 + 9.0 * this.w24 * this.w24 - this.r06 * (13.0 * this.w12 + 15.0 * this.w22))) / (this.w214_w1_w2 * (-this.w1 + this.w2));
    }

    private double ddH() {
        return 12.0 * this.d0 * this.r06 * (this.r06 * (13.0 * this.w1 - 15.0 * this.w2) + this.w26 * (-7.0 * this.w1 + 9.0 * this.w2)) / this.w214_w1_w2;
    }

    private double dH() {
        return 12.0 * this.d0 * this.r * this.r06 * (this.r06 * (13.0 * this.w1 - 15.0 * this.w2) + this.w26 * (-7.0 * this.w1 + 9.0 * this.w2)) / this.w214_w1_w2;
    }

    private double H() {
        return this.d0 * this.r06 * (6.0 * this.r * this.r * (this.r06 * (13.0 * this.w1 - 15.0 * this.w2) + this.w26 * (-7.0 * this.w1 + 9.0 * this.w2)) + this.w2 * (-7.0 * this.r06 * (8.0 * this.w12 - 5.0 * this.w1 * this.w2 - 5.0 * this.w22) - 8.0 * this.w26 * (-4.0 * this.w12 + 3.0 * this.w1 * this.w2 + 3.0 * this.w22))) / this.w214_w1_w2;
    }

    public double getSecDer() {
        if (this.r > this.w2) {
            return this.ddF();
        }
        if (this.r <= this.w2 && this.r > this.w1) {
            return this.ddG();
        }
        if (this.r <= this.w1) {
            return this.ddH();
        }
        throw new UnsupportedOperationException("Value out of range: " + this.r + " " + this.w1 + " " + this.w2);
    }

    public double getDer() {
        if (this.r > this.w2) {
            return this.dF();
        }
        if (this.r <= this.w2 && this.r > this.w1) {
            return this.dG();
        }
        if (this.r <= this.w1) {
            return this.dH();
        }
        throw new UnsupportedOperationException("Value out of range: " + this.r + " " + this.w1 + " " + this.w2);
    }

    public double getValue() {
        if (this.r > this.w2) {
            return this.F();
        }
        if (this.r <= this.w2 && this.r > this.w1) {
            return this.G();
        }
        if (this.r <= this.w1) {
            return this.H();
        }
        throw new UnsupportedOperationException("Value out of range: " + this.r + " " + this.w1 + " " + this.w2);
    }

    private void equals(double a, double b) {
        double max;
        double min = Math.min(a, b);
        if (min / (max = Math.max(a, b)) < 0.97) {
            throw new UnsupportedOperationException(a + " != " + b);
        }
    }

    public void test() {
        this.setR(this.w1);
        this.equals(this.H(), this.G());
        this.equals(this.dH(), this.dG());
        this.equals(this.ddH(), this.ddG());
        this.setR(this.w2);
        this.equals(this.F(), this.G());
        this.equals(this.dF(), this.dG());
        this.equals(this.ddF(), this.ddG());
    }
}

