/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.mm.mmff94.AngleParameters;
import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.FFProviderHM;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.Tools;
import chemaxon.marvin.modelling.mm.mmff94.XMLParser;
import chemaxon.marvin.modelling.mm.mmff94.extra.ExtraAngleParameters;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AngleHashMap
extends FFProviderHM {
    @Deprecated
    public FFComponentProvider getParams(int at, int iType, int jType, int kType) {
        if (this.getParams(at + " " + iType + " " + jType + " " + kType) != null) {
            return this.getParams(at + " " + iType + " " + jType + " " + kType);
        }
        if (this.getParams(at + " " + kType + " " + jType + " " + iType) != null) {
            return this.getParams(at + " " + kType + " " + jType + " " + iType);
        }
        return null;
    }

    public FFComponentProvider getParams(int angleType, int[] atomIndeces, MMFFMolecule mol) {
        String key = angleType + " " + this.getKeyForIndeces(atomIndeces, mol);
        if (this.getParams(key) != null) {
            return this.getParams(key);
        }
        key = angleType + " 0 " + Tools.getAtomType(atomIndeces[1], mol) + " 0";
        if (this.getParams(key) != null) {
            ExtraAngleParameters ret = (ExtraAngleParameters)this.extraComponentProviderHM.getParams(atomIndeces, mol);
            ret.setTheta0(this.getParams(key).getOptimalValues()[0]);
            return ret;
        }
        return (ExtraAngleParameters)this.extraComponentProviderHM.getParams(atomIndeces, mol);
    }

    @Override
    public void xmlImport(XMLParser xml) {
        NodeList nl = xml.readParameters("angle");
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            AngleParameters ap = new AngleParameters();
            ap.setAt(Integer.parseInt(((Element)nl.item(i)).getAttribute("AT")));
            ap.setI(Integer.parseInt(((Element)nl.item(i)).getAttribute("i")));
            ap.setJ(Integer.parseInt(((Element)nl.item(i)).getAttribute("j")));
            ap.setK(Integer.parseInt(((Element)nl.item(i)).getAttribute("k")));
            ap.setKa(Double.parseDouble(((Element)nl.item(i)).getAttribute("ka")));
            ap.setTheta0(Double.parseDouble(((Element)nl.item(i)).getAttribute("theta0")) * Math.PI / 180.0);
            ap.setSource(((Element)nl.item(i)).getAttribute("source"));
            ap.setSmiles(((Element)nl.item(i)).getAttribute("smiles"));
            String key = ap.getAt() + " " + ap.getI() + " " + ap.getJ() + " " + ap.getK();
            this.addParams(key, ap);
        }
    }
}

