/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.linalg.internals.Internals;
import chemaxon.marvin.modelling.mm.mmff94.AngleComponent;
import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.LinearAngleComponent;
import chemaxon.marvin.modelling.mm.mmff94.MMFFComponent;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.MultipleFFComponentProvider;

public class AngleParameters
extends MultipleFFComponentProvider
implements FFComponentProvider {
    private int at;
    private int i;
    private int j;
    private int k;
    private double ka;
    private double theta0;
    private String source;
    private String smiles;

    public int getAt() {
        return this.at;
    }

    public void setAt(int at) {
        this.at = at;
    }

    public int getI() {
        return this.i;
    }

    public void setI(int i) {
        this.i = i;
    }

    public int getJ() {
        return this.j;
    }

    public void setJ(int j) {
        this.j = j;
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }

    public double getKa() {
        return this.ka;
    }

    public void setKa(double ka) {
        this.ka = ka;
    }

    public double getTheta0() {
        return this.theta0;
    }

    public void setTheta0(double theta0) {
        this.theta0 = theta0;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSmiles() {
        return this.smiles;
    }

    public void setSmiles(String smiles) {
        this.smiles = smiles;
    }

    @Deprecated
    public MMFFComponent getComponent(int[] atomIndeces, double[] coordinates) {
        return null;
    }

    @Override
    public MMFFComponent getComponent(InternalCoordinate q, MMFFMolecule mol) {
        double eps = 0.001;
        if (this.getOptimalValues()[0] < Math.PI + eps && this.getOptimalValues()[0] > Math.PI - eps) {
            LinearAngleComponent lac = new LinearAngleComponent();
            lac.setKa(this.ka);
            if (q.getType() == 2) {
                Internals.InternalCosAngle ic = new Internals.InternalCosAngle(q.getCartesianCoordinates(), q.getAtomIndeces());
                mol.getIntCoordSystem().replaceInternalCoordinate(q, ic);
                lac.setInternalCoordinate(ic);
            } else {
                lac.setInternalCoordinate(q);
            }
            return lac;
        }
        AngleComponent ac = new AngleComponent();
        ac.setKa(this.ka);
        ac.setTheta0(this.getOptimalValues()[0]);
        if (q.getType() == 6) {
            Internals.InternalBondAngle ic = new Internals.InternalBondAngle(q.getCartesianCoordinates(), q.getAtomIndeces());
            mol.getIntCoordSystem().replaceInternalCoordinate(q, ic);
            ac.setInternalCoordinate(ic);
        } else {
            ac.setInternalCoordinate(q);
        }
        return ac;
    }

    @Override
    public double[] getOptimalValues() {
        double[] optVal = new double[]{this.theta0};
        return optVal;
    }
}

