/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.mm.mmff94.BondCharge;
import chemaxon.marvin.modelling.mm.mmff94.NonBondedComponent;
import chemaxon.marvin.modelling.mm.mmff94.Tools;
import chemaxon.marvin.modelling.mm.mmff94.XMLParser;
import chemaxon.struc.Molecule;
import java.util.BitSet;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Charges
extends NonBondedComponent {
    private static HashMap<String, BondCharge> bondCharges;
    private static double[] partBondCharges;
    private static double[] primCharges;
    private static double[] theta;
    private double[] partAtomCharges = null;
    private static double l;
    private double e;
    private double de;

    private int getNeighborCount(Molecule m, int k) {
        int[][] ctab = m.getCtab();
        return ctab[k].length;
    }

    private int getNeighbor(Molecule m, int k, int i) {
        int[][] ctab = m.getCtab();
        return ctab[k][i];
    }

    public double[] getPartialAtomCharges() {
        int i;
        this.partAtomCharges = new double[this.mol.getMolecule().getAtomCount()];
        Molecule m = this.mol.getMolecule();
        for (i = 0; i < this.partAtomCharges.length; ++i) {
            int iType = Tools.getAtomType(i, this.mol);
            int n = i;
            this.partAtomCharges[n] = this.partAtomCharges[n] + this.mol.getFormalCharge(i);
            for (int j = 0; j < this.getNeighborCount(m, i); ++j) {
                int k = this.getNeighbor(m, i, j);
                int n2 = i;
                this.partAtomCharges[n2] = this.partAtomCharges[n2] - theta[iType] * this.mol.getFormalCharge(i);
                int n3 = k;
                this.partAtomCharges[n3] = this.partAtomCharges[n3] + theta[iType] * this.mol.getFormalCharge(i);
            }
        }
        i = 0;
        while (i < this.partAtomCharges.length) {
            double sumOmega = 0.0;
            for (int j = 0; j < this.getNeighborCount(m, i); ++j) {
                sumOmega += this.getOmega(this.getNeighbor(m, i, j), i);
            }
            int n = i++;
            this.partAtomCharges[n] = this.partAtomCharges[n] + sumOmega;
        }
        return this.partAtomCharges;
    }

    public static void readParameters(XMLParser xml) {
        int i;
        bondCharges = new HashMap();
        NodeList nl = xml.readParameters("electrostatic-bond-charge-increments");
        for (i = 0; i < nl.getLength(); ++i) {
            BondCharge bc = new BondCharge();
            bc.setBT(Integer.parseInt(((Element)nl.item(i)).getAttribute("bt")));
            bc.setIType(Integer.parseInt(((Element)nl.item(i)).getAttribute("i")));
            bc.setJType(Integer.parseInt(((Element)nl.item(i)).getAttribute("j")));
            bc.setCharge(Double.parseDouble(((Element)nl.item(i)).getAttribute("bci")));
            bc.setSource(((Element)nl.item(i)).getAttribute("source"));
            bondCharges.put(bc.getKey(), bc);
        }
        nl = xml.readParameters("electrostatic-partial-bond-charge");
        partBondCharges = new double[100];
        theta = new double[100];
        primCharges = new double[100];
        for (i = 0; i < nl.getLength(); ++i) {
            int type = Integer.parseInt(((Element)nl.item(i)).getAttribute("atomtype"));
            Charges.partBondCharges[type] = Double.parseDouble(((Element)nl.item(i)).getAttribute("pbc"));
            Charges.theta[type] = Double.parseDouble(((Element)nl.item(i)).getAttribute("theta"));
            Charges.primCharges[type] = Double.parseDouble(((Element)nl.item(i)).getAttribute("pcharge"));
        }
    }

    private BondCharge getBondCharge(int bt, int iType, int jType) {
        return bondCharges.get(bt + " " + iType + " " + jType);
    }

    private double getOmega(int kAtom, int iAtom) {
        int[] atomIndeces = new int[]{kAtom, iAtom};
        int kType = Tools.getAtomType(kAtom, this.mol);
        int iType = Tools.getAtomType(iAtom, this.mol);
        int bondType = Tools.getBondType(atomIndeces, this.mol);
        if (this.getBondCharge(bondType, kType, iType) != null) {
            return this.getBondCharge(bondType, kType, iType).getCharge();
        }
        if (this.getBondCharge(bondType, iType, kType) != null) {
            return -this.getBondCharge(bondType, iType, kType).getCharge();
        }
        return partBondCharges[iType] - partBondCharges[kType];
    }

    public double getE(int i, int j) {
        this.calcIJ(i, j);
        return this.e;
    }

    public double getdE(int i, int j) {
        this.calcIJ(i, j);
        return this.de;
    }

    private void calcIJ(int i, int j) {
        this.coord = this.mol.getIntCoordSystem().getCartesianCoordinates();
        BitSet[] closeAtoms = this.mol.getIntCoordSystem().getCloseAtoms();
        BitSet[] close14Atoms = this.mol.getIntCoordSystem().getClose14Atoms();
        if (!closeAtoms[i].get(j)) {
            if (close14Atoms[i].get(j)) {
                this.r = this.getDist(i, j);
                if (this.r < l) {
                    this.e = 0.75 * this.function.scaledElectr(this.r, l, this.partAtomCharges[i], partBondCharges[j]);
                    this.de = 0.75 * this.function.scaledElectrDer(this.r);
                } else {
                    this.e = 0.75 * this.function.electr(this.r, this.partAtomCharges[i], this.partAtomCharges[j]);
                    this.de = 0.75 * this.function.electrDer();
                }
            } else {
                this.r = this.getDist(i, j);
                if (this.r < l) {
                    this.e = this.function.scaledElectr(this.r, l, this.partAtomCharges[i], partBondCharges[j]);
                    this.de = this.function.scaledElectrDer(this.r);
                } else {
                    this.e = this.function.electr(this.r, this.partAtomCharges[i], this.partAtomCharges[j]);
                    this.de = this.function.electrDer();
                }
            }
        }
    }

    @Override
    protected void calc() {
        int maxIndex = this.mol.getMolecule().getAtomCount();
        this.coord = this.mol.getIntCoordSystem().getCartesianCoordinates();
        this.energy = 0.0;
        double de = 0.0;
        if (this.gradient == null || this.gradient.length != 3 * maxIndex) {
            this.gradient = new double[3 * maxIndex];
        }
        for (int i = 0; i < this.gradient.length; ++i) {
            this.gradient[i] = 0.0;
        }
        BitSet[] closeAtoms = this.mol.getIntCoordSystem().getCloseAtoms();
        BitSet[] close14Atoms = this.mol.getIntCoordSystem().getClose14Atoms();
        for (int i = 0; i < maxIndex; ++i) {
            for (int j = i + 1; j < maxIndex; ++j) {
                if (closeAtoms[i].get(j)) continue;
                if (close14Atoms[i].get(j)) {
                    this.r = this.getDist(i, j);
                    if (this.r < l) {
                        this.energy += 0.75 * this.function.scaledElectr(this.r, l, this.partAtomCharges[i], partBondCharges[j]);
                        de = 0.75 * this.function.scaledElectrDer(this.r);
                    } else {
                        this.energy += 0.75 * this.function.electr(this.r, this.partAtomCharges[i], this.partAtomCharges[j]);
                        de = 0.75 * this.function.electrDer();
                    }
                    this.addDerivative(de, i, j);
                    continue;
                }
                this.r = this.getDist(i, j);
                if (this.r < l) {
                    this.energy += this.function.scaledElectr(this.r, l, this.partAtomCharges[i], partBondCharges[j]);
                    de = this.function.scaledElectrDer(this.r);
                } else {
                    this.energy += this.function.electr(this.r, this.partAtomCharges[i], this.partAtomCharges[j]);
                    de = this.function.electrDer();
                }
                this.addDerivative(de, i, j);
            }
        }
    }

    @Override
    public int getType() {
        return 5;
    }

    static {
        l = 0.7;
    }
}

