/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

public class FFFunctions {
    private final double CB = -0.4;
    private final double CS = -2.0;
    private double d_r;
    private double d_rr;
    private double Cd;
    private double CCd;
    private double d_theta;
    private double angleLimit0 = 0.17453292519943295;
    private double angleLimit180 = 2.9670597283903604;
    private double linearAngleLimit = 2.9670597283903604;
    private double a0;
    private double b0;
    private double c0;
    private double d0;
    private double a1;
    private double b1;
    private double c1;
    private double d1;
    private double sBLimit = 0.3490658503988659;
    private double d_rij;
    private double d_rkj;
    private double kdkd;
    private double[] sBDer = new double[3];
    private double outOfPlaneLimit = 1.3962634015954636;
    private double m;
    private double n;
    private double o;
    private double p;
    private double piLimit = (1.5707963267948966 - this.outOfPlaneLimit) * (1.5707963267948966 - this.outOfPlaneLimit);
    private double q;
    private double r;
    private double r2;
    private double r4;
    private double r6;
    private double r7;
    private boolean DA;
    private double Rij;
    private double Rij2;
    private double Rij4;
    private double Rij6;
    private double Rij7;
    private double rRij;
    private double rRij2;
    private double rRij6;
    private double rR;
    private double rR2;
    private double r7R;
    private double r7R2;
    private double X;
    private double Y;
    private double gamma;
    private double eps;
    private final double DARAD = 0.8;
    private final double DAEPS = 0.5;
    private double B;
    private final char donor = (char)68;
    private final char acceptor = (char)65;
    private static double a;
    private static double b;
    private static double d;
    private static double vdwSecDer;
    private double coulombE;
    private double r05;
    private double aC;
    private double bC;
    private double dC;
    private double secDerC;

    public double bondStretching(double k_bond, double r, double r_eq) {
        this.d_r = r - r_eq;
        this.d_rr = this.d_r * this.d_r;
        this.Cd = -2.0 * this.d_r;
        this.CCd = 4.0 * this.d_rr;
        return 143.9325 * (k_bond / 2.0) * this.d_rr * (1.0 + this.Cd + 0.5833333333333334 * this.CCd);
    }

    public double bondStretchingDer(double k_bond, double r, double r_eq) {
        return 143.9325 * k_bond * this.d_r * (1.0 + 1.5 * this.Cd + 1.1666666666666667 * this.CCd);
    }

    public double bondStretchingSecDer(double k_bond, double r, double r_eq) {
        return 143.9325 * k_bond * (1.0 + 3.0 * this.Cd + 3.5 * this.CCd);
    }

    public double angleBending(double k_angle, double theta, double theta_eq) {
        this.d_theta = theta - theta_eq;
        return 143.9325 * (k_angle / 2.0) * this.d_theta * this.d_theta * (1.0 + -0.4 * this.d_theta);
    }

    public double angleBendingDer(double k_angle, double theta, double theta_eq) {
        return 143.9325 * k_angle * this.d_theta * (1.0 + -0.6000000000000001 * this.d_theta);
    }

    public double angleBendingSecDer(double k_angle, double theta, double theta_eq) {
        return 143.9325 * k_angle * (1.0 + -1.2000000000000002 * this.d_theta);
    }

    public double corrAngleBending(double k_angle, double theta, double theta_eq) {
        this.d_theta = theta - theta_eq;
        if (theta < this.angleLimit0 && theta_eq < this.linearAngleLimit) {
            this.a0 = k_angle / (this.angleLimit0 * this.angleLimit0) * (theta_eq / 3.0 + -0.4 * (this.angleLimit0 - theta_eq) * theta_eq + -0.2 * (this.angleLimit0 - theta_eq) * (this.angleLimit0 - theta_eq));
            this.b0 = 0.5 * k_angle + -0.6000000000000001 * k_angle * (this.angleLimit0 - theta_eq) - 3.0 * this.a0 * (this.angleLimit0 - theta_eq);
            this.c0 = (3.0 * this.a0 - -0.6000000000000001 * k_angle) * (this.angleLimit0 - theta_eq) * (this.angleLimit0 - theta_eq);
            this.d0 = (-0.2 * k_angle - this.a0) * (this.angleLimit0 - theta_eq) * (this.angleLimit0 - theta_eq) * (this.angleLimit0 - theta_eq);
            return 143.9325 * (this.a0 * this.d_theta * this.d_theta * this.d_theta + this.b0 * this.d_theta * this.d_theta + this.c0 * this.d_theta + this.d0);
        }
        if (theta > this.angleLimit180 && theta_eq < this.linearAngleLimit) {
            this.a1 = k_angle / ((Math.PI - this.angleLimit180) * (Math.PI - this.angleLimit180)) * (-(Math.PI - theta_eq) / 3.0 - -0.4 * (this.angleLimit180 - theta_eq) * (Math.PI - theta_eq) + -0.2 * (this.angleLimit180 - theta_eq) * (this.angleLimit180 - theta_eq));
            this.b1 = 0.5 * k_angle + -0.6000000000000001 * k_angle * (this.angleLimit180 - theta_eq) - 3.0 * this.a1 * (this.angleLimit180 - theta_eq);
            this.c1 = (3.0 * this.a1 - -0.6000000000000001 * k_angle) * (this.angleLimit180 - theta_eq) * (this.angleLimit180 - theta_eq);
            this.d1 = (-0.2 * k_angle - this.a1) * (this.angleLimit180 - theta_eq) * (this.angleLimit180 - theta_eq) * (this.angleLimit180 - theta_eq);
            return 143.9325 * (this.a1 * this.d_theta * this.d_theta * this.d_theta + this.b1 * this.d_theta * this.d_theta + this.c1 * this.d_theta + this.d1);
        }
        return this.angleBending(k_angle, theta, theta_eq);
    }

    public double corrAngleBendingDer(double k_angle, double theta, double theta_eq) {
        if (theta < this.angleLimit0 && theta_eq < 2.9670597283903604) {
            return 143.9325 * (3.0 * this.a0 * this.d_theta * this.d_theta + 2.0 * this.b0 * this.d_theta + this.c0);
        }
        if (theta > this.angleLimit180 && theta_eq < this.linearAngleLimit) {
            return 143.9325 * (3.0 * this.a1 * this.d_theta * this.d_theta + 2.0 * this.b1 * this.d_theta + this.c1);
        }
        return this.angleBendingDer(k_angle, theta, theta_eq);
    }

    public double angleBendingLinear(double k_angle, double cos_theta) {
        return 143.9325 * k_angle * (1.0 + cos_theta);
    }

    public double angleBendingLinearDer(double k_angle, double cos_theta) {
        return 143.9325 * k_angle;
    }

    public double angleBendingLinearSecDer() {
        return 0.0;
    }

    public double stretchBend(double k_baIJK, double k_baKJI, double rij, double rij_eq, double rkj, double rkj_eq, double theta, double theta_eq) {
        this.d_rij = rij - rij_eq;
        this.d_rkj = rkj - rkj_eq;
        this.d_theta = theta - theta_eq;
        this.kdkd = 143.9325 * (k_baIJK * this.d_rij + k_baKJI * this.d_rkj);
        return this.kdkd * this.d_theta;
    }

    public double[] stretchBendDer(double k_baIJK, double k_baKJI, double rij, double rij_eq, double rkj, double rkj_eq, double theta, double theta_eq) {
        this.sBDer[0] = 143.9325 * k_baIJK * this.d_theta;
        this.sBDer[1] = 143.9325 * k_baKJI * this.d_theta;
        this.sBDer[2] = this.kdkd;
        return this.sBDer;
    }

    public double outOfPlaneBending(double k_oop, double chi_ijkl) {
        return 143.9325 * (k_oop / 2.0) * chi_ijkl * chi_ijkl;
    }

    public double outOfPlaneBendingDer(double k_oop, double chi_ijkl) {
        return 143.9325 * k_oop * chi_ijkl;
    }

    public double outOfPlaneBendingSecDer(double k_oop, double chi_ijkl) {
        return 143.9325 * k_oop;
    }

    public double corrOutOfPlaneBending(double k_oop, double chi_ijkl) {
        if (chi_ijkl > this.outOfPlaneLimit) {
            this.q = 143.9325 * k_oop * 1.5707963267948966 / this.piLimit;
            return this.q * (-0.3333333333333333 * chi_ijkl * chi_ijkl * chi_ijkl + (0.5 * this.piLimit / 1.5707963267948966 + this.outOfPlaneLimit) * chi_ijkl * chi_ijkl - this.outOfPlaneLimit * this.outOfPlaneLimit * chi_ijkl + 0.3333333333333333 * this.outOfPlaneLimit * this.outOfPlaneLimit * this.outOfPlaneLimit);
        }
        return this.outOfPlaneBending(k_oop, chi_ijkl);
    }

    public double corrOutOfPlaneBendingDer(double k_oop, double chi_ijkl) {
        if (chi_ijkl > this.outOfPlaneLimit) {
            return this.q * (-chi_ijkl * chi_ijkl + (this.piLimit / 1.5707963267948966 + 2.0 * this.outOfPlaneLimit) * chi_ijkl - this.outOfPlaneLimit * this.outOfPlaneLimit);
        }
        return this.outOfPlaneBendingDer(k_oop, chi_ijkl);
    }

    public double torsion(double V1, double V2, double V3, double phi) {
        return 0.5 * (V1 * (1.0 + Math.cos(phi)) + V2 * (1.0 - Math.cos(2.0 * phi)) + V3 * (1.0 + Math.cos(3.0 * phi)));
    }

    public double torsionDer(double V1, double V2, double V3, double phi) {
        return 0.5 * (-V1 * Math.sin(phi) + 2.0 * V2 * Math.sin(2.0 * phi) - 3.0 * V3 * Math.sin(3.0 * phi));
    }

    public double torsionSecDer(double V1, double V2, double V3, double phi) {
        return 0.5 * (-V1 * Math.cos(phi) + 4.0 * V2 * Math.cos(2.0 * phi) - 9.0 * V3 * Math.cos(3.0 * phi));
    }

    public void initVanDerWaals(double r_, double alphai, double Gi, char DAi, double alphaj, double Gj, char DAj, double Rii, double Rjj, double aNi, double aNj) {
        this.DA = false;
        this.r = r_;
        this.r2 = this.r * this.r;
        this.r4 = this.r2 * this.r2;
        this.r6 = this.r4 * this.r2;
        this.r7 = this.r6 * this.r;
        this.B = 0.2;
        if (DAi == 'D' || DAj == 'D') {
            this.B = 0.0;
        }
        this.gamma = (Rii - Rjj) / (Rii + Rjj);
        this.Rij = 0.5 * (Rii + Rjj) * (1.0 + this.B * (1.0 - Math.exp(-12.0 * this.gamma * this.gamma)));
        this.Rij2 = this.Rij * this.Rij;
        this.Rij4 = this.Rij2 * this.Rij2;
        this.Rij6 = this.Rij4 * this.Rij2;
        this.Rij7 = this.Rij6 * this.Rij;
        this.eps = 181.16 * Gi * Gj * alphai * alphaj / (aNi + aNj) * (1.0 / this.Rij6);
        if (DAi == 'D' && DAj == 'A' || DAi == 'A' && DAj == 'D') {
            this.Rij *= 0.8;
            this.eps *= 0.5;
            this.Rij2 = this.Rij * this.Rij;
            this.Rij4 = this.Rij2 * this.Rij2;
            this.Rij6 = this.Rij4 * this.Rij2;
            this.Rij7 = this.Rij6 * this.Rij;
        }
        this.rR = this.r + 0.07 * this.Rij;
        this.rR2 = this.rR * this.rR;
        this.rRij = 1.07 * this.Rij / this.rR;
        this.rRij2 = this.rRij * this.rRij;
        this.rRij6 = this.rRij2 * this.rRij2 * this.rRij2;
        this.r7R = this.r7 + 0.12 * this.Rij7;
        this.r7R2 = this.r7R * this.r7R;
        this.X = this.rRij6 * this.rRij;
        this.Y = 1.12 * this.Rij7 / this.r7R;
    }

    public double vanDerWaals() {
        return this.eps * this.X * (this.Y - 2.0);
    }

    public double vanDerWaalsDer() {
        return this.eps * 7.0 * (this.X / this.rR * (this.Y - 2.0) + this.Y / this.r7R * this.r6 * this.X);
    }

    public double vanDerWaalsSecDer() {
        return this.eps * 7.0 * (8.0 * (this.X / this.rR2) * (this.Y - 2.0) + 7.0 * (this.X / this.rR) * (this.Y / this.r7R) * this.r6 + 14.0 * (this.Y / this.r7R2) * this.r6 * this.r6 * this.X - 6.0 * this.r4 * this.r * (this.Y / this.r7R) * this.X + 7.0 * (this.X / this.rR) * (this.Y / this.r7R) * this.r6);
    }

    public double scaledVanDerWaals(double x) {
        vdwSecDer = this.vanDerWaalsSecDer();
        a = (this.r * vdwSecDer - this.vanDerWaalsDer()) / (3.0 * this.r * this.r);
        b = vdwSecDer / 2.0 - 3.0 * a * this.r;
        d = this.vanDerWaals() - this.r * this.r * vdwSecDer / 2.0 + 2.0 * a * this.r * this.r * this.r;
        return a * x * x * x + b * x * x + d;
    }

    public double scaledVanDerWaalsDer(double x) {
        return -(3.0 * a * x * x + 2.0 * b * x);
    }

    @Deprecated
    public double vanDerWaals(double r, double alphai, double Ai, double Gi, double Ni, char DAi, double alphaj, double Aj, double Gj, double Nj, char DAj, double Rii, double Rjj, double aNi, double aNj) {
        long t = System.currentTimeMillis();
        double DARAD = 0.8;
        double DAEPS = 0.5;
        double B = 0.2;
        char donor = 'D';
        char acceptor = 'A';
        if (DAi == donor || DAj == donor) {
            B = 0.0;
        }
        double gamma = (Rii - Rjj) / (Rii + Rjj);
        double Rij = 0.5 * (Rii + Rjj) * (1.0 + B * (1.0 - Math.exp(-12.0 * Math.pow(gamma, 2.0))));
        double eps = 181.16 * Gi * Gj * alphai * alphaj / (aNi + aNj) * (1.0 / this.Rij6);
        if (DAi == donor && DAj == acceptor || DAi == acceptor && DAj == donor) {
            Rij *= DARAD;
            eps *= DAEPS;
        }
        double energy = eps * Math.pow(1.07 * Rij / (r + 0.07 * Rij), 7.0) * (1.12 * Math.pow(Rij, 7.0) / (Math.pow(r, 7.0) + 0.12 * Math.pow(Rij, 7.0)) - 2.0);
        return energy;
    }

    @Deprecated
    public double vanDerWaalsDer(double r, double alphai, double Ai, double Gi, double Ni, char DAi, double alphaj, double Aj, double Gj, double Nj, char DAj, double Rii, double Rjj, double aNi, double aNj) {
        long t = System.currentTimeMillis();
        double DARAD = 0.8;
        double DAEPS = 0.5;
        double B = 0.2;
        char donor = 'D';
        char acceptor = 'A';
        if (DAi == donor || DAj == donor) {
            B = 0.0;
        }
        double gamma = (Rii - Rjj) / (Rii + Rjj);
        double Rij = 0.5 * (Rii + Rjj) * (1.0 + B * (1.0 - Math.exp(-12.0 * Math.pow(gamma, 2.0))));
        double r7 = Math.pow(r, 7.0);
        double eps = 181.16 * Gi * Gj * alphai * alphaj / (aNi + aNj) * (1.0 / this.Rij6);
        if (DAi == donor && DAj == acceptor || DAi == acceptor && DAj == donor) {
            Rij *= DARAD;
            eps *= DAEPS;
        }
        double der = eps * 7.0 * (Math.pow(1.07 * Rij / (r + 0.07 * Rij), 6.0) * (1.07 * Rij / Math.pow(r + 0.07 * Rij, 2.0)) * (1.12 * Math.pow(Rij, 7.0) / (Math.pow(r, 7.0) + 0.12 * Math.pow(Rij, 7.0)) - 2.0) + Math.pow(1.07 * Rij / (r + 0.07 * Rij), 7.0) * (1.12 * Math.pow(Rij, 7.0) / Math.pow(Math.pow(r, 7.0) + 0.12 * Math.pow(Rij, 7.0), 2.0)) * Math.pow(r, 6.0));
        return der;
    }

    public double electr(double r, double qi, double qj) {
        this.r05 = r + 0.05;
        this.coulombE = 332.0716 * qi * qj / this.r05;
        return this.coulombE;
    }

    public double electrDer() {
        return this.coulombE / this.r05;
    }

    public double electrSecDer() {
        return 2.0 * this.coulombE / this.r05 / this.r05;
    }

    public double scaledElectr(double x, double l, double qi, double qj) {
        this.electr(l, qi, qj);
        this.secDerC = this.electrSecDer();
        this.aC = (l * this.secDerC - this.electrDer()) / (3.0 * l * l);
        this.bC = this.secDerC / 2.0 - 3.0 * this.aC * l;
        this.dC = this.coulombE - l * l * this.secDerC / 2.0 + 2.0 * this.aC * l * l * l;
        return this.aC * x * x * x + this.bC * x * x + this.dC;
    }

    public double scaledElectrDer(double x) {
        return -(3.0 * this.aC * x * x + 2.0 * this.bC * x);
    }

    protected double scale(double fi, double fi0) {
        if (fi < 0.0) {
            return 1.0;
        }
        double scale = 0.0;
        double a = 16.0 / (3.0 * fi0 * fi0 * fi0) * fi * fi * fi;
        if (fi >= 0.0 && fi < fi0 / 4.0) {
            scale = 1.0 - a;
        } else if (fi >= fi0 / 4.0 && fi < 0.75 * fi0) {
            scale = a - 8.0 / (fi0 * fi0) * fi * fi + 2.0 / fi0 * fi + 0.8333333333333334;
        } else if (fi >= 0.75 * fi0 && fi < fi0) {
            scale = -a + 16.0 / (fi0 * fi0) * fi * fi - 16.0 / fi0 * fi + 5.333333333333333;
        }
        return scale;
    }

    protected double scaleGrad(double fi, double fi0) {
        double diff = 0.0;
        double a = 16.0 / (fi0 * fi0 * fi0) * fi * fi;
        if (fi < 0.0) {
            diff = 0.0;
        } else if (fi >= 0.0 && fi < fi0 / 4.0) {
            diff = -a;
        } else if (fi >= fi0 / 4.0 && fi < 0.75 * fi0) {
            diff = a - a * fi0 / fi + 2.0 / fi0;
        } else if (fi >= 0.75 * fi0 && fi < fi0) {
            diff = -a + 2.0 * a * fi0 / fi - 16.0 / fi0;
        }
        if (diff > 0.0) {
            diff = 0.0;
        }
        return diff;
    }

    private double getNumericDerivate(double x) {
        double small = 1.0E-5;
        double e1 = new FFFunctions().torsion(0.593, 0.662, 1.12, x + small);
        double e2 = new FFFunctions().torsion(0.593, 0.662, 1.12, x - small);
        return (e1 - e2) / (2.0 * small);
    }

    public static void main(String[] args) {
        double a = 1000.0;
        double start = 0.0;
        double stop = Math.PI;
        double step = (stop - start) / a;
        int i = 0;
        while ((double)i < a) {
            double t = start + (double)i * step;
            System.err.println(new FFFunctions().angleBending(1.328, t, 1.895));
            ++i;
        }
    }
}

