/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.MultipleFFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.Tools;
import chemaxon.marvin.modelling.mm.mmff94.XMLParser;
import java.util.HashMap;

public abstract class FFProviderHM {
    protected HashMap<String, FFComponentProvider> hm = new HashMap();
    FFProviderHM extraComponentProviderHM = null;

    public void addParams(String key, FFComponentProvider cp) {
        if (this.hm.get(key) == null) {
            this.hm.put(key, cp);
        } else {
            ((MultipleFFComponentProvider)this.hm.get(key)).addFFComponentProvider(cp);
        }
    }

    public FFComponentProvider getParams(String key) {
        if (this.hm.get(key) != null) {
            return this.hm.get(key);
        }
        if (this.extraComponentProviderHM != null) {
            return this.extraComponentProviderHM.getParams(key);
        }
        return null;
    }

    public FFComponentProvider getParams(int[] atomIndeces, MMFFMolecule mol) {
        String key = this.getKeyForIndeces(atomIndeces, mol);
        if (this.hm.get(key) != null) {
            return this.hm.get(key);
        }
        if (this.extraComponentProviderHM != null) {
            return this.extraComponentProviderHM.getParams(atomIndeces, mol);
        }
        return null;
    }

    protected String getKeyForIndeces(int[] indeces, MMFFMolecule mol) {
        int[] types = new int[indeces.length];
        for (int i = 0; i < indeces.length; ++i) {
            types[i] = Tools.getAtomType(indeces[i], mol);
        }
        String key = "";
        switch (types.length) {
            case 2: {
                if (types[0] <= types[1]) break;
                int ii = types[0];
                types[0] = types[1];
                types[1] = ii;
                break;
            }
            case 3: {
                if (types[0] <= types[2]) break;
                int ii = types[0];
                types[0] = types[2];
                types[2] = ii;
                ii = indeces[0];
                indeces[0] = indeces[2];
                indeces[2] = ii;
                break;
            }
            case 4: {
                if (types[1] <= types[2]) break;
                int ii = types[0];
                types[0] = types[3];
                types[3] = ii;
                ii = types[1];
                types[1] = types[2];
                types[2] = ii;
            }
        }
        for (int i = 0; i < types.length; ++i) {
            key = key + " " + types[i];
        }
        return key.trim();
    }

    protected String getKeyForTypes(int[] types_) {
        int[] types = (int[])types_.clone();
        String key = "";
        switch (types.length) {
            case 2: {
                if (types[0] <= types[1]) break;
                int ii = types[0];
                types[0] = types[1];
                types[1] = ii;
                break;
            }
            case 3: {
                if (types[0] <= types[2]) break;
                int ii = types[0];
                types[0] = types[2];
                types[2] = ii;
                break;
            }
            case 4: {
                int ii;
                if (types[1] > types[2]) {
                    ii = types[0];
                    types[0] = types[3];
                    types[3] = ii;
                    ii = types[1];
                    types[1] = types[2];
                    types[2] = ii;
                }
                if (types[1] != types[2] || types[0] <= types[3]) break;
                ii = types[0];
                types[0] = types[3];
                types[3] = ii;
            }
        }
        for (int i = 0; i < types.length; ++i) {
            key = key + " " + types[i];
        }
        return key.trim();
    }

    public abstract void xmlImport(XMLParser var1);

    protected FFProviderHM() {
    }

    void setExtraComponentProviderHM(FFProviderHM extraComponentProviderHM) {
        this.extraComponentProviderHM = extraComponentProviderHM;
    }
}

