/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.mm.mmff94.FFFunctions;

public abstract class MMFFComponent {
    protected FFFunctions function = new FFFunctions();

    public abstract double getEnergy();

    public abstract double[] getDerivative();

    public void addGradient(double[] grad) {
        double[] der = this.getDerivative();
        for (int j = 0; j < der.length; ++j) {
            int[] indeces = this.getInternalCoordinates()[j].getAtomIndeces();
            double[] d = JLinAlg.VectScale(this.getInternalCoordinates()[j].getBMatrixLine().getLineArray(), der[j]);
            for (int k = 0; k < indeces.length; ++k) {
                JLinAlg.VectAdd(3, d, 3 * k, grad, 3 * indeces[k], grad, 3 * indeces[k]);
            }
        }
    }

    public abstract InternalCoordinate[] getInternalCoordinates();

    public abstract int getType();
}

