/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.mm.mmff94.MMFFComponent;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;

public abstract class NonBondedComponent
extends MMFFComponent {
    protected double r;
    protected double energy = 0.0;
    protected double[] gradient = null;
    protected double[] coord = null;
    private double[] tmp3 = new double[3];
    private double[] coordA = new double[3];
    private double[] coordB = new double[3];
    private double BA0;
    private double BA1;
    private double BA2;
    protected MMFFMolecule mol;

    public void init(MMFFMolecule mol) {
        this.mol = mol;
    }

    protected double getDist(int indexA, int indexB) {
        this.coordA[0] = this.coord[3 * indexA];
        this.coordA[1] = this.coord[3 * indexA + 1];
        this.coordA[2] = this.coord[3 * indexA + 2];
        this.coordB[0] = this.coord[3 * indexB];
        this.coordB[1] = this.coord[3 * indexB + 1];
        this.coordB[2] = this.coord[3 * indexB + 2];
        this.BA0 = (this.coordB[0] - this.coordA[0]) * (this.coordB[0] - this.coordA[0]);
        this.BA1 = (this.coordB[1] - this.coordA[1]) * (this.coordB[1] - this.coordA[1]);
        this.BA2 = (this.coordB[2] - this.coordA[2]) * (this.coordB[2] - this.coordA[2]);
        return Math.sqrt(this.BA0 + this.BA1 + this.BA2);
    }

    protected double[] getIJUnitVector(int indexA, int indexB) {
        double d = this.getDist(indexA, indexB);
        this.tmp3[0] = (this.coordB[0] - this.coordA[0]) / d;
        this.tmp3[1] = (this.coordB[1] - this.coordA[1]) / d;
        this.tmp3[2] = (this.coordB[2] - this.coordA[2]) / d;
        return this.tmp3;
    }

    protected abstract void calc();

    @Override
    public double getEnergy() {
        this.calc();
        return this.energy;
    }

    @Override
    public double[] getDerivative() {
        return this.gradient;
    }

    protected void addDerivative(double derivative, int iAtom, int jAtom) {
        double[] u = this.getIJUnitVector(iAtom, jAtom);
        u[0] = u[0] * derivative;
        u[1] = u[1] * derivative;
        u[2] = u[2] * derivative;
        int ia = iAtom * 3;
        int ja = jAtom * 3;
        int n = ia;
        this.gradient[n] = this.gradient[n] + u[0];
        int n2 = ia + 1;
        this.gradient[n2] = this.gradient[n2] + u[1];
        int n3 = ia + 2;
        this.gradient[n3] = this.gradient[n3] + u[2];
        int n4 = ja;
        this.gradient[n4] = this.gradient[n4] - u[0];
        int n5 = ja + 1;
        this.gradient[n5] = this.gradient[n5] - u[1];
        int n6 = ja + 2;
        this.gradient[n6] = this.gradient[n6] - u[2];
    }

    @Override
    public InternalCoordinate[] getInternalCoordinates() {
        return null;
    }

    @Override
    public void addGradient(double[] grad) {
        JLinAlg.VectAdd(grad, this.getDerivative(), grad);
    }
}

