/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.FFProviderHM;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.OutOfPlaneParameters;
import chemaxon.marvin.modelling.mm.mmff94.Tools;
import chemaxon.marvin.modelling.mm.mmff94.XMLParser;
import java.util.Arrays;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OutOfPlaneHashMap
extends FFProviderHM {
    public FFComponentProvider getParams(int iType, int jType, int kType, int lType) {
        int[] types = new int[]{iType, kType, lType};
        Arrays.sort(types);
        if (this.getParams(types[0] + " " + jType + " " + types[1] + " " + types[2]) != null) {
            return this.getParams(types[0] + " " + jType + " " + types[1] + " " + types[2]);
        }
        return null;
    }

    @Override
    public FFComponentProvider getParams(int[] atomIndeces, MMFFMolecule mol) {
        return this.getParams(Tools.getAtomType(atomIndeces[0], mol), Tools.getAtomType(atomIndeces[1], mol), Tools.getAtomType(atomIndeces[2], mol), Tools.getAtomType(atomIndeces[3], mol));
    }

    @Override
    public void xmlImport(XMLParser xml) {
        NodeList nl = xml.readParameters("out-of-plane");
        for (int i = 0; i < nl.getLength(); ++i) {
            OutOfPlaneParameters oopp = new OutOfPlaneParameters();
            oopp.setI(Integer.parseInt(((Element)nl.item(i)).getAttribute("i")));
            oopp.setJ(Integer.parseInt(((Element)nl.item(i)).getAttribute("j")));
            oopp.setK(Integer.parseInt(((Element)nl.item(i)).getAttribute("k")));
            oopp.setL(Integer.parseInt(((Element)nl.item(i)).getAttribute("l")));
            oopp.setKoop(Double.parseDouble(((Element)nl.item(i)).getAttribute("koop")));
            oopp.setSource(((Element)nl.item(i)).getAttribute("source"));
            String key = oopp.getI() + " " + oopp.getJ() + " " + oopp.getK() + " " + oopp.getL();
            this.addParams(key, oopp);
        }
    }
}

