/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.FFProviderHM;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.StretchBendParameters;
import chemaxon.marvin.modelling.mm.mmff94.Tools;
import chemaxon.marvin.modelling.mm.mmff94.XMLParser;
import chemaxon.marvin.modelling.mm.mmff94.extra.ExtraStretchBendParameters;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StretchBendHashMap
extends FFProviderHM {
    public FFComponentProvider getParams(int stretchBendType, int[] atomIndeces, MMFFMolecule mol) {
        int[] atomTypes = new int[atomIndeces.length];
        for (int i = 0; i < atomIndeces.length; ++i) {
            atomTypes[i] = Tools.getAtomType(atomIndeces[i], mol);
        }
        String key = stretchBendType + " " + this.getKeyForIndeces(atomIndeces, mol);
        if (this.getParams(key) != null) {
            return this.getParams(key);
        }
        return (ExtraStretchBendParameters)this.extraComponentProviderHM.getParams(atomIndeces, mol);
    }

    @Override
    public void xmlImport(XMLParser xml) {
        NodeList nl = xml.readParameters("stretch-bend");
        for (int i = 0; i < nl.getLength(); ++i) {
            StretchBendParameters sbp = new StretchBendParameters();
            sbp.setSbt(Integer.parseInt(((Element)nl.item(i)).getAttribute("SBT")));
            sbp.setI(Integer.parseInt(((Element)nl.item(i)).getAttribute("i")));
            sbp.setJ(Integer.parseInt(((Element)nl.item(i)).getAttribute("j")));
            sbp.setK(Integer.parseInt(((Element)nl.item(i)).getAttribute("k")));
            sbp.setKbaIJK(Double.parseDouble(((Element)nl.item(i)).getAttribute("kbaIJK")));
            sbp.setKbaKJI(Double.parseDouble(((Element)nl.item(i)).getAttribute("kbaKJI")));
            sbp.setSource(((Element)nl.item(i)).getAttribute("source"));
            String key = sbp.sbt + " " + sbp.getI() + " " + sbp.getJ() + " " + sbp.getK();
            this.addParams(key, sbp);
        }
    }
}

