/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.common.util.IntVector;
import chemaxon.core.util.BondTable;
import chemaxon.marvin.io.formats.smiles.SmilesImport;
import chemaxon.marvin.modelling.mm.mmff94.BondParameters;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.Parameters;
import chemaxon.marvin.modelling.mm.mmff94.extra.ExtraBondParameters;
import chemaxon.marvin.modelling.struc.Substructure3DSearch;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.io.IOException;

public class Tools {
    private static Parameters MMFF94_PARAMETERS = Parameters.getMMFFParameters();

    static boolean isMatch(String smiles, int[] targetAtoms, MMFFMolecule m) {
        SmilesImport si = new SmilesImport();
        Molecule qm = new Molecule();
        try {
            si.readMol(smiles, qm);
        }
        catch (IOException e) {
            System.err.println("Cannot read smiles string!");
            e.printStackTrace();
        }
        Substructure3DSearch ss = new Substructure3DSearch();
        ss.setIgnoreCharge(true);
        ss.setIgnoreQueryProperties(false);
        ss.setIgnoreGeometryMatching(true, 0.0);
        ss.setMolecules(qm, m.getMolecule());
        if (targetAtoms.length < qm.getAtomCount()) {
            int[] frozenAtoms1 = new int[qm.getAtomCount()];
            int[] frozenAtoms2 = new int[qm.getAtomCount()];
            int k = 0;
            for (int i = 0; i < frozenAtoms1.length; ++i) {
                if (qm.getAtom(i).getAtomMap() == 1) {
                    frozenAtoms1[i] = targetAtoms[k];
                    frozenAtoms2[i] = targetAtoms[1 - k];
                    ++k;
                    continue;
                }
                frozenAtoms1[i] = -1;
                frozenAtoms2[i] = -1;
            }
            ss.setFrozenMatch(frozenAtoms1);
            boolean find1 = ss.findFirst();
            ss.setFrozenMatch(frozenAtoms2);
            boolean find2 = ss.findFirst();
            return find1 || find2;
        }
        ss.restrictMatching(targetAtoms);
        return ss.findFirst();
    }

    public static int getAtomType(int idx, MMFFMolecule mol) {
        return mol.getAtomTypes()[idx];
    }

    public static int getBondType(int[] atomIndeces, MMFFMolecule m) {
        if (MMFF94_PARAMETERS.getBondHashMap().getParams(atomIndeces, m) instanceof ExtraBondParameters) {
            return 0;
        }
        BondParameters bp = (BondParameters)MMFF94_PARAMETERS.getBondHashMap().getParams(atomIndeces, m);
        if (!bp.isMultipleFFComponentProvider()) {
            return bp.getBt();
        }
        int bondType = 0;
        for (int i = 0; i < bp.size(); ++i) {
            String smiles = ((BondParameters)bp.getFFComponentProvider(i)).getSmiles();
            if (smiles == "") {
                bondType = ((BondParameters)bp.getFFComponentProvider(i)).getBt();
                continue;
            }
            if (!Tools.isMatch(smiles, atomIndeces, m)) continue;
            bondType = ((BondParameters)bp.getFFComponentProvider(i)).getBt();
        }
        return bondType;
    }

    public static int getAngleType(int[] atomIndeces, MMFFMolecule m) {
        int[] ijAtomIndeces = new int[]{atomIndeces[0], atomIndeces[1]};
        int[] jkAtomIndeces = new int[]{atomIndeces[1], atomIndeces[2]};
        int ijBondType = Tools.getBondType(ijAtomIndeces, m);
        int jkBondType = Tools.getBondType(jkAtomIndeces, m);
        int angleType = 0;
        int ringSize = Tools.getRing(atomIndeces, m).length;
        if (ringSize == 3 || ringSize == 4) {
            switch (ijBondType + jkBondType) {
                case 0: {
                    angleType = ringSize;
                    break;
                }
                case 1: {
                    angleType = 2 * ringSize - 1;
                    break;
                }
                case 2: {
                    angleType = 2 * ringSize;
                }
            }
        } else {
            angleType = ijBondType + jkBondType;
        }
        return angleType;
    }

    static int getStretchBendType(int[] atomIndeces, MMFFMolecule m) {
        if (Tools.getAtomType(atomIndeces[0], m) > Tools.getAtomType(atomIndeces[2], m)) {
            int ii = atomIndeces[0];
            atomIndeces[0] = atomIndeces[2];
            atomIndeces[2] = ii;
        }
        int[] ijAtomIndeces = new int[]{atomIndeces[0], atomIndeces[1]};
        int[] jkAtomIndeces = new int[]{atomIndeces[1], atomIndeces[2]};
        int ijBondType = Tools.getBondType(ijAtomIndeces, m);
        int jkBondType = Tools.getBondType(jkAtomIndeces, m);
        int ijkAngleType = Tools.getAngleType(atomIndeces, m);
        if (Tools.getAtomType(atomIndeces[0], m) == Tools.getAtomType(atomIndeces[2], m) && ijBondType == 0 && jkBondType == 1) {
            int ii = atomIndeces[0];
            atomIndeces[0] = atomIndeces[2];
            atomIndeces[2] = ii;
            ii = ijBondType;
            ijBondType = jkBondType;
            jkBondType = ii;
        }
        switch (ijkAngleType) {
            case 0: {
                if (ijBondType != 0 || jkBondType != 0) break;
                return 0;
            }
            case 1: {
                if (ijBondType == 1 && jkBondType == 0) {
                    return 1;
                }
                if (ijBondType != 0 || jkBondType != 1) break;
                return 2;
            }
            case 2: {
                if (ijBondType != 1 || jkBondType != 1) break;
                return 3;
            }
            case 3: {
                if (ijBondType != 0 || jkBondType != 0) break;
                return 5;
            }
            case 4: {
                if (ijBondType != 0 || jkBondType != 0) break;
                return 4;
            }
            case 5: {
                if (ijBondType == 1 && jkBondType == 0) {
                    return 6;
                }
                if (ijBondType != 0 || jkBondType != 1) break;
                return 7;
            }
            case 6: {
                if (ijBondType != 1 || jkBondType != 1) break;
                return 8;
            }
            case 7: {
                if (ijBondType == 1 && jkBondType == 0) {
                    return 9;
                }
                if (ijBondType != 0 || jkBondType != 1) break;
                return 10;
            }
            case 8: {
                if (ijBondType != 1 || jkBondType != 1) break;
                return 11;
            }
        }
        return -1;
    }

    static int getTorsionType(int[] atomIndeces, MMFFMolecule mol) {
        MolBond bond;
        int[] ijAtomIndeces = new int[]{atomIndeces[0], atomIndeces[1]};
        int[] jkAtomIndeces = new int[]{atomIndeces[1], atomIndeces[2]};
        int[] klAtomIndeces = new int[]{atomIndeces[2], atomIndeces[3]};
        int ijBondType = Tools.getBondType(ijAtomIndeces, mol);
        int jkBondType = Tools.getBondType(jkAtomIndeces, mol);
        int klBondType = Tools.getBondType(klAtomIndeces, mol);
        BondTable btab = mol.getMolecule().getBondTable();
        int[] ring = Tools.getRing(atomIndeces, mol);
        boolean r = false;
        for (int i = 0; i < ring.length - 1; ++i) {
            if (Tools.getAtomType(ring[i], mol) != 1) continue;
            r = true;
        }
        int torsionType = 0;
        if (jkBondType == 1) {
            torsionType = 1;
        }
        if (jkBondType == 0 && (ijBondType == 1 || klBondType == 1)) {
            torsionType = 2;
            bond = mol.getMolecule().getBond(btab.getBondIndex(atomIndeces[1], atomIndeces[2]));
            if (bond.getType() != 1) {
                torsionType = 0;
            }
        }
        if (ring.length == 4) {
            torsionType = 4;
            if (Tools.getAtomType(atomIndeces[0], mol) == 22 && Tools.getAtomType(atomIndeces[1], mol) == 22 && Tools.getAtomType(atomIndeces[2], mol) == 22 && Tools.getAtomType(atomIndeces[3], mol) == 22) {
                torsionType = 0;
            }
        }
        if (ring.length == 5 && r) {
            torsionType = 5;
            if (jkBondType == 0 && (ijBondType == 1 || klBondType == 1)) {
                torsionType = 2;
            }
            if ((bond = mol.getMolecule().getBond(btab.getBondIndex(atomIndeces[1], atomIndeces[2]))).getType() != 1) {
                torsionType = 5;
            }
            if (jkBondType == 1) {
                torsionType = 1;
            }
        }
        return torsionType;
    }

    public static int[] getRing(int[] atomIndeces, MMFFMolecule mol) {
        IntVector ring = new IntVector(atomIndeces);
        int[][] ctab = mol.getMolecule().getCtab();
        IntVector iv = new IntVector(ctab[atomIndeces[0]]);
        iv.removeElement(atomIndeces[1]);
        switch (atomIndeces.length) {
            case 3: {
                if (iv.contains(atomIndeces[2])) {
                    return ring.toArray();
                }
                for (int i = 0; i < ctab[atomIndeces[2]].length; ++i) {
                    if (!iv.contains(ctab[atomIndeces[2]][i])) continue;
                    ring.add(ctab[atomIndeces[2]][i]);
                    return ring.toArray();
                }
                break;
            }
            case 4: {
                if (iv.contains(atomIndeces[3])) {
                    return ring.toArray();
                }
                for (int i = 0; i < ctab[atomIndeces[3]].length; ++i) {
                    if (!iv.contains(ctab[atomIndeces[3]][i]) || ring.contains(ctab[atomIndeces[3]][i])) continue;
                    ring.add(ctab[atomIndeces[3]][i]);
                    return ring.toArray();
                }
                break;
            }
        }
        ring.clear();
        return ring.toArray();
    }
}

