/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.FFProviderHM;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.Parameters;
import chemaxon.marvin.modelling.mm.mmff94.Tools;
import chemaxon.marvin.modelling.mm.mmff94.TorsionParameters;
import chemaxon.marvin.modelling.mm.mmff94.XMLParser;
import chemaxon.marvin.modelling.mm.mmff94.extra.ExtraAngleParameters;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TorsionHashMap
extends FFProviderHM {
    public FFComponentProvider getParams(int torsionType, int[] indeces, MMFFMolecule mol) {
        double theta0 = 0.0;
        double eps = 0.01;
        for (int i = 0; i < 2; ++i) {
            int[] angleIdx = new int[]{indeces[i], indeces[i + 1], indeces[i + 2]};
            int angleType = Tools.getAngleType(angleIdx, mol);
            FFComponentProvider ap = Parameters.getMMFFParameters().getAngleHashMap().getParams(angleType, angleIdx, mol);
            if (ap instanceof ExtraAngleParameters) {
                theta0 = ((ExtraAngleParameters)ap).getTheta(angleIdx, mol);
            }
            if (!((theta0 = ap.getOptimalValues()[0]) > Math.PI - eps)) continue;
            return null;
        }
        int[] types = new int[indeces.length];
        for (int i = 0; i < indeces.length; ++i) {
            types[i] = Tools.getAtomType(indeces[i], mol);
        }
        String key = torsionType + " " + this.getKeyForTypes(types);
        if (this.getParams(key) != null) {
            return this.getParams(key);
        }
        int tmp = types[0];
        types[0] = 0;
        key = torsionType + " " + this.getKeyForTypes(types);
        if (this.getParams(key) != null) {
            return this.getParams(key);
        }
        types[0] = tmp;
        types[3] = 0;
        key = torsionType + " " + this.getKeyForTypes(types);
        if (this.getParams(key) != null) {
            return this.getParams(key);
        }
        types[0] = 0;
        key = torsionType + " " + this.getKeyForTypes(types);
        if (this.getParams(key) != null) {
            return this.getParams(key);
        }
        return this.extraComponentProviderHM.getParams(indeces, mol);
    }

    @Override
    public void xmlImport(XMLParser xml) {
        NodeList nl = xml.readParameters("torsion");
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            TorsionParameters tp = new TorsionParameters();
            tp.setTt(Integer.parseInt(((Element)nl.item(i)).getAttribute("TT")));
            tp.setI(Integer.parseInt(((Element)nl.item(i)).getAttribute("i")));
            tp.setJ(Integer.parseInt(((Element)nl.item(i)).getAttribute("j")));
            tp.setK(Integer.parseInt(((Element)nl.item(i)).getAttribute("k")));
            tp.setL(Integer.parseInt(((Element)nl.item(i)).getAttribute("l")));
            tp.setV1(Double.parseDouble(((Element)nl.item(i)).getAttribute("V1")));
            tp.setV2(Double.parseDouble(((Element)nl.item(i)).getAttribute("V2")));
            tp.setV3(Double.parseDouble(((Element)nl.item(i)).getAttribute("V3")));
            tp.setSource(((Element)nl.item(i)).getAttribute("source"));
            String key = tp.tt + " " + tp.getI() + " " + tp.getJ() + " " + tp.getK() + " " + tp.getL();
            this.addParams(key, tp);
        }
    }
}

