/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94;

import chemaxon.marvin.modelling.mm.mmff94.NonBondedComponent;
import chemaxon.marvin.modelling.mm.mmff94.Tools;
import chemaxon.marvin.modelling.mm.mmff94.XMLParser;
import java.util.BitSet;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VanDerWaals
extends NonBondedComponent {
    private static double[] alpha;
    private static double[] N;
    private static double[] A;
    private static double[] G;
    private static char[] DA;
    private static double[] R;
    private static double[] aN;
    private int iType;
    private int jType;
    private double vdwLimit = 0.7;
    private double e;
    private double der;

    public static void readParameters(XMLParser xml) {
        NodeList nl = xml.readParameters("van-der-waals");
        alpha = new double[100];
        N = new double[100];
        A = new double[100];
        G = new double[100];
        R = new double[100];
        aN = new double[100];
        DA = new char[100];
        for (int i = 0; i < nl.getLength(); ++i) {
            int type = Integer.parseInt(((Element)nl.item(i)).getAttribute("atomtype"));
            VanDerWaals.alpha[type] = Double.parseDouble(((Element)nl.item(i)).getAttribute("alpha"));
            VanDerWaals.N[type] = Double.parseDouble(((Element)nl.item(i)).getAttribute("N"));
            VanDerWaals.A[type] = Double.parseDouble(((Element)nl.item(i)).getAttribute("A"));
            VanDerWaals.G[type] = Double.parseDouble(((Element)nl.item(i)).getAttribute("G"));
            VanDerWaals.DA[type] = ((Element)nl.item(i)).getAttribute("DA").charAt(0);
            VanDerWaals.R[type] = A[type] * Math.pow(alpha[type], 0.25);
            VanDerWaals.aN[type] = Math.sqrt(alpha[type] / N[type]);
        }
    }

    public double getE(int i, int j) {
        this.calcIJ(i, j);
        return this.e;
    }

    public double getdE(int i, int j) {
        this.calcIJ(i, j);
        return this.der;
    }

    private void calcIJ(int i, int j) {
        this.coord = this.mol.getIntCoordSystem().getCartesianCoordinates();
        BitSet[] closeAtoms = this.mol.getIntCoordSystem().getCloseAtoms();
        if (!closeAtoms[i].get(j)) {
            this.iType = Tools.getAtomType(i, this.mol);
            this.jType = Tools.getAtomType(j, this.mol);
            this.r = this.getDist(i, j);
            if (this.r < this.vdwLimit) {
                this.function.initVanDerWaals(this.vdwLimit, alpha[this.iType], G[this.iType], DA[this.iType], alpha[this.jType], G[this.jType], DA[this.jType], R[this.iType], R[this.jType], aN[this.iType], aN[this.jType]);
                this.e = this.function.scaledVanDerWaals(this.r);
                this.der = this.function.scaledVanDerWaalsDer(this.r);
            } else {
                this.function.initVanDerWaals(this.r, alpha[this.iType], G[this.iType], DA[this.iType], alpha[this.jType], G[this.jType], DA[this.jType], R[this.iType], R[this.jType], aN[this.iType], aN[this.jType]);
                this.e = this.function.vanDerWaals();
                this.der = this.function.vanDerWaalsDer();
            }
        }
    }

    @Override
    protected void calc() {
        int maxIndex = this.mol.getMolecule().getAtomCount();
        this.coord = this.mol.getIntCoordSystem().getCartesianCoordinates();
        this.energy = 0.0;
        double der = 0.0;
        if (this.gradient == null || this.gradient.length != 3 * maxIndex) {
            this.gradient = new double[3 * maxIndex];
        }
        for (int i = 0; i < this.gradient.length; ++i) {
            this.gradient[i] = 0.0;
        }
        BitSet[] closeAtoms = this.mol.getIntCoordSystem().getCloseAtoms();
        for (int i = 0; i < maxIndex; ++i) {
            for (int j = i + 1; j < maxIndex; ++j) {
                if (closeAtoms[i].get(j)) continue;
                this.iType = Tools.getAtomType(i, this.mol);
                this.jType = Tools.getAtomType(j, this.mol);
                this.r = this.getDist(i, j);
                if (this.r < this.vdwLimit) {
                    this.function.initVanDerWaals(this.vdwLimit, alpha[this.iType], G[this.iType], DA[this.iType], alpha[this.jType], G[this.jType], DA[this.jType], R[this.iType], R[this.jType], aN[this.iType], aN[this.jType]);
                    this.energy += this.function.scaledVanDerWaals(this.r);
                    der = this.function.scaledVanDerWaalsDer(this.r);
                } else {
                    this.function.initVanDerWaals(this.r, alpha[this.iType], G[this.iType], DA[this.iType], alpha[this.jType], G[this.jType], DA[this.jType], R[this.iType], R[this.jType], aN[this.iType], aN[this.jType]);
                    this.energy += this.function.vanDerWaals();
                    der = this.function.vanDerWaalsDer();
                }
                this.addDerivative(der, i, j);
            }
        }
    }

    @Override
    public int getType() {
        return 6;
    }
}

