/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94.extra;

import chemaxon.marvin.modelling.mm.mmff94.FFProviderHM;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.XMLParser;
import chemaxon.marvin.modelling.mm.mmff94.extra.ExtraAngleParameters;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExtraAngleHashMap
extends FFProviderHM {
    protected HashMap<String, double[]> hm = new HashMap();

    @Override
    public void xmlImport(XMLParser xml) {
        NodeList nl = xml.readParameters("angle-extension");
        for (int i = 0; i < nl.getLength(); ++i) {
            double[] par = new double[]{Double.parseDouble(((Element)nl.item(i)).getAttribute("Z")), Double.parseDouble(((Element)nl.item(i)).getAttribute("C"))};
            String key = ((Element)nl.item(i)).getAttribute("atom");
            this.hm.put(key, par);
        }
    }

    @Override
    public ExtraAngleParameters getParams(int[] atomIndeces, MMFFMolecule mol) {
        ExtraAngleParameters extraap = new ExtraAngleParameters();
        try {
            String key = Integer.toString(mol.getMolecule().getAtom(atomIndeces[0]).getAtno());
            extraap.setZi(this.hm.get(key)[0]);
            key = Integer.toString(mol.getMolecule().getAtom(atomIndeces[1]).getAtno());
            extraap.setCj(this.hm.get(key)[1]);
            key = Integer.toString(mol.getMolecule().getAtom(atomIndeces[2]).getAtno());
            extraap.setZk(this.hm.get(key)[0]);
        }
        catch (NullPointerException e) {
            mol.setDummy();
            extraap.setZi(2.5);
            extraap.setCj(1.0);
            extraap.setZk(2.5);
        }
        return extraap;
    }
}

