/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94.extra;

import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.mm.mmff94.AngleComponent;
import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.MMFFComponent;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.Parameters;
import chemaxon.marvin.modelling.mm.mmff94.Tools;
import java.io.IOException;

public class ExtraAngleParameters
implements FFComponentProvider {
    private double Zi;
    private double Cj;
    private double Zk;
    private double scale = Math.PI / 180;
    private double theta0;

    public void setTheta0(double theta0) {
        this.theta0 = theta0;
    }

    public void setZi(double zi) {
        this.Zi = zi;
    }

    public void setCj(double cj) {
        this.Cj = cj;
    }

    public void setZk(double zk) {
        this.Zk = zk;
    }

    public MMFFComponent getComponent(int[] atomIndeces, double[] coordinates) throws IOException {
        return null;
    }

    @Override
    public MMFFComponent getComponent(InternalCoordinate q, MMFFMolecule mol) {
        int[] ai = q.getAtomIndeces();
        this.getTheta(ai, mol);
        int ringSize = Tools.getRing(ai, mol).length;
        double beta = 1.75;
        if (ringSize == 3) {
            beta = 0.0875;
        }
        if (ringSize == 4) {
            beta = 1.4875;
        }
        int[] ij = new int[]{ai[0], ai[1]};
        int[] jk = new int[]{ai[1], ai[2]};
        double rij = Parameters.getMMFFParameters().getBondHashMap().getOptimalValues(ij, mol);
        double rjk = Parameters.getMMFFParameters().getBondHashMap().getOptimalValues(jk, mol);
        double D = Math.pow(rij - rjk, 2.0) / Math.pow(rij + rjk, 2.0);
        double ka = beta * this.Zi * this.Cj * this.Zk * Math.exp(-2.0 * D) / ((rij + rjk) * Math.pow(this.theta0, 2.0));
        AngleComponent ac = new AngleComponent();
        ac.setTheta0(this.theta0);
        ac.setKa(ka);
        ac.setInternalCoordinate(q);
        return ac;
    }

    @Override
    public double[] getOptimalValues() {
        double[] optVal = new double[]{this.theta0};
        return optVal;
    }

    public double getTheta(int[] ai, MMFFMolecule mol) {
        if (this.theta0 == 0.0) {
            int ringSize;
            int jType = Tools.getAtomType(ai[1], mol);
            int z = mol.getMolecule().getAtom(ai[1]).getAtno();
            int crd = Parameters.getMMFFParameters().getAtomTypeProp().getCrd(jType);
            int lin = Parameters.getMMFFParameters().getAtomTypeProp().getLin(jType);
            int val = Parameters.getMMFFParameters().getAtomTypeProp().getVal(jType);
            int mltb = Parameters.getMMFFParameters().getAtomTypeProp().getMltb(jType);
            this.theta0 = 120.0;
            if (crd == 4) {
                this.theta0 = 109.45;
            }
            if (crd == 2 && z == 8) {
                this.theta0 = 109.45;
            }
            if (crd == 2 && z > 10) {
                this.theta0 = 95.0;
            }
            if (crd == 2 && lin == 1) {
                this.theta0 = 180.0;
            }
            if (crd == 3 && val == 3 && mltb == 0) {
                this.theta0 = 92.0;
            }
            if (crd == 3 && val == 3 && mltb == 0 && z == 7) {
                this.theta0 = 107.0;
            }
            if ((ringSize = Tools.getRing(ai, mol).length) == 3) {
                this.theta0 = 60.0;
            }
            if (ringSize == 4) {
                this.theta0 = 90.0;
            }
            this.theta0 *= this.scale;
        }
        return this.theta0;
    }
}

