/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94.extra;

import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.FFProviderHM;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.XMLParser;
import chemaxon.marvin.modelling.mm.mmff94.extra.ExtraStretchBendParameters;
import chemaxon.struc.Molecule;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExtraStretchBendHashMap
extends FFProviderHM {
    @Override
    public void xmlImport(XMLParser xml) {
        NodeList nl = xml.readParameters("stretch-bend-extension");
        for (int i = 0; i < nl.getLength(); ++i) {
            ExtraStretchBendParameters extrasbp = new ExtraStretchBendParameters();
            extrasbp.setI(Integer.parseInt(((Element)nl.item(i)).getAttribute("i")));
            extrasbp.setJ(Integer.parseInt(((Element)nl.item(i)).getAttribute("j")));
            extrasbp.setK(Integer.parseInt(((Element)nl.item(i)).getAttribute("k")));
            extrasbp.setKbaIJK(Double.parseDouble(((Element)nl.item(i)).getAttribute("kbaIJK")));
            extrasbp.setKbaKJI(Double.parseDouble(((Element)nl.item(i)).getAttribute("kbaKJI")));
            String key = extrasbp.getI() + " " + extrasbp.getJ() + " " + extrasbp.getK();
            this.addParams(key, extrasbp);
        }
    }

    @Override
    public FFComponentProvider getParams(int[] atomIndeces, MMFFMolecule mol) {
        String key;
        FFComponentProvider extrasbp;
        Molecule m = mol.getMolecule();
        int[] rows = new int[3];
        for (int i = 0; i < atomIndeces.length; ++i) {
            rows[i] = this.getRowInPeriodicTable(m.getAtom(atomIndeces[i]).getAtno());
        }
        if (rows[0] > rows[2]) {
            int ii = rows[0];
            rows[0] = rows[2];
            rows[2] = ii;
            ii = atomIndeces[0];
            atomIndeces[0] = atomIndeces[2];
            atomIndeces[2] = ii;
        }
        if ((extrasbp = this.getParams(key = rows[0] + " " + rows[1] + " " + rows[2])) == null) {
            mol.setDummy();
            ExtraStretchBendParameters dummy = new ExtraStretchBendParameters();
            dummy.setKbaIJK(0.25);
            dummy.setKbaKJI(0.25);
            return dummy;
        }
        return extrasbp;
    }

    private int getRowInPeriodicTable(int atno) {
        if (atno < 3) {
            return 0;
        }
        if (atno < 11) {
            return 1;
        }
        if (atno < 19) {
            return 2;
        }
        if (atno < 37) {
            return 3;
        }
        if (atno < 55) {
            return 4;
        }
        return -1;
    }
}

