/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.mm.mmff94.extra;

import chemaxon.core.util.BondTable;
import chemaxon.marvin.modelling.mm.mmff94.FFComponentProvider;
import chemaxon.marvin.modelling.mm.mmff94.FFProviderHM;
import chemaxon.marvin.modelling.mm.mmff94.MMFFMolecule;
import chemaxon.marvin.modelling.mm.mmff94.Tools;
import chemaxon.marvin.modelling.mm.mmff94.TorsionParameters;
import chemaxon.marvin.modelling.mm.mmff94.XMLParser;
import chemaxon.marvin.modelling.mm.mmff94.extra.AtomTypeProperties;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;

public class ExtraTorsionHashMap
extends FFProviderHM {
    private AtomTypeProperties p;

    public ExtraTorsionHashMap(AtomTypeProperties p) {
        this.p = p;
    }

    @Override
    public void xmlImport(XMLParser xml) {
    }

    @Override
    public FFComponentProvider getParams(int[] atomIndeces, MMFFMolecule mol) {
        double Vk;
        double Vj;
        double Uk;
        double Uj;
        int i = Tools.getAtomType(atomIndeces[0], mol);
        int j = Tools.getAtomType(atomIndeces[1], mol);
        int k = Tools.getAtomType(atomIndeces[2], mol);
        int l = Tools.getAtomType(atomIndeces[3], mol);
        TorsionParameters torp = new TorsionParameters();
        torp.setI(i);
        torp.setJ(j);
        torp.setK(k);
        torp.setL(l);
        torp.setSource("extra torsion");
        torp.setV1(0.0);
        torp.setV2(0.0);
        torp.setV3(0.0);
        int Zj = mol.getMolecule().getAtom(atomIndeces[1]).getAtno();
        int Zk = mol.getMolecule().getAtom(atomIndeces[2]).getAtno();
        try {
            Uj = AtomTypeProperties.getEmpTorsPar(Zj)[0];
            Uk = AtomTypeProperties.getEmpTorsPar(Zk)[0];
            Vj = AtomTypeProperties.getEmpTorsPar(Zj)[1];
            Vk = AtomTypeProperties.getEmpTorsPar(Zk)[1];
        }
        catch (NullPointerException e) {
            mol.setDummy();
            return torp;
        }
        double pbo = 0.3;
        double beta = 6.0;
        if (this.p.getLin(j) == 1 || this.p.getLin(k) == 1) {
            return torp;
        }
        if (this.p.getArom(j) == 1 && this.p.getArom(k) == 1) {
            if (this.p.getPilp(j) == 0 && this.p.getPilp(k) == 0) {
                pbo = 0.5;
            }
            if (this.p.getVal(j) == 3 && this.p.getVal(k) == 4 || this.p.getVal(j) == 4 && this.p.getVal(k) == 3) {
                beta = 3.0;
            }
            torp.setV2(beta * pbo * Math.sqrt(Uj * Uk));
            return torp;
        }
        if (this.p.getMltb(j) == 2 || this.p.getMltb(k) == 2) {
            pbo = 0.4;
            if (this.p.getMltb(j) == 2 && this.p.getMltb(k) == 2) {
                pbo = 1.0;
            }
            torp.setV2(beta * pbo * Math.sqrt(Uj * Uk));
            return torp;
        }
        if (this.p.getCrd(j) == 4 && this.p.getCrd(k) == 3 && (this.p.getVal(k) == 4 || this.p.getVal(k) == 34)) {
            return torp;
        }
        if (this.p.getCrd(j) == 4 && this.p.getCrd(k) == 3 && this.p.getMltb(k) != 0) {
            return torp;
        }
        if (this.p.getCrd(j) == 4 && this.p.getCrd(k) == 2 && (this.p.getVal(k) == 3 || this.p.getMltb(k) != 0)) {
            return torp;
        }
        if (this.p.getCrd(k) == 4 && this.p.getCrd(j) == 3 && (this.p.getVal(j) == 4 || this.p.getVal(k) == 34)) {
            return torp;
        }
        if (this.p.getCrd(k) == 4 && this.p.getCrd(j) == 3 && this.p.getMltb(j) != 0) {
            return torp;
        }
        if (this.p.getCrd(k) == 4 && this.p.getCrd(j) == 2 && (this.p.getVal(j) == 3 || this.p.getMltb(j) != 0)) {
            return torp;
        }
        if (this.p.getCrd(j) == 4 || this.p.getCrd(k) == 4) {
            torp.setV3(Math.sqrt(Vj * Vk) / (((double)this.p.getCrd(j) - 1.0) * ((double)this.p.getCrd(k) - 1.0)));
            return torp;
        }
        BondTable btab = mol.getMolecule().getBondTable();
        MolBond bond = mol.getMolecule().getBond(btab.getBondIndex(atomIndeces[1], atomIndeces[2]));
        if (bond.getType() == 1 && (this.p.getMltb(j) != 0 && this.p.getMltb(k) != 0 || this.p.getMltb(j) != 0 && this.p.getPilp(k) != 0 || this.p.getPilp(j) != 0 && this.p.getMltb(k) != 0)) {
            if (this.p.getPilp(j) == 1 && this.p.getPilp(k) == 1) {
                return torp;
            }
            if (this.p.getPilp(j) != 0 && this.p.getMltb(k) != 0) {
                beta = 0.6;
                pbo = this.p.getMltb(j) == 1 ? 0.5 : (MolAtom.getRow(Zj) == 2 && MolAtom.getRow(Zk) == 2 ? 0.3 : 0.15);
                torp.setV2(beta * pbo * Math.sqrt(Uj * Uk));
                return torp;
            }
            if (this.p.getPilp(k) != 0 && this.p.getMltb(j) != 0) {
                pbo = this.p.getMltb(k) == 1 ? 0.5 : (MolAtom.getRow(Zj) == 2 && MolAtom.getRow(Zk) == 2 ? 0.3 : 0.15);
                torp.setV2(beta * pbo * Math.sqrt(Uj * Uk));
                return torp;
            }
            if (!(this.p.getMltb(j) != 1 && this.p.getMltb(k) != 1 || Zj == 6 && Zk == 6)) {
                pbo = 0.4;
                torp.setV2(beta * pbo * Math.sqrt(Uj * Uk));
                return torp;
            }
            pbo = 0.15;
            torp.setV2(beta * pbo * Math.sqrt(Uj * Uk));
            return torp;
        }
        if ((Zj == 8 || Zj == 16) && Zk == 8 && Zk == 16) {
            double Wj = 2.0;
            double Wk = 2.0;
            if (Zj == 16) {
                Wj = 8.0;
            }
            if (Zk == 16) {
                Wk = 8.0;
            }
            torp.setV2(-Math.sqrt(Wj * Wk));
            return torp;
        }
        torp.setV3(Math.sqrt(Vj * Vk) / (((double)this.p.getCrd(j) - 1.0) * ((double)this.p.getCrd(k) - 1.0)));
        return torp;
    }
}

