/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.newmd;

import chemaxon.marvin.modelling.linalg.EquationSequenceSolver;
import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.linalg.internals.InternalCoordinateSystem;
import chemaxon.marvin.modelling.linalg.internals.Internals;
import chemaxon.marvin.modelling.mm.BMatrix;
import chemaxon.marvin.modelling.newmd.Debug;
import chemaxon.marvin.modelling.newmd.boundary.Monitor;
import chemaxon.marvin.modelling.newmd.boundary.MonitorI;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.BitSet;

public class InternalCoordinateProjection {
    private Molecule mol;
    private BMatrix bmat;
    private BitSet ringAtoms = new BitSet();
    private boolean useSolver = true;
    private boolean naturals = true;
    private EquationSequenceSolver eSS = null;
    private int projectionRank = 0;
    private JLinAlg.Matrix inverse = null;
    private InternalCoordinateSystem icsp = null;
    int[][] connectionTab;
    private MonitorI numericMonitor = null;
    private Monitor analyticMonitor = null;

    InternalCoordinateProjection(Molecule mol) {
        this.mol = mol;
        int[][] sSSR = mol.getSSSR();
        for (int i = 0; i < sSSR.length; ++i) {
            for (int j = 0; j < sSSR[i].length; ++j) {
                this.ringAtoms.set(sSSR[i][j]);
            }
        }
        if (this.useSolver) {
            this.eSS = new EquationSequenceSolver();
        }
    }

    public JLinAlg.Matrix calculateBondLengthB(double[] coords) {
        ArrayList<double[]> bLines = new ArrayList<double[]>();
        if (this.icsp != null) {
            this.icsp.setCartesianCoordinates(coords);
            InternalCoordinateProjection.chkCoordinates(coords, this.icsp);
            InternalCoordinate[] q = this.icsp.getInternalCoordinates();
            for (int i = 0; i < q.length; ++i) {
                InternalCoordinate.BMatrixLine bl = q[i].getBMatrixLine();
                double[] a = bl.getLineArray();
                int[] idx = bl.getAtomIndeces();
                double[] bLine = new double[this.mol.getAtomCount() * 3];
                int j = 0;
                int ij = 0;
                for (int it = 0; it < idx.length; ++it) {
                    ij = idx[it] * 3;
                    for (int k = 0; k < 3; ++k) {
                        bLine[ij] = a[j];
                        ++j;
                        ++ij;
                    }
                }
                bLines.add(bLine);
            }
            JLinAlg.Matrix matrixB = new JLinAlg.Matrix(bLines.size(), this.mol.getAtomCount() * 3);
            for (int i = 0; i < bLines.size(); ++i) {
                matrixB.setRow(i, (double[])bLines.get(i), 0);
            }
            return matrixB;
        }
        System.err.println("icsp is null!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        this.icsp = new InternalCoordinateSystem(this.mol);
        double[] bLine = new double[this.mol.getAtomCount() * 3];
        JLinAlg.Matrix matrixB = null;
        if (this.naturals) {
            this.icsp.setInternalCoordinates(InternalCoordinateSystem.getCoolInternals(this.mol));
            InternalCoordinate.BMatrixLine[] bMat = this.icsp.getBMatrix();
            matrixB = new JLinAlg.Matrix(bMat.length, this.mol.getAtomCount() * 3);
            for (int i = 0; i < bMat.length; ++i) {
                int[] idx = bMat[i].getAtomIndeces();
                double[] val = bMat[i].getLineArray();
                JLinAlg.VectClear(bLine);
                for (int j = 0; j < idx.length; ++j) {
                    int iv = j * 3;
                    int id = 3 * idx[j];
                    JLinAlg.VectCopy(3, val, iv, bLine, id);
                }
                matrixB.setRow(i, bLine, 0);
            }
            return matrixB;
        }
        boolean doAngles = true;
        InternalCoordinateSystem ics = new InternalCoordinateSystem(this.mol);
        ics.setBondAngleEnabled(true);
        ics.setDihedralEnabled(true);
        ics.setOutOfPlaneEnabled(true);
        ics.setCosAngleEnabled(true);
        ics.run();
        InternalCoordinate[] bb = ics.getInternalsForType(1);
        int[][] cTab = this.mol.getCtab();
        for (int i = 0; i < bb.length; ++i) {
            this.icsp.addInternalCoordinate(bb[i]);
            bLine = new double[this.mol.getAtomCount() * 3];
            int[] idx = bb[i].getAtomIndeces();
            double[] r = bb[i].getBMatrixLine().getLineArray();
            bLine[idx[0] * 3] = r[0];
            bLine[idx[0] * 3 + 1] = r[1];
            bLine[idx[0] * 3 + 2] = r[2];
            bLine[idx[1] * 3] = r[3];
            bLine[idx[1] * 3 + 1] = r[4];
            bLine[idx[1] * 3 + 2] = r[5];
            bLines.add(bLine);
        }
        if (doAngles) {
            InternalCoordinate[] ba = ics.getInternalsForType(2);
            if (ba.length < 2) {
                System.err.println("Too few bond angles...");
            }
            for (int i = 0; i < ba.length; ++i) {
                int[] idx = ba[i].getAtomIndeces();
                int idx1 = idx[0] * 3;
                int idx2 = idx[1] * 3;
                int idx3 = idx[2] * 3;
                int iA1 = idx[0];
                int iA2 = idx[1];
                int iA3 = idx[2];
                if (this.ringAtoms.get(iA2) && this.ringAtoms.get(iA1) == this.ringAtoms.get(iA3)) continue;
                this.icsp.addInternalCoordinate(ba[i]);
                double[] a = ba[i].getBMatrixLine().getLineArray();
                bLine = new double[this.mol.getAtomCount() * 3];
                bLine[idx1] = a[0];
                bLine[idx1 + 1] = a[1];
                bLine[idx1 + 2] = a[2];
                bLine[idx2] = a[3];
                bLine[idx2 + 1] = a[4];
                bLine[idx2 + 2] = a[5];
                bLine[idx3] = a[6];
                bLine[idx3 + 1] = a[7];
                bLine[idx3 + 2] = a[8];
                bLines.add(bLine);
            }
            InternalCoordinate[] d = ics.getInternalsForType(3);
            if (!doAngles) {
                for (int i = 0; i < d.length; ++i) {
                    this.icsp.addInternalCoordinate(d[i]);
                    int[] idx = d[i].getAtomIndeces();
                    MolAtom a1 = this.mol.getAtom(idx[1]);
                    MolAtom a2 = this.mol.getAtom(idx[2]);
                    if (a1.getBondTo(a2).getType() != 4) continue;
                    double[] a = d[i].getBMatrixLine().getLineArray();
                    bLine = new double[this.mol.getAtomCount() * 3];
                    int j = 0;
                    int ij = 0;
                    for (int it = 0; it < idx.length; ++it) {
                        ij = idx[it] * 3;
                        for (int k = 0; k < 3; ++k) {
                            bLine[ij] = a[j];
                            ++j;
                            ++ij;
                        }
                    }
                    bLines.add(bLine);
                }
            }
        }
        matrixB = new JLinAlg.Matrix(bLines.size(), this.mol.getAtomCount() * 3);
        for (int i = 0; i < bLines.size(); ++i) {
            matrixB.setRow(i, (double[])bLines.get(i), 0);
        }
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("B matrix:");
            for (int j = 0; j < matrixB.nRows; ++j) {
                Debug.debugstream.print(j + ". row ");
                for (int k = 0; k < matrixB.nCols; ++k) {
                    Debug.debugstream.print(matrixB.getElement(j, k) + ", ");
                }
                Debug.debugstream.println();
            }
        }
        return matrixB;
    }

    public double[] projectVelocities(JLinAlg.Matrix matrixB, double[] speeds) {
        if (this.useSolver) {
            if (this.eSS == null) {
                this.eSS = new EquationSequenceSolver();
                this.eSS.setAnalyticMonitor(this.analyticMonitor);
                this.eSS.setNumericMonitor(this.numericMonitor);
            }
            double[] ret = this.eSS.solve(matrixB, JLinAlg.mVMultiply(matrixB, speeds));
            this.setProjectionRank(this.eSS.getCoeffRank());
            if (!U.isDoubleOK(ret)) {
                System.err.println("Double NaN error found in equation solver.");
            }
            return ret;
        }
        double zLimit = 1.0E-6;
        matrixB.reDiagonalize(zLimit);
        this.setProjectionRank(matrixB.nRank);
        System.err.println("Projection rank is: " + this.getProjectionRank());
        JLinAlg.Matrix matrixBinv = matrixB.getInverse(zLimit);
        JLinAlg.Matrix projectorP = JLinAlg.mMMultiply(matrixBinv, matrixB);
        double[] pSpeeds = JLinAlg.mVMultiply(projectorP, speeds);
        double[] pDiag = new double[projectorP.nRows];
        for (int i = 0; i < projectorP.nRows; ++i) {
            pDiag[i] = projectorP.getElement(i, i);
            for (int j = 0; j <= i; ++j) {
                double vji;
                double vij = projectorP.getElement(i, j);
                if (!(Math.abs(vij - (vji = projectorP.getElement(j, i))) > 1.0E-6)) continue;
                System.err.println("Symmetry error in the projector: " + i + "," + j + " is " + vij + " " + vji);
            }
        }
        return pSpeeds;
    }

    public int getProjectionRank() {
        return this.projectionRank;
    }

    private void setProjectionRank(int projectionRank) {
        this.projectionRank = projectionRank;
    }

    public void setNumericMonitor(MonitorI numericMonitor) {
        this.numericMonitor = numericMonitor;
    }

    public MonitorI getNumericMonitor() {
        return this.numericMonitor;
    }

    public void setAnalyticMonitor(Monitor analyticMonitor) {
        this.analyticMonitor = analyticMonitor;
    }

    public Monitor getAnalyticMonitor() {
        return this.analyticMonitor;
    }

    public static void chkCoordinates(double[] coords, InternalCoordinate q) {
        double[] c = null;
        if (q.getType() == 8) {
            Internals.GeneralCombinedInternal bq = (Internals.GeneralCombinedInternal)q;
            InternalCoordinate[] qs = bq.getComponentInternals();
            for (int i = 0; i < qs.length; ++i) {
                InternalCoordinateProjection.chkCoordinates(coords, qs[i]);
            }
            return;
        }
        c = q.getCartesianCoordinates();
        double s2 = JLinAlg.press(coords, c);
        if (s2 > 1.0E-12) {
            System.err.println("Cartesians does not match for coordinate (" + s2 + ") " + q.toString());
        }
    }

    public static void chkCoordinates(double[] coords, InternalCoordinateSystem qs) {
        InternalCoordinate[] q = qs.getInternalCoordinates();
        for (int i = 0; i < q.length; ++i) {
            InternalCoordinateProjection.chkCoordinates(coords, q[i]);
        }
    }
}

