/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.newmd;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.modelling.gui.StructureStream;
import chemaxon.marvin.modelling.newmd.MDException;
import chemaxon.marvin.modelling.newmd.MDSettings;
import chemaxon.marvin.modelling.newmd.MDSettingsPanel;
import chemaxon.marvin.modelling.newmd.MolecularDynamics;
import chemaxon.marvin.modelling.util.Canceller;
import chemaxon.marvin.modelling.util.CancellerImpl;
import chemaxon.struc.Molecule;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MD
implements StructureStream {
    private Molecule m = null;
    private MolecularDynamics mDyn = null;
    private MDSettings settings = null;
    private UserSettings userSettings = null;
    private MDSettingsPanel settingsPanel = null;
    private long count = 0L;
    private long maxStep = 0L;
    private Canceller canceller = null;

    public MD(Molecule m) {
        if (m != null && !m.isEmpty()) {
            this.m = m;
            this.init();
        }
    }

    public MD(MDSettings settings, Molecule m) {
        if (m != null && !m.isEmpty()) {
            this.m = m;
            this.settings = settings;
            this.init();
        }
    }

    public MD() {
        this.init();
    }

    public MD(MDSettings settings) {
        this.settings = settings;
        this.init();
    }

    private void init() {
        if (this.settings == null) {
            this.settings = new MDSettings();
        }
        if (this.mDyn == null && this.m != null && !this.m.isEmpty()) {
            if (this.m != null) {
                try {
                    this.mDyn = new MolecularDynamics(this.settings, this.m);
                }
                catch (MDException e) {
                    System.err.println("Exception cought in init.");
                    e.printStackTrace();
                    System.err.println(e.getMessage());
                    if (this.canceller == null) {
                        this.canceller = new CancellerImpl(true);
                    }
                    this.canceller.set();
                    return;
                }
            } else {
                this.mDyn = new MolecularDynamics(this.settings);
            }
            if (this.settingsPanel == null) {
                this.settingsPanel = new MDSettingsPanel(this.settings);
                if (this.userSettings != null) {
                    this.settingsPanel.setUserSettings(this.userSettings);
                }
                this.settingsPanel.run();
            }
            while (this.settingsPanel.isVisible()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(MD.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.settings.setResistance(false);
            this.setMaxStep(Long.MAX_VALUE);
        }
    }

    @Override
    public void exit() {
        if (this.settingsPanel != null) {
            this.settingsPanel.exit();
        }
    }

    @Override
    public boolean isVisible() {
        if (this.settingsPanel != null) {
            return this.settingsPanel.isVisible();
        }
        return false;
    }

    public long getMaxStep() {
        return this.maxStep;
    }

    public void setMaxStep(long maxStep) {
        this.maxStep = maxStep;
    }

    @Override
    public void setCanceller(Canceller canceller) {
        this.canceller = canceller;
    }

    @Override
    public void setMolecule(Molecule m) {
        this.m = m;
        try {
            if (this.mDyn == null) {
                this.init();
            } else {
                this.mDyn.setInputMolecule(m);
            }
        }
        catch (MDException e) {
            System.err.println(e.getMessage());
            if (this.canceller == null) {
                this.canceller = new CancellerImpl(true);
            }
            this.canceller.set();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.settingsPanel != null) {
            this.settingsPanel.setVisible(visible);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.canceller != null && this.canceller.isCancelled()) {
            return false;
        }
        if (this.count > this.maxStep) {
            return false;
        }
        return this.m != null && !this.m.isEmpty();
    }

    @Override
    public Molecule next() {
        try {
            Molecule retVal = this.mDyn.NextStep();
            ++this.count;
            return retVal;
        }
        catch (MDException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void remove() {
        this.m = null;
    }

    @Override
    public void run() {
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("No input file given.");
            System.exit(1);
        }
        MD md = null;
        try {
            MolImporter mi = new MolImporter(args[0]);
            md = new MD((Molecule)null);
            md.setMolecule(mi.read());
        }
        catch (IOException ex) {
            Logger.getLogger(MD.class.getName()).log(Level.SEVERE, null, ex);
        }
        md.setMaxStep(10000L);
        Molecule actual = null;
        MolExporter me = null;
        try {
            FileOutputStream outFile = new FileOutputStream("trajectory.sdf");
            me = new MolExporter(outFile, "sdf");
            while (md.hasNext()) {
                actual = md.next();
                me.write(actual);
            }
            me.close();
        }
        catch (MolExportException ex) {
            Logger.getLogger(MD.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MD.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(MD.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void setUserSettings(UserSettings userSettings) {
        this.userSettings = userSettings;
        if (this.settingsPanel != null) {
            this.settingsPanel.setUserSettings(userSettings);
        }
    }

    @Override
    public String getLabel() {
        String label = "";
        if (this.mDyn != null) {
            label = label + "t (fs): ";
            label = label + this.nDigit(this.mDyn.getElapsedTime(), 8, 1);
            label = label + " T: ";
            label = label + this.nDigit(this.mDyn.getLastTemperature(), 5, 0);
            label = label + " Ek: ";
            label = label + this.nDigit(this.mDyn.getLastKineticEnergy(), 5, 0);
            label = label + " Ep: ";
            label = label + this.nDigit(this.mDyn.getLastPotentialEnergy(), 5, 0);
            label = label + " E: ";
            label = label + this.nDigit(this.mDyn.getLastTotalEnergy(), 5, 0);
        }
        return label;
    }

    public String nDigit(double a, int len, int n) {
        int nDig = n;
        for (int i = 0; i < nDig; nDig *= 10, ++i) {
        }
        String nD = "";
        nD = nDig > 0 ? Double.toString(Math.round(a * (double)nDig) / (long)nDig) : Integer.toString((int)Math.round(a));
        while (nD.length() < len) {
            nD = " " + nD;
        }
        return nD;
    }

    @Override
    public void setDebugLevel(int level, String output) {
        if (this.mDyn == null) {
            this.init();
        }
        this.mDyn.setDebugLevel(level, output);
    }

    public Canceller getCanceller() {
        return this.canceller;
    }
}

