/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.newmd;

import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.modelling.newmd.MDSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MDSettingsPanel
implements Runnable,
ActionListener,
ChangeListener {
    private MDSettings settings = null;
    private JFrame settingsFrame = null;
    private UserSettings userSettings = null;
    private JSpinner mainTemperatureSpinner = null;
    private JCheckBox coolCheckBox = null;
    private JCheckBox resistanceCheckBox = null;

    public MDSettingsPanel(MDSettings settings) {
        this.settings = settings;
        this.init();
        if (this.settingsFrame == null) {
            System.err.println("MDSettingsPanel: init failed");
        }
    }

    public void setVisible(boolean visible) {
        if (this.settingsFrame != null) {
            this.settingsFrame.setVisible(visible);
            if (this.userSettings != null) {
                this.userSettings.setProperty("viewPlayerShowStreamSettings", Boolean.toString(this.isVisible()));
            }
        }
    }

    public boolean isVisible() {
        if (this.settingsFrame != null) {
            return this.settingsFrame.isVisible();
        }
        return false;
    }

    public void exit() {
        if (this.settingsFrame != null) {
            Rectangle b = this.settingsFrame.getBounds();
            if (this.userSettings != null) {
                this.userSettings.setProperty("MDSettingsWindowX", Integer.toString(b.x));
                this.userSettings.setProperty("MDSettingsWindowY", Integer.toString(b.y));
                this.userSettings.setProperty("MDSettingsWindowWidth", Integer.toString(b.width));
                this.userSettings.setProperty("MDSettingsWindowHeight", Integer.toString(b.height));
            }
            this.settingsFrame.setVisible(false);
            this.settingsFrame.getContentPane().removeAll();
            this.settingsFrame.dispose();
        }
    }

    private void init() {
        try {
            this.settingsFrame = new JFrame("MD settings");
        }
        catch (HeadlessException e) {
            e.printStackTrace();
            System.err.println("Let's continue and see what goes on.");
            return;
        }
        this.settingsFrame.setResizable(true);
        JPanel settingsPanel = new JPanel(new GridBagLayout());
        Border b = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        settingsPanel.setBorder(b);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 3.0;
        c.weighty = 1.0;
        JLabel label = new JLabel("Main temperature (K):");
        ++c.gridy;
        c.gridx = 21;
        label.setBorder(b);
        settingsPanel.add((Component)label, c);
        SpinnerNumberModel temperatureModel = new SpinnerNumberModel(this.settings.getTemperature(), 0.0, 5000.0, 50.0);
        JSpinner spinner = new JSpinner(temperatureModel);
        spinner.setName("temp1");
        spinner.setBorder(b);
        spinner.addChangeListener(this);
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setHorizontalAlignment(2);
        c.gridx = -1;
        settingsPanel.add((Component)spinner, c);
        this.mainTemperatureSpinner = spinner;
        label = new JLabel("Time step (fs):");
        ++c.gridy;
        c.gridx = 21;
        label.setBorder(b);
        settingsPanel.add((Component)label, c);
        SpinnerNumberModel timestepModel = new SpinnerNumberModel(this.settings.getStepSize(), 0.0, 3.0, 0.5);
        spinner = new JSpinner(timestepModel);
        spinner.setName("timestep");
        spinner.setBorder(b);
        spinner.addChangeListener(this);
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setHorizontalAlignment(2);
        c.gridx = -1;
        settingsPanel.add((Component)spinner, c);
        label = new JLabel("Thermostat:");
        ++c.gridy;
        c.gridx = 21;
        label.setBorder(b);
        settingsPanel.add((Component)label, c);
        JComboBox<String> thermoChooser = new JComboBox<String>(this.settings.getThermostatNames());
        thermoChooser.setEditable(false);
        thermoChooser.addActionListener(this);
        thermoChooser.setActionCommand("thermostat");
        thermoChooser.setSelectedIndex(this.settings.getThermostat());
        c.gridx = -1;
        thermoChooser.setBorder(b);
        settingsPanel.add(thermoChooser, c);
        label = new JLabel("Selective cooling:");
        ++c.gridy;
        c.gridx = 21;
        label.setBorder(b);
        settingsPanel.add((Component)label, c);
        JCheckBox coolButton = new JCheckBox();
        coolButton.setActionCommand("coolInternals");
        coolButton.setHorizontalTextPosition(10);
        coolButton.setFocusPainted(false);
        coolButton.addActionListener(this);
        c.gridx = -1;
        coolButton.setBorder(b);
        coolButton.setSelected(this.settings.isCoolInternals());
        settingsPanel.add((Component)coolButton, c);
        this.coolCheckBox = coolButton;
        label = new JLabel("Virtual resistance:");
        ++c.gridy;
        c.gridx = 21;
        label.setBorder(b);
        settingsPanel.add((Component)label, c);
        coolButton = new JCheckBox();
        coolButton.setActionCommand("resistance");
        coolButton.setHorizontalTextPosition(10);
        coolButton.setFocusPainted(false);
        coolButton.addActionListener(this);
        c.gridx = -1;
        coolButton.setBorder(b);
        coolButton.setSelected(this.settings.isCoolInternals());
        settingsPanel.add((Component)coolButton, c);
        this.resistanceCheckBox = coolButton;
        JButton button = new JButton("Defaults");
        button.addActionListener(this);
        ++c.gridy;
        c.gridx = 21;
        settingsPanel.add((Component)button, c);
        button = new JButton("Load");
        button.addActionListener(this);
        c.gridx = -1;
        settingsPanel.add((Component)button, c);
        button = new JButton("Done");
        button.addActionListener(this);
        ++c.gridy;
        c.gridx = 21;
        settingsPanel.add((Component)button, c);
        button = new JButton("Save");
        button.addActionListener(this);
        c.gridx = -1;
        settingsPanel.add((Component)button, c);
        this.settingsFrame.add(settingsPanel);
        this.settingsFrame.pack();
        this.settingsFrame.validate();
    }

    @Override
    public void run() {
        UserSettings propSet = this.userSettings;
        if (propSet != null) {
            String prop = propSet.getProperty("MDSettingsWindowX");
            Rectangle bounds = this.settingsFrame.getBounds();
            int x = bounds.x;
            int y = bounds.y;
            int xSize = bounds.width;
            int ySize = bounds.height;
            if (prop != null) {
                x = Integer.parseInt(prop);
            }
            if ((prop = propSet.getProperty("MDSettingsWindowY")) != null) {
                y = Integer.parseInt(prop);
            }
            if ((prop = propSet.getProperty("MDSettingsWindowWidth")) != null) {
                xSize = Integer.parseInt(prop);
            }
            if ((prop = propSet.getProperty("MDSettingsWindowHeight")) != null) {
                ySize = Integer.parseInt(prop);
            }
            this.settingsFrame.setBounds(x, y, xSize, ySize);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        System.err.println("Action command is: " + e.getActionCommand());
        if (command.equals("coolInternals")) {
            this.settings.setCoolInternals(((JCheckBox)e.getSource()).isSelected());
        } else if (command.equals("resistance")) {
            this.settings.setResistance(((JCheckBox)e.getSource()).isSelected());
        } else if (command.equals("thermostat")) {
            this.settings.setThermostat(((JComboBox)e.getSource()).getSelectedIndex());
        } else if (command.equals("Defaults")) {
            this.settings.setDefaults();
            this.coolCheckBox.setSelected(this.settings.isCoolInternals());
            this.resistanceCheckBox.setSelected(this.settings.isCoolInternals());
            this.mainTemperatureSpinner.setValue(new Double(this.settings.getTemperature()));
        } else if (command.equals("Done")) {
            this.settingsFrame.setVisible(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSpinner spinner = (JSpinner)e.getSource();
        String command = spinner.getName();
        if (command.equals("temp1")) {
            this.settings.setTemperature((Double)spinner.getValue());
        } else if (command.equals("timeStep")) {
            this.settings.setStepSize((Double)spinner.getValue());
        }
        System.err.println("Value changed: " + spinner.getName() + ": " + (Double)spinner.getValue());
    }

    public UserSettings getUserSettings() {
        return this.userSettings;
    }

    public void setUserSettings(UserSettings userSettings) {
        this.userSettings = userSettings;
        UserSettings propSet = userSettings;
        if (propSet != null) {
            String prop = propSet.getProperty("MDSettingsWindowX");
            Rectangle bounds = this.settingsFrame.getBounds();
            int x = bounds.x;
            int y = bounds.y;
            int xSize = bounds.width;
            int ySize = bounds.height;
            if (prop != null) {
                x = Integer.parseInt(prop);
            }
            if ((prop = propSet.getProperty("MDSettingsWindowY")) != null) {
                y = Integer.parseInt(prop);
            }
            if ((prop = propSet.getProperty("MDSettingsWindowWidth")) != null) {
                xSize = Integer.parseInt(prop);
            }
            if ((prop = propSet.getProperty("MDSettingsWindowHeight")) != null) {
                ySize = Integer.parseInt(prop);
            }
            this.settingsFrame.setBounds(x, y, xSize, ySize);
            String visible = propSet.getProperty("viewPlayerShowStreamSettings");
            if (visible != null) {
                this.setVisible(Boolean.getBoolean(visible));
            }
        }
    }
}

