/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.newmd;

import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.linalg.JQuatFit;
import chemaxon.marvin.modelling.linalg.internals.InternalCoordinate;
import chemaxon.marvin.modelling.newmd.Debug;
import chemaxon.marvin.modelling.newmd.InternalCoordinateProjection;
import chemaxon.marvin.modelling.newmd.MDException;
import chemaxon.marvin.modelling.newmd.MDSettings;
import chemaxon.marvin.modelling.newmd.OldThermostat;
import chemaxon.marvin.modelling.newmd.boundary.Monitor;
import chemaxon.marvin.modelling.newmd.boundary.MonitorI;
import chemaxon.marvin.modelling.util.Stopper;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class MDTools {
    protected MDSettings settings = null;
    protected Molecule mdmol;
    int atomcount;
    final double[] coords;
    final double[] velocities;
    OldThermostat tt = null;
    protected InternalCoordinateProjection icp = null;
    protected boolean useMassWeightedBMatrix = true;
    protected JLinAlg.Matrix matrixB = null;
    protected JLinAlg.Matrix massWeightedBMatrix = null;
    protected InternalCoordinate.BMatrixLine[] bMat = null;
    protected int[][] qfitpairs = null;
    protected double dt = 1.0;
    protected Stopper bMatStopper = null;
    protected Stopper mdStopper = null;
    protected Stopper projectionStopper = null;
    private int degreesOfFreedom = 0;
    private Monitor stepMonitor = null;
    private MonitorI numericMonitor = null;
    private Monitor analyticMonitor = null;

    public MDTools(MDSettings settings, Molecule mol) throws MDException {
        int i;
        this.settings = settings;
        if (mol == null || mol.isEmpty()) {
            throw new MDException("Molecule is empty.");
        }
        this.mdmol = mol;
        this.atomcount = mol.getAtomCount();
        this.setDegreesOfFreedom(this.atomcount * 3);
        this.coords = new double[this.atomcount * 3];
        this.velocities = new double[this.atomcount * 3];
        for (i = 0; i < this.atomcount; ++i) {
            MolAtom matom = this.mdmol.getAtom(i);
            if (matom.getMass() == 0.0) {
                throw new MDException("Molecule is not valid. Atommass can't be zero!");
            }
            this.coords[3 * i] = matom.getX();
            this.coords[3 * i + 1] = matom.getY();
            this.coords[3 * i + 2] = matom.getZ();
        }
        for (i = 0; i < this.velocities.length; ++i) {
            this.velocities[i] = 0.0;
        }
        this.tt = new OldThermostat(settings, this.mdmol, this.velocities);
        this.mdStopper = new Stopper(false, "MD Stopper");
        this.bMatStopper = new Stopper(false, "BMat Stopper");
        this.projectionStopper = new Stopper(false, "Projection Stopper");
    }

    public void setCoordinates(double[] newcoords) throws MDException {
        if (newcoords == null) {
            throw new MDException("New coordinate array is null.");
        }
        if (this.coords.length != newcoords.length) {
            throw new MDException("New coordinate array dimension is incompatible with the current molecule.");
        }
        System.arraycopy(newcoords, 0, this.coords, 0, newcoords.length);
        for (int i = 0; i < this.atomcount; ++i) {
            MolAtom matom = this.mdmol.getAtom(i);
            matom.setXYZ(newcoords[i * 3], newcoords[i * 3 + 1], newcoords[i * 3 + 2]);
        }
    }

    public void storeCoordinates(Molecule m, double[] d) throws MDException {
        if (d == null) {
            throw new MDException("New coordinate array is null.");
        }
        if (m == null) {
            throw new MDException("Molecule parameter is null.");
        }
        if (m.getAtomCount() * 3 != d.length) {
            throw new MDException("New coordinate array dimension is incompatible with the parameter molecule.");
        }
        int ac = m.getAtomCount();
        for (int i = 0; i < ac; ++i) {
            m.getAtom(i).setXYZ(d[3 * i], d[3 * i + 1], d[3 * i + 2]);
        }
    }

    public void centerCoordinates() {
        if (this.coords != null && this.coords.length != 0) {
            int i;
            System.out.println("Centering molecule");
            double avgx = 0.0;
            double avgy = 0.0;
            double avgz = 0.0;
            for (i = 0; i < this.atomcount; ++i) {
                avgx += this.coords[i * 3];
                avgy += this.coords[i * 3 + 1];
                avgz += this.coords[i * 3 + 2];
            }
            avgx /= (double)this.atomcount;
            avgy /= (double)this.atomcount;
            avgz /= (double)this.atomcount;
            for (i = 0; i < this.atomcount; ++i) {
                int n = i * 3;
                this.coords[n] = this.coords[n] - avgx;
                int n2 = i * 3 + 1;
                this.coords[n2] = this.coords[n2] - avgy;
                int n3 = i * 3 + 2;
                this.coords[n3] = this.coords[n3] - avgz;
            }
        }
    }

    public void setVelocities(double[] newvelocities) throws MDException {
        if (newvelocities == null) {
            throw new MDException("Velocity array is null.");
        }
        if (this.velocities.length != newvelocities.length) {
            throw new MDException("New velocity array dimension is incompatible.");
        }
        double[] tmpVelocities = newvelocities;
        if (this.settings.isCoolInternals() || this.settings.isCoolTranslationRotation()) {
            tmpVelocities = this.getProjectedVelocities(newvelocities);
        }
        System.arraycopy(tmpVelocities, 0, this.velocities, 0, this.atomcount * 3);
        if (this.settings.getThermostat() > 0) {
            this.tt.scaleTemperature(this.velocities, this.getDegreesOfFreedom());
        }
    }

    public void setInitialVelocities() throws MDException {
        this.tt.setInitialVelocities();
    }

    public double getRealTemperature() {
        return this.tt.getRealTemperature(this.velocities, this.getDegreesOfFreedom());
    }

    public double getTemperature() {
        return this.getRealTemperature();
    }

    protected double[] getProjectedVelocities(double[] velocities) {
        int i;
        int nDeg = this.atomcount * 3 - 6;
        double origEKin = this.getKineticEnergy(velocities);
        boolean internalProjection = this.settings.isCoolInternals();
        boolean translationRotationProjection = this.settings.isCoolTranslationRotation();
        if (!internalProjection && !translationRotationProjection) {
            this.setDegreesOfFreedom(nDeg);
            return velocities;
        }
        double[] newvelocities = null;
        if ((Debug.debuglevel & 2) > 0) {
            Debug.debugstream.println("Temperature at entering projection: " + this.tt.getTemperature(velocities));
        }
        if (this.qfitpairs == null) {
            this.qfitpairs = new int[2][this.atomcount];
            for (i = 0; i < this.atomcount; ++i) {
                this.qfitpairs[0][i] = i;
                this.qfitpairs[1][i] = i;
            }
        }
        if (internalProjection) {
            int j;
            int i2;
            double[] mVec;
            if (this.icp == null) {
                this.icp = new InternalCoordinateProjection(this.mdmol);
                this.icp.setAnalyticMonitor(this.analyticMonitor);
                this.icp.setNumericMonitor(this.numericMonitor);
            }
            this.bMatStopper.start();
            this.matrixB = this.icp.calculateBondLengthB(this.coords);
            this.bMatStopper.stop();
            this.projectionStopper.start();
            if (this.useMassWeightedBMatrix) {
                this.massWeightedBMatrix = new JLinAlg.Matrix(this.matrixB.nRows, this.matrixB.nCols);
                mVec = new double[velocities.length];
                for (i2 = 0; i2 < this.mdmol.getAtomCount(); ++i2) {
                    for (j = 0; j < 3; ++j) {
                        mVec[i2 * 3 + j] = 1.0 / this.mdmol.getAtom(i2).getMass();
                    }
                }
                for (i2 = 0; i2 < this.matrixB.nRows; ++i2) {
                    int rShft = this.matrixB.rowIndex(i2);
                    int lShft = this.massWeightedBMatrix.rowIndex(i2);
                    for (int j2 = 0; j2 < mVec.length; ++j2) {
                        this.massWeightedBMatrix.aVec[lShft + j2] = this.matrixB.aVec[rShft + j2] * mVec[j2];
                    }
                }
                newvelocities = JLinAlg.VectCopy(velocities, newvelocities);
                for (i2 = 0; i2 < newvelocities.length; ++i2) {
                    int n = i2;
                    newvelocities[n] = newvelocities[n] / mVec[i2];
                }
                newvelocities = this.icp.projectVelocities(this.massWeightedBMatrix, newvelocities);
                for (i2 = 0; i2 < newvelocities.length; ++i2) {
                    int n = i2;
                    newvelocities[n] = newvelocities[n] * mVec[i2];
                }
            } else {
                mVec = new double[velocities.length];
                for (i2 = 0; i2 < this.mdmol.getAtomCount(); ++i2) {
                    for (j = 0; j < 3; ++j) {
                        mVec[i2 * 3 + j] = this.mdmol.getAtom(i2).getMass();
                    }
                }
                newvelocities = JLinAlg.VectCopy(velocities, newvelocities);
                for (i2 = 0; i2 < newvelocities.length; ++i2) {
                    int n = i2;
                    newvelocities[n] = newvelocities[n] * mVec[i2];
                }
                newvelocities = this.icp.projectVelocities(this.matrixB, newvelocities);
                for (i2 = 0; i2 < newvelocities.length; ++i2) {
                    int n = i2;
                    newvelocities[n] = newvelocities[n] / mVec[i2];
                }
            }
            this.projectionStopper.stop();
            if ((Debug.debuglevel & 2) > 0) {
                Debug.debugstream.println("Temperature of internal projection: " + this.tt.getTemperature(newvelocities));
            }
            for (i = 0; i < this.atomcount * 3; ++i) {
                newvelocities[i] = velocities[i] - newvelocities[i];
            }
            if ((Debug.debuglevel & 2) > 0) {
                Debug.debugstream.println("Temperature after removal projection: " + this.tt.getTemperature(newvelocities));
            }
            this.setDegreesOfFreedom(nDeg -= this.icp.getProjectionRank());
            if (!translationRotationProjection) {
                this.centerCoordinates();
                return newvelocities;
            }
        }
        if (newvelocities == null) {
            newvelocities = JLinAlg.VectCopy(velocities);
        }
        double[][] refcoords = new double[this.atomcount][3];
        double[][] newcoords = new double[this.atomcount][3];
        double[][] fitcoords = new double[this.atomcount][3];
        for (int i3 = 0; i3 < this.atomcount; ++i3) {
            refcoords[i3][0] = this.coords[i3 * 3];
            refcoords[i3][1] = this.coords[i3 * 3 + 1];
            refcoords[i3][2] = this.coords[i3 * 3 + 2];
            newcoords[i3][0] = refcoords[i3][0] + newvelocities[i3 * 3] * this.dt;
            newcoords[i3][1] = refcoords[i3][1] + newvelocities[i3 * 3 + 1] * this.dt;
            newcoords[i3][2] = refcoords[i3][2] + newvelocities[i3 * 3 + 2] * this.dt;
            fitcoords[i3][0] = newcoords[i3][0];
            fitcoords[i3][1] = newcoords[i3][1];
            fitcoords[i3][2] = newcoords[i3][2];
        }
        JQuatFit qfr = new JQuatFit(refcoords);
        double[] mWeight = new double[this.mdmol.getAtomCount()];
        for (int i4 = 0; i4 < mWeight.length; ++i4) {
            mWeight[i4] = this.mdmol.getAtom(i4).getMass();
            int n = i4;
            mWeight[n] = mWeight[n] * mWeight[i4];
        }
        qfr.quatfit(fitcoords, mWeight, this.qfitpairs);
        double[][] transvelo = new double[this.atomcount][3];
        for (int i5 = 0; i5 < this.atomcount; ++i5) {
            transvelo[i5][0] = (newcoords[i5][0] - fitcoords[i5][0]) / this.dt;
            transvelo[i5][1] = (newcoords[i5][1] - fitcoords[i5][1]) / this.dt;
            transvelo[i5][2] = (newcoords[i5][2] - fitcoords[i5][2]) / this.dt;
            int n = i5 * 3;
            newvelocities[n] = newvelocities[n] - transvelo[i5][0];
            int n2 = i5 * 3 + 1;
            newvelocities[n2] = newvelocities[n2] - transvelo[i5][1];
            int n3 = i5 * 3 + 2;
            newvelocities[n3] = newvelocities[n3] - transvelo[i5][2];
        }
        if ((Debug.debuglevel & 2) > 0) {
            Debug.debugstream.println("Temperature after tr-rot removal: " + this.tt.getTemperature(newvelocities));
        }
        this.setDegreesOfFreedom(nDeg);
        double newEKin = this.getKineticEnergy(newvelocities);
        if (newEKin > 0.0) {
            double scale = Math.sqrt(origEKin / newEKin);
            JLinAlg.VectScale(newvelocities, scale, newvelocities);
            newEKin = this.getKineticEnergy(newvelocities);
        }
        return newvelocities;
    }

    public double[] getCoordinates() {
        return this.coords;
    }

    public double[] getVelocities() {
        return this.velocities;
    }

    public double getKineticEnergy() {
        return this.tt.getKineticEnergy();
    }

    public double getKineticEnergy(double[] velocities) {
        return this.tt.getKineticEnergy(velocities);
    }

    public double[] getAtomicValues(double[] val3D) {
        double[] av = new double[val3D.length / 3];
        for (int i = 0; i < av.length; ++i) {
            double s2 = 0.0;
            for (int j = 0; j < 3; ++j) {
                s2 += val3D[i * 3 + j] * val3D[i * 3 + j];
            }
            av[i] = Math.sqrt(s2);
        }
        return av;
    }

    public long getProjectionTime() {
        return this.projectionStopper.getElapsedTime();
    }

    public long getBMatrixTime() {
        return this.bMatStopper.getElapsedTime();
    }

    public long getMdTime() {
        return this.mdStopper.getElapsedTime();
    }

    public int getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    private void setDegreesOfFreedom(int degreesOfFreedom) {
        this.degreesOfFreedom = degreesOfFreedom;
    }

    public Monitor getStepMonitor() {
        return this.stepMonitor;
    }

    public void setStepMonitor(Monitor stepMonitor) {
        this.stepMonitor = stepMonitor;
    }

    public MonitorI getNumericMonitor() {
        return this.numericMonitor;
    }

    public void setNumericMonitor(MonitorI numericMonitor) {
        this.numericMonitor = numericMonitor;
    }

    public Monitor getAnalyticMonitor() {
        return this.analyticMonitor;
    }

    public void setAnalyticMonitor(Monitor analyticMonitor) {
        this.analyticMonitor = analyticMonitor;
    }
}

