/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.newmd;

import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.newmd.Debug;
import chemaxon.marvin.modelling.newmd.MDException;
import chemaxon.marvin.modelling.newmd.MDSettings;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class OldThermostat {
    private MDSettings settings = null;
    private Molecule mdmol;
    private int atomcount;
    private double[] atommass;
    private double[] velocities = null;
    private double currentTemperature = 300.0;
    private double thermostatTimeConstant = 10.0;
    private double timeStep = 0.5;
    private double filledTime = 0.0;
    private double[] lastvelocity = null;
    private double lastTemperature = 0.0;

    OldThermostat(MDSettings settings, Molecule mol, double[] velocities) {
        this.settings = settings;
        this.setThermostatTimeConstant(settings.getThermostatTimeConstant());
        this.setTimeStep(settings.getStepSize());
        this.fillAtomMassTable(mol);
        this.velocities = velocities;
    }

    OldThermostat(MDSettings settings, Molecule mol) {
        this.settings = settings;
        this.fillAtomMassTable(mol);
        this.velocities = null;
    }

    protected void setVelocities(double[] velocities) {
        this.velocities = velocities;
    }

    private void fillAtomMassTable(Molecule mol) {
        this.mdmol = mol;
        this.atomcount = this.mdmol.getAtomCount();
        this.atommass = new double[this.atomcount];
        for (int i = 0; i < this.atomcount; ++i) {
            MolAtom matom = this.mdmol.getAtom(i);
            this.atommass[i] = matom.getMass();
        }
    }

    public void setInitialVelocities() throws MDException {
        double temp = this.settings.getTemperature();
        if (this.velocities == null) {
            throw new MDException("Atom velocity array is null.");
        }
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Target temperature: " + temp);
        }
        for (int i = 0; i < this.atomcount; ++i) {
            for (int j = 0; j < 3; ++j) {
                double rsum = 0.0;
                for (int k = 0; k < 12; ++k) {
                    rsum += Math.random();
                }
                this.velocities[i * 3 + j] = (rsum -= 6.0) / this.atommass[i];
            }
        }
        double temptemp = this.getTemperature(this.velocities);
        double scale = Math.sqrt(temp / temptemp);
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Temporary Temperature set to: " + temptemp);
            Debug.debugstream.println("Scaling: " + scale);
        }
        int i = 0;
        while (i < this.atomcount * 3) {
            int n = i++;
            this.velocities[n] = this.velocities[n] * scale;
        }
        this.currentTemperature = this.getTemperature(this.velocities);
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Current temperature: " + this.currentTemperature + "K");
        }
    }

    public void scaleTemperature(double[] newvelocities, int degreesOfFreedom) {
        this.scaleTemperature(newvelocities, this.settings.getTemperature(), degreesOfFreedom);
    }

    public void scaleTemperature(double[] newvelocities, double targetTemperature, int degreesOfFreedom) {
        double newtemp = this.getRealTemperature(newvelocities, degreesOfFreedom);
        double scalingFactor = 1.0;
        if (this.settings.getThermostat() > 1) {
            scalingFactor = this.settings.getStepSize() / this.settings.getThermostatTimeConstant();
        }
        double scale = (Math.sqrt(targetTemperature / newtemp) - 1.0) * scalingFactor + 1.0;
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Temperature of the molecule: " + newtemp + " K");
            Debug.debugstream.println("Target temperature: " + targetTemperature + "K");
            Debug.debugstream.println("Scaling: " + scale);
        }
        for (int i = 0; i < this.atomcount * 3; ++i) {
            this.velocities[i] = newvelocities[i] * scale;
        }
        this.currentTemperature = this.getTemperature(this.velocities);
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Current temperature: " + this.currentTemperature + "K");
        }
    }

    public void scaleToTargetTemperature(double[] newvelocities, int degreesOfFreedom) {
        double newtemp = this.getRealTemperature(newvelocities, degreesOfFreedom);
        double targetTemperature = this.settings.getTemperature();
        double scalingFactor = 1.0;
        if (this.settings.getThermostat() > 1) {
            scalingFactor = this.settings.getStepSize() / this.settings.getThermostatTimeConstant();
        }
        double scale = (Math.sqrt(targetTemperature / newtemp) - 1.0) * scalingFactor + 1.0;
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Temperature of the molecule: " + newtemp + "K");
            Debug.debugstream.println("Target temperature: " + targetTemperature + "K");
            Debug.debugstream.println("Scaling: " + scale);
        }
        for (int i = 0; i < this.atomcount * 3; ++i) {
            this.velocities[i] = newvelocities[i] * scale;
        }
        this.currentTemperature = this.getTemperature(this.velocities);
        if ((Debug.debuglevel & 4) > 0) {
            Debug.debugstream.println("Current temperature: " + this.currentTemperature + "K");
        }
    }

    public double getTemperature() {
        return this.getTemperature(this.velocities);
    }

    public double getTemperature(double[] atomvelo) {
        double temp = 2.0 * this.getKineticEnergy(atomvelo) * 4186.8 / 6.02214199E23 / 1.3806505E-23 / (double)(this.mdmol.getAtomCount() * 3);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getRealTemperature(double[] atomvelo, int nDegreesOfFreedom) {
        double temp = 2.0 * this.getKineticEnergy(atomvelo) * 4186.8 / 6.02214199E23 / 1.3806505E-23 / (double)nDegreesOfFreedom;
        if (this.lastvelocity == null) {
            this.lastvelocity = JLinAlg.VectCopy(atomvelo);
        }
        double realT = 0.0;
        MDSettings mDSettings = this.settings;
        synchronized (mDSettings) {
            if (JLinAlg.VLength(JLinAlg.vectSubtract(this.lastvelocity, atomvelo)) != 0.0) {
                this.filledTime = Math.min(this.filledTime, this.getThermostatTimeConstant() - this.getTimeStep());
                double newFilltime = this.filledTime + this.getTimeStep();
                realT = (this.filledTime * this.lastTemperature + this.getTimeStep() * temp) / newFilltime;
                this.filledTime = newFilltime;
                JLinAlg.VectCopy(atomvelo, this.lastvelocity);
            } else {
                realT = this.lastTemperature;
            }
        }
        return temp;
    }

    public double getKineticEnergy() {
        return this.getKineticEnergy(this.velocities);
    }

    public double getKineticEnergy(double[] atomvelo) {
        double kinenergy = 0.0;
        for (int i = 0; i < this.atomcount; ++i) {
            double v2 = 0.0;
            for (int j = 0; j < 3; ++j) {
                v2 += atomvelo[i * 3 + j] * atomvelo[i * 3 + j];
            }
            kinenergy += this.atommass[i] * v2 / 2.0;
        }
        return kinenergy /= 4.1868E-4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThermostatTimeConstant(double thermostatTimeConstant) {
        MDSettings mDSettings = this.settings;
        synchronized (mDSettings) {
            this.settings.setThermostatTimeConstant(thermostatTimeConstant);
        }
        this.thermostatTimeConstant = thermostatTimeConstant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getThermostatTimeConstant() {
        MDSettings mDSettings = this.settings;
        synchronized (mDSettings) {
            this.thermostatTimeConstant = this.settings.getThermostatTimeConstant();
        }
        return this.thermostatTimeConstant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeStep(double timeStep) {
        MDSettings mDSettings = this.settings;
        synchronized (mDSettings) {
            this.settings.setStepSize(timeStep);
        }
        this.timeStep = timeStep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTimeStep() {
        MDSettings mDSettings = this.settings;
        synchronized (mDSettings) {
            this.timeStep = this.settings.getStepSize();
        }
        return this.timeStep;
    }
}

