/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.newmd;

import chemaxon.marvin.modelling.debug.ErrPrint;
import chemaxon.marvin.modelling.linalg.JLinAlg;
import chemaxon.marvin.modelling.mm.ForceField;
import chemaxon.marvin.modelling.newmd.Debug;
import chemaxon.marvin.modelling.newmd.InternalCoordinateProjection;
import chemaxon.marvin.modelling.newmd.MDException;
import chemaxon.marvin.modelling.newmd.MDSettings;
import chemaxon.marvin.modelling.newmd.MDTools;
import chemaxon.marvin.modelling.newmd.OldIntegrator;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.Iterator;

public class ProjectedVelocityVerlet
extends MDTools
implements OldIntegrator {
    double[] a;
    double[] grad;
    double potenergy = 0.0;
    double accelScale = 1.0;
    ForceField ff = null;
    long stepCount = 0L;

    public ProjectedVelocityVerlet(MDSettings settings, Molecule mol, ForceField forcefield) throws MDException {
        super(settings, mol);
        if (forcefield == null) {
            throw new MDException("Force field must be initialized before intergrator called.");
        }
        this.a = new double[this.atomcount * 3];
        this.grad = new double[this.atomcount * 3];
        this.ff = forcefield;
        for (int i = 0; i < this.atomcount * 3; ++i) {
            this.grad[i] = 0.0;
            this.a[i] = 0.0;
        }
        this.icp = new InternalCoordinateProjection(mol);
        this.stepCount = 0L;
    }

    public void setStepTime(double femtosectimestep) throws MDException {
        if (femtosectimestep <= 0.0) {
            throw new MDException("Time step should be positive.");
        }
        this.dt = femtosectimestep;
        this.accelScale = Math.min(1.0, this.dt / 2.5);
        System.err.println("Set projection scaling to " + this.accelScale);
    }

    @Override
    public double getPotentialEnergy() {
        return this.potenergy;
    }

    @Override
    public Iterator Update() {
        return new UpdateData();
    }

    @Override
    public void setInitialVelocities() throws MDException {
        super.setInitialVelocities();
        if ((Debug.debuglevel & 1) > 0) {
            int i;
            Debug.debugstream.println("Input:");
            Debug.debugstream.println("Step time: " + this.dt + " fs");
            Debug.debugstream.println();
            Debug.debugstream.println("Coordinates (x y z) Angstrom");
            for (i = 0; i < this.atomcount; ++i) {
                MolAtom matom = this.mdmol.getAtom(i);
                double matommass = matom.getMass();
                Debug.debugstream.println(i + ".\t" + matommass + "\t" + this.coords[i * 3] + "\t" + this.coords[i * 3 + 1] + "\t" + this.coords[i * 3 + 2]);
            }
            Debug.debugstream.println();
            Debug.debugstream.println("Velocities (x y z) Angstrom/femtosecond");
            for (i = 0; i < this.atomcount; ++i) {
                Debug.debugstream.println(i + ".\t" + this.velocities[i * 3] + "\t" + this.velocities[i * 3 + 1] + "\t" + this.velocities[i * 3 + 2]);
            }
            Debug.debugstream.println();
        }
        double[] newvelocities = this.getProjectedVelocities(this.velocities);
        if (this.getDegreesOfFreedom() <= 0) {
            throw new MDException("Degrees of freedom is 0.");
        }
        this.tt.scaleTemperature(newvelocities, this.getDegreesOfFreedom());
        if ((Debug.debuglevel & 1) > 0) {
            Debug.debugstream.println();
            Debug.debugstream.println("Projected velocities (x y z) Angstrom/femtosecond");
            for (int i = 0; i < this.atomcount; ++i) {
                Debug.debugstream.println(i + ".\t" + this.velocities[i * 3] + "\t" + this.velocities[i * 3 + 1] + "\t" + this.velocities[i * 3 + 2]);
            }
            Debug.debugstream.println();
        }
    }

    private boolean NaNCheck(double[] a) {
        boolean nan;
        boolean bl = nan = !U.isDoubleOK(a);
        if (nan) {
            ErrPrint.errPrint("Nan found:", a);
            throw new UnsupportedOperationException("NaN");
        }
        return nan;
    }

    class UpdateData
    implements Iterator {
        UpdateData() {
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        public Object next() {
            int i;
            int i2;
            if (ProjectedVelocityVerlet.this.getStepMonitor() != null) {
                ProjectedVelocityVerlet.this.getStepMonitor().start();
            }
            if ((Debug.debuglevel & 1) > 0) {
                Debug.debugstream.println("NEXT MD step...");
                Debug.debugstream.println("Next atomcount:" + ProjectedVelocityVerlet.this.atomcount);
                Debug.debugstream.println("Next length:" + ProjectedVelocityVerlet.this.coords.length);
                Debug.debugstream.println("Step time: " + ProjectedVelocityVerlet.this.dt + " fs");
                Debug.debugstream.println();
                Debug.debugstream.println("Coordinates (x y z) Angstrom");
                for (i2 = 0; i2 < ProjectedVelocityVerlet.this.atomcount; ++i2) {
                    MolAtom matom = ProjectedVelocityVerlet.this.mdmol.getAtom(i2);
                    double matommass = matom.getMass();
                    Debug.debugstream.println(i2 + ".\t" + matommass + "\t" + ProjectedVelocityVerlet.this.coords[i2 * 3] + "\t" + ProjectedVelocityVerlet.this.coords[i2 * 3 + 1] + "\t" + ProjectedVelocityVerlet.this.coords[i2 * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Velocities (x y z) Angstrom/femtosecond");
                for (i2 = 0; i2 < ProjectedVelocityVerlet.this.atomcount; ++i2) {
                    Debug.debugstream.println(i2 + ".\t" + ProjectedVelocityVerlet.this.velocities[i2 * 3] + "\t" + ProjectedVelocityVerlet.this.velocities[i2 * 3 + 1] + "\t" + ProjectedVelocityVerlet.this.velocities[i2 * 3 + 2]);
                }
                Debug.debugstream.println();
            }
            for (i2 = 0; i2 < ProjectedVelocityVerlet.this.atomcount * 3; ++i2) {
                ProjectedVelocityVerlet.this.coords[i2] = ProjectedVelocityVerlet.this.coords[i2] + ProjectedVelocityVerlet.this.velocities[i2] * ProjectedVelocityVerlet.this.dt + ProjectedVelocityVerlet.this.a[i2] * ProjectedVelocityVerlet.this.dt * ProjectedVelocityVerlet.this.dt / 2.0;
                ProjectedVelocityVerlet.this.velocities[i2] = ProjectedVelocityVerlet.this.velocities[i2] + ProjectedVelocityVerlet.this.a[i2] * ProjectedVelocityVerlet.this.dt / 2.0;
            }
            ProjectedVelocityVerlet.this.NaNCheck(ProjectedVelocityVerlet.this.a);
            ProjectedVelocityVerlet.this.NaNCheck(ProjectedVelocityVerlet.this.velocities);
            ProjectedVelocityVerlet.this.NaNCheck(ProjectedVelocityVerlet.this.coords);
            ProjectedVelocityVerlet.this.NaNCheck(ProjectedVelocityVerlet.this.grad);
            ProjectedVelocityVerlet.this.mdStopper.start();
            ProjectedVelocityVerlet.this.ff.setCrd(ProjectedVelocityVerlet.this.coords);
            ProjectedVelocityVerlet.this.grad = ProjectedVelocityVerlet.this.ff.getForceFieldGradient();
            double[] gradsave = JLinAlg.VectCopy(ProjectedVelocityVerlet.this.grad);
            ProjectedVelocityVerlet.this.potenergy = ProjectedVelocityVerlet.this.ff.getEnergy();
            if (Double.isNaN(ProjectedVelocityVerlet.this.potenergy)) {
                System.err.println("Potenergy is NaN.");
            }
            ProjectedVelocityVerlet.this.mdStopper.stop();
            ProjectedVelocityVerlet.this.matrixB = ProjectedVelocityVerlet.this.icp.calculateBondLengthB(ProjectedVelocityVerlet.this.coords);
            if (ProjectedVelocityVerlet.this.accelScale != 1.0) {
                double[] constrainedGrad = ProjectedVelocityVerlet.this.icp.projectVelocities(ProjectedVelocityVerlet.this.matrixB, ProjectedVelocityVerlet.this.grad);
                double[] unconstrainedGrad = JLinAlg.vectSubtract(ProjectedVelocityVerlet.this.grad, constrainedGrad);
                JLinAlg.VectScaleAndAdd(unconstrainedGrad, ProjectedVelocityVerlet.this.accelScale, constrainedGrad, ProjectedVelocityVerlet.this.grad);
            }
            if ((Debug.debuglevel & 2) > 0) {
                Debug.debugstream.println("Temperature before projection: " + ProjectedVelocityVerlet.this.tt.getTemperature(ProjectedVelocityVerlet.this.velocities));
            }
            ProjectedVelocityVerlet.this.NaNCheck(ProjectedVelocityVerlet.this.velocities);
            double[] newvelocities = ProjectedVelocityVerlet.this.getProjectedVelocities(ProjectedVelocityVerlet.this.velocities);
            if ((Debug.debuglevel & 2) > 0) {
                Debug.debugstream.println("Temperature after projection: " + ProjectedVelocityVerlet.this.tt.getTemperature(newvelocities));
            }
            ProjectedVelocityVerlet.this.NaNCheck(newvelocities);
            ProjectedVelocityVerlet.this.NaNCheck(ProjectedVelocityVerlet.this.velocities);
            if (ProjectedVelocityVerlet.this.settings.getThermostat() > 0) {
                ProjectedVelocityVerlet.this.tt.scaleTemperature(newvelocities, ProjectedVelocityVerlet.this.getDegreesOfFreedom());
                ProjectedVelocityVerlet.this.NaNCheck(newvelocities);
                ProjectedVelocityVerlet.this.NaNCheck(ProjectedVelocityVerlet.this.velocities);
            } else if (newvelocities != ProjectedVelocityVerlet.this.velocities) {
                JLinAlg.VectCopy(newvelocities, ProjectedVelocityVerlet.this.velocities);
                ProjectedVelocityVerlet.this.NaNCheck(ProjectedVelocityVerlet.this.velocities);
            }
            ProjectedVelocityVerlet.this.NaNCheck(ProjectedVelocityVerlet.this.velocities);
            if ((Debug.debuglevel & 2) > 0) {
                Debug.debugstream.println("Temperature after termostate: " + ProjectedVelocityVerlet.this.tt.getTemperature(ProjectedVelocityVerlet.this.velocities));
            }
            ProjectedVelocityVerlet.this.NaNCheck(ProjectedVelocityVerlet.this.velocities);
            if (ProjectedVelocityVerlet.this.settings.isResistance()) {
                System.err.println("Apply virtual resistance....");
                for (int i3 = 0; i3 < ProjectedVelocityVerlet.this.atomcount; ++i3) {
                    double v2 = Math.sqrt(JLinAlg.VDot(3, ProjectedVelocityVerlet.this.velocities, i3 * 3, ProjectedVelocityVerlet.this.velocities, i3 * 3));
                    double Sc = v2 * ProjectedVelocityVerlet.this.settings.getResistanceCoefficient();
                    JLinAlg.VectScaleAndAdd(3, ProjectedVelocityVerlet.this.grad, i3 * 3, Sc, ProjectedVelocityVerlet.this.velocities, i3 * 3, ProjectedVelocityVerlet.this.grad, i3 * 3);
                }
            }
            ProjectedVelocityVerlet.this.NaNCheck(ProjectedVelocityVerlet.this.velocities);
            double[] velsave = JLinAlg.VectCopy(ProjectedVelocityVerlet.this.velocities);
            for (i = 0; i < ProjectedVelocityVerlet.this.atomcount; ++i) {
                MolAtom matom = ProjectedVelocityVerlet.this.mdmol.getAtom(i);
                double matommass = matom.getMass();
                for (int j = 0; j < 3; ++j) {
                    ProjectedVelocityVerlet.this.a[i * 3 + j] = -4.1868E-4 * ProjectedVelocityVerlet.this.grad[i * 3 + j] / matommass;
                    ProjectedVelocityVerlet.this.velocities[i * 3 + j] = ProjectedVelocityVerlet.this.velocities[i * 3 + j] + ProjectedVelocityVerlet.this.a[i * 3 + j] * ProjectedVelocityVerlet.this.dt / 2.0;
                }
            }
            ProjectedVelocityVerlet.this.NaNCheck(ProjectedVelocityVerlet.this.velocities);
            if ((Debug.debuglevel & 2) > 0) {
                Debug.debugstream.println("After MD step...");
                Debug.debugstream.println("Accelerations (x y z) Angstrom/femtosecond^2");
                for (i = 0; i < ProjectedVelocityVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + ProjectedVelocityVerlet.this.a[i * 3] + "\t" + ProjectedVelocityVerlet.this.a[i * 3 + 1] + "\t" + ProjectedVelocityVerlet.this.a[i * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Coordinates (x y z) Angstrom");
                for (i = 0; i < ProjectedVelocityVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + ProjectedVelocityVerlet.this.coords[i * 3] + "\t" + ProjectedVelocityVerlet.this.coords[i * 3 + 1] + "\t" + ProjectedVelocityVerlet.this.coords[i * 3 + 2]);
                }
                Debug.debugstream.println();
                Debug.debugstream.println("Velocities (x y z) Angstrom/femtosecond");
                for (i = 0; i < ProjectedVelocityVerlet.this.atomcount; ++i) {
                    Debug.debugstream.println(i + ".\t" + ProjectedVelocityVerlet.this.velocities[i * 3] + "\t" + ProjectedVelocityVerlet.this.velocities[i * 3 + 1] + "\t" + ProjectedVelocityVerlet.this.velocities[i * 3 + 2]);
                }
            }
            ProjectedVelocityVerlet.this.NaNCheck(ProjectedVelocityVerlet.this.velocities);
            if (ProjectedVelocityVerlet.this.getStepMonitor() != null) {
                ProjectedVelocityVerlet.this.getStepMonitor().stop();
            }
            ++ProjectedVelocityVerlet.this.stepCount;
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

