/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.newmd;

import chemaxon.marvin.modelling.linalg.JLinAlg;

public abstract class Thermostat {
    private double[] m = null;
    private String name = "None";
    private int degreesOfFreedom = -1;
    private double[] velocities = null;
    private double desiredTemperature = -1.0;
    private double actualTemperature = -1.0;
    private static int dimension = 3;

    public Thermostat() {
    }

    public Thermostat(String name) {
        this.setName(name);
    }

    public Thermostat(double[] m) {
        this.setMasses(m);
    }

    public Thermostat(double[] m, String name) {
        this.setMasses(m);
        this.setName(name);
    }

    public double[] getRandomVelocities() {
        return Thermostat.getRandomVelocities(this.m, this.desiredTemperature, this.velocities);
    }

    public static double[] getRandomVelocities(double[] m, double desiredTemperature, double[] velocities) {
        int i;
        if (velocities == null) {
            velocities = new double[m.length * Thermostat.getDimension()];
        }
        for (i = 0; i < m.length; ++i) {
            int ij = i * Thermostat.getDimension();
            for (int j = 0; j < Thermostat.getDimension(); ++j) {
                double rsum = 0.0;
                for (int k = 0; k < 12; ++k) {
                    rsum += Math.random();
                }
                velocities[ij + j] = rsum -= 6.0;
            }
        }
        for (i = 0; i < m.length; ++i) {
            for (int j = 0; j < Thermostat.getDimension(); ++j) {
                int n = i * Thermostat.getDimension() + j;
                velocities[n] = velocities[n] / m[i];
            }
        }
        return velocities;
    }

    public double getKineticEnergy() {
        return Thermostat.getKineticEnergy(this.m, this.velocities);
    }

    public double getKineticEnergy(double[] velocities) {
        return Thermostat.getKineticEnergy(this.m, velocities);
    }

    public static double getKineticEnergy(double[] m, double[] velocities) {
        if (m == null || m.length == 0) {
            return 0.0;
        }
        double kinenergy = 0.0;
        for (int i = 0; i < m.length; ++i) {
            double v2 = 0.0;
            for (int j = 0; j < Thermostat.getDimension(); ++j) {
                v2 += velocities[i * Thermostat.getDimension() + j] * velocities[i * Thermostat.getDimension() + j];
            }
            kinenergy += m[i] * v2 / 2.0;
        }
        return kinenergy /= 4.1868E-4;
    }

    public double[] getMasses() {
        return this.m;
    }

    public void setMasses(double[] m) {
        this.m = m;
        if (this.degreesOfFreedom < 0) {
            this.degreesOfFreedom = m.length * Thermostat.getDimension();
        }
    }

    public int getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    public void setDegreesOfFreedom(int degreesOfFreedom) {
        this.degreesOfFreedom = degreesOfFreedom;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double[] getVelocities() {
        return this.velocities;
    }

    public void setVelocities(double[] velocities) {
        this.velocities = velocities;
    }

    public double getDesiredTemperature() {
        return this.desiredTemperature;
    }

    public void setDesiredTemperature(double desiredTemperature) {
        this.desiredTemperature = desiredTemperature;
    }

    public static double[] generateRandomVelocities(double[] m, double desiredTemperature, int degreesOfFreedom, double[] velocities) {
        if (velocities == null) {
            velocities = new double[m.length * Thermostat.getDimension()];
        }
        return velocities;
    }

    public double[] applyDesiredTemperature(double[] velocities, double[] scaledVelocities) {
        if (scaledVelocities == null) {
            scaledVelocities = new double[velocities.length];
        }
        double sc = this.desiredTemperature / Thermostat.getActualTemperature(this.m, velocities, this.degreesOfFreedom);
        JLinAlg.VectScale(velocities, sc, scaledVelocities);
        return scaledVelocities;
    }

    public static double[] applyDesiredTemperature(double[] m, double desiredTemperature, int degreesOfFreedom, double[] velocities, double[] scaledVelocities) {
        if (scaledVelocities == null) {
            scaledVelocities = new double[velocities.length];
        }
        double sc = desiredTemperature / Thermostat.getActualTemperature(m, velocities, degreesOfFreedom);
        JLinAlg.VectScale(velocities, sc, scaledVelocities);
        return scaledVelocities;
    }

    public double[] applyThermostat(double[] velocities, double[] scaledVelocities) {
        return Thermostat.applyThermostat(this.m, this.desiredTemperature, this.degreesOfFreedom, velocities, scaledVelocities);
    }

    public static double[] applyThermostat(double[] m, double desiredTemperature, int degreesOfFreedom, double[] velocities, double[] scaledVelocities) {
        if (scaledVelocities == null) {
            scaledVelocities = new double[velocities.length];
        }
        JLinAlg.VectCopy(velocities, scaledVelocities);
        return scaledVelocities;
    }

    public static double getActualTemperature(double[] m, double[] velocities, int degreesOfFreedom) {
        double t = 2.0 * Thermostat.getKineticEnergy(m, velocities) * 4186.8 / 6.02214199E23 / 1.3806505E-23 / (double)degreesOfFreedom;
        return t;
    }

    public double getActualTemperature(double[] velocities, int degreesOfFreedom) {
        return Thermostat.getActualTemperature(this.m, velocities, degreesOfFreedom);
    }

    public double getActualTemperature(double[] velocities) {
        return Thermostat.getActualTemperature(this.m, velocities, this.degreesOfFreedom);
    }

    public double getActualTemperature() {
        return this.actualTemperature;
    }

    public static int getDimension() {
        return dimension;
    }

    public static void setDimension(int dimension) {
        Thermostat.dimension = dimension;
    }
}

