/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.struc;

import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.debug.ErrPrint;
import chemaxon.marvin.modelling.linalg.JQuatFit;
import chemaxon.marvin.modelling.struc.ConformersDescriptor;
import chemaxon.marvin.modelling.struc.Substructure3DSearch;
import chemaxon.struc.DPoint3;
import chemaxon.struc.Molecule;
import java.util.Vector;

public class ConformerEquivalenceUtils {
    double tolerance = 0.1;
    Molecule baseMolecule = null;
    double[][] baseCoord = null;
    Vector selectedConformers = null;
    Substructure3DSearch cSS = null;
    JQuatFit jQF = null;
    public static final double R_joule = 8.314472;
    public static final double R_kcal = 0.001987;

    public ConformerEquivalenceUtils(Molecule bM) {
        this.init(bM, 0.0);
    }

    public ConformerEquivalenceUtils(Molecule bM, double tol) {
        this.init(bM, tol);
    }

    void init(Molecule bM, double tol) {
        this.baseMolecule = bM.cloneMolecule();
        this.baseMolecule.clearProperties();
        this.baseCoord = ConformerEquivalenceUtils.getMolCoordinates(this.baseMolecule);
        this.cSS = new Substructure3DSearch();
        this.cSS.setQuery(this.baseMolecule);
        this.jQF = new JQuatFit(this.baseCoord);
        if (tol > 0.0) {
            this.tolerance = tol;
        }
        this.selectedConformers = new Vector();
        this.selectedConformers.addElement(new Conformer(this.baseMolecule, ConformerEquivalenceUtils.getMolCoordinates(this.baseMolecule), ConformerEquivalenceUtils.getMolEnergy(this.baseMolecule)));
    }

    public void setBaseCoordinates(double[][] coord) {
        if (coord.length == this.baseCoord.length) {
            this.baseCoord = coord;
        }
        ConformerEquivalenceUtils.setMolCoordinates(this.baseMolecule, coord);
    }

    public static double[][] getMolCoordinates(Molecule m) {
        return ConformerEquivalenceUtils.getMolCoordinates(m, null);
    }

    public static double[][] getMolCoordinates(Molecule m, double[][] coord) {
        DPoint3[] c = m.getPoints();
        if (coord == null) {
            coord = new double[c.length][3];
        }
        for (int i = 0; i < coord.length; ++i) {
            coord[i][0] = c[i].x;
            coord[i][1] = c[i].y;
            coord[i][2] = c[i].z;
        }
        return coord;
    }

    public static double getMolEnergy(Molecule m) {
        String eString = m.getProperty("ENERGY");
        if (eString == null) {
            return 0.0;
        }
        double energy = Double.valueOf(eString);
        return energy;
    }

    public static void setMolCoordinates(Molecule m, double[][] coord) {
        DPoint3 c = new DPoint3();
        for (int i = 0; i < coord.length; ++i) {
            c.x = coord[i][0];
            c.y = coord[i][1];
            c.z = coord[i][2];
            m.getAtom(i).setLocation(c);
        }
    }

    public static double[][][] getMolCoordinateArray(Molecule m) {
        if (m.getFragCount() > 1) {
            System.err.println("More than one fragments found.");
            return null;
        }
        if (!ConformersDescriptor.check(m)) {
            System.err.println("No valid conformer descriptor found.");
            double[][][] coords = new double[][][]{ConformerEquivalenceUtils.getMolCoordinates(m)};
            return coords;
        }
        ConformersDescriptor cD = ConformersDescriptor.getConformersDescriptor(m, false);
        double[][][] tmpCoord = cD.getCoords();
        if (tmpCoord == null || tmpCoord[0] == null) {
            return null;
        }
        double[][][] coords = new double[tmpCoord[0].length][tmpCoord.length][3];
        for (int i = 0; i < coords.length; ++i) {
            for (int j = 0; j < coords[i].length; ++j) {
                coords[i][j][0] = tmpCoord[j][i][0];
                coords[i][j][1] = tmpCoord[j][i][1];
                coords[i][j][2] = tmpCoord[j][i][2];
            }
        }
        return coords;
    }

    public static Molecule[] getFullConformers(Molecule m) {
        if (m.getFragCount() > 1) {
            System.err.println("More than one fragments found.");
            return null;
        }
        if (!ConformersDescriptor.check(m)) {
            Molecule[] mols = new Molecule[]{m};
            return mols;
        }
        return ConformersDescriptor.getConformers(m, false);
    }

    public static Molecule[] getSimpleConformers(Molecule m) {
        if (m.getFragCount() > 1) {
            System.err.println("More than one fragments found.");
            return null;
        }
        if (!ConformersDescriptor.check(m)) {
            Molecule[] mols = new Molecule[]{m};
            return mols;
        }
        Molecule[] conformers = ConformersDescriptor.getConformers(m, false);
        for (int i = 0; i < conformers.length; ++i) {
            conformers[i].setPropertyObject("Clean3DConformersDescriptor", null);
        }
        return conformers;
    }

    public static Molecule setMolCoordinateArray(Molecule m, double[][][] coords, double[] energies) {
        if (m.getFragCount() > 1) {
            System.err.println("More than one fragments found.");
            return null;
        }
        ConformersDescriptor cD = new ConformersDescriptor(m);
        ConformersDescriptor.createAndStoreConformersDescriptor(m, coords, energies);
        return m;
    }

    public static double[] getMolEnergyArray(Molecule m) {
        if (m.getFragCount() > 1) {
            System.err.println("More than one fragments found.");
            return null;
        }
        if (!ConformersDescriptor.check(m)) {
            System.err.println("No valid conformer descriptor found.");
            double[] energies = new double[]{ConformerEquivalenceUtils.getMolEnergy(m)};
            return energies;
        }
        ConformersDescriptor cD = ConformersDescriptor.getConformersDescriptor(m, false);
        double[][] tmpE = cD.getEnergy();
        double[] E = tmpE[0];
        return E;
    }

    public static double[] getConformerEquilibrium(Molecule m, double T) {
        double[] energies = ConformerEquivalenceUtils.getMolEnergyArray(m);
        return ConformerEquivalenceUtils.getConformerEquilibrium(energies, 0.001987, T);
    }

    public static double[] getConformerEquilibrium(Molecule[] m, double T) {
        double[] energies = new double[m.length];
        for (int i = 0; i < energies.length; ++i) {
            energies[i] = ConformerEquivalenceUtils.getMolEnergy(m[i]);
        }
        return ConformerEquivalenceUtils.getConformerEquilibrium(energies, 0.001987, T);
    }

    public static double[] getConformerEquilibrium(double[] energies, double R, double T) {
        int i;
        double[] eq = new double[energies.length];
        double lowestEnergy = energies[0];
        for (int i2 = 1; i2 < energies.length; ++i2) {
            if (!(lowestEnergy > energies[i2])) continue;
            lowestEnergy = energies[i2];
        }
        double sEq = 0.0;
        for (i = 0; i < energies.length; ++i) {
            eq[i] = Math.exp((lowestEnergy - energies[i]) / (R * T));
            sEq += eq[i];
        }
        for (i = 0; i < energies.length; ++i) {
            eq[i] = eq[i] / sEq;
        }
        ErrPrint.errPrint("Populations:", eq);
        return eq;
    }

    public Conformer[] getMolConformers(Molecule m) {
        double[][][] coords = ConformerEquivalenceUtils.getMolCoordinateArray(m);
        double[] energies = ConformerEquivalenceUtils.getMolEnergyArray(m);
        if (coords == null) {
            return null;
        }
        Conformer[] cStore = new Conformer[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            cStore[i] = new Conformer(m, coords[i], energies[i]);
        }
        return cStore;
    }

    public static Molecule setMolConformers(Molecule m, Conformer[] conformers) {
        double[][][] coords = new double[conformers.length][][];
        double[] energies = new double[conformers.length];
        for (int i = 0; i < conformers.length; ++i) {
            coords[i] = conformers[i].coords;
            energies[i] = conformers[i].energy;
        }
        ConformersDescriptor cD = new ConformersDescriptor(m);
        ConformersDescriptor.createAndStoreConformersDescriptor(m, coords, energies);
        return m;
    }

    public boolean addConformer(Molecule m, double[][] coords, double energy) {
        double[][] newCoords;
        this.cSS.setTarget(m);
        if (this.cSS.findFirst()) {
            int[] matchInd = this.cSS.getResult();
            int[] defaultInd = ConformerEquivalenceUtils.defaultIndeces(coords.length);
            Substructure3DSearch S3S = new Substructure3DSearch();
            S3S.setQuery(m);
            S3S.setQueryCoordinates(coords);
            S3S.setIgnoreGeometryMatching(false, this.tolerance);
            S3S.setIgnoreExactMatching(false);
            ErrPrint.errPrint(matchInd);
            for (int i = 0; i < this.selectedConformers.size(); ++i) {
                Conformer cAct = (Conformer)this.selectedConformers.elementAt(i);
                S3S.setTarget(cAct.m);
                S3S.setTargetCoordinates(cAct.coords);
                if (!S3S.findFirst()) continue;
                System.err.println("Conformer is already stored.");
                return false;
            }
            newCoords = new double[coords.length][];
            for (int i = 0; i < coords.length; ++i) {
                newCoords[matchInd[i]] = coords[i];
            }
        } else {
            return false;
        }
        this.selectedConformers.addElement(new Conformer(m, newCoords, energy));
        return true;
    }

    public boolean addConformer(Conformer mC) {
        return this.addConformer(mC.m, mC.coords, mC.energy);
    }

    public static double[][][] getFuseCoordinatePositions(Molecule m, double[][] coord, int[] involvedAtoms) {
        int i;
        if (coord == null) {
            return null;
        }
        if (CleanArgs.verboseLevel > 0) {
            CleanArgs.verbose("Enter getFuseCoordinatePositions.");
        }
        Object resCSet = null;
        Substructure3DSearch tSSS = new Substructure3DSearch();
        tSSS.setMolecules(m, m);
        tSSS.setHighPriorityQueryAtoms(involvedAtoms);
        tSSS.setIgnoreExactMatching(false);
        if (!tSSS.search()) {
            if (CleanArgs.verboseLevel > 0) {
                CleanArgs.verbose("Too many possibilities in Substructure3DSearch");
            }
            return null;
        }
        int nTry = tSSS.getResultCount();
        if (CleanArgs.verboseLevel > 0) {
            CleanArgs.verbose("Initial search is done in getFuseCoordinatePositions, found: " + nTry);
        }
        if (nTry == 1) {
            resCSet = new double[1][][];
            resCSet[0] = coord;
            return resCSet;
        }
        if (nTry > 1000) {
            if (CleanArgs.verboseLevel > 0) {
                CleanArgs.verbose("Too many possibilities (" + nTry + ") found Substructure3DSearch.");
            }
            return null;
        }
        Vector<double[][]> resCVect = new Vector<double[][]>();
        Substructure3DSearch gSSS = new Substructure3DSearch();
        gSSS.setMolecules(m, m);
        gSSS.setIgnoreGeometryMatching(false, 0.1);
        gSSS.setIgnoreExactMatching(false);
        gSSS.setQueryCoordinates(coord);
        resCVect.addElement(coord);
        for (i = 0; i < nTry; ++i) {
            int j;
            int[] tMatch = tSSS.getResult(i);
            int[] fMatch = (int[])tMatch.clone();
            for (j = 0; j < fMatch.length; ++j) {
                fMatch[j] = -1;
            }
            for (j = 0; j < involvedAtoms.length; ++j) {
                fMatch[involvedAtoms[j]] = involvedAtoms[j];
            }
            boolean foundMatch = false;
            double[][] nextCoord = new double[coord.length][coord[0].length];
            for (int j2 = 0; j2 < coord.length; ++j2) {
                nextCoord[j2] = (double[])coord[tMatch[j2]].clone();
            }
            JQuatFit jQF = new JQuatFit(nextCoord);
            gSSS.setQueryCoordinates(nextCoord);
            int[][] match = new int[][]{involvedAtoms, involvedAtoms};
            for (int j3 = 0; j3 < resCVect.size(); ++j3) {
                double fit = jQF.quatfit((double[][])resCVect.elementAt(j3), match);
                boolean bl = foundMatch = fit < 0.1;
                if (!foundMatch) continue;
                gSSS.setTarget(m);
                gSSS.setTargetCoordinates((double[][])resCVect.elementAt(j3));
                gSSS.setFrozenMatch(fMatch);
                foundMatch = gSSS.findFirst();
                if (foundMatch) break;
            }
            if (foundMatch) continue;
            int[] list = new int[involvedAtoms.length];
            for (int ia = 0; ia < list.length; ++ia) {
                list[ia] = tMatch[involvedAtoms[ia]];
            }
            if (CleanArgs.verboseLevel > 1) {
                CleanArgs.verbose("Adding new position.");
            }
            resCVect.addElement(nextCoord);
        }
        resCSet = new double[resCVect.size()][][];
        for (i = 0; i < ((double[][][])resCSet).length; ++i) {
            resCSet[i] = (double[][])resCVect.elementAt(i);
        }
        if (CleanArgs.verboseLevel > 0) {
            CleanArgs.verbose("Leave getFuseCoordinatePositions.");
        }
        return resCSet;
    }

    public static int[] defaultIndeces(int n) {
        int[] indeces = new int[n];
        for (int i = 0; i < n; ++i) {
            indeces[i] = i;
        }
        return indeces;
    }

    public class Conformer {
        public Molecule m = null;
        public double[][] coords = null;
        public double energy = 0.0;

        Conformer(Molecule mC, double[][] cCoords, double cEnergy) {
            this.m = mC.cloneMolecule();
            this.m.clearProperties();
            this.m.setDim(0);
            this.coords = (double[][])cCoords.clone();
            this.energy = cEnergy;
        }
    }
}

