/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.struc;

import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.util.U;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MDocument;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class ConformersDescriptor
extends MProp {
    public static final String CONFDESCPROPKEY = "Clean3DConformersDescriptor";
    int[] anum;
    int[][] bat;
    int[] bdesc;
    double[][][] coords;
    double[][] energy;
    Molecule source;
    SelectionMolecule[] fragments;
    int[] atomToFrag;
    int[][] fragToAtoms;

    public static int[] calcAnumArray(Molecule m) {
        int[] ret = new int[m.getAtomCount()];
        for (int i = 0; i < m.getAtomCount(); ++i) {
            ret[i] = m.getAtom(i).getAtno();
        }
        return ret;
    }

    public static ConformersDescriptor createAndStoreDescriptor(Molecule m, Molecule[] source) {
        int confct = source.length;
        double[] energy = new double[confct];
        for (int i = 0; i < confct; ++i) {
            try {
                energy[i] = Double.parseDouble(source[i].getProperty("ENERGY"));
                continue;
            }
            catch (Exception e) {
                System.err.println("Problem parsing energy for conformer " + i);
            }
        }
        int atomct = source[0].getAtomCount();
        double[][][] coords = new double[confct][atomct][3];
        for (int i = 0; i < confct; ++i) {
            if (source[i].getAtomCount() != atomct) {
                throw new IndexOutOfBoundsException("Atom count mismatch.");
            }
            for (int j = 0; j < atomct; ++j) {
                MolAtom a = source[i].getAtom(j);
                coords[i][j][0] = a.getX();
                coords[i][j][1] = a.getY();
                coords[i][j][2] = a.getZ();
            }
        }
        return ConformersDescriptor.createAndStoreConformersDescriptor(m, coords, energy);
    }

    public static ConformersDescriptor createAndStoreConformersDescriptor(Molecule m, double[][][] coords, double[] energy) {
        if (coords.length != energy.length) {
            throw new IndexOutOfBoundsException("Conformer count mismatch.");
        }
        int confct = coords.length;
        int atomct = coords[0].length;
        for (int i = 0; i < confct; ++i) {
            if (coords[i].length == atomct) continue;
            throw new IndexOutOfBoundsException("Atom count mismatch.");
        }
        ConformersDescriptor cd = new ConformersDescriptor(m);
        SelectionMolecule[] mols = cd.getFrags();
        int[][] fragToAtoms = cd.getFragToAtoms();
        for (int fragNo = 0; fragNo < mols.length; ++fragNo) {
            double[] e = fragNo == 0 ? energy : new double[confct];
            double[][][] c = new double[confct][fragToAtoms[fragNo].length][3];
            for (int i = 0; i < confct; ++i) {
                for (int j = 0; j < fragToAtoms[fragNo].length; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        c[i][j][k] = coords[i][fragToAtoms[fragNo][j]][k];
                    }
                }
            }
            cd.storeResults(fragNo, c, e);
        }
        cd.storeInSourceStructure();
        return cd;
    }

    public static int[][] calcBatArray(Molecule m) {
        int[][] ret = new int[2][m.getBondCount()];
        for (int i = 0; i < m.getBondCount(); ++i) {
            ret[0][i] = m.indexOf(m.getBond(i).getAtom1());
            ret[1][i] = m.indexOf(m.getBond(i).getAtom2());
        }
        return ret;
    }

    public static int[] calcBdescArray(Molecule m) {
        int[] ret = new int[m.getBondCount()];
        for (int i = 0; i < m.getBondCount(); ++i) {
            ret[i] = m.getBond(i).getType() == 1 ? 1 : (m.getBond(i).getType() == 2 ? 2 : (m.getBond(i).getType() == 3 ? 4 : (m.getBond(i).getType() == 4 ? 8 : 16)));
        }
        return ret;
    }

    public Molecule constructTopology() {
        int i;
        Molecule m = new Molecule();
        for (i = 0; i < this.anum.length; ++i) {
            MolAtom a = new MolAtom(this.anum[i]);
            m.add(a);
        }
        for (i = 0; i < this.bdesc.length; ++i) {
            int f = 1;
            switch (this.bdesc[i]) {
                case 1: {
                    f = 1;
                    break;
                }
                case 2: {
                    f = 2;
                    break;
                }
                case 4: {
                    f = 3;
                    break;
                }
                case 8: {
                    f = 4;
                }
            }
            MolAtom a1 = m.getAtom(this.bat[0][i]);
            MolAtom a2 = m.getAtom(this.bat[1][i]);
            MolBond b = new MolBond(a1, a2, f);
            m.add(b);
        }
        return m;
    }

    public double[][][] getCoords() {
        return this.coords;
    }

    public void setCoords(double[][][] c) {
        this.coords = c;
    }

    public void setEnergy(double[][] e) {
        this.energy = e;
    }

    public double[][] getEnergy() {
        return this.energy;
    }

    public int[] getAtomToFrag() {
        return this.atomToFrag;
    }

    public int[][] getFragToAtoms() {
        return this.fragToAtoms;
    }

    public static int[][] calcFragToAtoms(Molecule m) {
        SelectionMolecule[] fragments = m.findFrags();
        int[][] fragToAtoms = new int[fragments.length][];
        for (int i = 0; i < fragments.length; ++i) {
            fragToAtoms[i] = new int[fragments[i].getAtomCount()];
            for (int j = 0; j < fragments[i].getAtomCount(); ++j) {
                fragToAtoms[i][j] = m.indexOf(fragments[i].getAtom(j));
            }
        }
        return fragToAtoms;
    }

    public static int[] calcAtomToFrag(Molecule m, int[][] fragToAtoms) {
        int[] atomToFrag = new int[m.getAtomCount()];
        for (int i = 0; i < fragToAtoms.length; ++i) {
            for (int j = 0; j < fragToAtoms[i].length; ++j) {
                atomToFrag[fragToAtoms[i][j]] = i;
            }
        }
        return atomToFrag;
    }

    public ConformersDescriptor(Molecule m) {
        this.source = m;
        this.anum = ConformersDescriptor.calcAnumArray(m);
        this.bat = ConformersDescriptor.calcBatArray(m);
        this.bdesc = ConformersDescriptor.calcBdescArray(m);
        this.fragments = m.findFrags();
        this.fragToAtoms = ConformersDescriptor.calcFragToAtoms(m);
        this.atomToFrag = ConformersDescriptor.calcAtomToFrag(m, this.fragToAtoms);
        this.energy = new double[this.fragments.length][];
        this.coords = new double[m.getAtomCount()][][];
    }

    public SelectionMolecule[] getFrags() {
        return this.fragments;
    }

    public void storeResults(int fragno, double[][] c, double e) {
        this.storeResults(fragno, new double[][][]{c}, new double[]{e});
    }

    public void storeResults(int fragno, double[][][] c, double[] e) {
        int i;
        int confct = e.length;
        int atomct = this.fragments[fragno].getAtomCount();
        if (confct != c.length) {
            throw new IndexOutOfBoundsException("Conformer count mismatch");
        }
        this.energy[fragno] = new double[confct];
        for (i = 0; i < atomct; ++i) {
            this.coords[this.fragToAtoms[fragno][i]] = new double[confct][3];
        }
        for (i = 0; i < confct; ++i) {
            this.energy[fragno][i] = e[i];
            if (c[i].length != atomct) {
                throw new IndexOutOfBoundsException("Atom count mismatch");
            }
            for (int j = 0; j < atomct; ++j) {
                for (int k = 0; k < 3; ++k) {
                    this.coords[this.fragToAtoms[fragno][j]][i][k] = c[i][j][k];
                }
            }
        }
    }

    public static boolean cmpIntArray(int[] a, int[] b) {
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean cmpDoubleArray(double[] a, double[] b, double eps) {
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (!(Math.abs(a[i] - b[i]) > eps)) continue;
            return false;
        }
        return true;
    }

    public static boolean cmpIntIntArray(int[][] a, int[][] b) {
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null || b[i] == null || a[i].length != b[i].length) {
                return false;
            }
            for (int j = 0; j < a[i].length; ++j) {
                if (a[i][j] == b[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean checkStructure(Molecule m, double eps, boolean verbose) {
        if (verbose) {
            System.err.println("        Checking anum");
        }
        if (!ConformersDescriptor.cmpIntArray(this.anum, ConformersDescriptor.calcAnumArray(m))) {
            if (verbose) {
                System.err.println("        mismatch");
            }
            return false;
        }
        if (verbose) {
            System.err.println("        Checking fragToAtom");
        }
        if (!ConformersDescriptor.cmpIntIntArray(this.fragToAtoms, ConformersDescriptor.calcFragToAtoms(m))) {
            if (verbose) {
                System.err.println("        mismatch");
            }
            return false;
        }
        if (verbose) {
            System.err.println("        Checking atomToFrag");
        }
        if (!ConformersDescriptor.cmpIntArray(this.atomToFrag, ConformersDescriptor.calcAtomToFrag(m, this.fragToAtoms))) {
            if (verbose) {
                System.err.println("        mismatch");
            }
            return false;
        }
        if (verbose) {
            System.err.println("        Checking bat");
        }
        if (!ConformersDescriptor.cmpIntIntArray(this.bat, ConformersDescriptor.calcBatArray(m))) {
            if (verbose) {
                System.err.println("        mismatch");
            }
            return false;
        }
        if (verbose) {
            System.err.println("        Checking bdesc");
        }
        if (!ConformersDescriptor.cmpIntArray(this.bdesc, ConformersDescriptor.calcBdescArray(m))) {
            if (verbose) {
                System.err.println("        mismatch");
            }
            return false;
        }
        if (verbose) {
            System.err.println("        Checking coordinates");
        }
        for (int i = 0; i < this.fragToAtoms.length; ++i) {
            int confct = this.coords[this.fragToAtoms[i][0]].length;
            int atomct = this.fragToAtoms[i].length;
            boolean onematch = false;
            for (int j = 0; j < confct; ++j) {
                boolean allmatch = true;
                for (int k1 = 0; k1 < atomct; ++k1) {
                    int atindx1 = this.fragToAtoms[i][k1];
                    MolAtom atom1 = m.getAtom(atindx1);
                    for (int k2 = k1 + 1; k2 < atomct; ++k2) {
                        int atindx2 = this.fragToAtoms[i][k2];
                        MolAtom atom2 = m.getAtom(atindx2);
                        double d1 = V.dot(V.minus(this.coords[atindx1][j], this.coords[atindx2][j]));
                        double[] dArray = new double[]{atom1.getX(), atom1.getY(), atom1.getZ()};
                        double[] dArray2 = new double[]{atom2.getX(), atom2.getY(), atom2.getZ()};
                        double d2 = V.dot(V.minus(dArray, dArray2));
                        if (!(Math.abs(d2 - d1) > eps)) continue;
                        allmatch = false;
                        if (!verbose) break;
                        System.err.println("          Frag#" + i + " conf#" + j + "  failed on distance " + atindx1 + "-" + atindx2 + " (" + Math.sqrt(d1) + "-" + Math.sqrt(d2) + ")");
                        break;
                    }
                    if (!allmatch) break;
                }
                if (!allmatch) continue;
                onematch = true;
                break;
            }
            if (onematch) continue;
            return false;
        }
        return true;
    }

    public static ConformersDescriptor getConformersDescriptor(Molecule m, boolean doCheck) {
        MPropertyContainer pc = m.properties();
        MProp p = pc.get(CONFDESCPROPKEY);
        if (p == null) {
            return null;
        }
        if (!ConformersDescriptor.class.isInstance(p)) {
            return null;
        }
        ConformersDescriptor cp = (ConformersDescriptor)p;
        if (doCheck && !cp.checkStructure(m, 0.01, false)) {
            ConformersDescriptor.invalidate(m);
            return null;
        }
        return cp;
    }

    public void writeConformer(String fname, int fragno, int cno) {
        String fmt = "sdf";
        Molecule m = new Molecule();
        this.fragments[fragno].clonecopy(m);
        m.setDim(3);
        try {
            PrintStream ps = new PrintStream(new FileOutputStream(fname, true));
            int cid = 0;
            boolean go = true;
            while (go) {
                if (cno != -1) {
                    cid = cno;
                    go = false;
                }
                for (int i = 0; i < m.getAtomCount(); ++i) {
                    double[] c = this.coords[this.fragToAtoms[fragno][i]][cid];
                    m.getAtom(i).setXYZ(c[0], c[1], c[2]);
                }
                ps.print(m.toFormat(fmt));
                if (!go) continue;
                go = ++cid < this.getConformersCount(fragno);
            }
        }
        catch (Exception e) {
            System.err.println("Exception " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static ConformersDescriptor retrieveConformersDescriptor(Molecule m, boolean verbose) {
        MPropertyContainer pc;
        MProp p;
        if (verbose) {
            System.err.println("retrieveConformersDescriptor()");
        }
        if ((p = (pc = m.properties()).get(CONFDESCPROPKEY)) == null) {
            if (verbose) {
                System.err.println("   no descriptor, exiting");
            }
            return null;
        }
        if (!ConformersDescriptor.class.isInstance(p)) {
            if (verbose) {
                System.err.println("   corrupt descriptor, exiting");
            }
            return null;
        }
        return (ConformersDescriptor)p;
    }

    public static boolean checkConformersDescriptor(Molecule m, boolean verbose) {
        ConformersDescriptor cd = ConformersDescriptor.retrieveConformersDescriptor(m, verbose);
        if (cd == null) {
            return false;
        }
        return cd.checkStructure(m, 0.01, verbose);
    }

    public static boolean checkDescriptorPresence(Molecule m, boolean verbose) {
        ConformersDescriptor cd = ConformersDescriptor.retrieveConformersDescriptor(m, verbose);
        return cd != null;
    }

    public static Molecule[] constructConformers(Molecule m) {
        ConformersDescriptor cp = ConformersDescriptor.retrieveConformersDescriptor(m, false);
        if (cp == null) {
            return null;
        }
        int lf = 0;
        int[][] f2a = cp.getFragToAtoms();
        for (int i = 1; i < f2a.length; ++i) {
            if (f2a[i].length <= f2a[lf].length && (f2a[i].length != f2a[lf].length || cp.getConformersCount(i) <= cp.getConformersCount(lf))) continue;
            lf = i;
        }
        int confct = cp.getConformersCount(lf);
        int[] sel = new int[f2a.length];
        Molecule[] conformers = new Molecule[confct];
        Molecule reconstructed = cp.constructTopology();
        if (reconstructed == null) {
            return null;
        }
        for (int j = 0; j < confct; ++j) {
            Molecule mclone = (Molecule)reconstructed.clone();
            sel[lf] = j;
            cp.writeCoords(mclone, sel, true, true);
            conformers[j] = mclone;
        }
        return conformers;
    }

    public static Molecule[] getConformers(Molecule m, boolean verbose) {
        ConformersDescriptor cp;
        if (verbose) {
            System.err.println("getConformers()");
        }
        if ((cp = ConformersDescriptor.retrieveConformersDescriptor(m, verbose)) == null) {
            return null;
        }
        if (verbose) {
            System.err.println("   checking descriptor");
        }
        if (!cp.checkStructure(m, 0.01, verbose)) {
            if (verbose) {
                System.err.println("       check failed, invalidate and exit");
            }
            ConformersDescriptor.invalidate(m);
            return null;
        }
        int lf = 0;
        int[][] f2a = cp.getFragToAtoms();
        for (int i = 1; i < f2a.length; ++i) {
            if (f2a[i].length <= f2a[lf].length && (f2a[i].length != f2a[lf].length || cp.getConformersCount(i) <= cp.getConformersCount(lf))) continue;
            lf = i;
        }
        int confct = cp.getConformersCount(lf);
        int[] sel = new int[f2a.length];
        if (verbose) {
            System.err.println("   largest fragment is #" + lf + " (" + f2a[lf].length + " atoms), " + confct + " conformers");
        }
        Molecule[] conformers = new Molecule[confct];
        for (int j = 0; j < confct; ++j) {
            Molecule mclone;
            MDocument doc = m.getDocument();
            if (doc != null) {
                doc = (MDocument)doc.clone();
                mclone = (Molecule)doc.getMainMoleculeGraph();
            } else {
                mclone = (Molecule)m.clone();
            }
            sel[lf] = j;
            cp.writeCoords(mclone, sel, true, true);
            conformers[j] = mclone;
        }
        if (verbose) {
            System.err.println("   done");
        }
        return conformers;
    }

    public int getConformersCount(int fragno) {
        if (this.energy == null || this.energy.length == 0) {
            return 0;
        }
        return this.energy[fragno].length;
    }

    public void storeInSourceStructure() {
        MPropertyContainer pc = this.source.properties();
        pc.set(CONFDESCPROPKEY, this);
    }

    public static void invalidate(Molecule m) {
        m.properties().set(CONFDESCPROPKEY, null);
    }

    public static boolean check(Molecule m) {
        MPropertyContainer pc = m.properties();
        MProp p = pc.get(CONFDESCPROPKEY);
        if (p == null) {
            return false;
        }
        if (!ConformersDescriptor.class.isInstance(p)) {
            return false;
        }
        ConformersDescriptor cp = (ConformersDescriptor)p;
        if (!cp.checkStructure(m, 0.01, false)) {
            ConformersDescriptor.invalidate(m);
            return false;
        }
        return true;
    }

    public static void writeCoords(Molecule m, double[][] c) {
        ConformersDescriptor.writeCoords(m, c, false);
    }

    public static void writeCoords(Molecule m, double[][] c, boolean killflags) {
        if (c.length != m.getAtomCount()) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < c.length; ++i) {
            MolAtom ma = m.getAtom(i);
            ma.setXYZ(c[i][0], c[i][1], c[i][2]);
        }
        m.setDim(3);
        for (int ss = 0; ss < m.getBondCount(); ++ss) {
            MolBond b = m.getBond(ss);
            b.setFlags(0, 1008);
        }
    }

    public void writeCoords(Molecule source, int[] confsel, boolean killflags, boolean storeEnegy) {
        if (source == null) {
            return;
        }
        if (storeEnegy) {
            double e = 0.0;
            for (int i = 0; i < this.energy.length; ++i) {
                e += this.energy[i][confsel == null ? 0 : confsel[i]];
            }
            source.setProperty("ENERGY", "" + e);
        }
        for (int i = 0; i < source.getAtomCount(); ++i) {
            MolAtom at = source.getAtom(i);
            int frag = this.atomToFrag[i];
            if (this.coords[i].length == 0) {
                System.err.println("coords[ " + i + "].length=0");
            }
            if (confsel != null && confsel.length == 0) {
                System.err.println("confsel.length=0");
            }
            double[] coord = this.coords[i][confsel == null ? 0 : confsel[frag]];
            at.setX(coord[0]);
            at.setY(coord[1]);
            at.setZ(coord[2]);
        }
        source.setDim(3);
        if (killflags) {
            int mask = 1008;
            for (int ss = 0; ss < source.getBondCount(); ++ss) {
                MolBond b = source.getBond(ss);
                b.setFlags(0, mask);
            }
        }
    }

    public void writeCoordsBack(int[] confsel, boolean killflags, boolean storeEnegy) {
        this.writeCoords(this.source, confsel, killflags, storeEnegy);
    }

    @Override
    public int getPropArraySize() {
        return -1;
    }

    public static void appendIntArrayToStringBuffer(StringBuffer b, int[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (i != 0) {
                b.append(' ');
            }
            b.append(a[i]);
        }
    }

    public static String intarrayToString(int[] a) {
        String ret = null;
        for (int i = 0; i < a.length; ++i) {
            ret = i == 0 ? "" + a[i] : ret + " " + a[i];
        }
        return ret;
    }

    public static int[] stringToIntarray(String s) {
        StringTokenizer tok = new StringTokenizer(s, " ");
        int[] ret = new int[tok.countTokens()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Integer.parseInt(tok.nextToken());
        }
        return ret;
    }

    public static void appendDoubleArrayToStringBuffer(StringBuffer b, double[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (i != 0) {
                b.append(' ');
            }
            b.append(a[i]);
        }
    }

    public static String doublearrayToString(double[] a) {
        String ret = null;
        for (int i = 0; i < a.length; ++i) {
            ret = i == 0 ? "" + a[i] : ret + " " + a[i];
        }
        return ret;
    }

    public static double[] stringToDoublearray(String s) {
        StringTokenizer tok = new StringTokenizer(s, " ");
        double[] ret = new double[tok.countTokens()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Double.parseDouble(tok.nextToken());
        }
        return ret;
    }

    @Override
    @Deprecated
    public String convertToString(String fmt, int flags) throws IllegalArgumentException {
        MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
        return handler.convertToString(this, fmt);
    }

    @Override
    public String toString() {
        int i;
        int i2;
        if (CleanArgs.doVerbose()) {
            CleanArgs.verboseInc("ConformersDescriptor2string");
        }
        int[] cc = new int[this.anum.length];
        for (int i3 = 0; i3 < this.anum.length; ++i3) {
            cc[i3] = this.coords[i3].length;
        }
        int estIntCount = 0;
        int estDblCount = 0;
        estIntCount += this.anum.length + this.bat[0].length + this.bat[1].length + this.bdesc.length;
        for (i2 = 0; i2 < this.coords.length; ++i2) {
            for (int j = 0; j < this.coords[i2].length; ++j) {
                estDblCount += this.coords[i2][j].length;
            }
        }
        estIntCount += this.atomToFrag.length + 1;
        for (i2 = 0; i2 < this.fragToAtoms.length; ++i2) {
            estIntCount += this.fragToAtoms[i2].length;
            estDblCount += this.energy[i2].length;
        }
        int estChrCount = estIntCount * 3 + estDblCount * 19;
        StringBuffer ret = new StringBuffer(estChrCount);
        ConformersDescriptor.appendIntArrayToStringBuffer(ret, this.anum);
        ret.append('\n');
        ConformersDescriptor.appendIntArrayToStringBuffer(ret, this.bat[0]);
        ret.append('\n');
        ConformersDescriptor.appendIntArrayToStringBuffer(ret, this.bat[1]);
        ret.append('\n');
        ConformersDescriptor.appendIntArrayToStringBuffer(ret, this.bdesc);
        ret.append('\n');
        ConformersDescriptor.appendIntArrayToStringBuffer(ret, cc);
        ret.append('\n');
        for (i = 0; i < this.coords.length; ++i) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Export atom index " + i);
            }
            for (int j = 0; j < this.coords[i].length; ++j) {
                ConformersDescriptor.appendDoubleArrayToStringBuffer(ret, this.coords[i][j]);
                ret.append('\n');
            }
        }
        ConformersDescriptor.appendIntArrayToStringBuffer(ret, this.atomToFrag);
        ret.append('\n');
        ret.append(this.fragToAtoms.length);
        ret.append('\n');
        for (i = 0; i < this.fragToAtoms.length; ++i) {
            ConformersDescriptor.appendIntArrayToStringBuffer(ret, this.fragToAtoms[i]);
            ret.append('\n');
            ConformersDescriptor.appendDoubleArrayToStringBuffer(ret, this.energy[i]);
            ret.append('\n');
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("eic: " + estIntCount + " edc: " + estDblCount + " ecc: " + estChrCount + " rcc: " + ret.length());
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verboseDec("Done.");
        }
        return ret.toString();
    }

    ConformersDescriptor() {
    }

    public ConformersDescriptor(String sval) {
        int i;
        StringTokenizer tok = new StringTokenizer(sval, "\n");
        this.anum = ConformersDescriptor.stringToIntarray(tok.nextToken());
        this.bat = new int[2][];
        this.bat[0] = ConformersDescriptor.stringToIntarray(tok.nextToken());
        this.bat[1] = ConformersDescriptor.stringToIntarray(tok.nextToken());
        this.bdesc = ConformersDescriptor.stringToIntarray(tok.nextToken());
        int[] cc = ConformersDescriptor.stringToIntarray(tok.nextToken());
        this.coords = new double[this.anum.length][][];
        for (i = 0; i < this.coords.length; ++i) {
            this.coords[i] = new double[cc[i]][];
            for (int j = 0; j < this.coords[i].length; ++j) {
                this.coords[i][j] = ConformersDescriptor.stringToDoublearray(tok.nextToken());
            }
        }
        this.atomToFrag = ConformersDescriptor.stringToIntarray(tok.nextToken());
        this.fragToAtoms = new int[Integer.parseInt(tok.nextToken())][];
        this.energy = new double[this.fragToAtoms.length][];
        for (i = 0; i < this.fragToAtoms.length; ++i) {
            this.fragToAtoms[i] = ConformersDescriptor.stringToIntarray(tok.nextToken());
            this.energy[i] = ConformersDescriptor.stringToDoublearray(tok.nextToken());
        }
    }

    @Override
    public MProp cloneProp() {
        try {
            ConformersDescriptor ret = new ConformersDescriptor();
            ret.anum = U.clone(this.anum);
            ret.bat = U.clone(this.bat);
            ret.bdesc = U.clone(this.bdesc);
            ret.coords = U.clone(this.coords);
            ret.atomToFrag = U.clone(this.atomToFrag);
            ret.fragToAtoms = U.clone(this.fragToAtoms);
            ret.energy = U.clone(this.energy);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object getPropValue() {
        return this;
    }

    @Override
    public String getPropType() {
        return "chemaxon.marvin.modelling.struc.ConformersDescriptor";
    }

    @Override
    public String getPropXSDType() {
        return "ENTITY";
    }
}

