/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.struc;

import chemaxon.marvin.modelling.struc.Fragment;

public class FragmentConformer {
    Fragment frag;
    double[][] coord;
    double e = 0.0;
    boolean energySet = false;
    boolean optimizationRequired = false;
    boolean optimized = false;
    double optLimitUsed = -1.0;

    public double getOptLimitUsed() {
        if (!this.optimized) {
            throw new UnsupportedOperationException("No optimization done");
        }
        return this.optLimitUsed;
    }

    public void setOptimizationRequired() {
        this.optimizationRequired = true;
    }

    public boolean getOptimizationRequired() {
        return this.optimizationRequired;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public boolean isOptimized(double optLimit) {
        if (!this.optimized) {
            return false;
        }
        return this.optLimitUsed <= optLimit;
    }

    public void optimize(double optLimit) {
        this.optimized = true;
        this.optimizationRequired = false;
        this.frag.optimizeDreiding(this.getCoordinates(), optLimit);
        this.calcEnergy();
        this.optLimitUsed = optLimit;
    }

    public FragmentConformer(Fragment fragment, double[][] coordinates) {
        this.frag = fragment;
        this.coord = coordinates;
    }

    public FragmentConformer(Fragment fragment, double[][] coordinates, double energy) {
        this.frag = fragment;
        this.e = energy;
        this.coord = coordinates;
        this.energySet = true;
    }

    public double calcEnergy() {
        this.energySet = true;
        this.e = this.frag.calcDreiding(this.coord);
        return this.e;
    }

    public double getEnergy() {
        if (!this.energySet) {
            this.calcEnergy();
        }
        return this.e;
    }

    public double[][] getCoordinates() {
        return this.coord;
    }
}

