/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.struc;

import chemaxon.calculations.clean.Optimization;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.diag.Instrumentation;
import chemaxon.marvin.modelling.struc.Fragment;
import chemaxon.marvin.modelling.struc.FragmentConformer;
import chemaxon.marvin.modelling.struc.Multiconformer;
import chemaxon.marvin.modelling.util.SimpleCanceller;
import java.util.BitSet;
import java.util.Vector;

public class FragmentPool
implements Multiconformer {
    Fragment frag;
    Vector confs = new Vector();
    CleanSettings cleanSettings = null;
    private boolean optimizeOnAddon = false;
    private boolean eqcheckAdded = false;
    private double minrmsd = 0.1;
    private double de = -1.0;
    private boolean keepLowerEOnEqchk = false;
    private double optLimitOnAddon = CleanSettings.BUILDCOMMAND_DEFAULTOPTLIMITVALUE;

    public FragmentPool(Fragment f) {
        this.frag = f;
        this.cleanSettings = f.getCleanSettings();
    }

    public FragmentPool(Fragment f, boolean optOnAdd, double optLimit, boolean eqcOnAdd, double de, double minrmsd, boolean keeple) {
        this.frag = f;
        this.optimizeOnAddon = optOnAdd;
        this.eqcheckAdded = eqcOnAdd;
        if (optLimit > 0.0) {
            this.optLimitOnAddon = optLimit;
        }
        this.minrmsd = minrmsd;
        this.de = de;
        this.keepLowerEOnEqchk = keeple;
        if (this.optimizeOnAddon && !eqcOnAdd) {
            throw new UnsupportedOperationException("No eqcheck after optimization specified");
        }
    }

    public int addConformer(double[][] c) {
        if (this.optimizeOnAddon) {
            throw new UnsupportedOperationException("Optimized state could not be determined");
        }
        return this.addConformer(new FragmentConformer(this.frag, c));
    }

    public int addConformer(double[][] c, double e) {
        if (this.optimizeOnAddon) {
            throw new UnsupportedOperationException("Optimized state could not be determined");
        }
        return this.addConformer(new FragmentConformer(this.frag, c, e));
    }

    public int addConformers(double[][][] c) {
        int ret = 0;
        for (int i = 0; i < c.length; ++i) {
            ret += this.addConformer(c[i]);
        }
        return ret;
    }

    public int addConformers(double[][][] c, double[] e) {
        int ret = 0;
        for (int i = 0; i < c.length; ++i) {
            ret += this.addConformer(c[i], e[i]);
        }
        return ret;
    }

    public boolean ensureOptimizationBeforeAddon(FragmentConformer c) {
        if (this.optimizeOnAddon && !c.isOptimized(this.optLimitOnAddon)) {
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("Optimize before addon");
            }
            c.optimize(this.optLimitOnAddon);
            debugPrintout debug = CleanArgs.getDebug();
            if (debug != null) {
                c.frag.fragMol.place3DApplet("Optimized: ", c.coord);
            }
            return true;
        }
        return false;
    }

    public int addConformer(FragmentConformer c) {
        if (this.ensureOptimizationBeforeAddon(c)) {
            // empty if block
        }
        if (this.eqcheckAdded) {
            for (int i = 0; i < this.getConfCount(); ++i) {
                if (!(this.de < 0.0) && !(Math.abs(c.getEnergy() - this.get(i).getEnergy()) <= this.de)) continue;
                boolean same = this.frag.isEquivalent(this.getCoordinates(i), c.getCoordinates(), this.minrmsd);
                if (CleanArgs.doVerbose()) {
                    CleanArgs.verbose("Check with #" + i + " same: " + same);
                }
                if (!same) continue;
                if (this.keepLowerEOnEqchk && c.getEnergy() < this.get(i).getEnergy()) {
                    this.confs.setElementAt(c, i);
                }
                return 0;
            }
        }
        this.confs.add(c);
        return 1;
    }

    public int size() {
        return this.confs.size();
    }

    public FragmentConformer remove(int n) {
        FragmentConformer ret = (FragmentConformer)this.confs.remove(n);
        return ret;
    }

    public FragmentConformer get(int n) {
        return (FragmentConformer)this.confs.get(n);
    }

    public void sortByEnergy() {
        boolean needsort = false;
        for (int i = 0; i < this.size() - 1; ++i) {
            if (!(this.get(i).getEnergy() > this.get(i + 1).getEnergy())) continue;
            needsort = true;
            break;
        }
        if (!needsort) {
            return;
        }
        Optimization.quickSort(0, this.confs.size() - 1, new Optimization.Sortable(){

            @Override
            public boolean isGreater(int i, int j) {
                return FragmentPool.this.get(i).getEnergy() > FragmentPool.this.get(j).getEnergy();
            }

            @Override
            public void swap(int i, int j) {
                FragmentConformer fci = FragmentPool.this.get(i);
                FragmentConformer fcj = FragmentPool.this.get(j);
                FragmentPool.this.confs.setElementAt(fci, j);
                FragmentPool.this.confs.setElementAt(fcj, i);
            }
        });
    }

    public void printout(String s, debugPrintout debug) {
        if (debug == null) {
            return;
        }
        if (this.size() == 0) {
            debug.println("EMPTY");
            return;
        }
        double[][][] c = new double[this.getConfCount()][][];
        String[] desc = new String[this.getConfCount()];
        for (int i = 0; i < this.getConfCount(); ++i) {
            FragmentConformer fc = this.get(i);
            c[i] = fc.getCoordinates();
            desc[i] = "#" + i + " E=" + fc.getEnergy() + " optreq:" + fc.getOptimizationRequired();
        }
        this.get((int)0).frag.getFragMol().place3DApplets(s, c, null, desc);
    }

    private static int addToPoolSteric(FragmentConformer fc, FragmentPool poolOK, FragmentPool poolSofterror, FragmentPool poolHardError, FragmentPool poolStereoError, debugPrintout debug) {
        return FragmentPool.addToPoolSteric_0(fc, poolOK, poolSofterror, poolHardError, poolStereoError, debug, false);
    }

    private static void notifyStericCorruption(FragmentConformer fc, String msg) {
        CleanSettings s = fc.frag.getCleanSettings();
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.printB("WARNING! Steric corruption after optimization: " + msg);
        }
        if (s.getInst() != null) {
            s.getInst().addFlag(new Instrumentation.OptimizationCorruptedFlag());
            System.err.println("Stack trace:");
            Thread.dumpStack();
        }
    }

    private static int addToPoolSteric_0(FragmentConformer fc, FragmentPool poolOK, FragmentPool poolSofterror, FragmentPool poolHardError, FragmentPool poolStereoError, debugPrintout debug, boolean invokedOnOkOptimized) {
        int steric;
        if (debug != null) {
            debug.printB("addToPoolSteric_0(...," + invokedOnOkOptimized + ")");
        }
        if (((steric = fc.frag.checkSteric(fc.getCoordinates(), fc.isOptimized(), debug)) & 0x20) != 0) {
            if (debug != null) {
                debug.println("Flawed structure.");
            }
            if (invokedOnOkOptimized) {
                FragmentPool.notifyStericCorruption(fc, "Optimized to flawed");
            }
            return 0;
        }
        if ((steric & 0xA) != 0) {
            if (debug != null) {
                debug.println("Hard error.");
            }
            if (poolHardError != null) {
                poolHardError.addConformer(fc);
            }
            if (invokedOnOkOptimized) {
                FragmentPool.notifyStericCorruption(fc, "Optimized to hard error");
            }
            return 0;
        }
        if ((steric & 0x40) != 0) {
            if (debug != null) {
                debug.println("Deformed SP3");
            }
            if (!fc.isOptimized(0.01)) {
                if (debug != null) {
                    debug.println("Not optimized");
                }
                if (poolSofterror != null) {
                    poolSofterror.addConformer(fc);
                }
                return 0;
            }
        }
        if (fc.frag.isStereoSpecified()) {
            int stereo = fc.frag.checkStereo(fc.getCoordinates(), true, 0.1, debug);
            if (debug != null) {
                debug.println("Stereo result: " + stereo + " " + Fragment.stereoResultsToString(stereo));
            }
            boolean stereoOK = true;
            if ((stereo & 1) == 0) {
                stereoOK = false;
            }
            if (!stereoOK) {
                if (poolStereoError != null) {
                    poolStereoError.addConformer(fc);
                }
                if (invokedOnOkOptimized) {
                    FragmentPool.notifyStericCorruption(fc, "Optimized to stereo error");
                }
                return 0;
            }
        }
        if (fc.getOptimizationRequired() || (steric & 0x15) != 0) {
            if (debug != null) {
                debug.println("Soft error/optimization required flag found");
            }
            if (poolSofterror != null) {
                poolSofterror.addConformer(fc);
            }
            if (invokedOnOkOptimized) {
                FragmentPool.notifyStericCorruption(fc, "Optimized to soft error");
            }
            return 0;
        }
        if (debug != null) {
            debug.println("Steric ok.");
        }
        if (poolOK != null) {
            if (invokedOnOkOptimized) {
                return poolOK.addConformer(fc);
            }
            if (poolOK.ensureOptimizationBeforeAddon(fc)) {
                return FragmentPool.addToPoolSteric_0(fc, poolOK, poolSofterror, poolHardError, poolStereoError, debug, true);
            }
            return poolOK.addConformer(fc);
        }
        return 0;
    }

    public int moveAllTo(FragmentPool dest) {
        int ret = 0;
        while (this.size() != 0) {
            ret += dest.addConformer(this.remove(0));
        }
        return ret;
    }

    public int filterOptimize(int expected, FragmentPool poolOK, FragmentPool poolSofterror, FragmentPool poolHardError, FragmentPool poolStereoError, double optLimit, CleanSettings settings) {
        int ret = 0;
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.incLevel("Pool filter optimize");
        }
        while (expected > ret && !this.confs.isEmpty()) {
            FragmentConformer fc = this.remove(0);
            if (debug != null) {
                this.frag.getFragMol().place3DApplet("Before optimization", fc.getCoordinates());
            }
            fc.optimize(optLimit);
            ret += FragmentPool.addToPoolSteric(fc, poolOK, poolSofterror, poolHardError, poolStereoError, debug);
        }
        if (debug != null) {
            debug.decLevel();
        }
        return ret;
    }

    public int filterSteric(FragmentPool poolOK, FragmentPool poolSofterror, FragmentPool poolHardError, FragmentPool poolStereoError, SimpleCanceller c, int maxAddedCount, CleanSettings settings) {
        int ret = 0;
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.incLevel("Pool filter steric");
        }
        while (!this.confs.isEmpty()) {
            if (c != null && c.isCancelled()) {
                return 0;
            }
            FragmentConformer fc = this.remove(0);
            if (maxAddedCount <= 0 || (ret += FragmentPool.addToPoolSteric(fc, poolOK, poolSofterror, poolHardError, poolStereoError, debug)) < maxAddedCount) continue;
            break;
        }
        if (debug != null) {
            debug.decLevel();
        }
        return ret;
    }

    public int removeDuplicates(Multiconformer set2, Multiconformer set3, double de, double minrmsd, CleanSettings settings) {
        int i;
        if (settings.OPT_stopper_equivalences != null) {
            settings.OPT_stopper_equivalences.start();
        }
        int ret = 0;
        debugPrintout debug = CleanArgs.getDebug();
        if (debug != null) {
            debug.incLevel("removeDuplicates");
        }
        if (set2 == null || set2.getConfCount() == 0) {
            if (debug != null) {
                debug.println("Set set2 to null. " + (set2 == null ? "Set2==null" : "set2.getConfCount=" + set2.getConfCount()));
            }
            set2 = null;
        }
        if (set3 == null || set3.getConfCount() == 0) {
            if (debug != null) {
                debug.println("Set set3 to null. " + (set3 == null ? "Set3==null" : "set3.getConfCount=" + set3.getConfCount()));
            }
            set3 = null;
        }
        if (debug != null) {
            debug.println("This conformer count = " + this.size());
            if (set2 == null) {
                debug.println("Set2 not given.");
            } else {
                debug.println("Set2 conformer count = " + set2.getConfCount());
            }
            if (set3 == null) {
                debug.println("Set3 not given.");
            } else {
                debug.println("Set3 conformer count = " + set3.getConfCount());
            }
            debug.println("Energy tolerance: " + de);
            debug.println("Min RMSD: " + minrmsd);
        }
        double[] e1 = this.getEnergies();
        double[] e2 = set2 == null ? null : set2.getEnergies();
        double[] e3 = set3 == null ? null : set3.getEnergies();
        BitSet dropped = new BitSet(this.size());
        block0: for (i = 0; i < this.size(); ++i) {
            boolean same;
            int j;
            if (debug != null) {
                debug.printBC("Checking " + i + " E=" + e1[i]);
            }
            if (set2 != null) {
                if (debug != null) {
                    debug.printB("Against items in set2");
                }
                for (j = 0; j < set2.getConfCount(); ++j) {
                    if (!(de <= 0.0) && !(Math.abs(e2[j] - e1[i]) <= de)) continue;
                    if (debug != null) {
                        debug.println("Checking " + j + " in set2 E=" + e2[j]);
                    }
                    if (!(same = this.frag.isEquivalent(this.getCoordinates(i), set2.getCoordinates(j), minrmsd))) continue;
                    if (debug != null) {
                        debug.printB("SAME!");
                    }
                    dropped.set(i);
                    break;
                }
            }
            if (set3 != null && !dropped.get(i)) {
                if (debug != null) {
                    debug.printB("Against items in set3");
                }
                for (j = 0; j < set3.getConfCount(); ++j) {
                    if (!(de <= 0.0) && !(Math.abs(e3[j] - e1[i]) <= de)) continue;
                    if (debug != null) {
                        debug.println("Checking " + j + " in set3 E=" + e3[j]);
                    }
                    if (!(same = this.frag.isEquivalent(this.getCoordinates(i), set3.getCoordinates(j), minrmsd))) continue;
                    if (debug != null) {
                        debug.printB("SAME!");
                    }
                    dropped.set(i);
                    break;
                }
            }
            if (dropped.get(i)) continue;
            if (debug != null) {
                debug.printB("Against items in set1");
            }
            for (j = 0; j < this.size(); ++j) {
                if (i == j || dropped.get(j) || de > 0.0 && Math.abs(e1[j] - e1[i]) > de || e1[j] > e1[i]) continue;
                if (debug != null) {
                    debug.println("Checking " + j + " in set1 E=" + e1[j]);
                }
                if (!(same = this.frag.isEquivalent(this.getCoordinates(i), this.getCoordinates(j), minrmsd))) continue;
                if (debug != null) {
                    debug.printB("SAME!");
                }
                dropped.set(i);
                continue block0;
            }
        }
        for (i = this.size() - 1; i >= 0; --i) {
            if (!dropped.get(i)) continue;
            this.remove(i);
            ++ret;
        }
        if (debug != null) {
            debug.printBC("removeDuplicates done");
            debug.println("Set1 conformer count = " + this.size());
            if (set2 == null) {
                debug.println("Set2 not given.");
            } else {
                debug.println("Set2 conformer count = " + set2.getConfCount());
            }
            debug.decLevel();
        }
        if (settings.OPT_stopper_equivalences != null) {
            settings.OPT_stopper_equivalences.stop();
        }
        return ret;
    }

    @Override
    public double[][][] getCoordinates() {
        double[][][] ret = new double[this.size()][][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.getCoordinates(i);
        }
        return ret;
    }

    @Override
    public double[][] getCoordinates(int confid) {
        return this.get(confid).getCoordinates();
    }

    @Override
    public void setCoordinates(double[][][] coordinates) {
        throw new UnsupportedOperationException("Interface method not implemented");
    }

    @Override
    public double[] getEnergies() {
        double[] ret = new double[this.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.get(i).getEnergy();
        }
        return ret;
    }

    @Override
    public void setEnergies(double[] energies) {
        throw new UnsupportedOperationException("Interface method not implemented");
    }

    @Override
    public int getConfCount() {
        return this.size();
    }

    @Override
    public int getAtomCount() {
        return this.frag.getFragMol().a;
    }

    @Override
    public void removeConformer(int confid) {
        this.remove(confid);
    }

    public boolean getOptimizeOnAddon() {
        return this.optimizeOnAddon;
    }

    @Override
    public void applyConfPerm(int[] confperm) {
        throw new UnsupportedOperationException("Interface method not implemented");
    }
}

