/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.struc;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.modelling.linalg.GradientOptimization;
import chemaxon.marvin.modelling.linalg.V;
import chemaxon.marvin.modelling.mm.Dreiding;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MolGeom {
    public static double scale(double fi, double fi0) {
        if (fi < 0.0) {
            return 1.0;
        }
        double scale = 0.0;
        double a = 16.0 / (3.0 * fi0 * fi0 * fi0) * fi * fi * fi;
        if (fi >= 0.0 && fi < fi0 / 4.0) {
            scale = 1.0 - a;
        } else if (fi >= fi0 / 4.0 && fi < 0.75 * fi0) {
            scale = a - 8.0 / (fi0 * fi0) * fi * fi + 2.0 / fi0 * fi + 0.8333333333333334;
        } else if (fi >= 0.75 * fi0 && fi < fi0) {
            scale = -a + 16.0 / (fi0 * fi0) * fi * fi - 16.0 / fi0 * fi + 5.333333333333333;
        }
        if (scale < 0.0) {
            if (scale < -1.0E-12) {
                System.err.println("[INFO] scale < 0 scale=");
            }
            scale = 0.0;
        }
        return scale;
    }

    public static Molecule rotate(Molecule m1, int atom1, int atom2, double radian) {
        double[][] c1 = MolGeom.getCoordniates(m1);
        int[] atoms = new int[m1.getAtomCount() - 2];
        int c = 0;
        for (int i = 0; i < m1.getAtomCount(); ++i) {
            if (i == atom1 || i == atom2) continue;
            atoms[c++] = i;
        }
        c1 = MolGeom.rigidRotate(c1, atoms, radian, atom1, atom2, new double[3]);
        m1 = MolGeom.putCoordinates(m1, c1);
        return m1;
    }

    public static double scaleGrad(double fi, double fi0) {
        double diff = 0.0;
        double a = 16.0 / (fi0 * fi0 * fi0) * fi * fi;
        if (fi < 0.0) {
            diff = 0.0;
        } else if (fi >= 0.0 && fi < fi0 / 4.0) {
            diff = -a;
        } else if (fi >= fi0 / 4.0 && fi < 0.75 * fi0) {
            diff = a - a * fi0 / fi + 2.0 / fi0;
        } else if (fi >= 0.75 * fi0 && fi < fi0) {
            diff = -a + 2.0 * a * fi0 / fi - 16.0 / fi0;
        }
        if (diff > 0.0) {
            diff = 0.0;
        }
        return diff;
    }

    public static void removeLonePairs(Molecule m) {
        int i = 0;
        while (i < m.getAtomCount()) {
            MolAtom a = m.getAtom(i);
            if (a.getAtno() == 130) {
                m.removeAtom(i);
                continue;
            }
            ++i;
        }
    }

    public static void removeAlias(Molecule m) {
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom a = m.getAtom(i);
            a.setAliasstr(null);
        }
    }

    public static void addHydrogens3D(Molecule m) throws GradientOptimization.GradientOptimizationException {
        Dreiding d = new Dreiding();
        m.hydrogenize(true);
        int hCount = 0;
        for (int i = 0; i < m.getAtomCount(); ++i) {
            if (m.getAtom(i).getAtno() != 1) continue;
            ++hCount;
        }
        if (hCount == 0) {
            return;
        }
        int[] index = new int[hCount];
        hCount = 0;
        for (int i = 0; i < m.getAtomCount(); ++i) {
            if (m.getAtom(i).getAtno() != 1) continue;
            index[hCount] = i;
            ++hCount;
        }
        d.init(m, index);
        GradientOptimization g = new GradientOptimization(d);
        g.setGradientRMSLimit(0.001);
        g.run();
        if (!g.isOptimizationConverged()) {
            throw new UnsupportedOperationException("Optimization was not converged");
        }
        m = d.getMoleculeWithLastUsedCoordinates();
    }

    public static double distance(MolAtom ma1, MolAtom ma2) {
        double x = ma1.getX() - ma2.getX();
        double y = ma1.getY() - ma2.getY();
        double z = ma1.getZ() - ma2.getZ();
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static double exp(double val) {
        long tmp = (long)(1512775.0 * val + 1.072632447E9);
        return Double.longBitsToDouble(tmp << 32);
    }

    public static void writeMol(Molecule m, String filename) {
        System.err.println("write file:" + filename);
        try {
            FileOutputStream out = new FileOutputStream(filename);
            MolExporter me = new MolExporter(out, "mrv");
            me.write(m);
            me.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (MolExportException mf) {
            mf.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        System.err.println("done");
    }

    public static Molecule[] readMols(String filename) {
        try {
            Molecule m;
            MolImporter mr = new MolImporter(filename);
            ArrayList<Molecule> tmp = new ArrayList<Molecule>();
            while ((m = mr.read()) != null) {
                tmp.add(m.cloneMolecule());
            }
            mr.close();
            return tmp.toArray(new Molecule[tmp.size()]);
        }
        catch (IOException ex) {
            Logger.getLogger(MolGeom.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static void writeMol(List<Molecule> m, String filename) {
        try {
            FileOutputStream out = new FileOutputStream(filename);
            MolExporter me = new MolExporter(out, "mrv");
            for (Molecule molecule : m) {
                me.write(molecule);
            }
            me.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (MolExportException mf) {
            mf.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public static void writeMol(Molecule[] m, String filename) {
        System.err.println("write file:" + filename);
        try {
            FileOutputStream out = new FileOutputStream(filename);
            MolExporter me = new MolExporter(out, "mrv");
            for (Molecule molecule : m) {
                me.write(molecule);
            }
            me.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (MolExportException mf) {
            mf.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        System.err.println("done");
    }

    public static double getRMSD(double[][] crd1, double[][] crd2, int[][] mapping) {
        double r = 0.0;
        for (int i = 0; i < mapping.length; ++i) {
            r += MolGeom.getDistSq(crd1[mapping[i][0]], crd2[mapping[i][1]]);
        }
        return Math.sqrt(r / (double)(mapping.length * 3));
    }

    public static double getRMSD(double[][] crd1, double[][] crd2) {
        if (crd1.length != crd2.length) {
            throw new UnsupportedOperationException("crd arrays length mismatch");
        }
        int[][] map = new int[crd1.length][2];
        for (int i = 0; i < map.length; ++i) {
            map[i][0] = i;
            map[i][1] = i;
        }
        return MolGeom.getRMSD(crd1, crd2, map);
    }

    public static Molecule[] breakMol(Molecule mol) {
        SelectionMolecule[] components = (SelectionMolecule[])mol.findFrags(SelectionMolecule.class, 1);
        Molecule[] ret = new Molecule[components.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new Molecule();
            components[i].clonecopy(ret[i]);
        }
        return ret;
    }

    public static int myPow(int base, int exp) {
        int ret = 1;
        for (int i = 0; i < exp; ++i) {
            ret *= base;
        }
        return ret;
    }

    public static double myPow(double base, int exp) {
        double ret = 1.0;
        for (int i = 0; i < exp; ++i) {
            ret *= base;
        }
        return ret;
    }

    public static double stDev(double expct, double[] a) {
        double moment = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double x = a[i] - expct;
            moment += x * x;
        }
        return Math.sqrt(moment / (double)a.length);
    }

    public static double skewness(double expct, double stdDev, double[] a) {
        double moment = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double x = a[i] - expct;
            moment += x * x * x;
        }
        return moment *= 1.0 / ((double)a.length * stdDev * stdDev * stdDev);
    }

    public static double kurtosis(double expct, double stdDev, double[] a) {
        double moment = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double x = a[i] - expct;
            moment += x * x * x * x;
        }
        moment *= 1.0 / ((double)a.length * stdDev * stdDev * stdDev * stdDev);
        return moment -= 3.0;
    }

    public static double average(double[] a) {
        double avg = 0.0;
        for (int i = 0; i < a.length; ++i) {
            avg += a[i];
        }
        return avg / (double)a.length;
    }

    public static double[] getCenter(double[][] c) {
        double cx = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        for (int i = 0; i < c.length; ++i) {
            cx += c[i][0];
            cy += c[i][1];
            cz += c[i][2];
        }
        return new double[]{cx /= (double)c.length, cy /= (double)c.length, cz /= (double)c.length};
    }

    public static void centerTheseMolecules(List<Molecule> mols) {
        int i;
        System.err.println("centerTheseMolecules");
        double[][][] crds = new double[mols.size()][][];
        int count = 0;
        for (int i2 = 0; i2 < mols.size(); ++i2) {
            crds[i2] = MolGeom.getCoordniates(mols.get(i2));
            count += crds[i2].length;
        }
        double[][] crdsTot = new double[count][];
        count = 0;
        for (int i3 = 0; i3 < crds.length; ++i3) {
            for (int j = 0; j < crds[i3].length; ++j) {
                crdsTot[count++] = crds[i3][j];
            }
        }
        double[] center = MolGeom.getCenter(crdsTot);
        for (i = 0; i < crdsTot.length; ++i) {
            MolGeom.minusVec(crdsTot[i], center, crdsTot[i]);
        }
        for (i = 0; i < mols.size(); ++i) {
            MolGeom.putCoordinates(mols.get(i), crds[i]);
        }
    }

    public static double[][] center(double[][] c) {
        int i;
        double cx = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        for (i = 0; i < c.length; ++i) {
            cx += c[i][0];
            cy += c[i][1];
            cz += c[i][2];
        }
        cx /= (double)c.length;
        cy /= (double)c.length;
        cz /= (double)c.length;
        for (i = 0; i < c.length; ++i) {
            double[] dArray = c[i];
            dArray[0] = dArray[0] - cx;
            double[] dArray2 = c[i];
            dArray2[1] = dArray2[1] - cy;
            double[] dArray3 = c[i];
            dArray3[2] = dArray3[2] - cz;
        }
        return c;
    }

    public static double[][] getCoordniates(Molecule m) {
        return MolGeom.getCoordniates(m, new double[m.getAtomCount()][3]);
    }

    public static double[][] getCoordniates(Molecule m, double[][] crd) {
        for (int i = 0; i < m.getAtomCount(); ++i) {
            crd[i][0] = m.getAtom(i).getX();
            crd[i][1] = m.getAtom(i).getY();
            crd[i][2] = m.getAtom(i).getZ();
        }
        return crd;
    }

    public static Molecule putCoordinates(Molecule m, double[][] crd) {
        for (int i = 0; i < m.getAtomCount(); ++i) {
            m.getAtom(i).setX(crd[i][0]);
            m.getAtom(i).setY(crd[i][1]);
            m.getAtom(i).setZ(crd[i][2]);
        }
        return m;
    }

    public static double getDistSq(double[] crd1, double[] crd2) {
        double x = crd1[0] - crd2[0];
        double y = crd1[1] - crd2[1];
        double z = crd1[2] - crd2[2];
        return x * x + y * y + z * z;
    }

    public static double getLength(double[] crd1, double[] crd2) {
        return Math.sqrt(MolGeom.getDistSq(crd1, crd2));
    }

    protected void printBtab(int[][] btab) {
        System.err.println("BTAB");
        for (int i = 0; i < btab.length; ++i) {
            int[] is = btab[i];
            System.err.print(i + 1 + ". ");
            for (int j = 0; j < is.length; ++j) {
                int k = is[j];
                if (k == -1) continue;
                System.err.print(j + 1 + " ");
            }
            System.err.println("");
        }
    }

    public void printCtab(int[][] ctab) {
        System.out.println("CTAB:");
        int a = 1;
        for (int i = 0; i < ctab.length; ++i) {
            int[] is = ctab[i];
            System.out.print(i + a + ". ");
            for (int j = 0; j < is.length; ++j) {
                System.out.print(is[j] + a + " ");
            }
            System.out.println("");
        }
    }

    public static double dihedralDifference(double d1, double d2) {
        double d;
        for (d = d1 - d2; d > Math.PI; d -= Math.PI * 2) {
        }
        while (d < -Math.PI) {
            d += Math.PI * 2;
        }
        return d;
    }

    public static double limitStep(double d) {
        double limit = Math.PI;
        if (Math.abs(d) > limit) {
            System.out.println("wanted: " + MolGeom.forHumans(d) + " returning: " + MolGeom.forHumans(limit));
            d = limit;
        }
        return d;
    }

    public static double doubleEquals(double a, double b) {
        double diff = Math.abs(a - b);
        double min = Math.min(Math.abs(a), Math.abs(b));
        if (min == 0.0) {
            return diff;
        }
        return diff / min;
    }

    public static boolean doubleEquals(double[][] a, double[][] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < b.length; ++i) {
            if (a[i].length != b[i].length) {
                return false;
            }
            for (int j = 0; j < b[i].length; ++j) {
                if (!(MolGeom.doubleEquals(a[i][j], b[i][j]) > 0.01)) continue;
                return false;
            }
        }
        return true;
    }

    public static void getVector3D(double[] d1, double[] d2, double[] result) {
        result[0] = d1[1] * d2[2] - d1[2] * d2[1];
        result[1] = d1[2] * d2[0] - d1[0] * d2[2];
        result[2] = d1[0] * d2[1] - d1[1] * d2[0];
    }

    public static double dot3D(double[] d1, double[] d2) {
        return d1[0] * d2[0] + d1[1] * d2[1] + d1[2] * d2[2];
    }

    public static double[] minusVec(double[] a, double[] b, double[] toStore) {
        toStore[0] = a[0] - b[0];
        toStore[1] = a[1] - b[1];
        toStore[2] = a[2] - b[2];
        return toStore;
    }

    public static double[] plusVec(double[] a, double[] b, double[] toStore) {
        toStore[0] = a[0] + b[0];
        toStore[1] = a[1] + b[1];
        toStore[2] = a[2] + b[2];
        return toStore;
    }

    public static void cpVec(double[] from, double[] to) {
        System.arraycopy(from, 0, to, 0, from.length);
    }

    public static void mul(double[] v, double s) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i] * s;
        }
    }

    public static double getLength(double[] v) {
        return Math.sqrt(V.dot(v));
    }

    public static double[] substr(double[] from, double[] what) {
        for (int i = 0; i < from.length; ++i) {
            from[i] = from[i] - what[i];
        }
        return from;
    }

    protected static boolean ifzero(double r) {
        double tol = 1.0E-10;
        return -tol < r && tol > r;
    }

    protected static double getDihedralMy(int i, int j, int k, int l, double[][] crd) {
        double[] u = new double[3];
        double[] v = new double[3];
        double[] w = new double[3];
        double[] uw = new double[3];
        double[] vw = new double[3];
        MolGeom.cpVec(crd[i], u);
        MolGeom.cpVec(crd[k], w);
        MolGeom.cpVec(crd[l], v);
        MolGeom.substr(u, crd[j]);
        MolGeom.substr(w, crd[j]);
        MolGeom.substr(v, crd[k]);
        MolGeom.mul(u, 1.0 / MolGeom.getLength(u));
        MolGeom.mul(w, 1.0 / MolGeom.getLength(w));
        MolGeom.mul(v, 1.0 / MolGeom.getLength(v));
        double[] vwuw = new double[3];
        return MolGeom.getDihedByVecMy(u, v, w, uw, vw, vwuw);
    }

    public static String forHumans(double radian) {
        DecimalFormat formatter = new DecimalFormat("000.000");
        return formatter.format(Math.toDegrees(radian));
    }

    private static double getDihedByVecMy(double[] u, double[] v, double[] w, double[] uw, double[] vw, double[] vwuw) {
        MolGeom.getVector3D(u, w, uw);
        MolGeom.getVector3D(v, w, vw);
        double cos_u = V.dot(u, w);
        cos_u = Math.max(-1.0, Math.min(1.0, cos_u));
        double cos_v = -1.0 * V.dot(v, w);
        cos_v = Math.max(-1.0, Math.min(1.0, cos_v));
        double sinSq_u = 1.0 - cos_u * cos_u;
        double sinSq_v = 1.0 - cos_v * cos_v;
        double sin_u = Math.sqrt(sinSq_u);
        double sin_v = Math.sqrt(sinSq_v);
        if (MolGeom.ifzero(sin_u) || MolGeom.ifzero(sin_v)) {
            try {
                throw new Exception("linear bondangle!");
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
                System.exit(0);
            }
        }
        double cosdelta = V.dot(uw, vw) / (sin_u * sin_v);
        cosdelta = Math.min(1.0, Math.max(-1.0, cosdelta));
        MolGeom.getVector3D(vw, uw, vwuw);
        double cossign = V.dot(w, vwuw);
        double Deltasign = cossign < 0.0 ? 1.0 : -1.0;
        double delta = Math.acos(cosdelta) * Deltasign;
        return delta;
    }

    public static double[] getDihedrals(int[][] index, double[][] crd, boolean wishtest) throws LinearBondAngleException {
        double[] dihedrals = new double[index.length];
        for (int j = 0; j < index.length; ++j) {
            double d;
            dihedrals[j] = d = MolGeom.getDihedral(index[j][0], index[j][1], index[j][2], index[j][3], crd, wishtest);
        }
        return dihedrals;
    }

    public static boolean ifLinear(double cosAngle) {
        return MolGeom.ifzero(1.0 - Math.abs(cosAngle));
    }

    public static double getDihedral(int i, int j, int k, int l, double[][] crd, boolean wishtest) throws LinearBondAngleException {
        double[] u = new double[3];
        double[] v = new double[3];
        double[] w = new double[3];
        double[] uw = new double[3];
        double[] vw = new double[3];
        MolGeom.cpVec(crd[j], u);
        MolGeom.cpVec(crd[k], w);
        MolGeom.cpVec(crd[l], v);
        MolGeom.substr(u, crd[i]);
        MolGeom.substr(w, crd[j]);
        MolGeom.substr(v, crd[k]);
        if (wishtest) {
            MolGeom.mul(u, 1.0 / MolGeom.getLength(u));
            MolGeom.mul(w, 1.0 / MolGeom.getLength(w));
            MolGeom.mul(v, 1.0 / MolGeom.getLength(v));
        }
        return MolGeom.getDihedByVec(u, w, v, uw, vw, wishtest);
    }

    public static double getDihedByVec(double[] u, double[] w, double[] v, double[] uw, double[] wv, boolean wishtest) throws LinearBondAngleException {
        if (wishtest) {
            double a1 = V.dot(u, w);
            double a2 = V.dot(w, v);
            if (MolGeom.ifLinear(a1)) {
                throw new LinearBondAngleException("Linear bondangle found, cannot calculate dihedral. Send bug report with molecule.");
            }
            if (MolGeom.ifLinear(a2)) {
                throw new LinearBondAngleException("Linear bondangle found, cannot calculate dihedral. Send bug report with molecule.");
            }
        }
        MolGeom.getVector3D(w, v, wv);
        MolGeom.getVector3D(u, w, uw);
        double y = MolGeom.getLength(w) * V.dot(u, wv);
        double x = V.dot(uw, wv);
        double delta = Math.atan2(y, x);
        return delta;
    }

    public static double[] arrayCopy3D(double[][] from, double[] to) {
        if (to == null) {
            to = new double[from.length * 3];
        }
        int c = 0;
        for (int i = 0; i < from.length; ++i) {
            to[c++] = from[i][0];
            to[c++] = from[i][1];
            to[c++] = from[i][2];
        }
        return to;
    }

    public static double[][] arrayCopy3D(double[] from, double[][] to) {
        if (to == null) {
            to = new double[from.length / 3][3];
        }
        int c = 0;
        for (int i = 0; i < to.length; ++i) {
            to[i][1] = from[c++];
            to[i][2] = from[c++];
            to[i][3] = from[c++];
        }
        return to;
    }

    public static double[][] rigidRotate(double[][] crds, int[] atomsToRotate, double theta, int bondAtom1, int bondAtom2, double[] tmp) {
        double[] bond1 = crds[bondAtom1];
        double[] bond2 = crds[bondAtom2];
        double[] axis = tmp;
        axis[0] = bond2[0] - bond1[0];
        axis[1] = bond2[1] - bond1[1];
        axis[2] = bond2[2] - bond1[2];
        MolGeom.mul(axis, 1.0 / MolGeom.getLength(axis));
        double costheta = MolGeom.cos(theta);
        double sintheta = MolGeom.sin(theta);
        double oneMinuscostheta = 1.0 - costheta;
        for (int i = 0; i < atomsToRotate.length; ++i) {
            int j = atomsToRotate[i];
            double tx = crds[j][0] - bond1[0];
            double ty = crds[j][1] - bond1[1];
            double tz = crds[j][2] - bond1[2];
            crds[j][0] = (costheta + oneMinuscostheta * axis[0] * axis[0]) * tx + (oneMinuscostheta * axis[0] * axis[1] - axis[2] * sintheta) * ty + (oneMinuscostheta * axis[0] * axis[2] + axis[1] * sintheta) * tz;
            crds[j][1] = (oneMinuscostheta * axis[0] * axis[1] + axis[2] * sintheta) * tx + (costheta + oneMinuscostheta * axis[1] * axis[1]) * ty + (oneMinuscostheta * axis[1] * axis[2] - axis[0] * sintheta) * tz;
            crds[j][2] = (oneMinuscostheta * axis[0] * axis[2] - axis[1] * sintheta) * tx + (oneMinuscostheta * axis[1] * axis[2] + axis[0] * sintheta) * ty + (costheta + oneMinuscostheta * axis[2] * axis[2]) * tz;
            double[] dArray = crds[j];
            dArray[0] = dArray[0] + bond1[0];
            double[] dArray2 = crds[j];
            dArray2[1] = dArray2[1] + bond1[1];
            double[] dArray3 = crds[j];
            dArray3[2] = dArray3[2] + bond1[2];
        }
        return crds;
    }

    public static double[][] rigidRotateQ(double[][] crds, int[] atomsToRotate, double theta, int bondAtom1, int bondAtom2, double[] tmp) {
        double[] bond1 = crds[bondAtom1];
        double[] bond2 = crds[bondAtom2];
        double[] q = tmp;
        q[0] = bond2[0] - bond1[0];
        q[1] = bond2[1] - bond1[1];
        q[2] = bond2[2] - bond1[2];
        double mult = MolGeom.sin(theta / 2.0);
        double s1 = MolGeom.cos(theta / 2.0);
        MolGeom.mul(q, mult / MolGeom.getLength(q));
        for (int i = 0; i < atomsToRotate.length; ++i) {
            double x = crds[atomsToRotate[i]][0] - bond1[0];
            double y = crds[atomsToRotate[i]][1] - bond1[1];
            double z = crds[atomsToRotate[i]][2] - bond1[2];
            double s2 = -q[0] * x - q[1] * y - q[2] * z;
            double rx = s1 * x + q[1] * z - q[2] * y;
            double ry = s1 * y + q[2] * x - q[0] * z;
            double rz = s1 * z + q[0] * y - q[1] * x;
            crds[atomsToRotate[i]][0] = -s2 * q[0] + s1 * rx - ry * q[2] + rz * q[1] + bond1[0];
            crds[atomsToRotate[i]][1] = -s2 * q[1] + s1 * ry - rz * q[0] + rx * q[2] + bond1[1];
            crds[atomsToRotate[i]][2] = -s2 * q[2] + s1 * rz - rx * q[1] + ry * q[0] + bond1[2];
        }
        return crds;
    }

    public static double[][] rot(double[][] crds, double theta, double cx, double cy, double cz, double ax, double ay, double az) {
        double mult = MolGeom.sin(theta / 2.0);
        double s1 = MolGeom.cos(theta / 2.0);
        ax *= mult;
        ay *= mult;
        az *= mult;
        for (int i = 0; i < crds.length; ++i) {
            double x = crds[i][0] - cx;
            double y = crds[i][1] - cy;
            double z = crds[i][2] - cz;
            double s2 = -ax * x - ay * y - az * z;
            double rx = s1 * x + ay * z - az * y;
            double ry = s1 * y + az * x - ax * z;
            double rz = s1 * z + ax * y - ay * x;
            crds[i][0] = -s2 * ax + s1 * rx - ry * az + rz * ay + cx;
            crds[i][1] = -s2 * ay + s1 * ry - rz * ax + rx * az + cy;
            crds[i][2] = -s2 * az + s1 * rz - rx * ay + ry * ax + cz;
        }
        return crds;
    }

    public static double[][] rotQ(double[][] crds, double p, double t, double f, double cx, double cy, double cz) {
        double cp = MolGeom.cos(p / 2.0);
        double sp = MolGeom.sin(p / 2.0);
        double ct = MolGeom.cos(t / 2.0);
        double st = MolGeom.sin(t / 2.0);
        double cf = MolGeom.cos(f / 2.0);
        double sf = MolGeom.sin(f / 2.0);
        double q0 = cp * ct * cf + sp * st * sf;
        double q1 = sp * st * sf - cp * st * sf;
        double q2 = cp * st * cf + sp * ct * sf;
        double q3 = cp * ct * sf - sp * st * cf;
        for (int i = 0; i < crds.length; ++i) {
            double x = crds[i][0] - cx;
            double y = crds[i][1] - cy;
            double z = crds[i][2] - cz;
            double s2 = -q1 * x - q2 * y - q3 * z;
            double rx = q0 * x + q2 * z - q3 * y;
            double ry = q0 * y + q3 * x - q1 * z;
            double rz = q0 * z + q1 * y - q2 * x;
            crds[i][0] = -s2 * q1 + q0 * rx - ry * q3 + rz * q2 + cx;
            crds[i][1] = -s2 * q2 + q0 * ry - rz * q1 + rx * q3 + cy;
            crds[i][2] = -s2 * q3 + q0 * rz - rx * q2 + ry * q1 + cz;
        }
        return crds;
    }

    public static double[][] rotEuler(double[][] crds, double tX, double tY, double tZ, double cx, double cy, double cz) {
        double c1 = MolGeom.cos(tX);
        double s1 = MolGeom.sin(tX);
        double c2 = MolGeom.cos(tY);
        double s2 = MolGeom.sin(tY);
        double c3 = MolGeom.cos(tZ);
        double s3 = MolGeom.sin(tZ);
        double p11 = c2 * c3;
        double p12 = c3 * s1 * s2 - c1 * s3;
        double p13 = c1 * c3 * s2 + s1 * s3;
        double p21 = c2 * s3;
        double p22 = c1 * c3 + s1 * s2 * s3;
        double p23 = c1 * s2 * s3 - c3 * s1;
        double p31 = -s2;
        double p32 = c2 * s1;
        double p33 = c1 * c2;
        for (int i = 0; i < crds.length; ++i) {
            double x = crds[i][0] - cx;
            double y = crds[i][1] - cy;
            double z = crds[i][2] - cz;
            crds[i][0] = p11 * x + p12 * y + p13 * z + cx;
            crds[i][1] = p21 * x + p22 * y + p23 * z + cy;
            crds[i][2] = p31 * x + p32 * y + p33 * z + cz;
        }
        return crds;
    }

    public static double[][] griewank(double[][] crds, double p, double t, double f, double cx, double cy, double cz) {
        double e0 = MolGeom.cos(t / 2.0) * MolGeom.cos((p + f) / 2.0);
        double e1 = MolGeom.sin(t / 2.0) * MolGeom.cos((p - f) / 2.0);
        double e2 = MolGeom.sin(t / 2.0) * MolGeom.sin((p - f) / 2.0);
        double e3 = MolGeom.cos(t / 2.0) * MolGeom.sin((p + f) / 2.0);
        double p11 = e1 * e1 - e2 * e2 - e3 * e3 + e0 * e0;
        double p12 = 2.0 * (e1 * e2 + e3 * e0);
        double p13 = 2.0 * (e1 * e3 - e2 * e0);
        double p21 = 2.0 * (e1 * e2 - e3 * e0);
        double p22 = -e1 * e1 + e2 * e2 - e3 * e3 + e0 * e0;
        double p23 = 2.0 * (e2 * e3 + e1 * e0);
        double p31 = 2.0 * (e1 * e3 + e2 * e0);
        double p32 = 2.0 * (e2 * e3 - e1 * e0);
        double p33 = -e1 * e1 - e2 * e2 + e3 * e3 + e0 * e0;
        for (int i = 0; i < crds.length; ++i) {
            double xx = crds[i][0] - cx;
            double yy = crds[i][1] - cy;
            double zz = crds[i][2] - cz;
            crds[i][0] = p11 * xx + p12 * yy + p13 * zz + cx;
            crds[i][1] = p21 * xx + p22 * yy + p23 * zz + cy;
            crds[i][2] = p31 * xx + p32 * yy + p33 * zz + cz;
        }
        return crds;
    }

    public static double[] parallelToPlane(double[] crd, double[] ret, double[] b) {
        if (Math.abs(b[0] * b[0] + b[1] * b[1] + b[2] * b[2] - 1.0) > 1.0E-5) {
            System.err.println("L: " + (b[0] * b[0] + b[1] * b[1] + b[2] * b[2]));
            throw new UnsupportedOperationException("Plane`s normal must have unit length.");
        }
        double m11 = 1.0 - b[0] * b[0];
        double m12 = -b[0] * b[1];
        double m13 = -b[0] * b[2];
        double m22 = 1.0 - b[1] * b[1];
        double m23 = -b[1] * b[2];
        double m33 = 1.0 - b[2] * b[2];
        ret[0] = crd[0] * m11 + crd[1] * m12 + crd[2] * m13;
        ret[1] = crd[0] * m12 + crd[1] * m22 + crd[2] * m23;
        ret[2] = crd[0] * m13 + crd[1] * m23 + crd[2] * m33;
        return ret;
    }

    public static double[] parallelToPlaneUnnormalized(double[] crd, double[] ret, double v0, double v1, double v2) {
        double vx = v0 * v0;
        double vy = v1 * v1;
        double vz = v2 * v2;
        double rSQ = vx + vy + vz;
        double m11 = (vz + vy) / rSQ;
        double m12 = -v0 * v1 / rSQ;
        double m13 = -v0 * v2 / rSQ;
        double m22 = (vz + vx) / rSQ;
        double m23 = -v1 * v2 / rSQ;
        double m33 = (vx + vy) / rSQ;
        ret[0] = crd[0] * m11 + crd[1] * m12 + crd[2] * m13;
        ret[1] = crd[0] * m12 + crd[1] * m22 + crd[2] * m23;
        ret[2] = crd[0] * m13 + crd[1] * m23 + crd[2] * m33;
        return ret;
    }

    public static void normalize(double[] crd) {
        MolGeom.mul(crd, 1.0 / MolGeom.getLength(crd));
    }

    public static double[] perpendicularToPlane(double[] crd, double[] ret, double[] b) {
        if (Math.abs(b[0] * b[0] + b[1] * b[1] + b[2] * b[2] - 1.0) > 1.0E-5) {
            throw new UnsupportedOperationException("Plane`s normal must have unit length.");
        }
        double m11 = b[0] * b[0];
        double m12 = b[0] * b[1];
        double m13 = b[0] * b[2];
        double m22 = b[1] * b[1];
        double m23 = b[1] * b[2];
        double m33 = b[2] * b[2];
        ret[0] = crd[0] * m11 + crd[1] * m12 + crd[2] * m13;
        ret[1] = crd[0] * m12 + crd[1] * m22 + crd[2] * m23;
        ret[2] = crd[0] * m13 + crd[1] * m23 + crd[2] * m33;
        return ret;
    }

    private static double[][] adrians(double[][] crds, double p, double t, double f, double cx, double cy, double cz) {
        double e0 = MolGeom.cos(t / 2.0) * MolGeom.cos((p + f) / 2.0);
        double e1 = MolGeom.sin(t / 2.0) * MolGeom.cos((p - f) / 2.0);
        double e2 = MolGeom.sin(t / 2.0) * MolGeom.sin((p - f) / 2.0);
        double e3 = MolGeom.cos(t / 2.0) * MolGeom.sin((p + f) / 2.0);
        e0 = MolGeom.cos(p / 2.0);
        e1 = MolGeom.sin(p / 2.0) * MolGeom.cos(t);
        e2 = MolGeom.sin(p / 2.0) * MolGeom.sin(t) * MolGeom.cos(f);
        e3 = MolGeom.sin(p / 2.0) * MolGeom.sin(t) * MolGeom.sin(f);
        double p11 = e1 * e1 - e2 * e2 - e3 * e3 + e0 * e0;
        double p12 = 2.0 * (e1 * e2 + e3 * e0);
        double p13 = 2.0 * (e1 * e3 - e2 * e0);
        double p21 = 2.0 * (e1 * e2 - e3 * e0);
        double p22 = -e1 * e1 + e2 * e2 - e3 * e3 + e0 * e0;
        double p23 = 2.0 * (e2 * e3 + e1 * e0);
        double p31 = 2.0 * (e1 * e3 + e2 * e0);
        double p32 = 2.0 * (e2 * e3 - e1 * e0);
        double p33 = -e1 * e1 - e2 * e2 + e3 * e3 + e0 * e0;
        for (int i = 0; i < crds.length; ++i) {
            double xx = crds[i][0] - cx;
            double yy = crds[i][1] - cy;
            double zz = crds[i][2] - cz;
            crds[i][0] = p11 * xx + p12 * yy + p13 * zz + cx;
            crds[i][1] = p21 * xx + p22 * yy + p23 * zz + cy;
            crds[i][2] = p31 * xx + p32 * yy + p33 * zz + cz;
        }
        return crds;
    }

    public static void wr(double[] a) {
        System.err.print("{");
        for (int i = 0; i < a.length - 1; ++i) {
            System.err.print(a[i] + ",");
        }
        System.err.println(a[a.length - 1] + " },");
    }

    public static void wrl(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            System.out.println(i + ". " + a[i]);
        }
    }

    public static void wr(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            System.err.print(a[i] + 0 + " ");
        }
        System.err.println("");
    }

    public static void wr(short[] a) {
        for (int i = 0; i < a.length; ++i) {
            System.err.print(a[i] + " ");
        }
        System.err.println("");
    }

    public static void wr(float[] a) {
        DecimalFormat f = new DecimalFormat("0.000");
        for (int i = 0; i < a.length; ++i) {
            System.err.print(f.format(a[i]) + " ");
        }
        System.err.println("");
    }

    public static void wr(int[][] a) {
        for (int i = 0; i < a.length; ++i) {
            System.err.print(i + ". ");
            MolGeom.wr(a[i]);
        }
    }

    public static void wr(float[][] a) {
        int c = 1;
        for (int i = 0; i < a.length; ++i) {
            System.err.print(i + c + ". ");
            MolGeom.wr(a[i]);
        }
    }

    public static void wr(double[][] a) {
        boolean c = true;
        for (int i = 0; i < a.length; ++i) {
            MolGeom.wr(a[i]);
        }
    }

    public static void wr(BitSet b) {
        for (int i = 0; i < b.length(); ++i) {
            if (!b.get(i)) continue;
            System.err.print(i + " ");
        }
        System.err.println("");
    }

    public static double[][] arrayCopy(double[][] a) {
        double[][] b = new double[a.length][];
        for (int i = 0; i < a.length; ++i) {
            b[i] = new double[a[i].length];
        }
        MolGeom.arrayCopy(a, b);
        return b;
    }

    public static double[][] arrayCopy(double[][] from, double[][] to) {
        for (int i = 0; i < from.length; ++i) {
            System.arraycopy(from[i], 0, to[i], 0, from[i].length);
        }
        return to;
    }

    public static int[][] arrayCopy(int[][] a) {
        int[][] b = new int[a.length][];
        for (int i = 0; i < a.length; ++i) {
            b[i] = MolGeom.arrayCopy(a[i]);
        }
        return b;
    }

    public static int[] arrayCopy(int[] a) {
        int[] b = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            b[i] = a[i];
        }
        return b;
    }

    public static short[] arrayCopy(short[] a) {
        short[] b = new short[a.length];
        for (int i = 0; i < a.length; ++i) {
            b[i] = a[i];
        }
        return b;
    }

    public static double[] arrayCopy(double[] a) {
        double[] b = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            b[i] = a[i];
        }
        return b;
    }

    public static float[] arrayCopy(float[] a) {
        float[] b = new float[a.length];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    public static void arrayCopy(double[] from, double[] to) {
        System.arraycopy(from, 0, to, 0, from.length);
    }

    public static double cos(double a) {
        return Math.max(-1.0, Math.min(1.0, Math.cos(a)));
    }

    public static double sin(double a) {
        return Math.max(-1.0, Math.min(1.0, Math.sin(a)));
    }

    public static double getAngle(int a1, int a2, int a3, double[][] crd) {
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        return MolGeom.getAngle(a1, a2, a3, crd, v1, v2);
    }

    public static double getAngle(int a1, int a2, int a3, double[][] crd, double[] v1, double[] v2) {
        MolGeom.minusVec(crd[a1], crd[a2], v1);
        MolGeom.minusVec(crd[a3], crd[a2], v2);
        MolGeom.mul(v1, 1.0 / MolGeom.getLength(v1));
        MolGeom.mul(v2, 1.0 / MolGeom.getLength(v2));
        return Math.acos(V.dot(v1, v2));
    }

    public static class LinearBondAngleException
    extends Exception {
        public LinearBondAngleException() {
        }

        public LinearBondAngleException(String message) {
            super(message);
        }
    }
}

