/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.struc;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.CleanSettings;
import chemaxon.marvin.modelling.debug.VerbosePrinter;
import chemaxon.marvin.modelling.debug.debugPrintout;
import chemaxon.marvin.modelling.struc.StereoCriteriaItem;
import chemaxon.marvin.modelling.struc.myMolecule;
import chemaxon.marvin.modelling.util.U;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;
import java.util.BitSet;
import java.util.Vector;

public class StereoCriteriaList {
    private Vector items = null;

    public StereoCriteriaList(int n) {
        this.items = new Vector(n);
    }

    public StereoCriteriaList(SelectionMolecule mol, CleanSettings settings, int[][] ctab, int[][] bat, int[][] bonds) {
        int i;
        VerbosePrinter vp = settings.getVerbosePrinter("Collect stereo", false);
        this.items = new Vector(Math.max(10, mol.getAtomCount()));
        int mdim = mol.getDim();
        if (vp != null) {
            vp.print("mol.getDim()=" + mdim);
        }
        if (ctab == null) {
            ctab = mol.getCtab();
        }
        if (bat == null) {
            bat = myMolecule.constuctBat(mol);
        }
        if (bonds == null) {
            bonds = myMolecule.constructBonds(mol.getAtomCount(), bat);
        }
        VerbosePrinter vps = null;
        if (vp != null) {
            vps = vp.incDetail("Collect C/T");
        }
        boolean ctinstrained = false;
        IntVector ctinstraineda = null;
        boolean ctextraligangs = false;
        IntVector ctextraligandsa = null;
        boolean transinsmallring = false;
        IntVector transinsmallringa = null;
        boolean ctnsligand = false;
        IntVector ctnsliganda = null;
        boolean ignored = false;
        for (i = 0; i < mol.getBondCount(); ++i) {
            boolean TRANS;
            MolBond cb = mol.getBond(i);
            if (cb.getType() != 2 && cb.getType() != 4) continue;
            int ii1 = mol.indexOf(cb.getAtom1());
            int ii2 = mol.indexOf(cb.getAtom2());
            if (ii1 < 0 || ii2 < 0) {
                throw new UnsupportedOperationException();
            }
            MolAtom A1 = cb.getCTAtom1();
            MolAtom A4 = cb.getCTAtom4();
            if (A1 == null || A4 == null) continue;
            int ctA1 = mol.indexOf(A1);
            int ctA4 = mol.indexOf(A4);
            int sflags = 0;
            sflags = mdim == 0 ? cb.getFlags() & 0xC0 : cb.calcStereo2();
            boolean CIS = sflags == 128;
            boolean bl = TRANS = sflags == 64;
            if (vps != null) {
                vps.print("Bond #" + i + " (" + ii1 + "-" + ii2 + ") ctA1=" + ctA1 + " ctA4=" + ctA4 + " CIS=" + CIS + " TRANS=" + TRANS);
            }
            if (!CIS && !TRANS) continue;
            if (myMolecule.isInSmallRing(ii1, ii2, bat, ctab, bonds)) {
                if (vps == null) continue;
                vps.print("->Bond in small ring, skip");
                continue;
            }
            if (myMolecule.isStrainedCT(ii1, ii2, bat, ctab, bonds)) {
                ctinstrained = true;
                if (ctinstraineda == null) {
                    ctinstraineda = new IntVector();
                }
                ctinstraineda.add(ii1);
                ctinstraineda.add(ii2);
                if (vps != null) {
                    vps.print("->Bond in strained");
                }
                ignored = true;
                if (vps == null) continue;
                vps.print("-->Skip");
                continue;
            }
            if (ctab[ii1].length > 3 || ctab[ii2].length > 3) {
                ctextraligangs = true;
                if (ctextraligandsa == null) {
                    ctextraligandsa = new IntVector();
                }
                ctextraligandsa.add(ii1);
                ctextraligandsa.add(ii2);
                if (vps == null) continue;
                vps.print("->Bond has extra ligands, skip");
                continue;
            }
            boolean nslskip = false;
            block1: for (int k = 0; k < 2; ++k) {
                int n1 = k == 0 ? ii1 : ii2;
                for (int j = 0; j < ctab[n1].length; ++j) {
                    int bj;
                    MolBond mbj;
                    int n2 = ctab[n1][j];
                    if (n2 == ii1 || n2 == ii2 || (mbj = mol.getBond(bj = bonds[n1][n2])).getType() == 1) continue;
                    ctnsligand = true;
                    if (ctnsliganda == null) {
                        ctnsliganda = new IntVector();
                    }
                    ctnsliganda.add(ii1);
                    ctnsliganda.add(ii2);
                    if (vps != null) {
                        vps.print("->Bond has non single ligand, skip ");
                    }
                    nslskip = true;
                    continue block1;
                }
            }
            if (nslskip) continue;
            boolean bondReportedAsTransInSmallRing = false;
            for (int j = 0; j < ctab[ii1].length; ++j) {
                int ii0 = ctab[ii1][j];
                for (int k = 0; k < ctab[ii2].length; ++k) {
                    int ii3 = ctab[ii2][k];
                    if (ii0 == ii2 || ii3 == ii1) continue;
                    boolean toCIS = false;
                    boolean toTRANS = false;
                    boolean inSmallRing = false;
                    inSmallRing = myMolecule.isInSmallRing(ii0, ii1, ii2, ii3, bat, ctab, bonds);
                    if (inSmallRing && vps != null) {
                        vps.print("Visited criteria is in small ring");
                    }
                    if (ii0 == ctA1 && ii3 == ctA4 || ii0 == ctA4 && ii3 == ctA1 || ii0 != ctA1 && ii3 != ctA4 && ii0 != ctA4 && ii3 != ctA1) {
                        toCIS = CIS;
                        toTRANS = TRANS;
                    } else {
                        toCIS = !CIS;
                        boolean bl2 = toTRANS = !TRANS;
                    }
                    if (toTRANS) {
                        if (inSmallRing && !bondReportedAsTransInSmallRing) {
                            transinsmallring = true;
                            if (transinsmallringa == null) {
                                transinsmallringa = new IntVector();
                            }
                            transinsmallringa.add(ii1);
                            transinsmallringa.add(ii2);
                            if (vps != null) {
                                vps.print("WARNING! TRANS stereo required in a ring smaller than 8 atoms.");
                            }
                            bondReportedAsTransInSmallRing = true;
                        }
                        if (inSmallRing) {
                            ignored = true;
                            this.removeCT(ii1, ii2);
                            if (vps == null) continue;
                            vps.print("Explicit specified CT will be ignored.");
                            continue;
                        }
                        this.addTRANS(ii0, ii1, ii2, ii3);
                        if (vps != null) {
                            vps.print("Add TRANS: " + ii0 + "-" + ii1 + " " + ii2 + "-" + ii3);
                        }
                    }
                    if (!toCIS) continue;
                    this.addCIS(ii0, ii1, ii2, ii3);
                    if (vps == null) continue;
                    vps.print("Add CIS: " + ii0 + "-" + ii1 + " " + ii2 + "-" + ii3);
                }
            }
        }
        if (ctextraligangs || ctinstrained || transinsmallring) {
            StringBuffer wmsg = new StringBuffer(200);
            wmsg.append("WARNING! ");
            if (ctextraligangs) {
                wmsg.append("CIS/TRANS bond(s) has extra ligands (");
                for (int i2 = 0; i2 < ctextraligandsa.size(); ++i2) {
                    if (i2 != 0) {
                        wmsg.append(',');
                    }
                    wmsg.append(ctextraligandsa.get(i2));
                    wmsg.append('-');
                    wmsg.append(ctextraligandsa.get(++i2));
                }
                wmsg.append(") ");
            }
            if (ctinstrained) {
                wmsg.append("CIS/TRANS requirement(s) on strained bond(s) specified. (");
                for (int i3 = 0; i3 < ctinstraineda.size(); ++i3) {
                    if (i3 != 0) {
                        wmsg.append(',');
                    }
                    wmsg.append(ctinstraineda.get(i3));
                    wmsg.append('-');
                    wmsg.append(ctinstraineda.get(++i3));
                }
                wmsg.append(") ");
            }
            if (transinsmallring) {
                wmsg.append("TRANS required in ring(s) smaller than 8 atoms. (");
                for (int i4 = 0; i4 < transinsmallringa.size(); ++i4) {
                    if (i4 != 0) {
                        wmsg.append(',');
                    }
                    wmsg.append(transinsmallringa.get(i4));
                    wmsg.append('-');
                    wmsg.append(transinsmallringa.get(++i4));
                }
                wmsg.append(") ");
            }
            if (ignored) {
                wmsg.append("These CT requirements will be ignored. ");
            }
            if (settings != null) {
                // empty if block
            }
            if (vp != null) {
                vp.print(wmsg.toString());
            } else {
                System.err.println(wmsg.toString());
            }
        }
        vps = null;
        if (vp != null) {
            vps = vp.incDetail("Collect parities");
        }
        for (i = 0; i < mol.getAtomCount(); ++i) {
            int parity = mol.getParity(i);
            if (vps != null && parity != 0) {
                vps.print("GetParity() on atom " + i + " returns " + parity);
            }
            if (parity != 2 && parity != 1) continue;
            if (vps != null) {
                vps.print("  ==> chiral atom");
            }
            boolean[] isH = new boolean[ctab[i].length];
            for (int j = 0; j < isH.length; ++j) {
                if (mol.getAtom(ctab[i][j]).getAtno() != 1 || mol.getAtom(ctab[i][j]).getMassno() != 0) continue;
                isH[j] = true;
            }
            if (parity == 2) {
                this.addEVEN(i, ctab[i], isH);
            }
            if (parity != 1) continue;
            this.addODD(i, ctab[i], isH);
        }
        if (vp != null) {
            vp.close();
        }
    }

    public int getSize() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    public boolean hasTrans() {
        if (this.getSize() == 0) {
            return false;
        }
        for (int i = 0; i < this.getSize(); ++i) {
            StereoCriteriaItem it = this.get(i);
            if (it.type != 2) continue;
            return true;
        }
        return false;
    }

    public StereoCriteriaItem get(int i) {
        return (StereoCriteriaItem)this.items.get(i);
    }

    public void printout(debugPrintout debug, myMolecule mol) {
        if (debug == null) {
            return;
        }
        debug.incLevel("Stereo criteria list");
        for (int i = 0; i < this.getSize(); ++i) {
            if (i != 0) {
                debug.printHR();
            }
            StereoCriteriaItem it = this.get(i);
            it.printout(debug);
            if (mol == null) continue;
            mol.placeApplet("Involved atoms", U.sel(U.removeByValue(it.atoms, -1)));
        }
        debug.decLevel();
    }

    public void removeCT(int a1, int a2) {
        for (int i = this.getSize() - 1; i >= 0; --i) {
            StereoCriteriaItem it = this.get(i);
            if (it.type != 2 && it.type != 1) continue;
            boolean remove = false;
            if (it.atoms[1] == a1 && it.atoms[2] == a2) {
                remove = true;
            } else if (it.atoms[1] == a2 && it.atoms[2] == a1) {
                remove = true;
            }
            if (!remove) continue;
            this.items.remove(i);
        }
    }

    public void removeTrans(int a0, int a1, int a2, int a3) {
        for (int i = this.getSize() - 1; i >= 0; --i) {
            StereoCriteriaItem it = this.get(i);
            if (it.type != 2) continue;
            boolean remove = false;
            if (it.atoms[0] == a0 && it.atoms[1] == a1 && it.atoms[2] == a2 && it.atoms[3] == a3) {
                remove = true;
            } else if (it.atoms[3] == a0 && it.atoms[2] == a1 && it.atoms[1] == a2 && it.atoms[0] == a3) {
                remove = true;
            }
            if (!remove) continue;
            this.items.remove(i);
        }
    }

    public StereoCriteriaItem addCIS(int a0, int a1, int a2, int a3) {
        StereoCriteriaItem ret = new StereoCriteriaItem(a0, a1, a2, a3, 1);
        this.items.add(ret);
        return ret;
    }

    public StereoCriteriaItem addTRANS(int a0, int a1, int a2, int a3) {
        StereoCriteriaItem ret = new StereoCriteriaItem(a0, a1, a2, a3, 2);
        this.items.add(ret);
        return ret;
    }

    public StereoCriteriaItem addEVEN(int a0, int[] nlis, boolean[] isH) {
        StereoCriteriaItem ret = new StereoCriteriaItem(a0, nlis, isH, 3);
        this.items.add(ret);
        return ret;
    }

    public StereoCriteriaItem addODD(int a0, int[] nlis, boolean[] isH) {
        StereoCriteriaItem ret = new StereoCriteriaItem(a0, nlis, isH, 4);
        this.items.add(ret);
        return ret;
    }

    public boolean checkStereo(double[][] c) {
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("Stereo check");
        }
        boolean ok = true;
        for (int i = 0; i < this.getSize(); ++i) {
            StereoCriteriaItem req = this.get(i);
            ok &= req.check(c, true, null);
            if (CleanArgs.doVerbose()) {
                CleanArgs.verbose("#" + i + " ok: " + ok, "Item: " + req.toString());
            }
            if (ok) continue;
        }
        if (CleanArgs.doVerbose()) {
            CleanArgs.verbose("All OK: " + ok);
        }
        return ok;
    }

    public boolean checkStereo(coordinateQuery getc, int mustinvolve, debugPrintout debug) {
        if (debug != null) {
            debug.printBC("Stereo check");
        }
        boolean ret = true;
        for (int i = 0; i < this.getSize(); ++i) {
            StereoCriteriaItem req = this.get(i);
            if (debug != null) {
                debug.printB("See criterion #" + i);
            }
            if ((mustinvolve < 0 || req.isInvolved(mustinvolve)) && req.canCheck(getc, debug)) {
                if (debug != null) {
                    debug.println(" Checking criterion #" + i);
                }
                boolean res = req.check(getc, debug);
                ret &= res;
                continue;
            }
            if (debug == null) continue;
            debug.println("not involved or cannot check.");
        }
        return ret;
    }

    public boolean checkStereo(coordinateQuery getc, debugPrintout debug) {
        return this.checkStereo(getc, -1, debug);
    }

    public boolean isInvolved(int ai) {
        for (int i = 0; i < this.getSize(); ++i) {
            StereoCriteriaItem it = this.get(i);
            if (!it.isInvolved(ai)) continue;
            return true;
        }
        return false;
    }

    public BitSet getParityCenters() {
        BitSet ret = null;
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.get(i).isTypeParity()) continue;
            int c = this.get(i).getCenterAtom();
            if (ret == null) {
                ret = new BitSet();
            }
            ret.set(c);
        }
        return ret;
    }

    public PhantomAtomList constructPhantomAtomList(int[] sel) {
        return new PhantomAtomList(this, sel);
    }

    public StereoCriteriaList cloneWithProjection(int[] pt, int[] newGrinv, int[][] newCtab, debugPrintout debug) {
        if (debug != null) {
            debug.printBC("Clone criteria list with projection");
            debug.println("Permutation table (orig)->(new)");
            debug.printVector(pt);
        }
        StereoCriteriaList ret = new StereoCriteriaList(this.getSize());
        for (int i = 0; i < this.getSize(); ++i) {
            StereoCriteriaItem it = this.get(i).cloneWithPermutation(pt, newGrinv, newCtab, debug);
            if (it == null) continue;
            ret.items.add(it);
        }
        return ret;
    }

    static class PhantomAtomDescriptor {
        double[] coord = null;
        int ba = -1;
        int type = -1;
        int[] il = null;

        public PhantomAtomDescriptor(double[] coord, int ba) {
            this.coord = coord;
            this.ba = ba;
        }

        public double[] getCoord() {
            return this.coord;
        }

        public int getBIndex() {
            return this.ba;
        }

        public void printout(debugPrintout debug) {
            debug.Tstart();
            debug.Trow();
            debug.TprintBC(2, "Phantom atom descriptor ");
            debug.Trow();
            debug.TprintBC("Coordinates:");
            debug.Tprint(debugPrintout.formatNumber(this.coord[0]) + " " + debugPrintout.formatNumber(this.coord[1]) + " " + debugPrintout.formatNumber(this.coord[2]));
            debug.Trow();
            debug.TprintBC("Bonded atom:");
            debug.Tprint("" + this.ba);
            debug.Trow();
            debug.TprintBC("Type:");
            debug.Tprint("" + this.type);
            debug.Trow();
            debug.TprintBC("Index list:");
            String ils = "";
            for (int i = 0; i < this.il.length; ++i) {
                ils = ils + this.il[i] + " ";
            }
            debug.Tprint(ils);
            debug.Tstop();
        }
    }

    public static interface coordinateQuery {
        public double[] get(int var1);

        public boolean isPlaced(int var1);
    }

    public static class PhantomAtomList {
        coordinateQuery cq = null;
        int[] selecteds = null;
        int[] selInv = null;
        double[][] coords = null;
        Vector pal = null;

        public PhantomAtomList(StereoCriteriaList slist, int[] sel) {
            debugPrintout debug = CleanArgs.getDebug();
            if (debug != null) {
                debug.printB("construct PhantomAtomList");
            }
            final double[][] c = new double[sel.length][3];
            this.selecteds = sel;
            this.coords = c;
            final int[] selInverse = U.genInverse(sel, U.max(sel) + 1);
            this.selInv = selInverse;
            this.cq = new coordinateQuery(){

                @Override
                public double[] get(int i) {
                    if (!this.isPlaced(i)) {
                        return null;
                    }
                    return c[selInverse[i]];
                }

                @Override
                public boolean isPlaced(int i) {
                    return i < selInverse.length && selInverse[i] >= 0;
                }
            };
            if (debug != null) {
                debug.printB("Create phantom atom list");
            }
            this.pal = new Vector();
            for (int i = 0; i < slist.getSize(); ++i) {
                slist.get(i).addPhantomAtomDescriptors(this.cq, this.pal, debug);
            }
        }

        private int size() {
            return this.pal.size();
        }

        private PhantomAtomDescriptor get(int i) {
            return (PhantomAtomDescriptor)this.pal.get(i);
        }

        public Molecule extendMol(Molecule baseFrag) {
            if (baseFrag.getAtomCount() != this.selecteds.length) {
                throw new UnsupportedOperationException();
            }
            Molecule ret = baseFrag.cloneMolecule();
            for (int i = 0; i < this.size(); ++i) {
                PhantomAtomDescriptor d = this.get(i);
                MolAtom pa = new MolAtom(1);
                ret.add(pa);
                MolAtom ba = ret.getAtom(this.selInv[d.getBIndex()]);
                MolBond nb = new MolBond(pa, ba, 1);
                ret.add(nb);
            }
            return ret;
        }

        public double[][] getExtendedCoordinates(double[][] fragCoords) {
            double[][] ret = new double[this.selecteds.length + this.size()][3];
            this.fillExtendedCoordinates(fragCoords, ret);
            return ret;
        }

        public void fillExtendedCoordinates(double[][] fragCoords, double[][] extendedCoords) {
            int i;
            debugPrintout debug = CleanArgs.getDebug();
            if (debug != null && debug.getWillPrint()) {
                debug.printB("FillExtendedCoordinates");
            }
            if (fragCoords.length != this.selecteds.length) {
                throw new UnsupportedOperationException();
            }
            if (extendedCoords.length != this.selecteds.length + this.size()) {
                throw new UnsupportedOperationException();
            }
            U.copyTo(fragCoords, this.coords);
            for (i = 0; i < this.size(); ++i) {
                PhantomAtomDescriptor d = this.get(i);
                StereoCriteriaItem.refreshPhantomAtom(this.cq, d, debug);
                U.copyTo(extendedCoords[this.selecteds.length + i], d.coord);
            }
            for (i = 0; i < fragCoords.length; ++i) {
                U.copyTo(extendedCoords[i], fragCoords[i]);
            }
        }

        public void printout(debugPrintout debug) {
            if (debug == null || !debug.getWillPrint()) {
                return;
            }
            debug.printBC("Phantom atom list");
            debug.println("selecteds: " + U.sel(this.selecteds));
            debug.println("selInv: " + U.sel(this.selInv));
            debug.println("size: " + this.size());
            for (int i = 0; i < this.size(); ++i) {
                this.get(i).printout(debug);
            }
        }
    }
}

