/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.modelling.struc;

import chemaxon.core.calculations.ElementalAnalysisCalc;
import chemaxon.core.util.BondTable;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.modelling.CleanArgs;
import chemaxon.marvin.modelling.linalg.JQuatFit;
import chemaxon.marvin.modelling.struc.ConformerEquivalenceUtils;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.io.FileOutputStream;
import java.util.BitSet;
import java.util.Vector;

public class Substructure3DSearch {
    public static final int DEFAULT_MIN_COMMON_SIZE = 3;
    private Molecule targetMol = null;
    private Molecule queryMol = null;
    private boolean queryMolChanged = true;
    private int minCommonSize = 3;
    private boolean ignoreAtomType = false;
    private boolean ignoreBondType = false;
    private boolean ignoreCharge = true;
    private boolean ignoreHybridization = true;
    private boolean ignoreIsotopes = true;
    private boolean ignoreQueryProperties = true;
    private boolean ignoreGeometryMatching = true;
    private boolean ignoreGeometryConstraints = true;
    private boolean ignoreExactMatching = true;
    private double geometryTolerance = 0.0;
    private double[][] queryCoordinates = null;
    private double[][] targetCoordinates = null;
    private int[] queryInvariant = null;
    private int[] targetInvariant = null;
    private JQuatFit jQF = null;
    private int fitSize = 0;
    private int[] frozenMatch = null;
    private boolean ignoreRadicals = true;
    private boolean[] allowedQueryAtoms = null;
    private boolean[] allowedTargetAtoms = null;
    private int[] highPriorityQueryAtoms = null;
    private int largestHighPriorityIndex = 0;
    private int lowestHighPriorityIndex = -1;
    BitSet highPriority = null;
    boolean lowPrioritySearch = false;
    int maxVariation = 10000000;
    private BondTable connectionMatrix = null;
    private int[] lastSSMap = null;
    private int[] startBFSFromAtom = null;
    private Vector allHits = new Vector();
    private int treeSize = 0;
    private int[] route = null;
    private boolean[] visited = null;
    private Queue visitQueue = new Queue();
    private boolean[] adequateAtoms = null;
    private int[] baseNumber = null;
    private int[] state = null;
    private boolean carry = false;
    private int pos = 0;
    private int[][] valueToTargetAtomIndex = null;
    private int[] parentQueryNode = null;
    private boolean[] targetAtomMapped = null;
    private boolean[] mappedAtPos = null;
    private int[] queryAtomIndexToPos = null;
    private int currentMapSize = 0;
    private ElementalAnalysisCalc elemAnal = new ElementalAnalysisCalc();
    private int[] ringCountOfAtoms = null;
    private boolean isRingCountOfAtomsSet = false;

    public void setMolecules(Molecule query, Molecule target) {
        this.queryMol = query;
        this.queryMolChanged = true;
        this.targetMol = target;
        this.allowedQueryAtoms = null;
        this.allowedTargetAtoms = null;
        this.queryCoordinates = null;
        this.targetCoordinates = null;
        this.frozenMatch = null;
        this.jQF = null;
        this.queryInvariant = null;
        this.targetInvariant = null;
    }

    public void setQuery(Molecule query) {
        this.queryMol = query;
        this.allowedQueryAtoms = null;
        this.queryMolChanged = true;
        this.queryCoordinates = null;
        this.frozenMatch = null;
        this.jQF = null;
        this.queryInvariant = null;
    }

    public void setTarget(Molecule target) {
        this.targetMol = target;
        this.allowedTargetAtoms = null;
        this.targetCoordinates = null;
        this.frozenMatch = null;
        this.targetInvariant = null;
    }

    public void setTargetCoordinates(double[][] coords) {
        this.allowedTargetAtoms = null;
        this.targetCoordinates = (double[][])coords.clone();
    }

    public void setQueryCoordinates(double[][] coords) {
        this.allowedQueryAtoms = null;
        this.queryMolChanged = true;
        this.queryCoordinates = (double[][])coords.clone();
        this.jQF = null;
    }

    public void setFrozenMatch(int[] frozen) {
        this.frozenMatch = frozen;
    }

    public void setIgnoreAtomType(boolean ignore) {
        this.ignoreAtomType = ignore;
    }

    public void setIgnoreHybridization(boolean ignore) {
        this.ignoreHybridization = ignore;
    }

    public void setIgnoreCharge(boolean ignore) {
        this.ignoreCharge = ignore;
    }

    public void setIgnoreIsotopes(boolean ignore) {
        this.ignoreIsotopes = ignore;
    }

    public void setIgnoreBondType(boolean ignore) {
        this.ignoreBondType = ignore;
    }

    public void setIgnoreQueryProperties(boolean ignore) {
        this.ignoreQueryProperties = ignore;
    }

    public void setIgnoreGeometryMatching(boolean ignore, double tolerance) {
        this.ignoreGeometryMatching = ignore;
        if (!ignore) {
            this.ignoreGeometryConstraints = true;
            this.geometryTolerance = tolerance;
            if (CleanArgs.verboseLevel > 1) {
                CleanArgs.verbose("Set geometry tolerance to " + this.geometryTolerance);
            }
        }
    }

    public void setIgnoreGeometryConstraints(boolean ignore) {
        this.ignoreGeometryConstraints = ignore;
        if (!ignore) {
            this.ignoreGeometryMatching = true;
            this.geometryTolerance = 0.001;
        }
    }

    public void setIgnoreExactMatching(boolean ignore) {
        this.ignoreExactMatching = ignore;
    }

    public void setIgnoreRadicals(boolean ignore) {
        this.ignoreRadicals = ignore;
    }

    public void setHighPriorityQueryAtoms(int[] queryAtoms) {
        this.highPriorityQueryAtoms = queryAtoms;
        this.queryMolChanged = true;
    }

    public void restrictMatching(int[] targetAtoms) {
        this.allowedTargetAtoms = new boolean[this.targetMol.getAtomCount()];
        for (int i = 0; i < targetAtoms.length; ++i) {
            this.allowedTargetAtoms[targetAtoms[i]] = true;
        }
    }

    public void excludeAtoms(int[] excludedQueryAtoms, int[] excludedTargetAtoms) {
        int i;
        if (this.allowedQueryAtoms == null) {
            this.allowedQueryAtoms = new boolean[this.queryMol.getAtomCount()];
            this.fill(this.allowedQueryAtoms, true);
        }
        if (this.allowedTargetAtoms == null) {
            this.allowedTargetAtoms = new boolean[this.targetMol.getAtomCount()];
            this.fill(this.allowedQueryAtoms, true);
        }
        for (i = 0; i < excludedQueryAtoms.length; ++i) {
            this.allowedQueryAtoms[excludedQueryAtoms[i]] = false;
        }
        for (i = 0; i < excludedTargetAtoms.length; ++i) {
            this.allowedTargetAtoms[excludedTargetAtoms[i]] = false;
        }
    }

    public void excludeQueryAtom(int excludedQueryAtom) {
        if (this.allowedQueryAtoms == null) {
            this.allowedQueryAtoms = new boolean[this.queryMol.getAtomCount()];
            this.fill(this.allowedQueryAtoms, true);
        }
        this.allowedQueryAtoms[excludedQueryAtom] = false;
    }

    public void excludeTargetAtom(int excludedTargetAtom) {
        if (this.allowedTargetAtoms == null) {
            this.allowedTargetAtoms = new boolean[this.targetMol.getAtomCount()];
            this.fill(this.allowedTargetAtoms, true);
        }
        this.allowedTargetAtoms[excludedTargetAtom] = false;
    }

    public boolean search() {
        if (!this.findFirst()) {
            return false;
        }
        while (this.findNext()) {
        }
        return true;
    }

    public boolean findFirst() {
        int i;
        if (this.queryMol.getAtomCount() > this.targetMol.getAtomCount()) {
            return false;
        }
        this.init();
        if (this.highPriorityQueryAtoms != null) {
            this.highPriority = new BitSet();
            for (i = 0; i < this.highPriorityQueryAtoms.length; ++i) {
                this.highPriority.set(this.highPriorityQueryAtoms[i]);
            }
        }
        this.createSpannigTree(this.startBFSFromAtom[0]);
        this.setupConstrainedBacktrack();
        if (this.highPriorityQueryAtoms != null) {
            for (i = 0; i < this.route.length; ++i) {
                if (!this.highPriority.get(this.route[i])) continue;
                if (this.lowestHighPriorityIndex == -1) {
                    this.lowestHighPriorityIndex = i;
                }
                this.largestHighPriorityIndex = i;
            }
            if (this.tooManyHighPriorityVariations()) {
                return false;
            }
        }
        this.carry = false;
        this.pos = 0;
        while (!this.carry) {
            if (this.find()) {
                return true;
            }
            this.next();
        }
        return false;
    }

    public boolean findNext() {
        if (this.carry) {
            return false;
        }
        this.lastSSMap = null;
        this.next();
        while (!this.carry) {
            if (this.find()) {
                return true;
            }
            this.next();
        }
        return false;
    }

    public int[] getResult() {
        return this.lastSSMap;
    }

    public int getResultCount() {
        return this.allHits.size();
    }

    public int[] getResult(int resultIndex) {
        return (int[])this.allHits.get(resultIndex);
    }

    private boolean find() {
        while (this.pos != this.treeSize) {
            if (!this.good()) {
                return false;
            }
            ++this.pos;
        }
        --this.pos;
        if (!this.isNewHighPrioritySolution()) {
            return false;
        }
        if (!this.addCommonSubstructure()) {
            return false;
        }
        this.setHighPriorityIndex();
        return true;
    }

    private boolean good() {
        int targetAtom = this.valueToTargetAtomIndex[this.pos][this.state[this.pos]];
        if (this.pos == 0) {
            if (this.state[this.pos] == this.baseNumber[this.pos] - 1) {
                return false;
            }
            if (!this.matchAtoms(this.route[this.pos], targetAtom)) {
                return false;
            }
            this.targetAtomMapped[targetAtom] = true;
            this.mappedAtPos[this.pos] = true;
            ++this.currentMapSize;
            return true;
        }
        if (this.state[this.pos] == this.baseNumber[this.pos] - 1) {
            return false;
        }
        if (this.targetAtomMapped[targetAtom]) {
            return false;
        }
        if (this.parentQueryNode[this.pos] != -2) {
            int predecessorPos;
            int n = predecessorPos = this.parentQueryNode[this.pos] == -1 ? this.pos - 1 : this.parentQueryNode[this.pos];
            if (this.state[predecessorPos] == this.baseNumber[predecessorPos] - 1 && this.state[this.pos] != this.baseNumber[this.pos] - 1) {
                return false;
            }
            if (!this.match(predecessorPos)) {
                return false;
            }
        }
        if (!this.matchGeometry() || !this.bondsOK(this.pos)) {
            return false;
        }
        this.targetAtomMapped[targetAtom] = true;
        this.mappedAtPos[this.pos] = true;
        ++this.currentMapSize;
        return true;
    }

    private boolean match(int predecessorPos) {
        int queryBondIndex;
        int targetAtomMappedToPredecessor = this.state[predecessorPos] == this.baseNumber[predecessorPos] - 1 ? -1 : this.valueToTargetAtomIndex[predecessorPos][this.state[predecessorPos]];
        int atomAtPos = this.route[this.pos];
        int targetAtomMappedToAtomAtPos = this.state[this.pos] == this.baseNumber[this.pos] - 1 ? -1 : this.valueToTargetAtomIndex[this.pos][this.state[this.pos]];
        int targetBondIndex = -1;
        if (targetAtomMappedToAtomAtPos != -1 && targetAtomMappedToPredecessor != -1 && (targetBondIndex = this.targetMol.getBondTable().getBondIndex(targetAtomMappedToAtomAtPos, targetAtomMappedToPredecessor)) == -1) {
            return false;
        }
        if (targetAtomMappedToAtomAtPos != -1 && !this.matchAtoms(atomAtPos, targetAtomMappedToAtomAtPos)) {
            return false;
        }
        int predecessorAtom = this.route[predecessorPos];
        return targetBondIndex == -1 || this.ignoreBondType || this.matchBonds(queryBondIndex = this.connectionMatrix.getBondIndex(atomAtPos, predecessorAtom), targetBondIndex);
    }

    private boolean matchAtoms(int queryAtomIndex, int targetAtomIndex) {
        MolAtom qa = this.queryMol.getAtom(queryAtomIndex);
        MolAtom ta = this.targetMol.getAtom(targetAtomIndex);
        if (!this.ignoreAtomType) {
            if (qa.getAtno() == 128 ? !this.atomInList(ta.getAtno(), qa.getList()) : (qa.getAtno() == 129 ? this.atomInList(ta.getAtno(), qa.getList()) : (qa.getAtno() == 132 ? ta.getAtno() == 1 || ta.getAtno() == 6 : qa.getAtno() != 131 && qa.getAtno() != ta.getAtno()))) {
                return false;
            }
            if (!this.ignoreExactMatching && this.queryMol.getChirality(queryAtomIndex) != this.targetMol.getChirality(targetAtomIndex)) {
                return false;
            }
        }
        if (!this.ignoreRadicals && qa.getRadical() != ta.getRadical()) {
            return false;
        }
        if (!this.ignoreHybridization && qa.getHybridizationState() != ta.getHybridizationState()) {
            return false;
        }
        if (!this.ignoreCharge && qa.getCharge() != ta.getCharge()) {
            return false;
        }
        if (!this.ignoreIsotopes && qa.getMassno() != ta.getMassno()) {
            return false;
        }
        if (!this.ignoreQueryProperties) {
            return this.matchQueryProperties(queryAtomIndex, targetAtomIndex);
        }
        return true;
    }

    private boolean matchBonds(int queryBondIndex, int targetBondIndex) {
        return (this.targetMol.getBond(targetBondIndex).getFlags() & 0xF) == (this.queryMol.getBond(queryBondIndex).getFlags() & 0xF);
    }

    private boolean matchQueryProperties(int queryAtomIndex, int targetAtomIndex) {
        MolAtom qa = this.queryMol.getAtom(queryAtomIndex);
        MolAtom ta = this.targetMol.getAtom(targetAtomIndex);
        int cc = qa.getQPropAsInt("X");
        if (cc != -1 && ta.getBondCount() + ta.getImplicitHcount() != cc) {
            return false;
        }
        int hc = qa.getQPropAsInt("H");
        if (hc != -1 && ta.getExplicitHcount() + ta.getImplicitHcount() != hc) {
            return false;
        }
        int rc = qa.getQPropAsInt("R");
        if (rc != -1) {
            if (!this.isRingCountOfAtomsSet) {
                int[][] rings = this.targetMol.getSSSR();
                for (int i = 0; i < rings.length; ++i) {
                    int[] r = rings[i];
                    for (int j = 0; j < r.length; ++j) {
                        int n = r[j];
                        this.ringCountOfAtoms[n] = this.ringCountOfAtoms[n] + 1;
                    }
                }
                this.isRingCountOfAtomsSet = true;
            }
            return rc == 256 && this.ringCountOfAtoms[targetAtomIndex] != 0 || rc != 256 && this.ringCountOfAtoms[targetAtomIndex] == rc;
        }
        return true;
    }

    private boolean matchGeometry() {
        double diff;
        int i;
        if (this.ignoreGeometryMatching && this.ignoreGeometryConstraints) {
            return true;
        }
        if (this.queryMol.getDim() != 3 && this.queryCoordinates == null) {
            return false;
        }
        if (this.ignoreGeometryConstraints && this.targetMol.getDim() != 3 && this.targetCoordinates == null) {
            return false;
        }
        if (this.pos < 2) {
            return true;
        }
        if (this.queryCoordinates == null) {
            this.queryCoordinates = Substructure3DSearch.getMolCoordinates(this.queryMol);
            this.jQF = null;
        }
        if (this.targetCoordinates == null) {
            this.targetCoordinates = !this.ignoreGeometryConstraints ? new double[this.targetMol.getAtomCount()][3] : Substructure3DSearch.getMolCoordinates(this.targetMol);
        }
        if (this.currentMapSize == 1) {
            int qAt0 = this.route[this.pos];
            int tAt0 = this.valueToTargetAtomIndex[this.pos][this.state[this.pos]];
            for (int i2 = 0; i2 < this.pos; ++i2) {
                if (!this.mappedAtPos[i2]) continue;
                int qAt1 = this.route[i2];
                int tAt1 = this.valueToTargetAtomIndex[i2][this.state[i2]];
                double dq = 0.0;
                double dt = 0.0;
                double dd = this.queryCoordinates[qAt0][0] - this.queryCoordinates[qAt1][0];
                dq += dd * dd;
                dd = this.queryCoordinates[qAt0][1] - this.queryCoordinates[qAt1][1];
                dq += dd * dd;
                dd = this.queryCoordinates[qAt0][2] - this.queryCoordinates[qAt1][2];
                dq += dd * dd;
                dq = Math.sqrt(dq);
                dd = this.targetCoordinates[tAt0][0] - this.targetCoordinates[tAt1][0];
                dt += dd * dd;
                dd = this.targetCoordinates[tAt0][1] - this.targetCoordinates[tAt1][1];
                dt += dd * dd;
                dd = this.targetCoordinates[tAt0][2] - this.targetCoordinates[tAt1][2];
                dt += dd * dd;
                return !(Math.abs((dt = Math.sqrt(dt)) - dq) > this.geometryTolerance);
            }
        }
        if (this.jQF == null) {
            this.jQF = new JQuatFit(this.queryCoordinates);
        } else if (this.pos > 3 && this.pos < this.treeSize - 2 && this.fitSize <= this.pos) {
            int qAt = this.route[this.pos];
            int tAt = this.valueToTargetAtomIndex[this.pos][this.state[this.pos]];
            double diff2 = 0.0;
            double dd = 0.0;
            dd = this.queryCoordinates[qAt][0] - this.targetCoordinates[tAt][0];
            diff2 += dd * dd;
            dd = this.queryCoordinates[qAt][1] - this.targetCoordinates[tAt][1];
            diff2 += dd * dd;
            dd = this.queryCoordinates[qAt][2] - this.targetCoordinates[tAt][2];
            diff2 += dd * dd;
            if ((diff2 = Math.sqrt(diff2)) < this.geometryTolerance) {
                return true;
            }
        }
        this.fitSize = this.pos + 1;
        int[][] pairs = new int[2][this.fitSize];
        for (i = 0; i <= this.pos; ++i) {
            pairs[0][i] = this.route[i];
            pairs[1][i] = this.valueToTargetAtomIndex[i][this.state[i]];
        }
        if (!this.ignoreGeometryConstraints) {
            for (i = 0; i < pairs[0].length; ++i) {
                this.targetCoordinates[pairs[1][i]] = this.queryCoordinates[pairs[0][i]];
            }
        }
        if ((diff = this.jQF.quatfit(this.targetCoordinates, pairs)) >= this.geometryTolerance) {
            if (CleanArgs.verboseLevel > 2) {
                CleanArgs.verbose("Geom fit failed for pos " + this.pos + " diff is " + diff + " with tolerance of " + this.geometryTolerance);
            }
            return false;
        }
        if (CleanArgs.verboseLevel > 2) {
            CleanArgs.verbose("Geom fit is OK for pos " + this.pos + " diff is " + diff + " with tolerance of " + this.geometryTolerance);
        }
        return true;
    }

    public static double[][] getMolCoordinates(Molecule m) {
        DPoint3[] c = m.getPoints();
        double[][] coord = new double[c.length][3];
        for (int i = 0; i < coord.length; ++i) {
            coord[i][0] = c[i].x;
            coord[i][1] = c[i].y;
            coord[i][2] = c[i].z;
        }
        return coord;
    }

    private void next() {
        while (true) {
            if (this.mappedAtPos[this.pos]) {
                int targetAtom = this.valueToTargetAtomIndex[this.pos][this.state[this.pos]];
                this.targetAtomMapped[targetAtom] = false;
                this.mappedAtPos[this.pos] = false;
                --this.currentMapSize;
            }
            if (this.state[this.pos] < this.baseNumber[this.pos] - 1) {
                int n = this.pos;
                this.state[n] = this.state[n] + 1;
                this.carry = false;
                return;
            }
            if (this.pos == 0) {
                this.carry = true;
                return;
            }
            this.state[this.pos--] = 0;
        }
    }

    private void createSpannigTree(int startingNode) {
        this.treeSize = 0;
        for (int i = 0; i < this.visited.length; ++i) {
            this.visited[i] = false;
        }
        if (!this.isAllowedQueryAtom(startingNode)) {
            return;
        }
        this.visitQueue.addLast(-1);
        this.visitQueue.addLast(startingNode);
        if (this.highPriorityQueryAtoms != null) {
            this.visitHighPriority();
        } else {
            this.visit();
        }
    }

    private void visit() {
        while (!this.visitQueue.isEmpty()) {
            int parent = this.visitQueue.removeFirst();
            int nodeIndex = this.visitQueue.removeFirst();
            if (this.visited[nodeIndex]) continue;
            this.visited[nodeIndex] = true;
            this.route[this.treeSize++] = nodeIndex;
            int[] neighbours = this.queryMol.getCtab()[nodeIndex];
            for (int ni = 0; ni < neighbours.length; ++ni) {
                if (neighbours[ni] == parent || !this.isAllowedQueryAtom(neighbours[ni])) continue;
                this.visitQueue.addLast(nodeIndex);
                this.visitQueue.addLast(neighbours[ni]);
            }
        }
    }

    private void visitHighPriority() {
        int i;
        int ni;
        int[] neighbours;
        int nodeIndex;
        int parent;
        while (!this.visitQueue.isEmpty()) {
            parent = this.visitQueue.removeFirst();
            nodeIndex = this.visitQueue.removeFirst();
            if (this.visited[nodeIndex]) continue;
            this.visited[nodeIndex] = true;
            if (this.highPriority.get(nodeIndex)) {
                this.route[this.treeSize++] = nodeIndex;
            }
            neighbours = this.queryMol.getCtab()[nodeIndex];
            for (ni = 0; ni < neighbours.length; ++ni) {
                if (neighbours[ni] == parent || !this.isAllowedQueryAtom(neighbours[ni])) continue;
                this.visitQueue.addLast(nodeIndex);
                this.visitQueue.addLast(neighbours[ni]);
            }
        }
        for (i = 0; i < this.visited.length; ++i) {
            this.visited[i] = false;
        }
        for (i = 0; i < this.treeSize; ++i) {
            nodeIndex = this.route[i];
            this.visited[nodeIndex] = true;
        }
        for (i = 0; i < this.treeSize; ++i) {
            nodeIndex = this.route[i];
            neighbours = this.queryMol.getCtab()[nodeIndex];
            for (ni = 0; ni < neighbours.length; ++ni) {
                if (this.visited[neighbours[ni]]) continue;
                this.visitQueue.addLast(nodeIndex);
                this.visitQueue.addLast(neighbours[ni]);
                this.visited[neighbours[ni]] = true;
            }
        }
        for (i = 0; i < this.visited.length; ++i) {
            this.visited[i] = false;
        }
        for (i = 0; i < this.treeSize; ++i) {
            nodeIndex = this.route[i];
            this.visited[nodeIndex] = true;
        }
        while (!this.visitQueue.isEmpty()) {
            parent = this.visitQueue.removeFirst();
            nodeIndex = this.visitQueue.removeFirst();
            if (this.visited[nodeIndex]) continue;
            this.visited[nodeIndex] = true;
            this.route[this.treeSize++] = nodeIndex;
            neighbours = this.queryMol.getCtab()[nodeIndex];
            for (ni = 0; ni < neighbours.length; ++ni) {
                if (this.visited[neighbours[ni]] || !this.isAllowedQueryAtom(neighbours[ni])) continue;
                this.visitQueue.addLast(nodeIndex);
                this.visitQueue.addLast(neighbours[ni]);
            }
        }
    }

    private boolean isAllowedQueryAtom(int atom) {
        return this.allowedQueryAtoms == null || this.allowedQueryAtoms[atom];
    }

    private boolean isAllowedTargetAtom(int atom) {
        return this.allowedTargetAtoms == null || this.allowedTargetAtoms[atom];
    }

    private void setupConstrainedBacktrack() {
        int j;
        int i;
        int ts = this.targetMol.getAtomCount();
        for (i = 0; i < this.treeSize; ++i) {
            this.queryAtomIndexToPos[this.route[i]] = i;
            this.baseNumber[i] = 0;
            for (j = 0; j < ts; ++j) {
                if (!this.isAllowedTargetAtom(j) || !this.adequateAtoms[this.route[i] * ts + j]) continue;
                int n = i;
                int n2 = this.baseNumber[n];
                this.baseNumber[n] = n2 + 1;
                this.valueToTargetAtomIndex[i][n2] = j;
            }
            int n = i;
            int n3 = this.baseNumber[n];
            this.baseNumber[n] = n3 + 1;
            this.valueToTargetAtomIndex[i][n3] = -1;
        }
        this.parentQueryNode[0] = -1;
        for (i = 1; i < this.treeSize; ++i) {
            this.parentQueryNode[i] = -2;
        }
        for (i = 1; i < this.treeSize; ++i) {
            if (this.connectionMatrix.getBondIndex(this.route[i], this.route[i - 1]) == -1) {
                for (j = i - 2; j >= 0 && this.connectionMatrix.getBondIndex(this.route[i], this.route[j]) == -1; --j) {
                }
                if (j < 0) {
                    if (this.highPriorityQueryAtoms != null) continue;
                    throw new RuntimeException("Unrecoverable error: corrupt query graph.");
                }
                this.parentQueryNode[i] = j;
                continue;
            }
            this.parentQueryNode[i] = -1;
        }
        for (i = 0; i < this.state.length; ++i) {
            this.state[i] = 0;
            this.mappedAtPos[i] = false;
        }
        for (i = 0; i < this.targetAtomMapped.length; ++i) {
            this.targetAtomMapped[i] = false;
        }
        this.currentMapSize = 0;
    }

    private boolean adequateAtoms(MolAtom queryAtom, MolAtom targetAtom) {
        int queryAtomType = queryAtom.getAtno();
        if (!(this.ignoreAtomType || queryAtomType == 131 || queryAtomType == 132 && targetAtom.getAtno() != 1 && targetAtom.getAtno() != 6 || queryAtomType == 128 && this.atomInList(targetAtom.getAtno(), queryAtom.getList()) || queryAtomType == 129 && !this.atomInList(targetAtom.getAtno(), queryAtom.getList()) || targetAtom.getAtno() == queryAtomType)) {
            return false;
        }
        if (!this.ignoreHybridization && queryAtom.getHybridizationState() != targetAtom.getHybridizationState()) {
            return false;
        }
        if (!this.ignoreCharge && queryAtom.getCharge() != targetAtom.getCharge()) {
            return false;
        }
        return queryAtom.getBondCount() <= targetAtom.getBondCount();
    }

    private boolean addCommonSubstructure() {
        int i;
        if (this.currentMapSize < this.minCommonSize) {
            return false;
        }
        int[] map = new int[this.queryMol.getAtomCount()];
        for (i = 0; i < map.length; ++i) {
            map[i] = -1;
        }
        for (i = 0; i < this.treeSize; ++i) {
            map[this.route[i]] = this.valueToTargetAtomIndex[i][this.state[i]];
        }
        if (this.isNewSolution(map) && this.bondsOK(map)) {
            this.lastSSMap = map;
            this.allHits.addElement(map);
            return true;
        }
        return false;
    }

    private boolean bondsOK(int[] map) {
        int[][] qCTab = this.queryMol.getCtab();
        BondTable tBTab = this.targetMol.getBondTable();
        for (int i = 0; i < map.length; ++i) {
            if (map[i] <= -1) continue;
            int iQAt = i;
            int iTAt = map[i];
            for (int j = 0; j < qCTab[i].length; ++j) {
                int jQAt = qCTab[i][j];
                int jTAt = map[jQAt];
                if (jQAt >= iQAt || jTAt <= -1 || tBTab.getBondIndex(iTAt, jTAt) != -1) continue;
                if (CleanArgs.verboseLevel > 2) {
                    CleanArgs.verbose("bondsOK found a match error in Substructure3DSEarch.");
                }
                return false;
            }
        }
        if (CleanArgs.verboseLevel > 2) {
            CleanArgs.verbose("bondsOK checked a good match in Substructure3DSEarch");
        }
        return true;
    }

    private boolean bondsOK() {
        int i;
        int[] map = new int[this.queryMol.getAtomCount()];
        for (i = 0; i < map.length; ++i) {
            map[i] = -1;
        }
        for (i = 0; i < Math.min(this.currentMapSize + 1, map.length); ++i) {
            map[this.route[i]] = this.valueToTargetAtomIndex[i][this.state[i]];
        }
        return this.bondsOK(map);
    }

    private boolean bondsOK(int pos) {
        int[][] qCTab = this.queryMol.getCtab();
        BondTable tBTab = this.targetMol.getBondTable();
        int iQAt = this.route[pos];
        int iTAt = this.valueToTargetAtomIndex[pos][this.state[pos]];
        for (int j = 0; j < qCTab[iQAt].length; ++j) {
            int jTAt;
            int jQAt = qCTab[iQAt][j];
            int jPos = this.queryAtomIndexToPos[jQAt];
            if (jPos >= pos || tBTab.getBondIndex(iTAt, jTAt = this.valueToTargetAtomIndex[jPos][this.state[jPos]]) != -1) continue;
            if (CleanArgs.verboseLevel > 2) {
                CleanArgs.verbose("bondsOK found a match error in Substructure3DSEarch.");
            }
            return false;
        }
        if (CleanArgs.verboseLevel > 2) {
            CleanArgs.verbose("bondsOK checked a good match in Substructure3DSEarch");
        }
        return true;
    }

    private boolean isNewSolution(int[] map) {
        for (int i = 0; i < this.allHits.size(); ++i) {
            int[] m = (int[])this.allHits.elementAt(i);
            boolean same = true;
            for (int j = 0; same && j < m.length; ++j) {
                same = m[j] == map[j];
            }
            if (!same) continue;
            return false;
        }
        return true;
    }

    private boolean isNewHighPrioritySolution() {
        int i;
        if (this.highPriorityQueryAtoms == null) {
            return true;
        }
        int[] map = new int[this.queryMol.getAtomCount()];
        for (int i2 = 0; i2 < map.length; ++i2) {
            map[i2] = -1;
        }
        int nMatch = this.treeSize;
        if (this.pos < nMatch) {
            nMatch = this.pos + 1;
        }
        for (i = 0; i < nMatch; ++i) {
            map[this.route[i]] = this.valueToTargetAtomIndex[i][this.state[i]];
        }
        for (i = 0; i < this.allHits.size(); ++i) {
            int[] m = (int[])this.allHits.elementAt(i);
            boolean same = true;
            for (int j = 0; same && j < this.highPriorityQueryAtoms.length; ++j) {
                same = m[this.highPriorityQueryAtoms[j]] == -1 || m[this.highPriorityQueryAtoms[j]] == map[this.highPriorityQueryAtoms[j]];
            }
            if (!same) continue;
            this.setHighPriorityIndex();
            return false;
        }
        return true;
    }

    private void setHighPriorityIndex() {
        if (this.highPriorityQueryAtoms != null && this.pos > this.largestHighPriorityIndex) {
            for (int i = this.largestHighPriorityIndex + 1; i < this.treeSize; ++i) {
                if (this.mappedAtPos[i]) {
                    int targetAtom = this.valueToTargetAtomIndex[i][this.state[i]];
                    this.targetAtomMapped[targetAtom] = false;
                    this.mappedAtPos[i] = false;
                    --this.currentMapSize;
                }
                this.state[i] = this.baseNumber[i] - 1;
            }
        }
    }

    private boolean atomInList(int atno, int[] atnoList) {
        for (int i = 0; i < atnoList.length; ++i) {
            if (atnoList[i] != atno) continue;
            return true;
        }
        return false;
    }

    private void init() {
        this.alloc();
        this.lastSSMap = null;
        this.allHits.removeAllElements();
        this.connectionMatrix = this.queryMol.getBondTable();
        this.minCommonSize = this.queryMol.getAtomCount();
        this.clear(this.ringCountOfAtoms);
        this.isRingCountOfAtomsSet = false;
        if (this.queryMolChanged) {
            this.findStartingNode();
        }
        this.initAdequateAtoms();
        this.queryMolChanged = false;
        if (!this.ignoreGeometryConstraints && this.targetCoordinates != null && this.targetCoordinates.length != this.targetMol.getAtomCount()) {
            this.targetCoordinates = null;
        }
    }

    private void findStartingNode() {
        int i;
        boolean highPriorityMode;
        boolean bl = highPriorityMode = this.highPriorityQueryAtoms != null;
        if (!this.ignoreExactMatching && this.queryInvariant == null) {
            this.queryInvariant = new int[this.queryMol.getAtomCount()];
            this.queryMol.getGrinv(this.queryInvariant, 0);
        }
        this.elemAnal.setMolecule(this.queryMol);
        int qgSize = this.queryMol.getAtomCount();
        for (int i2 = 0; i2 < qgSize; ++i2) {
            this.startBFSFromAtom[i2] = this.isAllowedQueryAtom(i2) ? i2 : -1;
        }
        int[] highPriorityFactor = null;
        if (highPriorityMode) {
            int qi;
            highPriorityFactor = new int[qgSize];
            for (i = 0; i < qgSize; ++i) {
                qi = 0;
                if (!this.ignoreExactMatching) {
                    qi = qgSize - this.queryInvariant[i];
                }
                highPriorityFactor[i] = 1000 + qi;
            }
            for (i = 0; i < this.highPriorityQueryAtoms.length; ++i) {
                qi = 0;
                if (!this.ignoreExactMatching) {
                    qi = qgSize - this.queryInvariant[this.highPriorityQueryAtoms[i]];
                }
                highPriorityFactor[this.highPriorityQueryAtoms[i]] = 1 + qi;
            }
        }
        for (i = 0; i < qgSize - 1; ++i) {
            int ai = this.startBFSFromAtom[i];
            if (ai == -1) continue;
            int atnoi = this.queryMol.getAtom(ai).getAtno();
            double scorei = this.atomScore(ai, atnoi);
            if (highPriorityMode) {
                scorei *= (double)highPriorityFactor[i];
            }
            for (int j = i + 1; j < qgSize; ++j) {
                int aj = this.startBFSFromAtom[j];
                if (aj == -1) continue;
                int atnoj = this.queryMol.getAtom(aj).getAtno();
                double scorej = this.atomScore(aj, atnoj);
                if (highPriorityMode) {
                    scorej *= (double)highPriorityFactor[j];
                }
                if (!(scorej < scorei)) continue;
                int w = this.startBFSFromAtom[i];
                this.startBFSFromAtom[i] = this.startBFSFromAtom[j];
                this.startBFSFromAtom[j] = w;
                if (highPriorityMode) {
                    w = highPriorityFactor[i];
                    highPriorityFactor[i] = highPriorityFactor[j];
                    highPriorityFactor[j] = w;
                }
                ai = this.startBFSFromAtom[i];
                scorei = scorej;
            }
        }
    }

    private int atomScore(int atomIndex, int atno) {
        return (atno == 6 || atno == 128 || atno == 131 || atno == 132 ? 6 : 2 * this.elemAnal.atomCount(atno)) + this.queryMol.getAtom(atomIndex).getBondCount();
    }

    private void initAdequateAtoms() {
        if (!this.ignoreExactMatching) {
            if (this.queryInvariant == null) {
                this.queryInvariant = new int[this.queryMol.getAtomCount()];
                this.queryMol.getGrinv(this.queryInvariant, 0);
            }
            if (this.targetInvariant == null) {
                this.targetInvariant = new int[this.targetMol.getAtomCount()];
                this.targetMol.getGrinv(this.targetInvariant, 0);
            }
        }
        for (int i = 0; i < this.queryMol.getAtomCount(); ++i) {
            MolAtom targetAtom;
            int j;
            MolAtom queryAtom = this.queryMol.getAtom(i);
            if (this.frozenMatch != null && this.frozenMatch[i] >= 0) {
                for (j = 0; j < this.targetMol.getAtomCount(); ++j) {
                    this.adequateAtoms[i * this.targetMol.getAtomCount() + j] = false;
                }
                this.adequateAtoms[i * this.targetMol.getAtomCount() + this.frozenMatch[i]] = true;
                continue;
            }
            if (!this.ignoreExactMatching) {
                for (j = 0; j < this.targetMol.getAtomCount(); ++j) {
                    if (this.queryInvariant[i] == this.targetInvariant[j]) {
                        targetAtom = this.targetMol.getAtom(j);
                        this.adequateAtoms[i * this.targetMol.getAtomCount() + j] = this.adequateAtoms(queryAtom, targetAtom);
                        continue;
                    }
                    this.adequateAtoms[i * this.targetMol.getAtomCount() + j] = false;
                }
                continue;
            }
            for (j = 0; j < this.targetMol.getAtomCount(); ++j) {
                targetAtom = this.targetMol.getAtom(j);
                this.adequateAtoms[i * this.targetMol.getAtomCount() + j] = this.adequateAtoms(queryAtom, targetAtom);
            }
        }
    }

    boolean tooManyHighPriorityVariations() {
        if (this.highPriority != null) {
            int[][] cTab = this.queryMol.getCtab();
            boolean tooMuch = false;
            long nVariations = 1L;
            int count = 0;
            int mNeigh = 0;
            for (int i = 0; i < this.route.length; ++i) {
                if (!this.highPriority.get(this.route[i])) continue;
                if (mNeigh < cTab[this.route[i]].length) {
                    mNeigh = cTab[this.route[i]].length;
                }
                ++count;
                int nVar = this.baseNumber[i] - 1;
                if ((nVariations *= (long)nVar) <= (long)this.maxVariation) continue;
                tooMuch = true;
            }
            if (CleanArgs.verboseLevel > 0) {
                CleanArgs.verbose("Number of high priority variations in Substructure3DSearch: " + nVariations + " (" + this.maxVariation + ")");
            }
            if (mNeigh > 5 && tooMuch) {
                if (CleanArgs.verboseLevel > 0) {
                    CleanArgs.verbose("Too many possibilities in Substructure3DSearch: " + nVariations + " > " + this.maxVariation);
                }
                return true;
            }
        }
        return false;
    }

    private void fill(boolean[] a, boolean v) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = v;
        }
    }

    private void clear(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = 0;
        }
    }

    private void alloc() {
        int qgSize = this.queryMol.getAtomCount();
        int tgSize = this.targetMol.getAtomCount();
        if (this.route == null || qgSize > this.route.length) {
            this.startBFSFromAtom = new int[qgSize];
            this.route = new int[qgSize];
            this.visited = new boolean[qgSize];
            this.baseNumber = new int[qgSize];
            this.state = new int[qgSize];
            this.parentQueryNode = new int[qgSize];
            this.mappedAtPos = new boolean[qgSize];
            this.valueToTargetAtomIndex = new int[qgSize][tgSize + 1];
            this.targetAtomMapped = new boolean[tgSize];
            this.queryAtomIndexToPos = new int[qgSize];
            this.visitQueue.setMaxSize(10 * qgSize);
            this.ringCountOfAtoms = new int[tgSize];
            if (this.adequateAtoms == null || qgSize * tgSize > this.adequateAtoms.length) {
                this.adequateAtoms = new boolean[qgSize * tgSize];
            }
            return;
        }
        int minLength = 0;
        if (this.valueToTargetAtomIndex != null) {
            minLength = this.valueToTargetAtomIndex[0].length;
            for (int i = 1; i < this.valueToTargetAtomIndex.length; ++i) {
                if (this.valueToTargetAtomIndex[i].length >= minLength) continue;
                minLength = this.valueToTargetAtomIndex[i].length;
            }
            if (this.targetAtomMapped.length < minLength) {
                minLength = this.targetAtomMapped.length;
            }
        }
        if (this.valueToTargetAtomIndex == null || tgSize > minLength) {
            this.valueToTargetAtomIndex = new int[this.route.length][tgSize + 1];
            this.targetAtomMapped = new boolean[tgSize];
            this.ringCountOfAtoms = new int[tgSize];
        }
        if (qgSize * tgSize > this.adequateAtoms.length) {
            this.adequateAtoms = new boolean[qgSize * tgSize];
        }
    }

    public void dump() {
        int i;
        System.err.println("=== dump ===");
        System.err.println("treeSize = " + this.treeSize);
        for (i = 0; i < this.treeSize; ++i) {
            System.err.println("route[ " + i + " ] = " + this.route[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.err.println("baseNumber[ " + i + " ] = " + this.baseNumber[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.err.println("state[ " + i + " ] = " + this.state[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.err.print("valueToTargetAtomIndex[ " + i + " ] = ");
            for (int j = 0; j < this.valueToTargetAtomIndex[i].length && this.valueToTargetAtomIndex[i][j] != -1; ++j) {
                System.err.print(this.valueToTargetAtomIndex[i][j] + " ");
            }
            System.err.println();
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.err.println("parentQueryNode[ " + i + " ]= " + this.parentQueryNode[i]);
        }
        for (i = 0; i < this.treeSize; ++i) {
            System.err.println("queryAtomIndexToPos[ " + i + " ]= " + this.queryAtomIndexToPos[i]);
        }
        if (this.lastSSMap != null) {
            for (i = 0; i < this.lastSSMap.length; ++i) {
                System.err.println("lastSSMap[" + i + "]=" + this.lastSSMap[i]);
            }
        }
        System.err.println("=== ---- ===");
        Molecule mol = this.queryMol.cloneMolecule();
        if (this.queryCoordinates != null) {
            ConformerEquivalenceUtils.setMolCoordinates(mol, this.queryCoordinates);
            mol.setDim(3);
        }
        this.writeMolecule(mol);
        mol = this.targetMol.cloneMolecule();
        if (this.targetCoordinates != null) {
            ConformerEquivalenceUtils.setMolCoordinates(mol, this.targetCoordinates);
            mol.setDim(3);
        }
        this.writeMolecule(mol);
    }

    public void writeMolecule(Molecule mol) {
        String fileName = "SubStructure3DSearchDebug.sdf";
        System.err.println("Appending molecule to \"" + fileName + "\".");
        try {
            FileOutputStream molOut = new FileOutputStream(fileName, true);
            MolExporter mExporter = new MolExporter(molOut, "sdf");
            mExporter.write(mol);
            molOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        int hc = 0;
        int sc = 0;
        Substructure3DSearch ss = new Substructure3DSearch();
        ss.setIgnoreHybridization(true);
        try {
            MolImporter mi = new MolImporter(args[0]);
            Molecule q = mi.read();
            q.aromatize();
            ss.setQuery(q);
            mi.close();
            mi = new MolImporter(args[1]);
            Molecule t = mi.read();
            while (t != null) {
                t.aromatize();
                ss.setTarget(t);
                ++sc;
                if (ss.findFirst()) {
                    System.out.println(t.toFormat("smiles"));
                    ++hc;
                }
                t = mi.read();
            }
            System.out.println("found/processed = " + hc + "/" + sc);
        }
        catch (Exception e) {
            e.printStackTrace();
            ss.dump();
        }
    }

    private static void printResults(Substructure3DSearch mcs) {
        int[] m = mcs.getResult();
        if (m == null) {
            System.out.println("no hit found\n");
        } else {
            System.out.println("hit found");
            for (int j = 0; j < m.length; ++j) {
                if (m[j] == -1) continue;
                System.out.println(j + 1 + " -> " + (m[j] + 1));
            }
            System.out.println();
        }
    }

    private class Queue {
        private int[] values = null;
        private int head = -1;
        private int tail = -1;
        private boolean empty = true;

        public void setMaxSize(int maxSize) {
            if (this.values == null || maxSize > this.values.length) {
                this.values = new int[maxSize];
            }
            this.clear();
        }

        public void clear() {
            this.head = 0;
            this.tail = -1;
            this.empty = true;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public void addLast(int value) throws RuntimeException {
            if (this.overflow()) {
                throw new RuntimeException("Queue overflow.");
            }
            this.tail = (this.tail + 1) % this.values.length;
            this.values[this.tail] = value;
            this.empty = false;
        }

        private int removeFirst() throws RuntimeException {
            if (this.empty) {
                throw new RuntimeException("Queue underflow.");
            }
            int r = this.values[this.head];
            this.empty = this.head == this.tail;
            this.head = (this.head + 1) % this.values.length;
            return r;
        }

        private boolean overflow() {
            return !this.empty && (this.tail + 1) % this.values.length == this.head;
        }
    }
}

